function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/controller/ops/MoveSelectionOp
 */
define(['baja!', 'Promise', 'nmodule/webEditors/rc/wb/commands/SetCommand', 'nmodule/wiresheet/rc/wb/util/wsUtils'], function (baja, Promise, SetCommand, wsUtils) {
  'use strict';

  var entityToOrd = wsUtils.entityToOrd;
  var RUBBER_BAND_ID = 'rubberBand';

  /**
   * This op allows the user to select a set of entities (or just one entity)
   * and move them around on the wiresheet as a group.
   *
   * This op has a BajaScript dependency.
   *
   * @class
   * @alias module:nmodule/wiresheet/rc/wb/controller/ops/MoveSelectionOp
   * @implements module:nmodule/wiresheet/rc/typedefs~DragOp
   * @param {Object} params
   * @param {number} params.x starting mouse x, in wixels
   * @param {number} params.y starting mouse y, in wixels
   * @param {string} entityId the ID of the entity being moved
   * @param {module:nmodule/wiresheet/rc/core/ViewModel} params.viewModel
   * @param {module:nmodule/wiresheet/rc/wb/layout/Mask} params.mask
   * @param {module:nmodule/wiresheet/rc/core/controller/Selection} params.selection
   * @param {Number} [params.zoomLevel=1]
   * @param {function} params.cancelToolTip a function to cancel the ToolTip if
   * it is currently displayed
   */
  var MoveSelectionOp = function MoveSelectionOp(_ref) {
    var origX = _ref.x,
      origY = _ref.y,
      viewModel = _ref.viewModel,
      mask = _ref.mask,
      entityId = _ref.entityId,
      selection = _ref.selection,
      cancelToolTip = _ref.cancelToolTip;
    /**
     * When the user drags around, move the rubber band appropriately.
     * @param {module:nmodule/wiresheet/rc/typedefs~DragOpState} dragOpState
     * @returns {Promise}
     */
    this.update = function (_ref2) {
      var x = _ref2.x,
        y = _ref2.y,
        setCursor = _ref2.setCursor;
      cancelToolTip();
      setCursor('move');
      var deltaX = Math.round(x - origX),
        deltaY = Math.round(y - origY);
      return viewModel.get(entityId).then(function (entity) {
        if (entity && !selection.contains(entity)) {
          selection.setSelectedEntities([entity]);
        }
        var box = getBoundingBox(selection.getSelectedVertices());
        var rubberBand = {
          glyph: {
            type: 'RubberBandGlyph'
          },
          layout: {
            x: clamp(box.x + deltaX, 0, mask.getWidth() - box.width),
            y: clamp(box.y + deltaY, 0, mask.getHeight() - box.height),
            width: box.width,
            height: box.height
          }
        };
        return viewModel.put(rubberBand, RUBBER_BAND_ID);
      });
    };

    /**
     * When the user commits the move, update the `wsAnnotation` slots of all
     * selected components so they move in concordance with the rubber band.
     * @returns {Promise}
     */
    this.commit = function () {
      var base = viewModel.getContainer(),
        entities = selection.getSelectedVertices(),
        componentEntities = entities.filter(function (e) {
          return viewModel.getId(e).match(/^component:/);
        }),
        ords = componentEntities.map(function (e) {
          return entityToOrd(e, viewModel);
        });
      return Promise.all([baja.BatchResolve.resolve({
        ords: ords,
        base: base
      }), viewModel.get(RUBBER_BAND_ID)]).then(function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 2),
          br = _ref4[0],
          rubberBand = _ref4[1];
        var components = br.getTargetObjects();
        var box = getBoundingBox(entities);
        var deltaX = rubberBand.layout.x - box.x;
        var deltaY = rubberBand.layout.y - box.y;
        if (!deltaX && !deltaY) {
          return;
        }
        var layouts = components.map(function (c, i) {
          var layout = componentEntities[i].layout;
          return baja.$('baja:WsAnnotation', layout.x + deltaX, layout.y + deltaY, layout.width, layout.height);
        });
        return new SetCommand({
          subject: components,
          slot: 'wsAnnotation'
        }).invoke(layouts);
      });
    };

    /**
     * Removes any existing rubber band from the view model.
     * @returns {Promise}
     */
    this.destroy = function () {
      return viewModel.del(RUBBER_BAND_ID);
    };
  };
  function getBoundingBox(entities) {
    if (!entities.length) {
      return {
        x: 0,
        y: 0,
        width: 0,
        height: 0
      };
    }
    var top = Number.MAX_VALUE,
      right = Number.MIN_VALUE,
      bottom = Number.MIN_VALUE,
      left = Number.MAX_VALUE;
    entities.forEach(function (_ref5) {
      var layout = _ref5.layout;
      top = Math.min(top, layout.y);
      right = Math.max(right, layout.x + layout.width);
      bottom = Math.max(bottom, layout.y + layout.height);
      left = Math.min(left, layout.x);
    });
    return {
      x: left,
      y: top,
      width: right - left,
      height: bottom - top
    };
  }
  function clamp(n, min, max) {
    return Math.max(Math.min(n, max), min);
  }
  return MoveSelectionOp;
});
