function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/* jshint browser: true */ /* eslint-env browser */
/* global niagara: false */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/controller/WbInteractionController
 */
define(['baja!', 'log!nmodule.wiresheet.rc.wb.controller.WbInteractionController', 'bajaux/dragdrop/dragDropUtils', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/ToolTip', 'nmodule/webEditors/rc/wb/commands/AddSlotCommand', 'nmodule/webEditors/rc/wb/commands/LinkToCommand', 'nmodule/webEditors/rc/wb/commands/RelateToCommand', 'nmodule/webEditors/rc/wb/links/LinkOrRelatePad', 'nmodule/wiresheet/rc/wb/baja/bajaUtils', 'nmodule/wiresheet/rc/wb/controller/ops/DropperOp', 'nmodule/wiresheet/rc/wb/controller/ops/LinkOp', 'nmodule/wiresheet/rc/wb/controller/ops/RelateOp', 'nmodule/wiresheet/rc/wb/controller/ops/MoveSelectionOp', 'nmodule/wiresheet/rc/wb/controller/ops/ResizeSelectionOp', 'nmodule/wiresheet/rc/wb/controller/ops/RubberBandOp', 'nmodule/wiresheet/rc/wb/util/wsUtils'], function (baja, log, dragDropUtils, Promise, _, ToolTip, AddSlotCommand, LinkToCommand, RelateToCommand, LinkOrRelatePad, bajaUtils, DropperOp, LinkOp, RelateOp, MoveSelectionOp, ResizeSelectionOp, RubberBandOp, wsUtils) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var extend = _.extend,
    paramsToValues = bajaUtils.paramsToValues,
    entityToOrd = wsUtils.entityToOrd,
    isComponentGlyph = wsUtils.isComponentGlyph;

  /**
   * This module's job is to update the view model in response to user
   * interaction. Each method on here represents "a thing a user will do."
   *
   * Individual interaction controllers (e.g. SVG vs. canvas) can implement
   * their own way of calling these methods.
   *
   * @class
   * @alias module:nmodule/wiresheet/rc/wb/controller/WbInteractionController
   * @param {Object} params
   * @param {module:nmodule/wiresheet/rc/core/controller/Selection} params.selection
   * @param {module:nmodule/wiresheet/rc/wb/WbViewModel} params.viewModel
   * @param {Object} params.options the user configured options
   */
  var WbInteractionController = /*#__PURE__*/function () {
    function WbInteractionController(_ref) {
      var viewModel = _ref.viewModel,
        mask = _ref.mask,
        selection = _ref.selection,
        options = _ref.options;
      _classCallCheck(this, WbInteractionController);
      this.$viewModel = viewModel;
      this.$selection = selection;
      this.$mask = mask;
      this.$options = options;
    }
    /**
     * @param {Object} params
     * @param {Object} [params.selectedParams]
     * @returns {Promise}
     */
    return _createClass(WbInteractionController, [{
      key: "initialize",
      value: function initialize() {
        var _this = this;
        var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          selectionParams = _ref2.selectionParams;
        var viewModel = this.$viewModel;
        var selection = this.$selection;
        var selectionChanged = function selectionChanged(_ref3) {
          var added = _ref3.added,
            removed = _ref3.removed;
          var handle = function handle(added, entity) {
            var glyph = (entity.predicate || entity).glyph;
            switch (glyph.type) {
              case 'ComponentGlyph':
                return componentSelectionChanged(viewModel, !!added, entity);
              case 'SnakeGlyph':
              case 'StubGlyph':
                return edgeSelectionChanged(viewModel, !!added, entity);
              case 'TextBlockGlyph':
                return textBlockSelectionChanged(viewModel, !!added, entity);
            }
          };
          return Promise.all(removed.map(function (e) {
            return handle(false, e);
          })).then(function () {
            return Promise.all(added.map(function (e) {
              return handle(true, e);
            }));
          });
        };
        selection.on('changed', selectionChanged);
        this.release = function () {
          selection.removeListener('changed', selectionChanged);
          _this.cancelToolTip();
        };
        return this.$applySelection(selectionParams);
      }

      /**
       * Copy clipboard contents
       *
       * @param {DataTransfer} clipboard
       * @param {object} params
       * @param {string} params.origin
       * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} [params.entity]
       * @param {object} [params.horizontalPosition]
       * @returns {Promise}
       */
    }, {
      key: "dropFromClipboard",
      value: function dropFromClipboard(clipboard, params) {
        var _this2 = this;
        var viewModel = this.$viewModel;
        return dragDropUtils.fromClipboard(clipboard).then(function (envelope) {
          if (envelope.getMimeType() !== 'niagara/navnodes') {
            return;
          }
          var showRelations = _this2.$options.showRelations;
          return resolveNavNodesAndDrop(envelope, viewModel, showRelations, params);
        });
      }

      /**
       * Call this when selecting something you know to be a vertex.
       *
       * @param {string} id vertex id
       * @param {boolean} modifySelection true if modifying selection; false if
       * starting new selection
       * @returns {Promise}
       */
    }, {
      key: "selectVertex",
      value: function selectVertex(id, modifySelection) {
        var _this3 = this;
        return this.$viewModel.get(id).then(function (entity) {
          return _this3.$entitySelected(entity, {
            modifySelection: modifySelection
          });
        });
      }

      /**
       * Call this when selecting something you know to be an edge.
       *
       * @param {string} id edge id
       * @param {boolean} modifySelection true if modifying selection; false if
       * starting new selection
       * @returns {Promise}
       */
    }, {
      key: "selectEdge",
      value: function selectEdge(id, modifySelection) {
        var _this4 = this;
        return this.$viewModel.getEdges({
          predicate: id
        }).then(function (_ref4) {
          var _ref5 = _slicedToArray(_ref4, 1),
            triple = _ref5[0];
          return _this4.$entitySelected(triple, {
            modifySelection: modifySelection
          });
        });
      }

      /**
       * Call this when not sure whether the thing you're clicking on is a vertex
       * or edge. It will be slower than the vertex/edge-specific ones.
       *
       * @param {string} id vertex or edge id
       * @param {boolean} modifySelection true if modifying selection; false if
       * starting new selection
       * @param {boolean} preferCurrentSelection if true and the provided entity
       * is already selected, this will force there to be no changes to the
       * current selection.
       * @returns {Promise}
       */
    }, {
      key: "selectEntity",
      value: function selectEntity(id, modifySelection, preferCurrentSelection) {
        var _this5 = this;
        var viewModel = this.$viewModel;
        //TODO: i'm sort of lacking a non-ugly way to ask the db: is this id a vertex or an edge?
        return Promise.all([viewModel.get(id), viewModel.getEdges({
          predicate: id
        })]).then(function (_ref6) {
          var _ref7 = _slicedToArray(_ref6, 2),
            vertex = _ref7[0],
            _ref7$ = _slicedToArray(_ref7[1], 1),
            triple = _ref7$[0];
          var toSelect = triple || vertex;
          return _this5.$entitySelected(toSelect, {
            modifySelection: modifySelection,
            preferCurrentSelection: preferCurrentSelection
          });
        });
      }

      /**
       * @param {baja.Ord|string} ord to hyperlink to
       * @param {boolean} ordAsIs if true will hyperlink to ord otherwise
       * will attempt to `get` the value and hyperlink to the value's navOrd
       * @returns {Promise}
       */
    }, {
      key: "hyperlinkToOrd",
      value: function hyperlinkToOrd(ord) {
        var ordAsIs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
        if (ordAsIs) {
          return niagara.env.hyperlink(ord)["catch"](logSevere);
        }
        return baja.Ord.make(ord).get({
          base: this.$viewModel.getContainer()
        }).then(function (c) {
          return niagara.env.hyperlink(c.getNavOrd());
        })["catch"](logSevere);
      }

      /**
       * Displays the provided text in the ToolTip for the wiresheet.
       *
       * @param {string} text
       */
    }, {
      key: "displayToolTip",
      value: function displayToolTip(text) {
        if (this.$tooltip) {
          this.$tooltip.setDisplay(text);
          return;
        }
        this.$tooltip = ToolTip.create({
          value: text,
          fixedPosition: true,
          delay: 100
        });
      }

      /**
       * Update the user configured options
       *
       * @param {Object} params
       * @param {Object} params.options
       */
    }, {
      key: "options",
      value: function options(_ref8) {
        var _options = _ref8.options;
        this.$options = _options;
      }

      /**
       * Cancel the ToolTip if it is displayed.
       */
    }, {
      key: "cancelToolTip",
      value: function cancelToolTip() {
        if (!this.$tooltip || !this.$tooltip.cancel) {
          return;
        }
        this.$tooltip.cancel();
        this.$tooltip = undefined;
      }

      /**
       * @param {object} params
       * @param {number} params.x starting mouse x, in wixels
       * @param {number} params.y starting mouse y, in wixels
       * @param {string} entityId the ID of the glyph being linked from
       * @param {string} connectorId the ID of the connector in that glyph that is
       * being linked
       * @param {string} connectorDirection `in` if the given entity is the start
       * of the link (we're linking "into" something else), `out` if the given
       * entity is the target of the link (something will be linking "out" into
       * us).
       * @param {function} setCursor a function to update the visible cursor as
       * the link op gets updated - receives a string
       * @returns {Promise}
       */
    }, {
      key: "startLinkOp",
      value: function startLinkOp(_ref9) {
        var _this6 = this;
        var x = _ref9.x,
          y = _ref9.y,
          entityId = _ref9.entityId,
          connectorId = _ref9.connectorId,
          connectorDirection = _ref9.connectorDirection,
          setCursor = _ref9.setCursor;
        var viewModel = this.$viewModel;
        this.$canHighlightForOp = true;
        this.$op = new LinkOp({
          x: x,
          y: y,
          entityId: entityId,
          connectorId: connectorId,
          connectorDirection: connectorDirection,
          setCursor: setCursor,
          setToolTip: function setToolTip(text) {
            return _this6.displayToolTip(text);
          },
          cancelToolTip: function cancelToolTip() {
            return _this6.cancelToolTip();
          },
          viewModel: viewModel,
          base: viewModel.getContainer()
        });
        return Promise.resolve();
      }

      /**
       * @param {object} params
       * @param {number} params.x starting mouse x, in wixels
       * @param {number} params.y starting mouse y, in wixels
       * @param {string} entityId the ID of the glyph being related from
       * @param {string} connectorId the ID of the connector in that glyph that is
       * being related
       * @param {string} connectorDirection `from` if creating a relate
       * from relation. `to` if creating a relate to relation.
       * @param {function} setCursor a function to update the visible cursor as
       * the link op gets updated - receives a string
       * @returns {Promise}
       */
    }, {
      key: "startRelateOp",
      value: function startRelateOp(_ref10) {
        var _this7 = this;
        var x = _ref10.x,
          y = _ref10.y,
          entityId = _ref10.entityId,
          connectorId = _ref10.connectorId,
          connectorDirection = _ref10.connectorDirection,
          setCursor = _ref10.setCursor;
        var viewModel = this.$viewModel;
        this.$canHighlightForOp = true;
        this.$op = new RelateOp({
          x: x,
          y: y,
          entityId: entityId,
          connectorId: connectorId,
          connectorDirection: connectorDirection,
          setCursor: setCursor,
          setToolTip: function setToolTip(text) {
            return _this7.displayToolTip(text);
          },
          cancelToolTip: function cancelToolTip() {
            return _this7.cancelToolTip();
          },
          viewModel: viewModel,
          base: viewModel.getContainer()
        });
        return Promise.resolve();
      }

      /**
       * Start a new operation to move a glyph or group of glyphs (typically in
       * response to a mousedown on a glyph header).
       *
       * @param {object} params
       * @param {number} params.x starting mouse x, in wixels
       * @param {number} params.y starting mouse y, in wixels
       * @param {string} entityId the ID of the entity being moved
       * @returns {Promise}
       */
    }, {
      key: "startMoveOp",
      value: function startMoveOp(_ref11) {
        var _this8 = this;
        var x = _ref11.x,
          y = _ref11.y,
          entityId = _ref11.entityId;
        var viewModel = this.$viewModel,
          mask = this.$mask,
          selection = this.$selection;
        this.$op = new MoveSelectionOp({
          x: x,
          y: y,
          viewModel: viewModel,
          mask: mask,
          entityId: entityId,
          selection: selection,
          cancelToolTip: function cancelToolTip() {
            return _this8.cancelToolTip();
          }
        });
        return Promise.resolve();
      }

      /**
       * Start a new operation to resize a glyph or group of glyphs (typically in
       * response to a mousedown on a resize "handle" on a component or text
       * block).
       *
       * @param {object} params
       * @param {number} params.x starting mouse x, in wixels
       * @param {number} params.y starting mouse y, in wixels
       * @param {string} params.entityId the ID of the entity being resized
       * directly (other selected entities will be resized as well)
       * @param {string} params.direction the direction of the resize (n/e/w/s and
       * diagonals)
       * @returns {Promise}
       */
    }, {
      key: "startResizeOp",
      value: function startResizeOp(_ref12) {
        var _this9 = this;
        var x = _ref12.x,
          y = _ref12.y,
          entityId = _ref12.entityId,
          direction = _ref12.direction;
        var viewModel = this.$viewModel;
        var selection = this.$selection;
        var mask = this.$mask;
        this.$op = new ResizeSelectionOp({
          x: x,
          y: y,
          entityId: entityId,
          direction: direction,
          viewModel: viewModel,
          mask: mask,
          selection: selection,
          cancelToolTip: function cancelToolTip() {
            return _this9.cancelToolTip();
          }
        });
        return Promise.resolve();
      }

      /**
       * Start a new operation to select a group of glyphs on the wiresheet
       * (typically in response to a click on the grid itself).
       *
       * @param {object} params
       * @param {number} params.x starting mouse x, in wixels
       * @param {number} params.y starting mouse y, in wixels
       * @returns {Promise}
       */
    }, {
      key: "startSelectOp",
      value: function startSelectOp(_ref13) {
        var x = _ref13.x,
          y = _ref13.y;
        //TODO: this should work with touchstart too, but then two-finger scrolling doesn't
        var viewModel = this.$viewModel;
        var selection = this.$selection;
        this.$op = new RubberBandOp({
          x: x,
          y: y,
          viewModel: viewModel,
          selection: selection
        });
        return this.$clearSelection();
      }

      /**
       * Start a new operation that visually indicates a dragover from
       * the nav tree.
       * @param {object} params
       * @param {number} params.x starting mouse x, in wixels
       * @param {number} params.y starting mouse y, in wixels
       * @returns {Promise}
       */
    }, {
      key: "startDropperOp",
      value: function startDropperOp(_ref14) {
        var _this10 = this;
        var x = _ref14.x,
          y = _ref14.y;
        var viewModel = this.$viewModel;
        var showRelations = this.$options.showRelations;
        this.$op = new DropperOp({
          x: x,
          y: y,
          viewModel: viewModel,
          setToolTip: function setToolTip(text) {
            return _this10.displayToolTip(text);
          },
          cancelToolTip: function cancelToolTip() {
            return _this10.cancelToolTip();
          },
          showRelations: showRelations
        });
        return Promise.resolve();
      }

      /**
       * Whatever action the user is currently performing, this method updates it
       * (typically in response to a mousemove while the mouse button is still
       * held down).
       *
       * @param {module:nmodule/wiresheet/rc/typedefs~DragOpState} params parameters
       * to be passed directly to `op.update()`
       * @returns {Promise}
       */
    }, {
      key: "updateCurrentOp",
      value: function updateCurrentOp(params) {
        var op = this.$op;
        return Promise.resolve(op && op.update(params));
      }

      /**
       * Whatever operation the user is currently performing, this method
       * completes it (typically called on mouseup/touchend).
       *
       * @param {module:nmodule/wiresheet/rc/typedefs~DragOpState} params parameters
       * to be passed directly to `op.commit()`
       * @returns {Promise}
       */
    }, {
      key: "commitCurrentOp",
      value: function commitCurrentOp(params) {
        var op = this.$op;
        this.$op = null;
        this.$canHighlightForOp = false;
        if (!op) {
          return Promise.resolve();
        }
        return Promise["try"](function () {
          return op.commit(params);
        })["finally"](function () {
          return op.destroy();
        });
      }

      /**
       * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} entity
       * @param {object} highlightInfo
       * @returns {Promise}
       */
    }, {
      key: "highlightConnector",
      value: function highlightConnector(entity, highlightInfo) {
        var _this11 = this;
        var viewModel = this.$viewModel;
        return viewModel.get(entity).then(function (e) {
          return e && _this11.$setHighlightUiStatus(e, highlightInfo) && viewModel.put(e);
        });
      }

      /**
       * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} entity
       * @param {object} highlightInfo
       * @returns {Promise}
       */
    }, {
      key: "clearConnectorHighlight",
      value: function clearConnectorHighlight(entity, highlightInfo) {
        return highlightInfo ? this.highlightConnector(entity, Object.assign({}, highlightInfo, {
          connectorInfo: undefined
        })) : this.highlightConnector(entity);
      }

      /**
       *
       * @returns {boolean|undefined}
       */
    }, {
      key: "canHighlightForOp",
      value: function canHighlightForOp() {
        return this.$canHighlightForOp;
      }

      /**
       *
       * @private
       * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} entity
       * @param {object} highlightInfo
       * @returns {Promise}
       */
    }, {
      key: "$setHighlightUiStatus",
      value: function $setHighlightUiStatus(entity) {
        var _ref15 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          which = _ref15.which,
          connectorInfo = _ref15.connectorInfo;
        var _ref16 = connectorInfo || {},
          connectorDirection = _ref16.connectorDirection,
          connectorId = _ref16.connectorId;
        switch (which) {
          case 'start':
            return setUiStatus('highlightedStartConnector', {
              connectorId: connectorId,
              connectorDirection: connectorDirection
            }, entity);
          case 'end':
            return setUiStatus('highlightedEndConnector', {
              connectorId: connectorId,
              connectorDirection: connectorDirection
            }, entity);
          default:
            return Promise.all([setUiStatus('highlightedStartConnector', undefined, entity), setUiStatus('highlightedEndConnector', undefined, entity)]);
        }
      }

      /**
       * @private
       * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} entity
       * @param {object} params
       * @returns {Promise|*}
       */
    }, {
      key: "$entitySelected",
      value: function $entitySelected(entity) {
        var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var toSelect = entity && (entity.predicate || entity);
        if (!toSelect || toSelect.glyph.uiStatus.selectable === false) {
          return;
        }
        var selection = this.$selection,
          _params$preferCurrent = params.preferCurrentSelection,
          preferCurrentSelection = _params$preferCurrent === void 0 ? false : _params$preferCurrent,
          _params$modifySelecti = params.modifySelection,
          modifySelection = _params$modifySelecti === void 0 ? false : _params$modifySelecti,
          isSelected = selection.contains(entity);
        if (preferCurrentSelection && isSelected) {
          return Promise.resolve();
        } else if (modifySelection) {
          return selection[isSelected ? 'remove' : 'add'](entity);
        } else {
          return selection.setSelectedEntities([entity]);
        }
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$clearSelection",
      value: function $clearSelection() {
        return this.$selection.setSelectedEntities([]);
      }

      /**
       * @private
       * @param {module:nmodule/wiresheet/rc/wb/baja/bajaUtils~SelectionParams} params
       * @returns {Promise}
       */
    }, {
      key: "$applySelection",
      value: function $applySelection() {
        var _this12 = this;
        var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var viewModel = this.$viewModel;
        var bajaValues;
        return paramsToValues(params).then(function (values) {
          bajaValues = values;
          if (!values || !values.length) {
            return;
          }
          return viewModel.toId(values[0]);
        }).then(function (id) {
          if (!id) {
            return;
          }
          return Promise.all([viewModel.get(id), _this12.selectEntity(id, false)]).then(function (_ref17) {
            var _ref18 = _slicedToArray(_ref17, 1),
              entity = _ref18[0];
            if (entity && entity.glyph.type === 'StubGlyph' && bajaValues.length > 1) {
              return Promise.all(bajaValues.map(function (value, i) {
                return Promise.all([viewModel.toId(value), viewModel.get(value)]).then(function (_ref19) {
                  var _ref20 = _slicedToArray(_ref19, 2),
                    id = _ref20[0],
                    entity = _ref20[1];
                  if (entity && entity.glyph.type === 'StubGlyph') {
                    return _this12.selectEntity(id, true, true);
                  }
                });
              }));
            }
          });
        });
      }
    }]);
  }();
  function setHighlighted(viewModel, highlighted, triples) {
    return Promise.all(triples.map(function (_ref21) {
      var subject = _ref21.subject,
        predicate = _ref21.predicate,
        object = _ref21.object;
      return setUiStatus('highlighted', highlighted, predicate) && viewModel.link({
        subject: subject,
        object: object,
        predicate: predicate
      });
    }));
  }
  function setUiStatus(name, newValue, entity) {
    var uiStatus = entity && entity.glyph ? entity.glyph.uiStatus : null;
    if (!uiStatus) {
      return;
    }
    if (uiStatus[name] !== newValue) {
      uiStatus[name] = newValue;
      return true;
    }
  }

  /**
   * @param {module:nmodule/wiresheet/rc/wb/WbViewModel} viewModel
   * @param {boolean} added
   * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} entity
   * @return {Promise}
   */
  function componentSelectionChanged(viewModel, added, entity) {
    //we can get deselected events after the vertex was already removed from
    //the vm - so ensure it's actually present before updating
    return viewModel.get(entity).then(function (exists) {
      return exists && Promise.all([highlightConnectedLinks(viewModel, added, entity), setUiStatus('selected', added, entity) && viewModel.put(entity)]);
    });
  }

  /**
   * @param {module:nmodule/wiresheet/rc/wb/WbViewModel} viewModel
   * @param {boolean} added
   * @param {Object} triple
   * @return {Promise}
   */
  function edgeSelectionChanged(viewModel, added, triple) {
    //we can get deselected events after the triple was already removed from
    //the vm - so ensure it's actually present before updating/relinking
    return viewModel.getEdges(triple).then(function (edges) {
      return edges.length && setUiStatus('selected', added, triple.predicate) && viewModel.link(triple);
    });
  }

  /**
   * @param {module:nmodule/wiresheet/rc/wb/WbViewModel} viewModel
   * @param {boolean} added
   * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} entity
   * @return {Promise}
   */
  function textBlockSelectionChanged(viewModel, added, entity) {
    return viewModel.get(entity).then(function (exists) {
      return exists && setUiStatus('selected', added, entity) && viewModel.put(entity);
    });
  }

  /**
   * @param {module:nmodule/wiresheet/rc/wb/WbViewModel} viewModel
   * @param {boolean} added
   * @param {Object} componentEntity
   * @return {Promise}
   */
  function highlightConnectedLinks(viewModel, added, componentEntity) {
    return Promise.all([viewModel.getEdges({
      subject: componentEntity
    }), viewModel.getEdges({
      object: componentEntity
    })]).then(function (_ref22) {
      var _ref23 = _slicedToArray(_ref22, 2),
        outgoing = _ref23[0],
        incoming = _ref23[1];
      var toHighlight = incoming.concat(outgoing);
      return setHighlighted(viewModel, added, toHighlight);
    });
  }
  function resolveNavNodesAndDrop(envelope, viewModel, showRelations, params) {
    return envelope.toValues().then(function (values) {
      var entity = params.entity,
        connectorInfo = params.connectorInfo;
      var horizontalPosition = params.horizontalPosition;
      if (entity && isComponentGlyph(entity) && horizontalPosition !== undefined) {
        var ord = baja.Ord.make({
          base: baja.Ord.make('station:'),
          child: entityToOrd(entity, viewModel).relativizeToSession()
        });
        var connectorType = connectorInfo && connectorInfo.connectorType;
        var isRelationPreferred = showRelations && !!(connectorType === 'footer' || connectorType === 'relation');
        return Promise.all([resolveEnvelopeComponents(values), ord.get()]).then(function (_ref24) {
          var _ref25 = _slicedToArray(_ref24, 2),
            navNodeComponents = _ref25[0],
            wiresheetComponent = _ref25[1];
          var slot = connectorInfo && connectorInfo.connectorId && connectorInfo.connectorId.split('slot:')[1];
          var selectedSlot = {};
          var originalSources;
          var originalTargets;
          if (horizontalPosition === 'left') {
            originalSources = navNodeComponents;
            originalTargets = [wiresheetComponent];
            selectedSlot.target = slot;
          } else {
            originalSources = [wiresheetComponent];
            originalTargets = navNodeComponents;
            selectedSlot.source = slot;
          }
          return resolveToLinkOrRelate({
            originalSources: originalSources,
            originalTargets: originalTargets,
            isRelationPreferred: isRelationPreferred,
            selectedSlot: selectedSlot
          });
        });
      }
      return new AddSlotCommand(viewModel.getContainer(), {
        undoable: true
      }).invoke(extend({
        bulkValues: values
      }, params));
    });
  }

  /**
   * Takes the provided sources and targets and provides a dialog to link or
   * relate them.
   *
   * @param {Object} params
   * @param {Array.<baja.Component>} params.originalSources
   * @param {Array.<baja.Component>} params.originalTargets
   * @param {boolean} params.isRelationPreferred
   * @param {boolean} params.preSelectedSlot
   * @returns {Promise}
   */
  function resolveToLinkOrRelate(_ref26) {
    var originalSources = _ref26.originalSources,
      originalTargets = _ref26.originalTargets,
      isRelationPreferred = _ref26.isRelationPreferred,
      selectedSlot = _ref26.selectedSlot;
    var params = {
      sources: originalSources,
      targets: originalTargets
    };
    var properties = {
      isRelation: isRelationPreferred,
      selectedSlot: selectedSlot
    };
    return LinkOrRelatePad.doDialog(params, properties).then(function (result) {
      if (!result) {
        return;
      }
      var value = result.value,
        type = result.type;
      if (type === 'link') {
        return saveNewLinks(value);
      }
      var relationId = value.relationId,
        sources = value.sources,
        targets = value.targets;
      if (!relationId) {
        return;
      }
      return saveNewRelations(sources, targets, relationId);
    });
  }

  /**
   * @param {Array.<baja.Component>} sources
   * @param {Array.<baja.Component>} targets
   * @param {String} relationId
   * @returns {Promise}
   */
  function saveNewRelations(sources, targets, relationId) {
    var cmd = new RelateToCommand({
      subject: sources,
      object: targets,
      relationId: relationId
    });
    return cmd.invoke();
  }

  /**
   * @param {module:nmodule/webEditors/rc/wb/links/LinkPad~LinkCheckParams} linkCheckParams
   * @returns {Promise}
   */
  function saveNewLinks(linkCheckParams) {
    var sources = linkCheckParams.sources,
      sourceSlot = linkCheckParams.sourceSlot,
      targets = linkCheckParams.targets,
      targetSlot = linkCheckParams.targetSlot;
    var cmd = new LinkToCommand({
      subject: sources,
      sourceSlotName: sourceSlot,
      object: targets,
      targetSlotName: targetSlot
    });
    return cmd.invoke();
  }
  function resolveEnvelopeComponents(values) {
    return Promise.all(values.map(function (value) {
      return value.getNavOrd().get();
    }));
  }
  return WbInteractionController;
});
