function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/* eslint-disable no-unused-vars */

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/typedefs
 */
define([], function () {
  'use strict';

  /**
   * Contains rendering information about one glyph on the Wiresheet. Each glyph
   * type will have a different structure. The schema for the different glyph
   * types is in the `schema` directory.
   *
   * @typedef {object} module:nmodule/wiresheet/rc/typedefs~Glyph
   * @property {string} type a string identifying the glyph's type, e.g.
   * `ComponentGlyph`
   * @property {boolean} hidden represents whether or not the given glyph is
   * visible on the wiresheet
   * @property {module:nmodule/wiresheet/rc/typedefs~UiStatus} uiStatus
   */

  /**
   * Describes the current UI status of a glyph. This includes information about
   * how the user is currently interacting with it, and will inform both how the
   * glyph is rendered and how user interaction events should be handled.
   *
   * @typedef {object} module:nmodule/wiresheet/rc/typedefs~UiStatus
   * @property {boolean} selected whether this glyph is currently selected by
   * the user
   * @property {boolean} selectable whether this glyph is allowed to be selected
   * by the user
   * @property {boolean} highlighted whether this glyph is highlighted. This is
   * different from `selected` - e.g., when you select a component glyph, all
   * its connected links become highlighted, even though they are not selected.
   */

  /**
   * Describes a glyph's layout on the Wiresheet.
   *
   * @typedef {object} module:nmodule/wiresheet/rc/typedefs~Layout
   * @property {number} x x coordinate in wixels
   * @property {number} y y coordinate in wixels
   * @property {number} width width in wixels
   * @property {number} height height in wixels
   */

  /**
   * An object describing one particular glyph and its layout on the Wiresheet.
   *
   * @typedef {object} module:nmodule/wiresheet/rc/typedefs~WiresheetEntity
   * @property {module:nmodule/wiresheet/rc/typedefs~Glyph} glyph
   * @property {module:nmodule/wiresheet/rc/typedefs~Layout} layout
   */

  /**
   * An object describing an edge between two vertices on the Wiresheet.
   *
   * @typedef {object} module:nmodule/wiresheet/rc/typedefs~WiresheetTriple
   * @property {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} subject the
   * entity describing the subject (i.e. the start vertex of the edge, typically
   * a `ComponentGlyph`)
   * @property {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} predicate the
   * entity describing the predicate (i.e. the link between the vertices,
   * typically a `SnakeGlyph` or `StubGlyph`)
   * @property {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} object the
   * entity describing the object (i.e. the end vertex of the edge, typically a
   * `ComponentGlyph`)
   */

  /**
   * The state of a user drag operation event, such as where the user's mouse
   * is, what glyph is under it, etc.
   *
   * @typedef {object} module:nmodule/wiresheet/rc/typedefs~DragOpState
   * @property {number} x x coordinate of the mouse, in wixels
   * @property {number} y y coordinate of the mouse, in wixels
   * @property {function} setCursor a callback function that will be used to
   * update the mouse cursor as the user drags around. Don't worry about
   * cleaning up by calling it with `default` - that's the controller's job.
   * @property {function} setToolTip sets the tooltip that is currently
   * displayed to the text passed into this function.
   * @property {function} cancelToolTip will cancel the currently displayed
   * tooltip from the wiresheet when called.
   * @property {string} [entityId] the ID of the entity under the mouse
   * @property {string} [entity] the entity under the mouse
   * @property {string} [connectorId] the ID of the connector under the mouse
   * that belongs to that entity
   * @property {string} [connectorDirection] `in` or `out` depending on whether
   * the connector under the mouse is incoming or outgoing
   * @property {string} [connectorType] `link`, `relation`, or `footer`
   * depending on where on the entity the mouse is
   * @property {string} [horizontalPosition] `left` or `right` depending on the
   * position of the mouse over the current entity
   */

  /**
   * Defines an API for an operation that is invoked by the user by dragging
   * on the Wiresheet.
   *
   * @interface
   * @memberOf module:nmodule/wiresheet/rc/typedefs
   */
  var DragOp = /*#__PURE__*/function () {
    function DragOp() {
      _classCallCheck(this, DragOp);
    }
    return _createClass(DragOp, [{
      key: "update",
      value:
      /**
       * Update the current state of the op, and update the view model with any
       * glyphs that will visually depict the state of the op. This will typically
       * be called on `mousemove` as the user drags around.
       * @param {module:nmodule/wiresheet/rc/typedefs~DragOpState} params
       * @returns {Promise|*}
       */
      function update(params) {}

      /**
       * Commit the current op, writing the appropriate changes to the database.
       * This will typically be called on `mouseup` after the user completes their
       * drag.
       * @param {module:nmodule/wiresheet/rc/typedefs~DragOpState} params
       * @returns {Promise|*}
       */
    }, {
      key: "commit",
      value: function commit(params) {}

      /**
       * Clean up after the op is complete, removing any extra UI glyphs from the
       * view model, etc.
       * @returns {Promise|*}
       */
    }, {
      key: "destroy",
      value: function destroy() {}
    }]);
  }();
  /**
   * Defines an API for laying out vertices on the Wiresheet.
   *
   * @interface
   * @memberOf module:nmodule/wiresheet/rc/typedefs
   */
  var VertexLayoutStrategy = /*#__PURE__*/function () {
    function VertexLayoutStrategy() {
      _classCallCheck(this, VertexLayoutStrategy);
    }
    return _createClass(VertexLayoutStrategy, [{
      key: "update",
      value:
      /**
       * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetEntity} entity
       * @param {module:nmodule/wiresheet/rc/wb/layout/Mask} mask
       * @returns {Promise|*}
       */
      function update(entity, mask) {}
    }]);
  }();
  /**
   * Defines an API for laying out edges on the Wiresheet.
   *
   * @interface
   * @memberOf module:nmodule/wiresheet/rc/typedefs
   */
  var EdgeLayoutStrategy = /*#__PURE__*/function () {
    function EdgeLayoutStrategy() {
      _classCallCheck(this, EdgeLayoutStrategy);
    }
    return _createClass(EdgeLayoutStrategy, [{
      key: "update",
      value:
      /**
       * @param {module:nmodule/wiresheet/rc/typedefs~WiresheetTriple} triple
       * @param {module:nmodule/wiresheet/rc/wb/layout/Mask} mask
       * @returns {Promise|*}
       */
      function update(triple, mask) {}
    }]);
  }();
});
