function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Rowyn Brunner
 */

/**
 * API Status: **Private**
 * @module nmodule/gx/rc/fe/SizeEditor
 */
define(['baja!', 'hbs!nmodule/gx/rc/fe/template/SizeEditor', 'lex!gx', 'bajaux/events', 'bajaux/Widget', 'Promise', 'underscore', 'nmodule/gx/rc/baja/Size', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/fe', 'css!nmodule/gx/rc/gx'], function (baja, tplSizeEditor, lexes, events, Widget, Promise, _, Size, BaseEditor, fe) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT;
  var _lexes = _slicedToArray(lexes, 1),
    gxLex = _lexes[0];
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'gx',
      keyName: 'SizeEditor',
      properties: {
        rootCssClass: '-t-SizeEditor'
      }
    };
  };

  /**
   * Bajaux editor for BSize.
   *
   * Consists of two field editors, one for width and one for height, defaulting to value 0. The editors are readonly.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/gx/rc/fe/SizeEditor
   */
  var SizeEditor = /*#__PURE__*/function (_BaseEditor) {
    function SizeEditor(params) {
      var _this;
      _classCallCheck(this, SizeEditor);
      _this = _callSuper(this, SizeEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.validators().add(function () {
        return Promise.all([_this.$getWidthEditor().validate(), _this.$getHeightEditor().validate()]);
      });
      return _this;
    }

    /**
     * Creates an editor with correctly labeled width and height editors.
     *
     * @param {JQuery} dom
     * @returns {Promise}
     */
    _inherits(SizeEditor, _BaseEditor);
    return _createClass(SizeEditor, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        var widthText = gxLex.get('size.width');
        var heightText = gxLex.get('size.height');
        dom.html(tplSizeEditor({
          widthText: widthText,
          heightText: heightText
        }));
        dom.on(MODIFY_EVENT, '.type-baja-Number', function () {
          _this2.setModified(true);
          return false;
        });
        var min = this.properties().getValue('min');
        var max = this.properties().getValue('max');
        return Promise.all([fe.buildFor({
          formFactor: 'mini',
          dom: dom.find('.width-editor'),
          value: 0,
          properties: {
            min: min,
            max: max
          }
        }), fe.buildFor({
          formFactor: 'mini',
          dom: dom.find('.height-editor'),
          value: 0,
          properties: {
            min: min,
            max: max
          }
        })]);
      }

      /**
       * Loads the width field of the size parameter into the width editor, and the height field of the size parameter into
       * the height editor.
       *
       * @param {module:nmodule/gx/rc/baja/Size} size
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(size) {
        return Promise.all([this.$getWidthEditor().load(size.getWidth()), this.$getHeightEditor().load(size.getHeight())]);
      }

      /**
       * @private
       * @param {Number} width
       * @param {Number} height
       * @throws {Error}
       */
    }, {
      key: "$validateWidthAndHeightForMinAndMax",
      value: function $validateWidthAndHeightForMinAndMax(width, height) {
        var min = this.properties().getValue('min');
        var max = this.properties().getValue('max');
        if (min !== null && max !== null) {
          if (width < min || width > max) {
            throw new Error(gxLex.get('sizeEditor.widthOutOfRange.message', width, min, max));
          } else if (height < min || height > max) {
            throw new Error(gxLex.get('sizeEditor.heightOutOfRange.message', height, min, max));
          }
        }
      }

      /**
       * Returns the values of the width and height editors in a Size field.
       *
       * @returns {Promise.<module:nmodule/gx/rc/baja/Size>}
       */
    }, {
      key: "doRead",
      value: function doRead() {
        var _this3 = this;
        return Promise.all([this.$getWidthEditor().read(), this.$getHeightEditor().read()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            width = _ref2[0],
            height = _ref2[1];
          _this3.$validateWidthAndHeightForMinAndMax(width, height);
          return new Size(width, height);
        });
      }

      /**
       * Sets all the child widgets of this editor to readonly.
       *
       * @param {boolean} readonly
       * @returns {Promise}
       */
    }, {
      key: "doReadonly",
      value: function doReadonly(readonly) {
        return this.getChildWidgets().setAllReadonly(readonly);
      }

      /**
       * Sets all the child widgets of this editor to enabled.
       *
       * @param {boolean} enabled
       * @returns {Promise}
       */
    }, {
      key: "doEnabled",
      value: function doEnabled(enabled) {
        return this.getChildWidgets().setAllEnabled(enabled);
      }

      /**
       * Destroys all children of the editor.
       *
       * @returns {Promise}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        return this.getChildWidgets().destroyAll();
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getWidthEditor",
      value: function $getWidthEditor() {
        return Widget["in"](this.jq().find('.width-editor'));
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getHeightEditor",
      value: function $getHeightEditor() {
        return Widget["in"](this.jq().find('.height-editor'));
      }
    }]);
  }(BaseEditor);
  return SizeEditor;
});
