function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/gx/rc/fe/PolygonGeomEditor
 * @since Niagara 4.15
 */
define(['baja!', 'lex!gx', 'lex!workbench', 'bajaux/spandrel', 'bajaux/Widget', 'nmodule/gx/rc/baja/Point', 'nmodule/gx/rc/baja/PolygonGeom', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/table/EditTable', 'nmodule/webEditors/rc/wb/table/Table'], function (baja, lexs, wbLex, spandrel, Widget, Point, PolygonGeom, feDialogs, EditTable, Table) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    gxLex = _lexs[0];
  var _wbLex = _slicedToArray(wbLex, 1),
    workbenchLex = _wbLex[0];
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'gx',
      keyName: 'PolygonGeomEditor',
      properties: {
        rootCssClass: '-t-PolygonGeomEditor'
      }
    };
  };
  var miniFormFactor = Widget.formFactor.mini;
  var display = EditTable.columns.display;
  var columns = [display('point', {
    displayName: gxLex.get('GeomEditor.label.geom')
  })];
  var ROW_SELECTION_CHANGED_EVENT = Table.ROW_SELECTION_CHANGED_EVENT;

  /**
   * @param geom
   * @param index
   * @returns {module:nmodule/gx/rc/baja/Point}
   * @throws {Error} Throws an Error, when point is undefined.
   */
  function getPointAtIndex(geom, index) {
    try {
      return new Point(geom.xAt(index), geom.yAt(index));
    } catch (err) {
      return Point.NULL;
    }
  }

  /**
   * A field editor for manipulating polygon geometries
   *
   * @class
   * @alias module:nmodule/gx/rc/fe/PolygonGeomEditor
   * @extends module:bajaux/spandrel
   */
  var PolygonGeomEditor = /*#__PURE__*/function (_spandrel) {
    function PolygonGeomEditor(params) {
      _classCallCheck(this, PolygonGeomEditor);
      return _callSuper(this, PolygonGeomEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * @param {module:nmodule/gx/rc/baja/PolygonGeom} geom
     * @returns {{points: Array<Object>, point: Object}}
     */
    _inherits(PolygonGeomEditor, _spandrel);
    return _createClass(PolygonGeomEditor, [{
      key: "toState",
      value: function toState(geom) {
        var points = this.$toRows(geom);
        var point = getPointAtIndex(geom, 0);
        return {
          points: points,
          point: point
        };
      }

      /**
       * From the EditTable reconstruct a PolygonGeom
       * @param {Object} points
       * @returns {module:nmodule/gx/rc/baja/PolygonGeom}
       * @throws {Error} Throws an Error, when user enters an invalid geom string.
       */
    }, {
      key: "fromState",
      value: function fromState(_ref) {
        var points = _ref.points;
        return this.$fromRows({
          points: points
        });
      }

      /**
       * When EditTable row is selected, update the selected point.
       * Now the PointEditor can reflect the data from the new row.
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$syncPointWithSelectedRow",
      value: function $syncPointWithSelectedRow() {
        var table = this.$getEditTable().$getTable();
        var rows = table.getSelectedRows();
        if (rows.length > 0) {
          var geom = PolygonGeom.make(rows[0].getSubject().point.value);
          var point = getPointAtIndex(geom, 0);
          return this.state({
            point: point
          });
        }
        return this.state({
          point: null
        });
      }

      /**
       * When the PointEditor is changed the EditTable row
       * that stores that point value also needs to be updated.
       *
       * Overwrites the value currently stored in the row with the new modified value.
       * @private
       * @param newPoint
       * @returns {Promise}
       */
    }, {
      key: "$syncRowWithModifiedPoint",
      value: function $syncRowWithModifiedPoint(newPoint) {
        var table = this.$getEditTable().$getTable();
        var selectedRows = table.getSelectedRows();
        var newRows = this.state().points.slice();
        function createRowFromPoint() {
          if (selectedRows.length === 1) {
            var polygonString = newPoint.x() + "," + newPoint.y();
            return {
              point: {
                value: polygonString
              }
            };
          }
        }
        var index = table.getModel().getRowIndex(table.getSelectedRows()[0]);
        newRows[index] = createRowFromPoint();
        return this.state({
          points: newRows,
          point: newPoint
        });
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getEditTable",
      value: function $getEditTable() {
        return this.queryWidget('points');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPointEditor",
      value: function $getPointEditor() {
        var pointEditor = this.queryWidget('point');
        return pointEditor instanceof PointEditor && pointEditor;
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getMini",
      value: function $getMini() {
        return this.queryWidget('mini');
      }

      /**
       * Parse a PolygonGeom into rows for EditTable
       * @private
       * @param {module:nmodule/gx/rc/baja/PolygonGeom} geom
       * @returns {Array.<Object>}
       */
    }, {
      key: "$toRows",
      value: function $toRows(geom) {
        return geom.getPoints().map(function (point) {
          return {
            point: {
              value: point.x() + ',' + point.y()
            }
          };
        });
      }

      /**
       * Parse an EditTable row into a PolygonGeom
       * @private
       * @param  {Array.<Object>} points
       * @returns {module:nmodule/gx/rc/baja/PolygonGeom}
       * @throws {Error} Throws an Error, when user enters an invalid geom string.
       */
    }, {
      key: "$fromRows",
      value: function $fromRows(_ref2) {
        var points = _ref2.points;
        var polygonStr = points.map(function (_ref3) {
          var point = _ref3.point;
          return point.value;
        }).join(' ');
        try {
          return PolygonGeom.make(polygonStr);
        } catch (err) {
          throw new Error(gxLex.get('PolygonGeomEditor.invalidPoint.message', polygonStr));
        }
      }
    }]);
  }(spandrel(function (geom, _ref4) {
    var self = _ref4.self,
      points = _ref4.points,
      point = _ref4.point,
      formFactor = _ref4.formFactor;
    if (formFactor === miniFormFactor) {
      return spandrel.jsx("any", {
        spandrelKey: "mini",
        value: geom.encodeToString(),
        readonly: "true"
      });
    } else {
      return [spandrel.jsx(EditTable, {
        bind: true,
        lax: true,
        spandrelKey: "points",
        value: points,
        on: _defineProperty({}, ROW_SELECTION_CHANGED_EVENT, function () {
          return self.$syncPointWithSelectedRow().then(function () {
            return self.setModified(true);
          });
        }),
        properties: {
          columns: columns,
          showControls: true,
          getNew: function getNew() {
            return {
              point: {
                value: '0,0'
              }
            };
          }
        }
      }), !points[0] ? spandrel.jsx("wbr", {
        spandrelKey: "point"
      }) : spandrel.jsx(PointEditor, {
        bind: true,
        lax: true,
        spandrelKey: "point",
        value: point,
        validate: true,
        className: '-t-PointEditor',
        onUxModifiedValue: function onUxModifiedValue(newPoint) {
          return self.$syncRowWithModifiedPoint(newPoint).then(function () {
            return self.setModified(true);
          });
        }
      })];
    }
  }, {
    strategy: 'niagara'
  }));
  /**
   * A field editor for manipulating Points
   *
   * @class
   * @alias module:nmodule/gx/rc/fe/PolygonGeomEditor
   * @extends module:bajaux/spandrel
   */
  var PointEditor = /*#__PURE__*/function (_spandrel2) {
    function PointEditor() {
      _classCallCheck(this, PointEditor);
      return _callSuper(this, PointEditor, arguments);
    }
    _inherits(PointEditor, _spandrel2);
    return _createClass(PointEditor, [{
      key: "toState",
      value:
      /**
       * @param point
       * @returns {{x: *, y: *}}
       */
      function toState(point) {
        return {
          x: point.x(),
          y: point.y()
        };
      }

      /**
       * @param x
       * @param y
       * @returns {Array.<Object>}
       */
    }, {
      key: "fromState",
      value: function fromState(_ref6) {
        var x = _ref6.x,
          y = _ref6.y;
        return getPointAtIndex(PolygonGeom.make(x + ',' + y), 0);
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getX",
      value: function $getX() {
        return this.queryWidget('row1/x');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getY",
      value: function $getY() {
        return this.queryWidget('row2/y');
      }
    }]);
  }(spandrel(function (point, _ref7) {
    var x = _ref7.x,
      y = _ref7.y;
    return [spandrel.jsx("div", {
      spandrelKey: "row1",
      className: '-t-PointEditor-row'
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.x')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      spandrelKey: "x",
      validate: true,
      value: x
    })), spandrel.jsx("div", {
      spandrelKey: "row2",
      className: '-t-PointEditor-row'
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.y')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      spandrelKey: "y",
      validate: true,
      value: y
    }))];
  }, {
    strategy: 'niagara'
  }));
  return PolygonGeomEditor;
});
