function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/gx/rc/fe/PathGeomEditor
 * @since Niagara 4.15
 */
define(['baja!', 'baja!gx:PathGeom', 'lex!gx', 'lex!workbench', 'bajaux/spandrel', 'bajaux/Widget', 'nmodule/gx/rc/baja/PathGeom', 'nmodule/webEditors/rc/fe/RadioButtonGroup', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/wb/table/EditTable', 'nmodule/webEditors/rc/wb/table/Table'], function (baja, types, lexs, wbLex, spandrel, Widget, PathGeom, RadioButtonGroup, OrderedMapEditor, EditTable, Table) {
  'use strict';

  var miniFormFactor = Widget.formFactor.mini;
  var _lexs = _slicedToArray(lexs, 1),
    gxLex = _lexs[0];
  var _wbLex = _slicedToArray(wbLex, 1),
    workbenchLex = _wbLex[0];
  var ROW_SELECTION_CHANGED_EVENT = Table.ROW_SELECTION_CHANGED_EVENT;
  var display = EditTable.columns.display;
  var columns = [display('segment', {
    displayName: gxLex.get('GeomEditor.label.geom')
  })];
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'gx',
      keyName: 'PathGeomEditor',
      properties: {
        rootCssClass: '-t-PathGeomEditor'
      }
    };
  };
  var lexMap = _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty({}, workbenchLex.get('pathGeomFE.moveTo'), 'M'), workbenchLex.get('pathGeomFE.lineTo'), 'L'), workbenchLex.get('pathGeomFE.hLineTo'), 'H'), workbenchLex.get('pathGeomFE.vLineTo'), 'V'), workbenchLex.get('pathGeomFE.curveTo'), 'C'), workbenchLex.get('pathGeomFE.smoothCurveTo'), 'S'), workbenchLex.get('pathGeomFE.quadTo'), 'Q'), workbenchLex.get('pathGeomFE.smoothQuadTo'), 'T'), workbenchLex.get('pathGeomFE.arcTo'), 'A'), workbenchLex.get('pathGeomFE.closePath'), 'Z');

  /**
   * Takes a PathGeom and converts it to a Segment
   * @param {module:nmodule/gx/rc/baja/PathGeom} pathGeom
   * @returns {module:nmodule/gx/rc/baja/PathGeom~Segment}
   */
  function makeSegment(pathGeom) {
    return pathGeom.$getSegmentByIndex(0);
  }

  /**
   * A field editor for manipulating path geometries
   *
   * @class
   * @alias module:nmodule/gx/rc/fe/PathGeomEditor
   * @extends module:bajaux/spandrel
   */
  var PathGeomEditor = /*#__PURE__*/function (_spandrel) {
    function PathGeomEditor(params) {
      _classCallCheck(this, PathGeomEditor);
      return _callSuper(this, PathGeomEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * @param {module:nmodule/gx/rc/baja/PathGeom} geom
     * @returns {{rows: Array<Object>, selectedSegment: module:nmodule/gx/rc/baja/PathGeom~Segment}}
     */
    _inherits(PathGeomEditor, _spandrel);
    return _createClass(PathGeomEditor, [{
      key: "toState",
      value: function toState(geom) {
        var rows = this.$toRows(geom);
        var selectedSegment = makeSegment(geom);
        return {
          rows: rows,
          selectedSegment: selectedSegment
        };
      }

      /**
       * @param {Object} rows
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       * @throws {Error} Throws an Error, when user enters an invalid geom string.
       */
    }, {
      key: "fromState",
      value: function fromState(_ref) {
        var rows = _ref.rows;
        return this.$fromRows({
          rows: rows
        });
      }

      /**
       * Parse a PathGeom into rows for EditTable
       * @private
       * @param {module:nmodule/gx/rc/baja/PathGeom} geom
       * @returns {Array.<Object>}
       */
    }, {
      key: "$toRows",
      value: function $toRows(geom) {
        return geom.$getSegments().map(function (segment) {
          return {
            segment: {
              value: segment.getCommand() + segment
            }
          };
        });
      }

      /**
       * Parse and EditTable row into a PathGeom
       * @param {rows}
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */
    }, {
      key: "$fromRows",
      value: function $fromRows(_ref2) {
        var rows = _ref2.rows;
        var segmentStr = rows.map(function (_ref3) {
          var segment = _ref3.segment;
          return segment.value;
        }).join(',');
        try {
          return PathGeom.make(segmentStr);
        } catch (err) {
          throw new Error(gxLex.get('PathGeomEditor.invalidSegment.message', segmentStr));
        }
      }

      /**
       * When EditTable row is selected, update the selected segment.
       * Now the SegmentEditor can reflect the data from the new row.
       * @returns {Promise}
       */
    }, {
      key: "$syncSegmentWithSelectedRow",
      value: function $syncSegmentWithSelectedRow() {
        var table = this.$getEditTable().$getTable();
        var rows = table.getSelectedRows();
        if (rows.length > 0) {
          // Using the pathString value stored in EditTable rows create a Segment
          var geom = PathGeom.make(rows[0].getSubject().segment.value);
          var segment = makeSegment(geom);
          return this.state({
            selectedSegment: segment
          });
        }
        return this.state({
          selectedSegment: null
        });
      }

      /**
       * When the SegmentEditor is changed the EditTable row
       * that stores that segment value also needs to be updated.
       *
       * Overwrites the value currently stored in the row with the new modified value.
       * @param newSegment
       * @returns {Promise}
       */
    }, {
      key: "$syncRowWithModifiedSegment",
      value: function $syncRowWithModifiedSegment(newSegment) {
        var table = this.$getEditTable().$getTable();
        var selectedRows = table.getSelectedRows();
        var newRows = this.state().rows.slice();
        function createRowFromSegment() {
          if (selectedRows.length === 1) {
            var pathString = newSegment.getCommand() + newSegment.toString();
            return {
              segment: {
                value: pathString
              }
            };
          }
        }
        var index = table.getModel().getRowIndex(table.getSelectedRows()[0]);
        newRows[index] = createRowFromSegment();
        return this.state({
          rows: newRows,
          selectedSegment: newSegment
        });
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getEditTable",
      value: function $getEditTable() {
        return this.queryWidget('PathGeomEditor/rows');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getSegmentEditor",
      value: function $getSegmentEditor() {
        var segEd = this.queryWidget('PathGeomEditor/segEd');
        return segEd instanceof SegmentEditor && segEd;
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getMini",
      value: function $getMini() {
        return this.queryWidget('pathString');
      }
    }]);
  }(spandrel(function (geom, _ref4) {
    var self = _ref4.self,
      rows = _ref4.rows,
      selectedSegment = _ref4.selectedSegment,
      formFactor = _ref4.formFactor;
    if (formFactor === miniFormFactor) {
      return spandrel.jsx("any", {
        spandrelKey: "pathString",
        value: geom.encodeToString(),
        readonly: "true"
      });
    } else {
      return spandrel.jsx("div", {
        spandrelKey: "PathGeomEditor",
        className: "-t-PathGeomEditor-wrapper"
      }, spandrel.jsx(EditTable, {
        bind: true,
        lax: true,
        spandrelKey: "rows",
        value: rows,
        on: _defineProperty({}, ROW_SELECTION_CHANGED_EVENT, function () {
          return self.$syncSegmentWithSelectedRow().then(function () {
            return self.setModified(true);
          });
        }),
        properties: {
          columns: columns,
          showControls: true,
          getNew: function getNew() {
            return {
              segment: {
                value: 'm0,0'
              }
            };
          }
        }
      }), !selectedSegment ? spandrel.jsx("wbr", {
        spandrelKey: "segEd"
      }) : spandrel.jsx(SegmentEditor, {
        bind: true,
        lax: true,
        spandrelKey: "segEd",
        validate: true,
        className: "-t-SegmentEditor",
        value: selectedSegment,
        onUxModifiedValue: function onUxModifiedValue(newSegment) {
          return self.$syncRowWithModifiedSegment(newSegment).then(function () {
            return self.setModified(true);
          });
        }
      }));
    }
  }, {
    strategy: 'niagara'
  }));
  /**
   * A field editor for manipulating Segments
   *
   * @class
   * @alias module:nmodule/gx/rc/fe/PathGeomEditor
   * @extends module:bajaux/spandrel
   */
  var SegmentEditor = /*#__PURE__*/function (_spandrel2) {
    function SegmentEditor() {
      _classCallCheck(this, SegmentEditor);
      return _callSuper(this, SegmentEditor, arguments);
    }
    _inherits(SegmentEditor, _spandrel2);
    return _createClass(SegmentEditor, [{
      key: "toState",
      value: function toState(selectedSegment) {
        return {
          segmentChar: selectedSegment.getCommand().toUpperCase(),
          absolute: this.segmentChar !== 'Z' ? selectedSegment.getAbsolute().toString() : null,
          uniqueSeg: selectedSegment
        };
      }
    }, {
      key: "fromState",
      value: function fromState(_ref6) {
        var segmentChar = _ref6.segmentChar,
          absolute = _ref6.absolute,
          uniqueSeg = _ref6.uniqueSeg;
        var _char;
        if (segmentChar !== 'Z') {
          if (absolute.toString() === 'false') {
            _char = segmentChar.toLowerCase();
          } else {
            _char = segmentChar;
          }
          var pathString = PathGeom.make(_char + uniqueSeg.toString().substring(0).toLowerCase());
          return makeSegment(pathString);
        }
        return makeSegment(PathGeom.make(segmentChar));
      }

      /**
       * Creates and updates the unique segment based on the selected segment type character
       * @private
       * @param {String} newSegmentChar
       * @return {Promise}
       */
    }, {
      key: "$createSegmentByType",
      value: function $createSegmentByType(newSegmentChar) {
        var segment;
        switch (newSegmentChar) {
          case 'M':
            segment = makeSegment(PathGeom.make('m0.0,0.0'));
            break;
          case 'L':
            segment = makeSegment(PathGeom.make('L0.0,0.0'));
            break;
          case 'H':
            segment = makeSegment(PathGeom.make('H0.0'));
            break;
          case 'V':
            segment = makeSegment(PathGeom.make('V0.0'));
            break;
          case 'C':
            segment = makeSegment(PathGeom.make('C0.0,0.0 0.0,0.0 0.0,0.0'));
            break;
          case 'S':
            segment = makeSegment(PathGeom.make('S0.0,0.0 0.0,0.0'));
            break;
          case 'Q':
            segment = makeSegment(PathGeom.make('Q0.0,0.0 0.0,0.0'));
            break;
          case 'T':
            segment = makeSegment(PathGeom.make('T0.0,0.0'));
            break;
          case 'A':
            segment = makeSegment(PathGeom.make('A0.0,0.0 0.0 1,1 0.0,0.0'));
            break;
          default:
            segment = makeSegment(PathGeom.make('Z'));
        }
        return this.state({
          uniqueSeg: segment
        });
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getDropdown",
      value: function $getDropdown() {
        return this.queryWidget('SegmentEditor/segmentChar');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getRadioButtons",
      value: function $getRadioButtons() {
        return this.queryWidget('SegmentEditor/container/row2/absolute');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getUniqueSegment",
      value: function $getUniqueSegment() {
        return this.queryWidget('SegmentEditor/container/row3/uniqueSeg');
      }
    }]);
  }(spandrel(function (selectedSegment, _ref7) {
    var self = _ref7.self,
      segmentChar = _ref7.segmentChar,
      absolute = _ref7.absolute,
      uniqueSeg = _ref7.uniqueSeg;
    var segmentMap = {
      M: MoveSegmentEditor,
      L: LineSegmentEditor,
      H: HLineSegmentEditor,
      V: VLineSegmentEditor,
      C: CurveSegmentEditor,
      S: SmoothCurveSegmentEditor,
      Q: QuadSegmentEditor,
      T: SmoothQuadSegmentEditor,
      A: ArcSegmentEditor
    };
    var UniqueSegmentEditor = segmentMap[segmentChar];
    return spandrel.jsx("div", {
      spandrelKey: "SegmentEditor",
      className: "-t-SegmentEditor-wrapper"
    }, spandrel.jsx(OrderedMapEditor, {
      bind: true,
      lax: true,
      spandrelKey: "segmentChar",
      value: segmentChar,
      onUxModifiedValue: function onUxModifiedValue(newSegmentChar) {
        return self.$createSegmentByType(newSegmentChar);
      },
      properties: {
        map: lexMap
      }
    }), segmentChar !== 'Z' ? spandrel.jsx("div", {
      spandrelKey: "container"
    }, spandrel.jsx("div", {
      spandrelKey: "row2"
    }, spandrel.jsx(RadioButtonGroup, {
      bind: true,
      lax: true,
      spandrelKey: "absolute",
      className: "-t-SegmentEditor-radioButtonGroup",
      tagName: "span",
      value: absolute,
      properties: {
        options: [{
          displayName: ' ' + workbenchLex.get('pathGeomFE.absolute'),
          value: 'true'
        }, {
          displayName: ' ' + workbenchLex.get('pathGeomFE.relative'),
          value: 'false'
        }]
      }
    })), spandrel.jsx("div", {
      spandrelKey: "row3",
      className: "-t-SegmentEditor-row"
    }, spandrel.jsx(UniqueSegmentEditor, {
      bind: true,
      lax: true,
      spandrelKey: "uniqueSeg",
      className: "-t-SegmentEditor-uniqueSegmentEditor",
      value: uniqueSeg
    }))) : null);
  }, {
    strategy: 'niagara'
  }));
  /**
   * A field editor for manipulating Move Segments
   *
   * @class
   * @alias module:nmodule/gx/rc/fe/PathGeomEditor
   * @extends module:bajaux/spandrel
   */
  var MoveSegmentEditor = /*#__PURE__*/function (_spandrel3) {
    function MoveSegmentEditor() {
      _classCallCheck(this, MoveSegmentEditor);
      return _callSuper(this, MoveSegmentEditor, arguments);
    }
    _inherits(MoveSegmentEditor, _spandrel3);
    return _createClass(MoveSegmentEditor, [{
      key: "toState",
      value: function toState(moveSegment) {
        return {
          x: moveSegment.getPoint().x(),
          y: moveSegment.getPoint().y()
        };
      }
    }, {
      key: "fromState",
      value: function fromState(_ref8) {
        var x = _ref8.x,
          y = _ref8.y;
        return makeSegment(PathGeom.make('M' + x.encodeToString() + ',' + y.encodeToString()));
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getX",
      value: function $getX() {
        return this.queryWidget('move/row1/x');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getY",
      value: function $getY() {
        return this.queryWidget('move/row2/y');
      }
    }]);
  }(spandrel(function (moveSegment, _ref9) {
    var x = _ref9.x,
      y = _ref9.y;
    return spandrel.jsx("div", {
      spandrelKey: "move"
    }, spandrel.jsx("div", {
      spandrelKey: "row1",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.x')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: "x",
      tagName: "span",
      formFactor: "mini",
      value: x
    })), spandrel.jsx("div", {
      spandrelKey: "row2",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.y')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'y',
      tagName: "span",
      formFactor: "mini",
      value: y
    })));
  }, {
    strategy: 'niagara'
  }));
  /**
   * A field editor for manipulating Line Segments
   *
   * @class
   * @alias module:nmodule/gx/rc/fe/PathGeomEditor
   * @extends module:bajaux/spandrel
   */
  var LineSegmentEditor = /*#__PURE__*/function (_spandrel4) {
    function LineSegmentEditor() {
      _classCallCheck(this, LineSegmentEditor);
      return _callSuper(this, LineSegmentEditor, arguments);
    }
    _inherits(LineSegmentEditor, _spandrel4);
    return _createClass(LineSegmentEditor, [{
      key: "toState",
      value: function toState(lineSegment) {
        return {
          x: lineSegment.getPoint().x(),
          y: lineSegment.getPoint().y()
        };
      }
    }, {
      key: "fromState",
      value: function fromState(_ref10) {
        var x = _ref10.x,
          y = _ref10.y;
        return makeSegment(PathGeom.make('L' + x.encodeToString() + ',' + y.encodeToString()));
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getX",
      value: function $getX() {
        return this.queryWidget('line/row1/x');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getY",
      value: function $getY() {
        return this.queryWidget('line/row2/y');
      }
    }]);
  }(spandrel(function (lineSegment, _ref11) {
    var x = _ref11.x,
      y = _ref11.y;
    return spandrel.jsx("div", {
      spandrelKey: "line"
    }, spandrel.jsx("div", {
      spandrelKey: "row1",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.x')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: "x",
      tagName: "span",
      formFactor: "mini",
      value: x
    })), spandrel.jsx("div", {
      spandrelKey: "row2",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.y')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'y',
      tagName: "span",
      formFactor: "mini",
      value: y
    })));
  }, {
    strategy: 'niagara'
  }));
  /**
   * A field editor for manipulating HLine Segments
   *
   * @class
   * @alias module:nmodule/gx/rc/fe/PathGeomEditor
   * @extends module:bajaux/spandrel
   */
  var HLineSegmentEditor = /*#__PURE__*/function (_spandrel5) {
    function HLineSegmentEditor() {
      _classCallCheck(this, HLineSegmentEditor);
      return _callSuper(this, HLineSegmentEditor, arguments);
    }
    _inherits(HLineSegmentEditor, _spandrel5);
    return _createClass(HLineSegmentEditor, [{
      key: "toState",
      value: function toState(hlineSegment) {
        return {
          x: hlineSegment.getX()
        };
      }
    }, {
      key: "fromState",
      value: function fromState(_ref12) {
        var x = _ref12.x;
        return makeSegment(PathGeom.make('H' + x.encodeToString()));
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getX",
      value: function $getX() {
        return this.queryWidget('hline/row/x');
      }
    }]);
  }(spandrel(function (hlineSegment, _ref13) {
    var x = _ref13.x;
    return spandrel.jsx("div", {
      spandrelKey: "hline"
    }, spandrel.jsx("div", {
      spandrelKey: "row",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.x')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'x',
      tagName: "span",
      formFactor: "mini",
      value: x
    })));
  }, {
    strategy: 'niagara'
  }));
  /**
   * A field editor for manipulating VLine Segments
   *
   * @class
   * @alias module:nmodule/gx/rc/fe/PathGeomEditor
   * @extends module:bajaux/spandrel
   */
  var VLineSegmentEditor = /*#__PURE__*/function (_spandrel6) {
    function VLineSegmentEditor() {
      _classCallCheck(this, VLineSegmentEditor);
      return _callSuper(this, VLineSegmentEditor, arguments);
    }
    _inherits(VLineSegmentEditor, _spandrel6);
    return _createClass(VLineSegmentEditor, [{
      key: "toState",
      value: function toState(vlineSegment) {
        return {
          y: vlineSegment.getY()
        };
      }
    }, {
      key: "fromState",
      value: function fromState(_ref14) {
        var y = _ref14.y;
        return makeSegment(PathGeom.make('V' + y.encodeToString()));
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getY",
      value: function $getY() {
        return this.queryWidget('vline/row/y');
      }
    }]);
  }(spandrel(function (vlineSegment, _ref15) {
    var y = _ref15.y;
    return spandrel.jsx("div", {
      spandrelKey: "vline"
    }, spandrel.jsx("div", {
      spandrelKey: "row",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.y')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'y',
      tagName: "span",
      formFactor: "mini",
      value: y
    })));
  }, {
    strategy: 'niagara'
  }));
  /**
   * A field editor for manipulating Curve Segments
   *
   * @class
   * @alias module:nmodule/gx/rc/fe/PathGeomEditor
   * @extends module:bajaux/spandrel
   */
  var CurveSegmentEditor = /*#__PURE__*/function (_spandrel7) {
    function CurveSegmentEditor() {
      _classCallCheck(this, CurveSegmentEditor);
      return _callSuper(this, CurveSegmentEditor, arguments);
    }
    _inherits(CurveSegmentEditor, _spandrel7);
    return _createClass(CurveSegmentEditor, [{
      key: "toState",
      value: function toState(curveSegment) {
        return {
          x1: curveSegment.getCp1().x(),
          y1: curveSegment.getCp1().y(),
          x2: curveSegment.getCp2().x(),
          y2: curveSegment.getCp2().y(),
          x: curveSegment.getEnd().x(),
          y: curveSegment.getEnd().y()
        };
      }
    }, {
      key: "fromState",
      value: function fromState(_ref16) {
        var x1 = _ref16.x1,
          y1 = _ref16.y1,
          x2 = _ref16.x2,
          y2 = _ref16.y2,
          x = _ref16.x,
          y = _ref16.y;
        return makeSegment(PathGeom.make('C' + x1.encodeToString() + ',' + y1.encodeToString() + ' ' + x2.encodeToString() + ',' + y2.encodeToString() + ' ' + x.encodeToString() + ',' + y.encodeToString()));
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getX",
      value: function $getX() {
        return this.queryWidget('curve/row1/x');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getY",
      value: function $getY() {
        return this.queryWidget('curve/row2/y');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getX1",
      value: function $getX1() {
        return this.queryWidget('curve/row3/x1');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getY1",
      value: function $getY1() {
        return this.queryWidget('curve/row4/y1');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getX2",
      value: function $getX2() {
        return this.queryWidget('curve/row5/x2');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getY2",
      value: function $getY2() {
        return this.queryWidget('curve/row6/y2');
      }
    }]);
  }(spandrel(function (curveSegment, _ref17) {
    var x1 = _ref17.x1,
      y1 = _ref17.y1,
      x2 = _ref17.x2,
      y2 = _ref17.y2,
      x = _ref17.x,
      y = _ref17.y;
    return spandrel.jsx("div", {
      spandrelKey: "curve"
    }, spandrel.jsx("div", {
      spandrelKey: "row1",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.x')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      spandrelKey: "x",
      tagName: "span",
      formFactor: "mini",
      value: x
    })), spandrel.jsx("div", {
      spandrelKey: "row2",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.y')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'y',
      tagName: "span",
      formFactor: "mini",
      value: y
    })), spandrel.jsx("div", {
      spandrelKey: "row3",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.x1')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'x1',
      tagName: "span",
      formFactor: "mini",
      value: x1
    })), spandrel.jsx("div", {
      spandrelKey: "row4",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.y1')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'y1',
      tagName: "span",
      formFactor: "mini",
      value: y1
    })), spandrel.jsx("div", {
      spandrelKey: "row5",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.x2')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'x2',
      tagName: "span",
      formFactor: "mini",
      value: x2
    })), spandrel.jsx("div", {
      spandrelKey: "row6",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.y2')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'y2',
      tagName: "span",
      formFactor: "mini",
      value: y2
    })));
  }, {
    strategy: 'niagara'
  }));
  /**
   * A field editor for manipulating Smooth Curve Segments
   *
   * @class
   * @alias module:nmodule/gx/rc/fe/PathGeomEditor
   * @extends module:bajaux/spandrel
   */
  var SmoothCurveSegmentEditor = /*#__PURE__*/function (_spandrel8) {
    function SmoothCurveSegmentEditor() {
      _classCallCheck(this, SmoothCurveSegmentEditor);
      return _callSuper(this, SmoothCurveSegmentEditor, arguments);
    }
    _inherits(SmoothCurveSegmentEditor, _spandrel8);
    return _createClass(SmoothCurveSegmentEditor, [{
      key: "toState",
      value: function toState(smoothCurveSegment) {
        return {
          x2: smoothCurveSegment.getCp2().x(),
          y2: smoothCurveSegment.getCp2().y(),
          x: smoothCurveSegment.getEnd().x(),
          y: smoothCurveSegment.getEnd().y()
        };
      }
    }, {
      key: "fromState",
      value: function fromState(_ref18) {
        var x2 = _ref18.x2,
          y2 = _ref18.y2,
          x = _ref18.x,
          y = _ref18.y;
        return makeSegment(PathGeom.make('S' + x2.encodeToString() + ',' + y2.encodeToString() + ' ' + x.encodeToString() + ',' + y.encodeToString()));
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getX",
      value: function $getX() {
        return this.queryWidget('smoothCurve/row1/x');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getY",
      value: function $getY() {
        return this.queryWidget('smoothCurve/row2/y');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getX2",
      value: function $getX2() {
        return this.queryWidget('smoothCurve/row3/x2');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getY2",
      value: function $getY2() {
        return this.queryWidget('smoothCurve/row4/y2');
      }
    }]);
  }(spandrel(function (smoothCurveSegment, _ref19) {
    var x2 = _ref19.x2,
      y2 = _ref19.y2,
      x = _ref19.x,
      y = _ref19.y;
    return spandrel.jsx("div", {
      spandrelKey: "smoothCurve"
    }, spandrel.jsx("div", {
      spandrelKey: "row1",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.x')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: "x",
      tagName: "span",
      formFactor: "mini",
      value: x
    })), spandrel.jsx("div", {
      spandrelKey: "row2",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.y')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'y',
      tagName: "span",
      formFactor: "mini",
      value: y
    })), spandrel.jsx("div", {
      spandrelKey: "row3",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.x2')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'x2',
      tagName: "span",
      formFactor: "mini",
      value: x2
    })), spandrel.jsx("div", {
      spandrelKey: "row4",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.y2')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'y2',
      tagName: "span",
      formFactor: "mini",
      value: y2
    })));
  }, {
    strategy: 'niagara'
  }));
  /**
   * A field editor for manipulating Quad Segments
   *
   * @class
   * @alias module:nmodule/gx/rc/fe/PathGeomEditor
   * @extends module:bajaux/spandrel
   */
  var QuadSegmentEditor = /*#__PURE__*/function (_spandrel9) {
    function QuadSegmentEditor() {
      _classCallCheck(this, QuadSegmentEditor);
      return _callSuper(this, QuadSegmentEditor, arguments);
    }
    _inherits(QuadSegmentEditor, _spandrel9);
    return _createClass(QuadSegmentEditor, [{
      key: "toState",
      value: function toState(quadSegment) {
        return {
          x1: quadSegment.getCp().x(),
          y1: quadSegment.getCp().y(),
          x: quadSegment.getEnd().x(),
          y: quadSegment.getEnd().y()
        };
      }
    }, {
      key: "fromState",
      value: function fromState(_ref20) {
        var x1 = _ref20.x1,
          y1 = _ref20.y1,
          x = _ref20.x,
          y = _ref20.y;
        return makeSegment(PathGeom.make('Q' + x1.encodeToString() + ',' + y1.encodeToString() + ' ' + x.encodeToString() + ',' + y.encodeToString()));
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getX",
      value: function $getX() {
        return this.queryWidget('quad/row1/x');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getY",
      value: function $getY() {
        return this.queryWidget('quad/row2/y');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getX1",
      value: function $getX1() {
        return this.queryWidget('quad/row3/x1');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getY1",
      value: function $getY1() {
        return this.queryWidget('quad/row4/y1');
      }
    }]);
  }(spandrel(function (quadSegment, _ref21) {
    var x1 = _ref21.x1,
      y1 = _ref21.y1,
      x = _ref21.x,
      y = _ref21.y;
    return spandrel.jsx("div", {
      spandrelKey: "quad"
    }, spandrel.jsx("div", {
      spandrelKey: "row1",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.x')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: "x",
      tagName: "span",
      formFactor: "mini",
      value: x
    })), spandrel.jsx("div", {
      spandrelKey: "row2",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.y')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'y',
      tagName: "span",
      formFactor: "mini",
      value: y
    })), spandrel.jsx("div", {
      spandrelKey: "row3",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.x1')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'x1',
      tagName: "span",
      formFactor: "mini",
      value: x1
    })), spandrel.jsx("div", {
      spandrelKey: "row4",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.y1')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'y1',
      tagName: "span",
      formFactor: "mini",
      value: y1
    })));
  }, {
    strategy: 'niagara'
  }));
  /**
   * A field editor for manipulating Smooth Quad Segments
   *
   * @class
   * @alias module:nmodule/gx/rc/fe/PathGeomEditor
   * @extends module:bajaux/spandrel
   */
  var SmoothQuadSegmentEditor = /*#__PURE__*/function (_spandrel10) {
    function SmoothQuadSegmentEditor() {
      _classCallCheck(this, SmoothQuadSegmentEditor);
      return _callSuper(this, SmoothQuadSegmentEditor, arguments);
    }
    _inherits(SmoothQuadSegmentEditor, _spandrel10);
    return _createClass(SmoothQuadSegmentEditor, [{
      key: "toState",
      value: function toState(quadSegment) {
        return {
          x: quadSegment.getEnd().x(),
          y: quadSegment.getEnd().y()
        };
      }
    }, {
      key: "fromState",
      value: function fromState(_ref22) {
        var x = _ref22.x,
          y = _ref22.y;
        return makeSegment(PathGeom.make('T' + x.encodeToString() + ',' + y.encodeToString()));
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getX",
      value: function $getX() {
        return this.queryWidget('smoothQuad/row1/x');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getY",
      value: function $getY() {
        return this.queryWidget('smoothQuad/row2/y');
      }
    }]);
  }(spandrel(function (smoothQuadSegment, _ref23) {
    var x = _ref23.x,
      y = _ref23.y;
    return spandrel.jsx("div", {
      spandrelKey: "smoothQuad"
    }, spandrel.jsx("div", {
      spandrelKey: "row1",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.x')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: "x",
      tagName: "span",
      formFactor: "mini",
      value: x
    })), spandrel.jsx("div", {
      spandrelKey: "row2",
      "class": "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.y')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'y',
      tagName: "span",
      formFactor: "mini",
      value: y
    })));
  }, {
    strategy: 'niagara'
  }));
  /**
   * A field editor for manipulating Arc Segments
   *
   * @class
   * @alias module:nmodule/gx/rc/fe/PathGeomEditor
   * @extends module:bajaux/spandrel
   */
  var ArcSegmentEditor = /*#__PURE__*/function (_spandrel11) {
    function ArcSegmentEditor() {
      _classCallCheck(this, ArcSegmentEditor);
      return _callSuper(this, ArcSegmentEditor, arguments);
    }
    _inherits(ArcSegmentEditor, _spandrel11);
    return _createClass(ArcSegmentEditor, [{
      key: "toState",
      value: function toState(arcSegment) {
        return {
          x: arcSegment.getEnd().x(),
          y: arcSegment.getEnd().y(),
          rx: arcSegment.getRadiusX(),
          ry: arcSegment.getRadiusY(),
          xAxisRotation: arcSegment.getXAxisRotation(),
          largeArcFlag: arcSegment.getLargeArcFlag(),
          sweepFlag: arcSegment.getSweepFlag()
        };
      }
    }, {
      key: "fromState",
      value: function fromState(_ref24) {
        var rx = _ref24.rx,
          ry = _ref24.ry,
          xAxisRotation = _ref24.xAxisRotation,
          largeArcFlag = _ref24.largeArcFlag,
          sweepFlag = _ref24.sweepFlag,
          x = _ref24.x,
          y = _ref24.y;
        return makeSegment(PathGeom.make('A' + rx.encodeToString() + ',' + ry.encodeToString() + ' ' + xAxisRotation.encodeToString() + ' ' + largeArcFlag.getOrdinal().encodeToString() + ',' + sweepFlag.getOrdinal().encodeToString() + ' ' + x.encodeToString() + ',' + y.encodeToString()));
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getX",
      value: function $getX() {
        return this.queryWidget('arc/row1/x');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getY",
      value: function $getY() {
        return this.queryWidget('arc/row2/y');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getRX",
      value: function $getRX() {
        return this.queryWidget('arc/row3/rx');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getRY",
      value: function $getRY() {
        return this.queryWidget('arc/row4/ry');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getXAxisRotation",
      value: function $getXAxisRotation() {
        return this.queryWidget('arc/row5/xAxisRotation');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getLargeArcFlag",
      value: function $getLargeArcFlag() {
        return this.queryWidget('arc/row6/largeArcFlag');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getSweepFlag",
      value: function $getSweepFlag() {
        return this.queryWidget('arc/row7/sweepFlag');
      }
    }]);
  }(spandrel(function (arcSegment, _ref25) {
    var rx = _ref25.rx,
      ry = _ref25.ry,
      xAxisRotation = _ref25.xAxisRotation,
      largeArcFlag = _ref25.largeArcFlag,
      sweepFlag = _ref25.sweepFlag,
      x = _ref25.x,
      y = _ref25.y;
    return spandrel.jsx("div", {
      spandrelKey: "arc"
    }, spandrel.jsx("div", {
      spandrelKey: "row1",
      className: "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.x')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: "x",
      tagName: "span",
      formFactor: "mini",
      value: x
    })), spandrel.jsx("div", {
      spandrelKey: "row2",
      className: "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.y')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'y',
      tagName: "span",
      formFactor: "mini",
      value: y
    })), spandrel.jsx("div", {
      spandrelKey: "row3",
      className: "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.radX')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'rx',
      tagName: "span",
      formFactor: "mini",
      value: rx
    })), spandrel.jsx("div", {
      spandrelKey: "row4",
      className: "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.radY')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'ry',
      tagName: "span",
      formFactor: "mini",
      value: ry
    })), spandrel.jsx("div", {
      spandrelKey: "row5",
      className: "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.xAxisRot')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'xAxisRotation',
      tagName: "span",
      formFactor: "mini",
      value: xAxisRotation
    })), spandrel.jsx("div", {
      spandrelKey: "row6",
      className: "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.largeArc')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'largeArcFlag',
      value: largeArcFlag
    })), spandrel.jsx("div", {
      spandrelKey: "row7",
      className: "-t-SegmentEditor-row"
    }, spandrel.jsx("label", null, workbenchLex.get('pathGeomFE.sweep')), spandrel.jsx("any", {
      bind: true,
      lax: true,
      validate: true,
      spandrelKey: 'sweepFlag',
      value: sweepFlag
    })));
  }, {
    strategy: 'niagara'
  }));
  return PathGeomEditor;
});
