function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/**
 * API Status: **Private**
 * @module module:nmodule/gx/rc/fe/InsetsEditor
 */
define(['baja!', 'lex!gx', 'bajaux/events', 'bajaux/Widget', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/fe', 'nmodule/gx/rc/baja/Insets', 'css!nmodule/gx/rc/gx'], function (baja, lexs, events, Widget, Promise, _, BaseEditor, fe, Insets) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    gxLex = _lexs[0];
  var topLabel = gxLex.get('insets.top'),
    rightLabel = gxLex.get('insets.right'),
    bottomLabel = gxLex.get('insets.bottom'),
    leftLabel = gxLex.get('insets.left');
  var insetsEditorHtml = function insetsEditorHtml() {
    return "\n    <span class='top'></span>\n    <span class='right'></span>\n    <span class='bottom'></span>\n    <span class='left'></span>\n  ";
  };

  /**
   * Insets Editor is a Baja Ux field editor which stores offsets from the four sides of a rectangle.
   * Top ,right, bottom and left are the four offsets that can be provided in their respective editors
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/gx/rc/fe/InsetsEditor
   */
  var InsetsEditor = /*#__PURE__*/function (_BaseEditor) {
    function InsetsEditor() {
      _classCallCheck(this, InsetsEditor);
      return _callSuper(this, InsetsEditor, arguments);
    }
    _inherits(InsetsEditor, _BaseEditor);
    return _createClass(InsetsEditor, [{
      key: "doInitialize",
      value:
      /**
       * Initializes the top,right,bottom and left insetEditors with value 0
       *
       * @param  {JQuery} dom
       * @returns {Promise}
       */
      function doInitialize(dom) {
        var _this = this;
        dom.addClass('InsetsEditor');
        dom.html(insetsEditorHtml());
        dom.on(events.MODIFY_EVENT, '.type-baja-Number', function () {
          _this.setModified(true);
          return false;
        });
        var insetEditors = [fe.buildFor({
          dom: this.$getTopElement(),
          value: 0,
          properties: {
            prelabel: topLabel
          },
          formFactor: 'mini'
        }), fe.buildFor({
          dom: this.$getRightElement(),
          value: 0,
          properties: {
            prelabel: rightLabel
          },
          formFactor: 'mini'
        }), fe.buildFor({
          dom: this.$getBottomElement(),
          value: 0,
          properties: {
            prelabel: bottomLabel
          },
          formFactor: 'mini'
        }), fe.buildFor({
          dom: this.$getLeftElement(),
          value: 0,
          properties: {
            prelabel: leftLabel
          },
          formFactor: 'mini'
        })];
        return Promise.all(insetEditors);
      }

      /**
       * Loads the top, right, bottom and left values in to the respective editors
       * It checks for the invalid values.
       * Invalid entries include NaN, +inf, -inf, string values or any special characters
       * @param {module:nmodule/gx/rc/baja/Insets} insets
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(insets) {
        var top = insets.getTop(),
          right = insets.getRight(),
          bottom = insets.getBottom(),
          left = insets.getLeft();
        if (isInvalidEntry(top) || isInvalidEntry(right) || isInvalidEntry(bottom) || isInvalidEntry(left)) {
          top = right = bottom = left = 0;
        }
        return Promise.all([this.$getTopEditor().load(top), this.$getRightEditor().load(right), this.$getBottomEditor().load(bottom), this.$getLeftEditor().load(left)]);
      }

      /**
       * Reads the value of top ,right, bottom and left, forms an Inset instance and returns it
       * If an invalid entry is made, Insets are set to 0
       * Invalid entries include NaN, +inf, -inf, string values or any special characters
       * @returns {module:nmodule/gx/rc/baja/Insets}
       */
    }, {
      key: "doRead",
      value: function doRead() {
        var topEditor = this.$getTopEditor(),
          rightEditor = this.$getRightEditor(),
          bottomEditor = this.$getBottomEditor(),
          leftEditor = this.$getLeftEditor();
        return Promise.all([topEditor.read(), rightEditor.read(), bottomEditor.read(), leftEditor.read()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 4),
            top = _ref2[0],
            right = _ref2[1],
            bottom = _ref2[2],
            left = _ref2[3];
          if (isInvalidEntry(top) || isInvalidEntry(right) || isInvalidEntry(bottom) || isInvalidEntry(left)) {
            return Insets.make(0);
          }
          return Insets.make(top, right, bottom, left);
        });
      }

      /**
       * Sets all the child widgets of this editor to readonly.
       *
       * @param {boolean} readonly
       * @returns {Promise}
       */
    }, {
      key: "doReadonly",
      value: function doReadonly(readonly) {
        return this.getChildWidgets().setAllReadonly(readonly);
      }

      /**
       * Sets all the child widgets of this editor to enabled.
       *
       * @param {boolean} enabled
       * @returns {Promise}
       */
    }, {
      key: "doEnabled",
      value: function doEnabled(enabled) {
        return this.getChildWidgets().setAllEnabled(enabled);
      }

      /**
       * Destroys all children of the editor.
       *
       * @returns {Promise}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        return this.getChildWidgets().destroyAll();
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getTopEditor",
      value: function $getTopEditor() {
        return Widget["in"](this.$getTopElement());
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getRightEditor",
      value: function $getRightEditor() {
        return Widget["in"](this.$getRightElement());
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getBottomEditor",
      value: function $getBottomEditor() {
        return Widget["in"](this.$getBottomElement());
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getLeftEditor",
      value: function $getLeftEditor() {
        return Widget["in"](this.$getLeftElement());
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getTopElement",
      value: function $getTopElement() {
        return this.jq().find('.top');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getRightElement",
      value: function $getRightElement() {
        return this.jq().find('.right');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getBottomElement",
      value: function $getBottomElement() {
        return this.jq().find('.bottom');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getLeftElement",
      value: function $getLeftElement() {
        return this.jq().find('.left');
      }
    }]);
  }(BaseEditor);
  function isNumber(number) {
    return typeof number === 'number';
  }
  function isInvalidEntry(side) {
    return side === Number.POSITIVE_INFINITY || side === Number.NEGATIVE_INFINITY || isNaN(side) || !isNumber(side);
  }
  return InsetsEditor;
});
