function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/gx/rc/fe/ImageBrushEditor
 */

define(['baja!', 'baja!gx:Image', 'bajaux/spandrel', 'lex!wbutil', 'nmodule/gx/rc/baja/Brush', 'nmodule/gx/rc/fe/ImageEditor', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/util/htmlUtils'], function (baja, types, spandrel, lexs, Brush, ImageEditor, OrderedMapEditor, htmlUtils) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: "-t-ImageBrushEditor",
        showOptions: {
          value: true,
          hidden: true
        }
      }
    };
  };
  var _lexs = _slicedToArray(lexs, 1),
    WB_UTIL_LEX = _lexs[0];
  var text = function text(attr) {
    return WB_UTIL_LEX.get('imageEditor.' + attr);
  };
  var TILES = _defineProperty(_defineProperty(_defineProperty(_defineProperty({}, text('tileFalse'), 'false'), text('tileTrue'), 'true'), text('tileX'), 'x'), text('tileY'), 'y'),
    HALIGNS = _defineProperty(_defineProperty(_defineProperty({}, text('halignLeft'), 'left'), text('halignCenter'), 'center'), text('halignRight'), 'right'),
    VALIGNS = _defineProperty(_defineProperty(_defineProperty({}, text('valignTop'), 'top'), text('valignCenter'), 'center'), text('valignBottom'), 'bottom');

  /**
   * @class
   * @alias module:nmodule/gx/rc/fe/ImageBrushEditor
   * @extends module:bajaux/spandrel
   */
  return /*#__PURE__*/function (_spandrel) {
    function ImageBrushEditor(params) {
      _classCallCheck(this, ImageBrushEditor);
      return _callSuper(this, ImageBrushEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * 
     * @param {module:nmodule/gx/rc/baja/Brush} brush 
     * @returns {object}
     */
    _inherits(ImageBrushEditor, _spandrel);
    return _createClass(ImageBrushEditor, [{
      key: "toState",
      value: function toState(brush) {
        var str = brush.encodeToString();
        if (!str.startsWith("image")) {
          return {
            image: baja.$('gx:Image', 'null'),
            tile: 'false',
            halign: 'center',
            valign: 'center'
          };
        } else {
          var _brush$getPaint = brush.getPaint(),
            $sourceOrd = _brush$getPaint.$sourceOrd,
            $tile = _brush$getPaint.$tile,
            $vAlign = _brush$getPaint.$vAlign,
            $hAlign = _brush$getPaint.$hAlign;
          return {
            image: baja.$('gx:Image', String($sourceOrd)),
            tile: $tile,
            halign: $hAlign,
            valign: $vAlign
          };
        }
      }
    }, {
      key: "fromState",
      value: function fromState() {
        var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          image = _ref.image,
          tile = _ref.tile,
          valign = _ref.valign,
          halign = _ref.halign;
        return Brush.makeImageBrush(image, {
          tile: tile,
          halign: halign,
          valign: valign
        });
      }

      /**
       * @private
       * @param {string} tile 
       * @returns {Promise}
       */
    }, {
      key: "$tileChangeHandler",
      value: function $tileChangeHandler(tile) {
        var _this = this;
        var _this$state = this.state(),
          halign = _this$state.halign,
          valign = _this$state.valign;
        var newHalign = tile === 'true' || tile === 'x' ? 'center' : halign,
          newValign = tile === 'true' || tile === 'y' ? 'center' : valign;
        return this.state({
          halign: newHalign,
          valign: newValign
        }).then(function () {
          return htmlUtils.resetFocus(_this.jq());
        });
      }
    }]);
  }(spandrel(function (value, _ref2) {
    var self = _ref2.self,
      image = _ref2.image,
      tile = _ref2.tile,
      halign = _ref2.halign,
      valign = _ref2.valign,
      writable = _ref2.writable,
      properties = _ref2.properties;
    var showOptions = properties.showOptions;
    var brush = Brush.makeImageBrush(image, {
      tile: tile,
      halign: halign,
      valign: valign
    });
    return spandrel.jsx("div", {
      className: "-t-ImageBrushEditor-wrapper"
    }, spandrel.jsx("div", null, spandrel.jsx("div", {
      className: "-t-ImageEditor-wrapper"
    }, spandrel.jsx(ImageEditor, {
      value: image,
      spandrelKey: "image",
      bind: true,
      readonly: !writable
    })), showOptions && spandrel.jsx("div", {
      className: "-t-ImageBrushEditor-options"
    }, spandrel.jsx("label", null, text('tile')), spandrel.jsx(OrderedMapEditor, {
      value: tile,
      spandrelKey: "tile",
      bind: true,
      readonly: !writable,
      properties: {
        map: TILES
      },
      onUxModifiedValue: function onUxModifiedValue(newValue) {
        return self.$tileChangeHandler(newValue);
      }
    }), spandrel.jsx("label", null, text('halign')), spandrel.jsx(OrderedMapEditor, {
      value: halign,
      spandrelKey: "halign",
      bind: true,
      lax: true,
      properties: {
        map: HALIGNS
      },
      readonly: !(writable && (tile === 'false' || tile === 'y')),
      onUxModifiedValue: function onUxModifiedValue() {
        return htmlUtils.resetFocus(self.jq());
      }
    }), spandrel.jsx("label", null, text('valign')), spandrel.jsx(OrderedMapEditor, {
      value: valign,
      spandrelKey: "valign",
      bind: true,
      lax: true,
      properties: {
        map: VALIGNS
      },
      readonly: !(writable && (tile === 'false' || tile === 'x')),
      onUxModifiedValue: function onUxModifiedValue() {
        return htmlUtils.resetFocus(self.jq());
      }
    }))), spandrel.jsx("div", {
      className: "-t-ImageBrushEditor-preview -t-color-preview-checkered-pattern"
    }, spandrel.jsx("div", {
      spandrelKey: "preview",
      className: "-t-ImageBrushEditor-preview-brush",
      $init: function $init(el) {
        return brush.applyBackgroundToElement(el);
      }
    })));
  }, {
    strategy: 'niagara'
  }));
});
