function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/*global document*/

/**
 * API Status: **Private**
 * @module nmodule/gx/rc/fe/GradientStopsEditor
 */

define(['baja!', 'lex!gx', 'Promise', 'underscore', 'bajaux/spandrel', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'bajaux/util/CommandButtonGroup', 'nmodule/gx/rc/baja/Brush', 'nmodule/gx/rc/baja/Color', 'nmodule/webEditors/rc/util/htmlUtils'], function (baja, lexs, Promise, _, spandrel, Widget, Command, CommandGroup, CommandButtonGroup, Brush, Color, htmlUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    GX_LEX = _lexs[0];
  var LEFT_BUTTON = 0;

  /**
   * Compares the offset of two stops for sorting purpose
   * @param {Object} stop1 the first stop to be compared
   * @param {Object} stop2 the second stop to be compared
   * @returns {number}
   */
  function comparesStopsByOffset(stop1, stop2) {
    return stop1.offset - stop2.offset;
  }
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'gx',
      keyName: 'GradientStopsEditor',
      properties: {
        rootCssClass: '-t-GradientStopsEditor'
      }
    };
  };

  /**
   * Editor for updating the stop of a gradient brush
   *
   * @class
   * @alias module:nmodule/gx/rc/fe/GradientStopsEditor
   * @extends module:bajaux/Widget
   * @since Niagara 4.15
  */
  var GradientStopsEditor = /*#__PURE__*/function (_spandrel) {
    function GradientStopsEditor(params) {
      var _this;
      _classCallCheck(this, GradientStopsEditor);
      _this = _callSuper(this, GradientStopsEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$onMouseMoveBound = _this.$onMouseMove.bind(_this);
      _this.$onMouseUpBound = _this.$onMouseUp.bind(_this);
      _this.$stopsCommandGrp = new CommandGroup();
      _this.$stopsCommandGrp.add(new Command({
        module: 'gx',
        lex: 'gradientEditor.command.remove',
        func: function func() {
          return _this.$removeStop(_this.$getCurrStopIdx());
        }
      }));
      return _this;
    }

    /**
     * Builds the gradient stop editor from the supplied
     * @private
     * @param {Object} state
     * @returns {Object}
     */
    _inherits(GradientStopsEditor, _spandrel);
    return _createClass(GradientStopsEditor, [{
      key: "$buildEditor",
      value: function $buildEditor(state) {
        var _this2 = this;
        var stops = state.stops,
          self = state.self;
        var currSelectIdx = this.$getCurrStopIdx();
        var currStop = stops[currSelectIdx];
        var currOffset = parseFloat(currStop.offset);
        var currColor = currStop.color;
        var stopsArray = stops.map(function (stop) {
          return [stop.offset, stop.color];
        });
        var stopDivs = [];
        stopsArray.forEach(function (stop, index) {
          var stopValue = stop[0];
          var stopColor = stop[1];
          stopDivs.push(spandrel.jsx("div", {
            className: "sliderPointer",
            "data-value": stopValue,
            "data-index": index,
            style: {
              left: "".concat(stopValue, "%"),
              background: "".concat(stopColor)
            },
            onMouseDown: function onMouseDown(e) {
              return _this2.$mouseDownSliderPointer(e, _this2);
            },
            onTouchStart: function onTouchStart(e) {
              return _this2.$mouseDownSliderPointer(e, _this2);
            }
          }));
        });
        return [spandrel.jsx("div", {
          className: "-t-GradientEditor-stopEditor",
          spandrelKey: "stopEditor"
        }, spandrel.jsx("div", {
          spandrelKey: "sliderContainer",
          className: "sliderContainer",
          onMouseDown: function onMouseDown(e) {
            return _this2.$mouseDownSliderContainer(e, _this2);
          },
          onTouchStart: function onTouchStart(e) {
            return _this2.$mouseDownSliderContainer(e, _this2);
          }
        }, spandrel.jsx("div", {
          spandrelKey: "sliderTrackHatch",
          className: "sliderTrackHatch -t-color-preview-checkered-pattern"
        }), spandrel.jsx("div", {
          spandrelKey: "sliderTrack",
          className: "sliderTrack"
        }), stopDivs), spandrel.jsx("table", null, spandrel.jsx("tr", null, spandrel.jsx("td", null, GX_LEX.get("gradientEditor.offset")), spandrel.jsx("any", {
          spandrelKey: "stopOffset",
          value: currOffset,
          properties: {
            precision: 2,
            max: 100,
            min: 0
          },
          onUxModify: function onUxModify() {
            return self.$applyOffsetChange();
          }
        })), spandrel.jsx("tr", null, spandrel.jsx("td", null, GX_LEX.get("gradientEditor.color")), spandrel.jsx("any", {
          spandrelKey: "stopColor",
          value: currColor,
          onUxModify: function onUxModify() {
            return self.$applyColorChange();
          }
        })), spandrel.jsx("tr", null, spandrel.jsx("td", {
          colSpan: "2"
        }, spandrel.jsx(CommandButtonGroup, {
          className: "-t-GradientEditor-stopCommands",
          spandrelKey: "stopCommands",
          value: self.$stopsCommandGrp,
          properties: {
            toolbar: true
          }
        })))))];
      }

      /**
       * returns the index for the current selected stop
       * @private
       * @returns {number}
       */
    }, {
      key: "$getCurrStopIdx",
      value: function $getCurrStopIdx() {
        return parseInt(this.$currStopIdx) || 0;
      }

      /**
       * destroys the editor
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.$removeEventListeners();
      }

      /**
       * Applies the current gradient brush to the preview, mainly so that the radial brush can adjust
       * its radius
       */
    }, {
      key: "doLayout",
      value: function doLayout() {
        this.$applyNewStopsToPreviews(this.state().stops);
      }

      /**
      * Converts the supplied stops into the state for the editor
      * @param {Array<Array<offset, color>>} stops
      * @returns {Object}
      */
    }, {
      key: "toState",
      value: function toState(stops) {
        var newStops = [{
          offset: 0,
          color: Color.make('red')
        }, {
          offset: 100,
          color: Color.make('navy')
        }];
        if (stops && stops.length >= 2) {
          newStops = [];
          stops.forEach(function (stop) {
            var offset = stop[0];
            offset = offset < 0 ? 0 : offset > 100 ? 100 : offset;
            var newStop = {
              offset: offset,
              color: stop[1]
            };
            newStops.push(newStop);
          });
          newStops.sort(comparesStopsByOffset);
        }
        return {
          stops: newStops
        };
      }

      /**
       * Converts the state stops back into stops for the brush
       * @param {Object} state
       * @returns {Object}
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        var outStops = [];
        var stops = state.stops;
        stops.forEach(function (stop) {
          var outStop = [stop.offset, stop.color];
          outStops.push(outStop);
        });
        return outStops;
      }

      /**
       * Handles the mouse down event on the slider container by adding a new stop
       * @private
       * @param {MouseEvent} e
       * @param {module:bajaux/Widget} editor the editor widget of the slider
       * @returns {Promise}
       */
    }, {
      key: "$mouseDownSliderContainer",
      value: function $mouseDownSliderContainer(e, editor) {
        var _this3 = this;
        if (e.button === LEFT_BUTTON || e.type === 'touchstart') {
          var mouseX = editor.$getClientX(e);
          var slider = e.target;
          var sliderX = slider.getBoundingClientRect().left;
          var pointerPosition = mouseX - sliderX;
          var sliderWidth = slider.offsetWidth;
          var newOffset = editor.$computeNewStopOffset(pointerPosition, sliderWidth);
          return editor.$addNewStop(newOffset).then(function () {
            var addedPointer = _this3.$getPointerByOffset(newOffset);
            if (addedPointer) {
              return _this3.$mouseDownSliderPointer(e, editor, addedPointer);
            }
          }).then(function () {
            return htmlUtils.resetFocus(editor.jq());
          });
        }
      }

      /**
       * returns the pointer that has the supplied offset
       * @private
       * @param {number} offset the offset of the pointer being looked for
       * @returns {Element|*}
       */
    }, {
      key: "$getPointerByOffset",
      value: function $getPointerByOffset(offset) {
        var pointers = this.$getSliderPointers().toArray();
        var matchingPointer;
        pointers.forEach(function (pointer) {
          if (parseFloat(pointer.dataset.value) === offset) {
            matchingPointer = pointer;
          }
        });
        return matchingPointer;
      }

      /**
       * Handles the mouse down event on the slider pointer
       * @private
       * @param {MouseEvent} e
       * @param {module:bajaux/Widget} parent the parent widget of the slider
       * @param {Element} [target] an alternate target to be used
       */
    }, {
      key: "$mouseDownSliderPointer",
      value: function $mouseDownSliderPointer(e, parent, target) {
        e.stopPropagation();
        if ((e.button === 0 || e.type === 'touchstart') && !parent.$currSlider) {
          parent.$currSlider = target || e.target;
          var pointer = parent.$currSlider;
          parent.$currStopIdx = pointer.dataset.index;
          this.$sliderWidth = pointer.parentNode.offsetWidth;
          this.$prevX = parent.$getClientX(e);
          document.addEventListener("mousemove", this.$onMouseMoveBound);
          document.addEventListener("mouseup", this.$onMouseUpBound);
          document.addEventListener("touchmove", this.$onMouseMoveBound);
          document.addEventListener("touchend", this.$onMouseUpBound);
          document.addEventListener("touchcancel", this.$onMouseUpBound);
          return parent.$showCurrentStop();
        }
      }

      /**
       * Handles the mouse move event when a slider is selected
       * @private
       * @param {MouseEvent} e
       */
    }, {
      key: "$onMouseMove",
      value: function $onMouseMove(e) {
        var currX = this.$getClientX(e);
        var pointer = this.$currSlider;
        var deltaX = currX - this.$prevX;
        var pointerPosition = Math.min(Math.max(pointer.offsetLeft + deltaX, 0), this.$sliderWidth);
        this.$prevX = currX;
        var newOffset = this.$computeNewStopOffset(pointerPosition, this.$sliderWidth);
        pointer.style.left = newOffset + "%";
        pointer.dataset.value = newOffset;
        var newStops = this.$saveNewOffsetToStop(pointer.dataset.index, newOffset);
        this.$applyNewStopsToPreviews(newStops);
        return this.$getStopOffset().load(parseFloat(newOffset));
      }

      /**
       * Handles the mouse up event signaling the end of the edit
       * @private
       */
    }, {
      key: "$onMouseUp",
      value: function $onMouseUp(e) {
        var pointer = this.$currSlider;
        this.$prevX = undefined;
        this.$sliderWidth = undefined;
        this.$removeEventListeners();

        //if we have no current pointer there is nothing to update
        if (pointer) {
          var newValue = pointer.dataset.value;
          this.$currSlider = undefined;
          return this.$saveNewStopOffsetToState(pointer.dataset.index, newValue);
        }
      }

      /**
       * Removes the touch and mouse event listeners
       * @private
       */
    }, {
      key: "$removeEventListeners",
      value: function $removeEventListeners() {
        document.removeEventListener("mousemove", this.$onMouseMoveBound);
        document.removeEventListener("mouseup", this.$onMouseUpBound);
        document.removeEventListener("touchmove", this.$onMouseMoveBound);
        document.removeEventListener("touchend", this.$onMouseUpBound);
        document.removeEventListener("touchcancel", this.$onMouseUpBound);
      }

      /**
       * returns the client x position of the event
       * @private
       * @param {Event} event
       * @returns {number}
       */
    }, {
      key: "$getClientX",
      value: function $getClientX(event) {
        if (event.touches && event.touches.length > 0) {
          return event.touches[0].clientX;
        } else {
          return event.clientX;
        }
      }

      /**
       * Computes the new stop offset based on the pointer position and slider width
       * @private
       * @param pointerPosition
       * @param sliderWidth
       * @returns {number}
       */
    }, {
      key: "$computeNewStopOffset",
      value: function $computeNewStopOffset(pointerPosition, sliderWidth) {
        return Math.round(pointerPosition / sliderWidth * 10000) / 100;
      }

      /**
       * Sorts the stops by offset and updates the $currStopIdx with the new value
       * @private
       * @param {Array<module:nmodule/gx/rc/fe/GradientStopsEditor~GradientStopsEditorStop>} stops
       * @returns {Array<module:nmodule/gx/rc/fe/GradientStopsEditor~GradientStopsEditorStop>}
       */
    }, {
      key: "$sortStopsByOffset",
      value: function $sortStopsByOffset(stops) {
        var _this4 = this;
        var newCurrIndex = 0;

        //store off the old index to be referenced after the sort is done
        stops.forEach(function (stop, index) {
          stop.oldIndex = index;
        });
        stops.sort(comparesStopsByOffset);

        //update the $currentIndex with the new value
        stops.forEach(function (stop, index) {
          if (stop.oldIndex === _this4.$getCurrStopIdx()) {
            newCurrIndex = index;
          }
          delete stop.oldIndex;
        });
        this.$currStopIdx = newCurrIndex;
        return stops;
      }

      /**
       * Shows the currently selected stop values in the offset and color fields
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$showCurrentStop",
      value: function $showCurrentStop() {
        var stops = this.state().stops;
        var currStop = stops[this.$getCurrStopIdx()];
        return Promise.all([this.$getStopOffset().load(parseFloat(currStop.offset)), this.$getStopColor().load(currStop.color)]);
      }

      /**
       * Adds a new stop at the specified offset
       * @private
       * @param {number} newOffset the offset to add the new stop at
       * @returns {Promise}
       */
    }, {
      key: "$addNewStop",
      value: function $addNewStop(newOffset) {
        var _this5 = this;
        var stops = this.state().stops;
        var newStops = stops.map(_.clone);
        var stopsLength = stops.length;

        //Create a basic new stop
        var newStop = {
          offset: baja.Double.make(newOffset),
          color: Color.DEFAULT
        };
        function getColor(index) {
          index = index < 0 ? 0 : index;
          return stops[index].color;
        }
        stops.forEach(function (stop, index) {
          var stopOffset = stop.offset;
          if (newStops.length === stopsLength) {
            if (newOffset <= stopOffset) {
              newStop.color = getColor(index - 1);
              newStops.splice(index, 0, newStop);
              _this5.$currStopIdx = index;
            } else if (index === stopsLength - 1) {
              newStop.color = getColor(index);
              newStops.push(newStop);
              _this5.$currStopIdx = stopsLength;
            }
          }
        });
        return this.state({
          stops: newStops
        }).then(function () {
          return _this5.$showCurrentStop();
        });
      }

      /**
       * Removes the stop specified by the index from the array of stops and updates the state
       * @private
       * @param {number} index the index of the stop to be removed
       * @returns {Promise}
       */
    }, {
      key: "$removeStop",
      value: function $removeStop(index) {
        var _this6 = this;
        var newStops = this.state().stops.map(_.clone);
        if (newStops.length > 2 && index < newStops.length) {
          newStops.splice(index, 1);
          this.$currSlider = undefined;
          var currStopIdx = this.$getCurrStopIdx();
          this.$currStopIdx = currStopIdx !== 0 ? currStopIdx - 1 : 0;
          return this.state({
            stops: newStops
          }).then(function () {
            return _this6.$showCurrentStop();
          });
        }
        return Promise.resolve();
      }

      /**
       * Applies the new stops to the slider bar in the editor and the preview in the parent editor, if it exist
       * @private
       * @param {Array<module:nmodule/gx/rc/fe/GradientStopsEditor~GradientStopsEditorStop>} newStops the new stops to be applied to the previews
       */
    }, {
      key: "$applyNewStopsToPreviews",
      value: function $applyNewStopsToPreviews(newStops) {
        var stops = newStops.map(function (stop) {
          return [stop.offset, stop.color];
        });
        var parent = this.properties().getValue("parent");
        var sliderTrack = this.$getSliderTrack().jq()[0];
        Brush.makeLinearGradientBrush(stops, {
          angle: 0
        }).applyBackgroundToElement(sliderTrack);
        if (parent && parent.$applyNewStopsToPreview instanceof Function) {
          parent.$applyNewStopsToPreview(stops);
        }
      }

      /**
       * Applies the new offset value to the state
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$applyOffsetChange",
      value: function $applyOffsetChange() {
        var _this7 = this;
        var stopOffset = this.$getStopOffset();
        return stopOffset.read().then(function (newOffset) {
          newOffset = newOffset < 0 ? 0 : newOffset > 100 ? 100 : newOffset;
          return _this7.$saveNewStopOffsetToState(_this7.$getCurrStopIdx(), newOffset);
        });
      }

      /**
       * Saves the new updated stop offset to the editor's state
       * @private
       * @param {number} index the index of the stop to apply the new color to
       * @param {number} offset the new color to be applied to the state
       * @returns {Promise}
       */
    }, {
      key: "$saveNewStopOffsetToState",
      value: function $saveNewStopOffsetToState(index, offset) {
        var stops = this.$saveNewOffsetToStop(index, offset);
        return this.state({
          stops: stops
        });
      }

      /**
       * Creates a new stop array and applies the new offset to the stop specified by the index
       * @private
       * @param {Number} index the index of the stop to update
       * @param {Number} newOffset the new offset value
       * @returns {Array<module:nmodule/gx/rc/fe/GradientStopsEditor~GradientStopsEditorStop>}
       */
    }, {
      key: "$saveNewOffsetToStop",
      value: function $saveNewOffsetToStop(index, newOffset) {
        var newStops = this.state().stops.map(_.clone);
        newOffset = newOffset < 0 ? 0 : newOffset > 100 ? 100 : newOffset;
        newStops[index].offset = newOffset;
        newStops = this.$sortStopsByOffset(newStops);
        return newStops;
      }

      /**
       * Applies the change to from the color editor to the state
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$applyColorChange",
      value: function $applyColorChange() {
        var _this8 = this;
        var stopColor = this.$getStopColor();
        return stopColor.read().then(function (newColor) {
          return _this8.$saveNewStopColorToState(_this8.$getCurrStopIdx(), newColor);
        });
      }

      /**
       * Saves the new updated stop color to the editor's state
       * @private
       * @param {number} index the index of the stop to apply the new color to
       * @param {module:nmodule/gx/rc/baja/Color} newColor the new color to be applied to the state
       * @returns {Promise}
       */
    }, {
      key: "$saveNewStopColorToState",
      value: function $saveNewStopColorToState(index, newColor) {
        var stops = this.$saveNewColorToStop(index, newColor);
        return this.state({
          stops: stops
        });
      }

      /**
       * Creates a new stop array and applies the new color to the stop specified by the index
       * @private
       * @param {number} index the index of the stop to apply the new color to
       * @param {module:nmodule/gx/rc/baja/Color} newColor the new color to be applied to the state
       */
    }, {
      key: "$saveNewColorToStop",
      value: function $saveNewColorToStop(index, newColor) {
        var newStops = this.state().stops.map(_.clone);
        newStops[index].color = newColor;
        return newStops;
      }

      /**
       * gets the stop editor
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getStopEditor",
      value: function $getStopEditor() {
        return this.queryWidget('**/stopEditor');
      }

      /**
       * gets the container for the slider
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getSliderContainer",
      value: function $getSliderContainer() {
        return this.queryWidget('**/stopEditor/sliderContainer');
      }

      /**
       * gets the hatch pattern for the slider track
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getSliderTrackHatch",
      value: function $getSliderTrackHatch() {
        return this.queryWidget('**/stopEditor/sliderContainer/sliderTrackHatch');
      }

      /**
       * gets the hatch pattern for the slider track
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getSliderTrack",
      value: function $getSliderTrack() {
        return this.queryWidget('**/stopEditor/sliderContainer/sliderTrack');
      }

      /**
       * returns the slider pointers
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getSliderPointers",
      value: function $getSliderPointers() {
        var container = this.$getSliderContainer().jq();
        return container.find(".sliderPointer");
      }

      /**
       * gets the offset editor which shows the value for the current selected stop
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getStopOffset",
      value: function $getStopOffset() {
        return this.queryWidget('**/stopOffset');
      }

      /**
       * gets the color editor which shows the value for the current selected stop
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getStopColor",
      value: function $getStopColor() {
        return this.queryWidget('**/stopColor');
      }

      /**
       * returns the stop commands
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getStopCommands",
      value: function $getStopCommands() {
        return this.queryWidget("**/stopCommands");
      }
    }]);
  }(spandrel(function (value, state) {
    var self = state.self;
    return self.$buildEditor(state);
  }, {
    strategy: 'niagara'
  }));
  return GradientStopsEditor;
});

/**
 * @typedef module:nmodule/gx/rc/fe/GradientStopsEditor~GradientStopsEditorStop
 * @property {number} offset the offset of the stop as a percentage from 0 to 100
 * @property {module:nmodule/gx/rc/baja/Color} color the color of the stop
 */
