function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/gx/rc/fe/GradientEditor
 */

define(['baja!', 'lex!gx', 'Promise', 'bajaux/spandrel', 'bajaux/commands/Command', 'bajaux/commands/ToggleCommandGroup', 'bajaux/util/CommandButtonGroup', 'nmodule/gx/rc/baja/Brush', 'nmodule/gx/rc/baja/Color', 'nmodule/gx/rc/fe/GradientStopsEditor'], function (baja, lexs, Promise, spandrel, Command, ToggleCommandGroup, CommandButtonGroup, Brush, Color, GradientStopsEditor) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    GX_LEX = _lexs[0];
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'gx',
      keyName: 'GradientEditor',
      properties: {
        rootCssClass: '-t-GradientEditor'
      }
    };
  };

  /**
   * Javascript editor for a Gradient
   *
   * @class
   * @alias module:nmodule/gx/rc/fe/GradientEditor
   * @extends module:bajaux/Widget
   * @since Niagara 4.15
  */
  var GradientEditor = /*#__PURE__*/function (_spandrel) {
    function GradientEditor(params) {
      var _this;
      _classCallCheck(this, GradientEditor);
      _this = _callSuper(this, GradientEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$toggleCmdGroup = new ToggleCommandGroup({
        commands: [{
          module: 'gx',
          lex: 'gradientEditor.command.setLinear',
          value: true
        }, {
          module: 'gx',
          lex: 'gradientEditor.command.setRadial',
          value: false
        }],
        onChange: function onChange(linearGradient) {
          return _this.state({
            linearGradient: linearGradient
          });
        }
      });
      return _this;
    }

    /**
     * Builds the GradientEditor
     * @private
     * @param {Object} state
     * @param {baja.UnitDatabase} unitDb
     * @returns {Object}
     */
    _inherits(GradientEditor, _spandrel);
    return _createClass(GradientEditor, [{
      key: "$buildEditor",
      value: function $buildEditor(state, unitDb) {
        var linearGradient = state.linearGradient,
          angle = state.angle,
          centerX = state.centerX,
          centerY = state.centerY,
          focalX = state.focalX,
          focalY = state.focalY,
          radius = state.radius,
          stops = state.stops,
          self = state.self;
        self.$toggleCmdGroup.get(linearGradient ? 0 : 1).setSelected(true);
        var deg = unitDb.getUnit('degrees angular');
        var percent = unitDb.getUnit('percent');
        return [spandrel.jsx("div", {
          className: "-t-GradientEditor-table"
        }, spandrel.jsx("div", {
          className: "-t-color-preview-checkered-pattern",
          style: "border: 1px solid rgb(118, 118, 118); height: 80px; width: 80px"
        }, spandrel.jsx("svg", {
          xmlns: "http://www.w3.org/2000/svg",
          viewBox: "0 0 80 80",
          style: {
            width: '80px',
            height: '80px'
          },
          spandrelKey: "previewSvg"
        }, spandrel.jsx("rect", {
          x: "0",
          y: "0",
          width: "100%",
          height: "100%",
          preserveAspectRatio: "none",
          spandrelKey: "previewRect"
        }))), spandrel.jsx("table", null, spandrel.jsx("tr", null, spandrel.jsx("td", null, GX_LEX.get("gradientEditor.centerX")), spandrel.jsx("any", {
          tagName: "td",
          bind: true,
          spandrelKey: "centerX",
          value: centerX,
          properties: {
            precision: 1,
            enabled: !linearGradient,
            units: percent
          }
        })), spandrel.jsx("tr", null, spandrel.jsx("td", null, GX_LEX.get("gradientEditor.centerY")), spandrel.jsx("any", {
          tagName: "td",
          bind: true,
          spandrelKey: "centerY",
          value: centerY,
          properties: {
            precision: 1,
            enabled: !linearGradient,
            units: percent
          }
        })), spandrel.jsx("tr", null, spandrel.jsx("td", null, GX_LEX.get("gradientEditor.radius")), spandrel.jsx("any", {
          tagName: "td",
          bind: true,
          spandrelKey: "radius",
          value: radius,
          properties: {
            precision: 1,
            enabled: !linearGradient,
            units: percent
          }
        }))), spandrel.jsx("table", null, spandrel.jsx("tr", null, spandrel.jsx("td", null, GX_LEX.get("gradientEditor.focalX")), spandrel.jsx("any", {
          tagName: "td",
          bind: true,
          spandrelKey: "focalX",
          value: focalX,
          properties: {
            precision: 1,
            enabled: !linearGradient,
            units: percent
          }
        })), spandrel.jsx("tr", null, spandrel.jsx("td", null, GX_LEX.get("gradientEditor.focalY")), spandrel.jsx("any", {
          tagName: "td",
          bind: true,
          spandrelKey: "focalY",
          value: focalY,
          properties: {
            precision: 1,
            enabled: !linearGradient,
            units: percent
          }
        })), spandrel.jsx("tr", null, spandrel.jsx("td", null, GX_LEX.get("gradientEditor.angle")), spandrel.jsx("any", {
          tagName: "td",
          bind: true,
          spandrelKey: "angle",
          value: angle,
          properties: {
            precision: 0,
            enabled: linearGradient,
            units: deg
          }
        }))), spandrel.jsx(CommandButtonGroup, {
          className: "-t-GradientEditor-gradientType",
          spandrelKey: "toggleCommands",
          value: self.$toggleCmdGroup
        })), spandrel.jsx("div", {
          spandrelKey: "gradientSlider"
        }, spandrel.jsx(GradientStopsEditor, {
          spandrelKey: "stopsEditor",
          value: stops,
          properties: {
            parent: self
          }
        }))];
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getLinearCommand",
      value: function $getLinearCommand() {
        return this.$toggleCmdGroup.get(0);
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getRadialCommand",
      value: function $getRadialCommand() {
        return this.$toggleCmdGroup.get(1);
      }

      /**
       * Applies the current gradient brush to the preview, mainly so that the radial brush can adjust
       * its radius
       */
    }, {
      key: "doLayout",
      value: function doLayout() {
        this.$applyNewStopsToPreview();
      }

      /**
      * Converts the current gradient into a state
      * @param {module:nmodule/gx/rc/baja/Brush} brush
      * @returns {Object}
      */
    }, {
      key: "toState",
      value: function toState(brush) {
        var state = {
          // default values
          linearGradient: true,
          angle: 0,
          centerX: 50,
          centerY: 50,
          radius: 50,
          focalX: 50,
          focalY: 50,
          stops: [[0, Color.make('red')], [100, Color.make('navy')]]
        };
        var paint = brush && brush.getPaint();
        var isGradient = brush && brush.isGradientBrush();
        var linearGradient = isGradient && paint instanceof Brush.LinearGradient;
        if (isGradient) {
          if (linearGradient) {
            this.$getLinearCommand().setSelected(true);
            state.linearGradient = true;
            state.angle = paint.getAngle();
          } else {
            var center = paint.getCenter();
            var focal = paint.getFocal();
            var radius = paint.getRadius();
            this.$getRadialCommand().setSelected(true);
            state.linearGradient = false;
            state.centerX = center.x;
            state.centerY = center.y;
            state.focalX = focal.x;
            state.focalY = focal.y;
            state.radius = radius;
          }
          state.stops = paint.getStops();
        }
        return state;
      }

      /**
       *
       * @param {Object} state
       * @returns {module:nmodule/gx/rc/baja/Brush}
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        var _this2 = this;
        return this.$getStopEditor().read().then(function (newStops) {
          return _this2.$makeBrushFromState(state, newStops);
        });
      }

      /**
       * Applies the new stops to the preview panes in the editor
       * @private
       * @param {Array<Array<number, module:nmodule/gx/rc/baja/Color>>} stops the new stops to be applied to the previews
       */
    }, {
      key: "$applyNewStopsToPreview",
      value: function $applyNewStopsToPreview(stops) {
        var svg = this.$getPreviewSvg();
        var rect = this.$getPreviewRect();
        var svgBrush = this.$makeBrushFromState(this.state(), stops);
        svgBrush.applyFillToSvgElement(rect.jq()[0], svg.jq()[0]);
      }

      /**
       * @private
       * @param {Object} state
       * @param {Array<Array<number, module:nmodule/gx/rc/baja/Color>>} [newStops] optional new stops used to create preview
       * @returns {module:nmodule/gx/rc/baja/Brush}
       */
    }, {
      key: "$makeBrushFromState",
      value: function $makeBrushFromState(state, newStops) {
        var linearGradient = state.linearGradient,
          angle = state.angle,
          centerX = state.centerX,
          centerY = state.centerY,
          focalX = state.focalX,
          focalY = state.focalY,
          radius = state.radius;
        var stops = state.stops;
        if (newStops) {
          stops = newStops;
        }
        if (linearGradient) {
          return Brush.makeLinearGradientBrush(stops, {
            angle: angle
          });
        } else {
          return Brush.makeRadialGradientBrush(stops, {
            centerX: centerX,
            centerY: centerY,
            focalX: focalX,
            focalY: focalY,
            radius: radius
          });
        }
      }

      /**
       * gets the preview widget
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPreviewSvg",
      value: function $getPreviewSvg() {
        return this.queryWidget('**/previewSvg');
      }

      /**
       * gets the preview widget
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPreviewRect",
      value: function $getPreviewRect() {
        return this.queryWidget('**/previewRect');
      }

      /**
       * gets the center x NumericEditor
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getCenterX",
      value: function $getCenterX() {
        return this.queryWidget('**/centerX');
      }

      /**
       * gets the center y NumericEditor
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getCenterY",
      value: function $getCenterY() {
        return this.queryWidget('**/centerY');
      }

      /**
       * gets the focus x NumericEditor
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getFocalX",
      value: function $getFocalX() {
        return this.queryWidget('**/focalX');
      }

      /**
       * gets the focus y NumericEditor
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getFocalY",
      value: function $getFocalY() {
        return this.queryWidget('**/focalY');
      }

      /**
       * gets the radius NumericEditor
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getRadius",
      value: function $getRadius() {
        return this.queryWidget('**/radius');
      }

      /**
       * gets the angle NumericEditor
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getAngle",
      value: function $getAngle() {
        return this.queryWidget('**/angle');
      }

      /**
       * gets the gradient type boolean editor
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getToggleCommandButtonGroup",
      value: function $getToggleCommandButtonGroup() {
        return this.queryWidget('**/toggleCommands');
      }

      /**
       * gets the stop editor
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getStopEditor",
      value: function $getStopEditor() {
        return this.queryWidget('**/stopsEditor');
      }
    }]);
  }(spandrel(function (value, state) {
    var self = state.self;
    return baja.UnitDatabase.get().then(function (unitDb) {
      return self.$buildEditor(state, unitDb);
    });
  }, {
    strategy: 'niagara'
  }));
  return GradientEditor;
});
