function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */
/*global document*/

/**
 * API Status: **Private**
 * @module nmodule/gx/rc/fe/ColorEditor
 */
define(['baja!', 'bajaux/spandrel', 'bajaux/Widget', 'lex!gx', 'Promise', 'nmodule/gx/rc/baja/Color', 'nmodule/gx/rc/fe/ColorPaletteChooser', 'nmodule/gx/rc/util/colorUtils', 'nmodule/webEditors/rc/wb/commands/PopOutCommand', 'nmodule/webEditors/rc/util/htmlUtils', 'css!nmodule/gx/rc/gx'], function (baja, spandrel, Widget, lexs, Promise, Color, ColorPaletteChooser, colorUtils, PopOutCommand, htmlUtils) {
  'use strict';

  var parseRgba = colorUtils.parseRgba;
  var _lexs = _slicedToArray(lexs, 1),
    gxLex = _lexs[0];
  var nullLabel = gxLex.get("colorChooser.useNullColor");
  var alphaLabel = gxLex.get("colorChooser.alphaText");
  var nameLabel = gxLex.get("colorChooser.nameText");
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-ColorEditor'
      }
    };
  };
  var COLOR_LIST = Color.getConstants().map(function (c) {
    return c.encodeToString();
  }).join(";");
  var _Widget$formFactor = Widget.formFactor,
    miniFormFactor = _Widget$formFactor.mini,
    compactFormFactor = _Widget$formFactor.compact;
  function getRgbaStyle(color) {
    return "box-shadow: inset 0 0 0 1000px " + color.toCssString() + ";";
  }
  function colorPicker(color, state) {
    var formFactor = state.formFactor,
      isNull = state.isNull,
      self = state.self,
      writable = state.writable;
    var isMini = formFactor === miniFormFactor;
    var isCompact = formFactor === compactFormFactor;
    var alphaClass = "color-preview -t-color-preview-checkered-pattern alpha-pattern ".concat(writable ? 'alpha-pattern-pointer' : '');
    var nullClass = "color-preview -t-color-preview-checkered-pattern null-pattern ".concat(writable ? 'null-pattern-pointer' : '');
    return spandrel.jsx("div", {
      className: "-t-ColorEditor-inputs",
      onclick: isMini && function (e) {
        e.preventDefault();
        return writable && PopOutCommand.doPopOut(self);
      }
    }, spandrel.jsx("div", {
      className: alphaClass,
      style: isNull || isCompact ? "display: none;" : getRgbaStyle(color)
    }), spandrel.jsx("input", {
      className: "-t-ColorEditor-colorInput",
      type: "color",
      value: color.toHexRgbString(),
      disabled: !writable,
      style: isNull || isMini ? "display: none;" : "",
      onchange: function onchange(e) {
        return self.$propagateToState({
          rgb: e.target.value
        });
      }
    }), spandrel.jsx("div", {
      className: nullClass,
      style: isNull ? "" : "display: none;"
    }));
  }

  /**
   * @param {module:nmodule/gx/rc/fe/ColorEditor~ColorEditorState} state
   * @returns {module:nmodule/gx/rc/baja/Color}
   */
  function stateToColor(state) {
    var alpha = state.alpha,
      name = state.name,
      isNull = state.isNull,
      rgb = state.rgb;
    if (isNull) {
      return Color.NULL;
    } else if (name) {
      return Color.make(name);
    } else {
      var _parseRgba = parseRgba(rgb),
        _parseRgba2 = _slicedToArray(_parseRgba, 3),
        r = _parseRgba2[0],
        g = _parseRgba2[1],
        b = _parseRgba2[2];
      var a = Math.round(alpha / 100 * 255);
      return Color.make([r, g, b, a]);
    }
  }

  /**
   * @param {module:nmodule/gx/rc/baja/Color} color
   * @returns {module:nmodule/gx/rc/fe/ColorEditor~ColorEditorState}
   */
  function colorToState(color) {
    var colorString = color.encodeToString();
    color = Color.make(colorString);
    return {
      name: getColorName(colorString),
      rgb: color.toHexRgbString(),
      alpha: color.getAlpha() / 255 * 100,
      isNull: color === Color.NULL
    };
  }
  function getColorName(color) {
    var colorString = color.encodeToString();
    return Color.getConstant(colorString) ? colorString : '';
  }

  /**
   * A color editor for selecting valid colors.
   *
   * @class
   * @alias module:nmodule/gx/rc/fe/ColorEditor
   * @extends module:bajaux/Widget
   */
  return /*#__PURE__*/function (_spandrel) {
    function ColorEditor(params) {
      _classCallCheck(this, ColorEditor);
      return _callSuper(this, ColorEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     *
     * @param {module:nmodule/gx/rc/fe/ColorEditor~ColorEditorState} state
     * @returns {string|module:nmodule/gx/rc/baja/Color}
     */
    _inherits(ColorEditor, _spandrel);
    return _createClass(ColorEditor, [{
      key: "fromState",
      value: function fromState(state) {
        var color = stateToColor(state);
        return state.asString ? color.encodeToString() : color;
      }

      /**
       * @param {string|module:nmodule/gx/rc/baja/Color} color
       * @returns {module:nmodule/gx/rc/fe/ColorEditor~ColorEditorState}
       */
    }, {
      key: "toState",
      value: function toState(color) {
        var asString = typeof color === 'string';
        var colorString = color.encodeToString();
        color = Color.make(colorString);
        var state = Object.assign(colorToState(color), {
          asString: asString
        });
        if (state.isNull) {
          state.alpha = 100;
        }
        return state;
      }

      /**
       * @private
       * @param {object} newState
       * @returns {Promise}
       */
    }, {
      key: "$propagateToState",
      value: function $propagateToState(newState) {
        var _this = this;
        this.setModified(true);
        var oldState = this.state();
        if (oldState.isNull && !newState.isNull) {
          newState.alpha = 100;
        }
        newState = Object.assign(oldState, {
          name: '',
          isNull: false
        }, newState);
        return this.state(colorToState(stateToColor(newState))).then(function () {
          if (document.activeElement.getAttribute('type') === 'color') {
            return htmlUtils.resetFocus(_this.jq());
          }
        });
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getColorWidget",
      value: function $getColorWidget() {
        if (this.getFormFactor() === miniFormFactor) {
          return this;
        }
        return this.queryWidget('container/picker');
      }
      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getColorPreviewWidget",
      value: function $getColorPreviewWidget() {
        return this.queryWidget('preview');
      }
      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getDefaultWidget",
      value: function $getDefaultWidget() {
        return this.queryWidget('container/colorOptions/nullOrDefault/isNull');
      }
      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getDropDownWidget",
      value: function $getDropDownWidget() {
        return this.queryWidget('container/colorOptions/namedColor/name');
      }
      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getAlphaInputWidget",
      value: function $getAlphaInputWidget() {
        return this.queryWidget('container/colorOptions/alphaVal/alpha');
      }
      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getAlphaView",
      value: function $getAlphaView() {
        return this.queryWidget('container/colorOptions').jq().find('.-t-ColorEditor-alphaColorView');
      }
      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getColorInputElement",
      value: function $getColorInputElement() {
        return this.$getColorWidget().jq().find('.-t-ColorEditor-colorInput');
      }
      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getColorInput",
      value: function $getColorInput() {
        return this.jq().find('input[type=color]');
      }
      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getNullInputElement",
      value: function $getNullInputElement() {
        return this.$getColorWidget().jq().find('.null-pattern');
      }
      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getNullColorPreview",
      value: function $getNullColorPreview() {
        return this.$getColorPreviewWidget().jq().find('.null-pattern');
      }
      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getPreviewColorSpan",
      value: function $getPreviewColorSpan() {
        return this.jq().find('.-t-ColorEditor-previewColorText');
      }
      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getPreviewColorInput",
      value: function $getPreviewColorInput() {
        return this.$getColorPreviewWidget().jq().find('.-t-ColorEditor-colorInput');
      }
      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getPreviewAlphaView",
      value: function $getPreviewAlphaView() {
        return this.$getColorPreviewWidget().jq().find('.alpha-pattern');
      }
    }]);
  }(spandrel(function (value, state) {
    var formFactor = state.formFactor,
      isNull = state.isNull,
      self = state.self;
    var color = stateToColor(state);
    var colorStr = color.encodeToString();
    var colorOpacity = Math.round(color.getAlpha() / 255 * 100);
    return baja.UnitDatabase.get().then(function (db) {
      if (formFactor === miniFormFactor) {
        return spandrel.jsx("div", {
          spandrelKey: "preview",
          className: "-t-ColorEditor-preview"
        }, colorPicker(color, state), spandrel.jsx("span", {
          className: "-t-label -t-ColorEditor-previewColorText"
        }, colorStr));
      } else {
        return spandrel.jsx("div", {
          className: "-t-ColorEditor-container",
          spandrelKey: "container"
        }, spandrel.jsx("div", {
          className: "-t-ColorEditor-column -t-ColorEditor-palette"
        }, spandrel.jsx(ColorPaletteChooser, {
          value: color,
          spandrelKey: "palette",
          on: _defineProperty({}, ColorPaletteChooser.SELECTED_EVENT, function (e, ed, rgb) {
            return self.$propagateToState({
              rgb: rgb
            });
          })
        })), spandrel.jsx("div", {
          className: "-t-ColorEditor-column -t-ColorEditor-picker",
          spandrelKey: "picker"
        }, colorPicker(color, state)), spandrel.jsx("div", {
          className: "-t-ColorEditor-column",
          spandrelKey: "colorOptions"
        }, spandrel.jsx("div", {
          className: "-t-ColorEditor-named",
          spandrelKey: "namedColor"
        }, spandrel.jsx("label", {
          className: "-t-label"
        }, nameLabel), spandrel.jsx("any", {
          className: "-t-ColorEditor-colorName",
          lax: true,
          bind: true,
          spandrelKey: "name",
          value: getColorName(color),
          properties: {
            datalist: COLOR_LIST,
            filterWhileTyping: false
          },
          onUxModifiedValue: function onUxModifiedValue(name) {
            return self.$propagateToState({
              name: name
            });
          }
        })), spandrel.jsx("div", {
          className: "-t-ColorEditor-alpha",
          spandrelKey: "alphaVal"
        }, spandrel.jsx("any", {
          className: "-t-ColorEditor-alphaValue editor",
          lax: true,
          bind: true,
          spandrelKey: "alpha",
          value: baja.Integer.make(colorOpacity),
          validate: true,
          properties: {
            min: 0,
            max: 100,
            prelabel: alphaLabel,
            units: db.getUnit('percent')
          },
          onUxModifiedValue: function onUxModifiedValue(alpha) {
            return self.$propagateToState({
              alpha: alpha
            });
          }
        })), spandrel.jsx("div", {
          className: "-t-ColorEditor-null",
          spandrelKey: "nullOrDefault"
        }, spandrel.jsx("any", {
          lax: true,
          bind: true,
          spandrelKey: "isNull",
          value: isNull,
          properties: {
            displayType: "checkbox",
            trueText: nullLabel,
            falseText: nullLabel
          }
        })), spandrel.jsx("div", {
          className: "-t-ColorEditor-displayColor",
          spandrelKey: "displayColor"
        }, spandrel.jsx("span", {
          className: "-t-label -t-ColorEditor-previewColorText"
        }, colorStr), spandrel.jsx("div", {
          className: "-t-ColorEditor-alphaColorView -t-color-preview-checkered-pattern",
          style: getRgbaStyle(color)
        }))));
      }
    });
  }, {
    strategy: 'niagara'
  }));
});
/**
 * @typedef module:nmodule/gx/rc/fe/ColorEditor~ColorEditorState
 * @property {string} name selected color name, if one is applicable
 * @property {string} rgb currently selected hex encoding, minus alpha
 * @property {number} alpha entered alpha value, in the range 0 to 100
 * @property {boolean} isNull whether null is checked - tracked separately so
 * color data is not lost when null is checked and can be restored after
 * unchecking
 * @property {boolean} [asString] whether the color is loaded/read as a string
 */
