function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/gx/rc/fe/BrushEditor
 */

define(["baja!", 'baja!gx:Brush,gx:Image', 'lex!gx', 'jquery', 'bajaux/spandrel', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'bajaux/util/CommandButton', 'nmodule/gx/rc/baja/Brush', 'nmodule/gx/rc/baja/Color', 'nmodule/gx/rc/baja/Image', 'nmodule/gx/rc/fe/GradientEditor', 'nmodule/gx/rc/fe/ImageBrushEditor', 'nmodule/webEditors/rc/fe/baja/StringEditor', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/commands/ContextMenuCommand', 'nmodule/webEditors/rc/util/htmlUtils'], function (baja, types, lexs, $, spandrel, Widget, Command, CommandGroup, CommandButton, Brush, Color, Image, GradientEditor, ImageBrushEditor, StringEditor, feDialogs, ContextMenuCommand, htmlUtils) {
  'use strict';

  var compactFormFactor = Widget.formFactor.compact;
  var _lexs = _slicedToArray(lexs, 1),
    GX_LEX = _lexs[0];
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'gx',
      keyName: 'BrushEditor',
      properties: {
        rootCssClass: "-t-BrushEditor"
      }
    };
  };

  /**
   * Javascript editor for Brush type
   *
   * @class
   * @alias module:nmodule/gx/rc/fe/BrushEditor
   * @extends module:bajaux/Widget
   * @since Niagara 4.15
  */
  var BrushEditor = /*#__PURE__*/function (_spandrel) {
    function BrushEditor(params) {
      var _this;
      _classCallCheck(this, BrushEditor);
      _this = _callSuper(this, BrushEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$contextMenuCommand = new ContextMenuCommand({
        module: 'gx',
        lex: 'brushEditor.command.menu',
        makeCommandGroup: function makeCommandGroup() {
          return _this.$makeCommandGroup();
        }
      });
      return _this;
    }

    /**
     * Makes the command group for selecting a different type of paint object
     * @private
     * @returns {bajaux/commands/CommandGroup}
     */
    _inherits(BrushEditor, _spandrel);
    return _createClass(BrushEditor, [{
      key: "$makeCommandGroup",
      value: function $makeCommandGroup() {
        var _this2 = this;
        return new CommandGroup({
          commands: [new Command({
            module: "gx",
            lex: "brushEditor.command.solid",
            func: function func() {
              return _this2.$editColor();
            }
          }), new Command({
            module: "gx",
            lex: "brushEditor.command.gradient",
            func: function func() {
              return _this2.$editGradient();
            }
          }), new Command({
            module: "gx",
            lex: "brushEditor.command.image",
            func: function func() {
              return _this2.$editImage();
            }
          }), new Command({
            module: "gx",
            lex: "brushEditor.command.null",
            func: function func() {
              var newBrush = Brush.make("null");
              return _this2.loadAndModify(newBrush).then(function () {
                return htmlUtils.resetFocus(_this2.jq());
              });
            }
          })]
        });
      }

      /**
       * Builds the editor from the state
       * @private
       * @param state
       * @returns {Object}
       */
    }, {
      key: "$buildEditor",
      value: function $buildEditor(state) {
        var _this3 = this;
        var brushStr = state.brushStr,
          brush = state.brush,
          self = state.self,
          writable = state.writable;
        var previewClass = "-t-BrushEditor-previewBrushPaint -t-color-preview-checkered-pattern" + (writable ? "" : " bajaux-disabled");
        this.$getContextMenuCommand().setEnabled(writable);
        var previewContents = [];
        if (!brush.isNull() && !brush.isImageBrush()) {
          previewContents = [spandrel.jsx("svg", {
            xmlns: "http://www.w3.org/2000/svg",
            viewBox: "0 14 52 52",
            spandrelKey: "previewSvg"
          }, spandrel.jsx("rect", {
            x: "0",
            y: "0",
            width: "52.5",
            height: "100%",
            spandrelKey: "previewRect"
          }))];
        }
        return [spandrel.jsx("div", {
          spandrelKey: "preview",
          className: "-t-BrushEditor-preview"
        }, spandrel.jsx("div", {
          className: previewClass,
          onClick: function onClick(e) {
            if (writable) {
              e.preventDefault();
              return _this3.$openPopout();
            }
          }
        }, spandrel.jsx("div", {
          className: "-t-BrushEditor-previewDiv"
        }, previewContents)), spandrel.jsx("span", {
          className: "-t-label -t-BrushEditor-previewBrushText"
        }, brushStr), spandrel.jsx(CommandButton, {
          spandrelKey: "contextCommandMenu",
          className: "-t-BrushEditor-commandMenu",
          value: self.$contextMenuCommand
        }))];
      }

      /**
       * Applies the current gradient brush to the preview, mainly so that the radial brush can adjust
       * its radius.
       */
    }, {
      key: "doLayout",
      value: function doLayout() {
        var _this$state = this.state(),
          brush = _this$state.brush;
        if (brush.isNull() || brush.isImageBrush()) {
          var previewDiv = this.$getPreviewDiv()[0];
          brush.applyBackgroundToElement(previewDiv);
        } else {
          var svg = this.$getPreviewSvg();
          var rect = this.$getPreviewRect();
          if (svg && rect) {
            brush.applyFillToSvgElement(rect.jq()[0], svg.jq()[0]);
          }
        }
      }

      /**
       * Converts the current brush value into a state
       * @param {module:nmodule/gx/rc/baja/Brush} brush
       * @returns {Object}
       */
    }, {
      key: "toState",
      value: function toState(brush) {
        var brushStr = brush.encodeToString();
        var brushType = 'solid';
        if (brush.isNull()) {
          brushStr = GX_LEX.get("brushEditor.null.label");
        }
        if (brush.isGradientBrush()) {
          brushStr = GX_LEX.get("brushEditor.gradient.label");
          brushType = 'gradient';
        }
        if (brushStr.startsWith("image")) {
          brushStr = GX_LEX.get("brushEditor.image.label");
          brushType = 'image';
        }
        return {
          brushStr: brushStr,
          brushType: brushType,
          brush: brush
        };
      }

      /**
       * returns the current brush value
       * @param {Object} state
       * @returns {module:nmodule/gx/rc/baja/Brush}
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        var brush = state.brush;
        return brush;
      }

      /**
       * Opens the correct editor for each paint subtype
       * @private
       * @returns {*}
       */
    }, {
      key: "$openPopout",
      value: function $openPopout() {
        var _this$state2 = this.state(),
          brushType = _this$state2.brushType;
        switch (brushType) {
          case 'gradient':
            return this.$editGradient();
          case 'image':
            return this.$editImage();
          default:
            return this.$editColor();
        }
      }

      /**
       * Opens the color chooser and allows the user to select a new color
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$editColor",
      value: function $editColor() {
        var _this4 = this;
        var _this$state3 = this.state(),
          brush = _this$state3.brush,
          brushType = _this$state3.brushType;
        var colorValue = brushType === 'solid' ? Color.make(brush.encodeToString()) : Color.DEFAULT;
        return feDialogs.showFor({
          title: GX_LEX.get("brushEditor.colorEditor.title"),
          value: colorValue,
          formFactor: compactFormFactor
        }).then(function (color) {
          if (color) {
            var newBrush = Brush.make(color.encodeToString());
            return _this4.loadAndModify(newBrush);
          }
        }).then(function () {
          return htmlUtils.resetFocus(_this4.jq());
        });
      }

      /**
       * Edits an image brush
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$editImage",
      value: function $editImage() {
        var _this5 = this;
        var _this$state4 = this.state(),
          brush = _this$state4.brush;
        return feDialogs.showFor({
          title: GX_LEX.get("brushEditor.imageEditor.title"),
          value: brush,
          type: ImageBrushEditor
        }).then(function (newBrush) {
          return newBrush && _this5.loadAndModify(newBrush);
        }).then(function () {
          return htmlUtils.resetFocus(_this5.jq());
        });
      }

      /**
       * Edits a gradient brush
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$editGradient",
      value: function $editGradient() {
        var _this6 = this;
        var _this$state5 = this.state(),
          brush = _this$state5.brush;
        return feDialogs.showFor({
          title: GX_LEX.get("brushEditor.gradientEditor.title"),
          value: brush,
          type: GradientEditor,
          formFactor: compactFormFactor
        }).then(function (brush) {
          if (brush) {
            return _this6.loadAndModify(brush);
          }
        }).then(function () {
          return htmlUtils.resetFocus(_this6.jq());
        });
      }

      /**
       * returns the context menu command
       * @private
       * @returns {ContextMenuCommand}
       */
    }, {
      key: "$getContextMenuCommand",
      value: function $getContextMenuCommand() {
        return this.$contextMenuCommand;
      }

      /**
       * returns the widget for the context menu command
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getContextMenuCommandButton",
      value: function $getContextMenuCommandButton() {
        return this.queryWidget('preview/**/contextCommandMenu');
      }

      /**
       * gets the preview widget
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPreviewWidget",
      value: function $getPreviewWidget() {
        return this.queryWidget('preview');
      }

      /**
       * returns the JQuery object for the preview paint
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getPreviewPaint",
      value: function $getPreviewPaint() {
        return this.$getPreviewWidget().jq().find(".-t-BrushEditor-previewBrushPaint");
      }

      /**
       * returns the JQuery object for the preview brush text
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getPreviewLabel",
      value: function $getPreviewLabel() {
        return this.$getPreviewWidget().jq().find(".-t-BrushEditor-previewBrushText");
      }

      /**
       * returns the JQuery object for the preview div area
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getPreviewDiv",
      value: function $getPreviewDiv() {
        return this.$getPreviewWidget().jq().find(".-t-BrushEditor-previewDiv");
      }

      /**
       * returns the SVG object for the preview
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPreviewSvg",
      value: function $getPreviewSvg() {
        return this.queryWidget('**/previewSvg');
      }

      /**
       * returns the SVG Rect object for the preview
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getPreviewRect",
      value: function $getPreviewRect() {
        return this.queryWidget('**/previewRect');
      }
    }]);
  }(spandrel(function (value, state) {
    var self = state.self;
    return self.$buildEditor(state);
  }, {
    strategy: 'niagara'
  }));
  BrushEditor.ContextMenuCommand = ContextMenuCommand;
  return BrushEditor;
});
