function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/* eslint-env browser */

/**
* API Status: **Private**
* @module nmodule/gx/rc/baja/PathGeom
*/

define(['baja!', 'nmodule/gx/rc/baja/Point'], function (baja, Point) {
  'use strict';

  /**
  * BajaScript representation of a `gx:PathGeom`.
  *
  * @class
  * @alias module:nmodule/gx/rc/baja/PathGeom
  * @extends baja.Simple
  */
  var PathGeom = /*#__PURE__*/function (_baja$Simple) {
    /**
     * 
     * @constructor
     */
    function PathGeom() {
      var _this;
      _classCallCheck(this, PathGeom);
      _this = _callSuper(this, PathGeom);
      _this.$segments = [];
      return _this;
    }

    /**
     * @private
     * @returns {Array.<Segment>}
     */
    _inherits(PathGeom, _baja$Simple);
    return _createClass(PathGeom, [{
      key: "$getSegments",
      value: function $getSegments() {
        return this.$segments.slice();
      }

      /**
       * @private
       * @param {Array.<Segment>} segments
       */
    }, {
      key: "$setSegments",
      value: function $setSegments(segments) {
        this.$segments = segments.slice();
      }

      /**
       * @private
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */
    }, {
      key: "$clone",
      value: function $clone() {
        var pathGeom = new PathGeom();
        pathGeom.$setSegments(this.$getSegments());
        return pathGeom;
      }

      /**
       * Makes a PathGeom from a string input
       * 
       * @param {String} pathString 
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */
    }, {
      key: "make",
      value:
      /**
       * Makes a PathGeom from a string input
       * 
       * @param {String} pathString 
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */
      function make(pathString) {
        return PathGeom.make(pathString);
      }

      /**
       * Adds a MoveTo segment to the path
       * 
       * @see {@link https://www.w3.org/TR/SVG/paths.html#PathDataMovetoCommands}
       * @param {boolean} isAbsolute 
       * @param {Number} x 
       * @param {Number} y
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */
    }, {
      key: "moveTo",
      value: function moveTo(isAbsolute, x, y) {
        return this.add(new PathGeom.MoveTo(isAbsolute, x, y));
      }

      /**
       * Adds a LineTo segment to the path
       * 
       * @see {@link https://www.w3.org/TR/SVG/paths.html#PathDataLinetoCommands}
       * @param {boolean} isAbsolute 
       * @param {Number} x 
       * @param {Number} y
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */
    }, {
      key: "lineTo",
      value: function lineTo(isAbsolute, x, y) {
        return this.add(new PathGeom.LineTo(isAbsolute, x, y));
      }

      /**
       * Adds a HLineTo segment to the path
       * 
       * @see {@link https://www.w3.org/TR/SVG/paths.html#PathDataLinetoCommands}
       * @param {boolean} isAbsolute 
       * @param {Number} x 
       * @returns {module:nmodule/gx/rc/baja/PathGeom} this instance
       */
    }, {
      key: "hLineTo",
      value: function hLineTo(isAbsolute, x) {
        return this.add(new PathGeom.HLineTo(isAbsolute, x));
      }

      /**
       * Adds a VLineTo segment to the path
       * 
       * @see {@link https://www.w3.org/TR/SVG/paths.html#PathDataLinetoCommands}
       * @param {boolean} isAbsolute 
       * @param {Number} y
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */
    }, {
      key: "vLineTo",
      value: function vLineTo(isAbsolute, y) {
        return this.add(new PathGeom.VLineTo(isAbsolute, y));
      }

      /**
       * Adds a cubic Bézier CurveTo segment to the path
       * 
       * @see {@link https://www.w3.org/TR/SVG/paths.html#PathDataCubicBezierCommands}
       * @param {boolean} isAbsolute 
       * @param {Number} x1
       * @param {Number} y1
       * @param {Number} x2 
       * @param {Number} y2
       * @param {Number} x
       * @param {Number} y
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */
    }, {
      key: "curveTo",
      value: function curveTo(isAbsolute, x1, y1, x2, y2, x, y) {
        return this.add(new PathGeom.CurveTo(isAbsolute, x1, y1, x2, y2, x, y));
      }

      /**
       * Adds a smooth cubic Bézier CurveTo segment to the path
       * 
       * @see {@link https://www.w3.org/TR/SVG/paths.html#PathDataCubicBezierCommands}
       * @param {boolean} isAbsolute 
       * @param {Number} x2 
       * @param {Number} y2 
       * @param {Number} x 
       * @param {Number} y
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */
    }, {
      key: "smoothCurveTo",
      value: function smoothCurveTo(isAbsolute, x2, y2, x, y) {
        return this.add(new PathGeom.SmoothCurveTo(isAbsolute, x2, y2, x, y));
      }

      /**
       * Adds a quadratic Bézier QuadTo segment to the path
       * 
       * @see {@link https://www.w3.org/TR/SVG/paths.html#PathDataQuadraticBezierCommands}
       * @param {boolean} isAbsolute 
       * @param {Number} x1 
       * @param {Number} y1 
       * @param {Number} x 
       * @param {Number} y
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */
    }, {
      key: "quadTo",
      value: function quadTo(isAbsolute, x1, y1, x, y) {
        return this.add(new PathGeom.QuadTo(isAbsolute, x1, y1, x, y));
      }

      /**
       * Adds a smooth quadratic Bézier QuadTo segment to the path
       * 
       * @see {@link https://www.w3.org/TR/SVG/paths.html#PathDataQuadraticBezierCommands}
       * @param {boolean} isAbsolute 
       * @param {Number} x
       * @param {Number} y
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */
    }, {
      key: "smoothQuadTo",
      value: function smoothQuadTo(isAbsolute, x, y) {
        return this.add(new PathGeom.SmoothQuadTo(isAbsolute, x, y));
      }

      /**
       * Adds an ArcTo segment to the path
       * 
       * @see {@link https://www.w3.org/TR/SVG/paths.html#PathDataEllipticalArcCommands}
       * @param {boolean} isAbsolute 
       * @param {Number} rx 
       * @param {Number} ry 
       * @param {Number} xAxisRotation
       * @param {boolean} largeArcFlag
       * @param {boolean} sweepFlag
       * @param {Number} x
       * @param {Number} y
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */
    }, {
      key: "arcTo",
      value: function arcTo(isAbsolute, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y) {
        return this.add(new PathGeom.ArcTo(isAbsolute, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y));
      }

      /**
       * Adds a ClosePath segment to the path
       * 
       * @see {@link https://www.w3.org/TR/SVG/paths.html#PathDataClosePathCommand}
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */
    }, {
      key: "close",
      value: function close() {
        return this.add(new PathGeom.ClosePath(false));
      }

      /**
       * Pushes a new segment to the end of a newly cloned PathGeom and returns it.
       * 
       * @param {Segment} segment
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */
    }, {
      key: "add",
      value: function add(segment) {
        var clone = this.$clone();
        clone.$segments.push(segment);
        return clone;
      }

      /**
       * 
       * @returns {String}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        var lastCmd;
        return this.$segments.map(function (s) {
          if (lastCmd === s.getCommand()) {
            return s.toString();
          } else {
            lastCmd = s.getCommand();
            return s.getCommand() + s.toString();
          }
        }).join(' ');
      }

      /**
       * Decodes a string into PathGeom
       * 
       * @param {String} pathString 
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(pathString) {
        return PathGeom.make(pathString);
      }

      /**
       * @returns {boolean}
       */
    }, {
      key: "isNull",
      value: function isNull() {
        return this.$getSegments().length === 0;
      }

      /**
       * 
       * @param {number} dx 
       * @param {number} dy 
       * @returns {module:nmodule/gx/rc/baja/PathGeom} a clone of the geom, translated by the given deltas
       * @since Niagara 4.15
       */
    }, {
      key: "translate",
      value: function translate(dx, dy) {
        var segments = this.$getSegments();
        var translatedGeom = new PathGeom();
        segments.forEach(function (segment) {
          var isAbsolute = segment.getAbsolute();
          translatedGeom = translatedGeom.add(isAbsolute ? segment.translate(dx, dy) : segment);
        });
        return translatedGeom;
      }

      /**
       * @private
       * @param {String} cName 
       * @returns {Array<Segment>}
       */
    }, {
      key: "$getSegmentsByCommand",
      value: function $getSegmentsByCommand(cName) {
        return this.$getSegments().filter(function (s) {
          return s.getCommand().toUpperCase() === cName.toUpperCase();
        });
      }

      /**
       * 
       * @private
       * @param {Number} index
       * @returns {Segment}
       */
    }, {
      key: "$getSegmentByIndex",
      value: function $getSegmentByIndex(index) {
        return this.$getSegments()[index];
      }

      /**
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */
    }], [{
      key: "make",
      value: function make(pathString) {
        if (pathString === 'null' || !pathString) {
          return PathGeom.NULL;
        }
        return parsePathAndMakePathGeom(pathString);
      }
    }, {
      key: "DEFAULT",
      get: function get() {
        return DEFAULT;
      }

      /**
       * @returns {module:nmodule/gx/rc/baja/PathGeom}
       */
    }, {
      key: "NULL",
      get: function get() {
        return DEFAULT;
      }
    }]);
  }(baja.Simple);
  /**
   * Inner implementation of path segments.
   * 
   * @alias module:nmodule/gx/rc/baja/PathGeom~Segment
   * @memberOf module:nmodule/gx/rc/baja/PathGeom
   */
  var Segment = /*#__PURE__*/function () {
    /**
     * 
     * @constructor
     * @param {boolean} isAbsolute True if the segment has absolute coordinates 
     */
    function Segment(isAbsolute) {
      _classCallCheck(this, Segment);
      this.$isAbsolute = isAbsolute;
    }

    /**
     * True if the segment has absolute coordinates
     * @returns {boolean}
     */
    return _createClass(Segment, [{
      key: "getAbsolute",
      value: function getAbsolute() {
        return this.$isAbsolute;
      }

      /**
       * True if the segment does not have absolute coordinates
       * @returns {boolean}
       */
    }, {
      key: "getRelative",
      value: function getRelative() {
        return !this.$isAbsolute;
      }

      /**
       * 
       * @returns {String} string representation of the Path command
       */
    }, {
      key: "getCommand",
      value: function getCommand() {
        throw new Error('not implemented');
      }

      /**
       * 
       * @returns {String}
       */
    }, {
      key: "toString",
      value: function toString() {}

      /**
       * Translates this segment by applying deltas and returning a new copy.
       * This method is primarily consumed by UxBuilder when a Path's geom 
       * is translated in response to movement or resizing events.
       * @param {number} dx 
       * @param {number} dy 
       * @since Niagara 4.15
       * @returns {module:nmodule/gx/rc/baja/PathGeom~Segment}
       */
    }, {
      key: "translate",
      value: function translate(dx, dy) {}
    }]);
  }();
  /**
   * 
   * @extends Segment
   */
  var ClosePath = /*#__PURE__*/function (_Segment) {
    function ClosePath() {
      _classCallCheck(this, ClosePath);
      return _callSuper(this, ClosePath, arguments);
    }
    _inherits(ClosePath, _Segment);
    return _createClass(ClosePath, [{
      key: "getCommand",
      value: function getCommand() {
        return 'Z'; // Case does not matter
      }
    }, {
      key: "toString",
      value: function toString() {
        return '';
      }
    }, {
      key: "translate",
      value: function translate() {
        return new ClosePath();
      }
    }]);
  }(Segment);
  var MoveTo = /*#__PURE__*/function (_Segment2) {
    function MoveTo(isAbsolute, x, y) {
      var _this2;
      _classCallCheck(this, MoveTo);
      _this2 = _callSuper(this, MoveTo, [isAbsolute]);
      try {
        _this2.$point = new Point(x, y);
      } catch (err) {
        throw new Error("MoveTo Point: " + err.message);
      }
      return _this2;
    }
    _inherits(MoveTo, _Segment2);
    return _createClass(MoveTo, [{
      key: "translate",
      value: function translate(dx, dy) {
        var point = this.getPoint();
        return new MoveTo(this.getAbsolute(), point.x() + dx, point.y() + dy);
      }
    }, {
      key: "getCommand",
      value: function getCommand() {
        return this.getAbsolute() ? 'M' : 'm';
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.$point.encodeToString();
      }
    }, {
      key: "getPoint",
      value: function getPoint() {
        return this.$point;
      }
    }]);
  }(Segment);
  var LineTo = /*#__PURE__*/function (_Segment3) {
    function LineTo(isAbsolute, x, y) {
      var _this3;
      _classCallCheck(this, LineTo);
      _this3 = _callSuper(this, LineTo, [isAbsolute]);
      try {
        _this3.$point = new Point(x, y);
      } catch (err) {
        throw new Error("LineTo Point: " + err.message);
      }
      return _this3;
    }
    _inherits(LineTo, _Segment3);
    return _createClass(LineTo, [{
      key: "getCommand",
      value: function getCommand() {
        return this.getAbsolute() ? 'L' : 'l';
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.$point.encodeToString();
      }
    }, {
      key: "getPoint",
      value: function getPoint() {
        return this.$point;
      }
    }, {
      key: "translate",
      value: function translate(dx, dy) {
        var point = this.getPoint();
        return new LineTo(this.getAbsolute(), point.x() + dx, point.y() + dy);
      }
    }]);
  }(Segment);
  var HLineTo = /*#__PURE__*/function (_Segment4) {
    function HLineTo(isAbsolute, x) {
      var _this4;
      _classCallCheck(this, HLineTo);
      _this4 = _callSuper(this, HLineTo, [isAbsolute]);
      if (!isNumber(x)) {
        throw new Error('HLineTo: x coordinate is not a valid number.');
      }
      _this4.$x = x;
      return _this4;
    }
    _inherits(HLineTo, _Segment4);
    return _createClass(HLineTo, [{
      key: "getCommand",
      value: function getCommand() {
        return this.getAbsolute() ? 'H' : 'h';
      }
    }, {
      key: "getX",
      value: function getX() {
        return this.$x;
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.$x.encodeToString();
      }
    }, {
      key: "translate",
      value: function translate(dx, dy) {
        var x = this.getX();
        return new HLineTo(this.getAbsolute(), x + dx);
      }
    }]);
  }(Segment);
  var VLineTo = /*#__PURE__*/function (_Segment5) {
    function VLineTo(isAbsolute, y) {
      var _this5;
      _classCallCheck(this, VLineTo);
      _this5 = _callSuper(this, VLineTo, [isAbsolute]);
      if (!isNumber(y)) {
        throw new Error('VLineTo: y coordinate is not a valid number.');
      }
      _this5.$y = y;
      return _this5;
    }
    _inherits(VLineTo, _Segment5);
    return _createClass(VLineTo, [{
      key: "getCommand",
      value: function getCommand() {
        return this.getAbsolute() ? 'V' : 'v';
      }
    }, {
      key: "getY",
      value: function getY() {
        return this.$y;
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.$y.encodeToString();
      }
    }, {
      key: "translate",
      value: function translate(dx, dy) {
        var y = this.getY();
        return new VLineTo(this.getAbsolute(), y + dy);
      }
    }]);
  }(Segment);
  var CurveTo = /*#__PURE__*/function (_Segment6) {
    function CurveTo(isAbsolute, x1, y1, x2, y2, x, y) {
      var _this6;
      _classCallCheck(this, CurveTo);
      _this6 = _callSuper(this, CurveTo, [isAbsolute]);
      try {
        _this6.$cp1 = new Point(x1, y1);
      } catch (err) {
        throw new Error("CurveTo Control Point: " + err.message);
      }
      try {
        _this6.$cp2 = new Point(x2, y2);
      } catch (err) {
        throw new Error("CurveTo Control Point: " + err.message);
      }
      try {
        _this6.$end = new Point(x, y);
      } catch (err) {
        throw new Error("CurveTo Point: " + err.message);
      }
      return _this6;
    }
    _inherits(CurveTo, _Segment6);
    return _createClass(CurveTo, [{
      key: "getCommand",
      value: function getCommand() {
        return this.getAbsolute() ? 'C' : 'c';
      }
    }, {
      key: "getCp1",
      value: function getCp1() {
        return this.$cp1;
      }
    }, {
      key: "getCp2",
      value: function getCp2() {
        return this.$cp2;
      }
    }, {
      key: "getEnd",
      value: function getEnd() {
        return this.$end;
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.$cp1.encodeToString() + ' ' + this.$cp2.encodeToString() + ' ' + this.$end.encodeToString();
      }
    }, {
      key: "translate",
      value: function translate(dx, dy) {
        var cp1 = this.getCp1(),
          cp2 = this.getCp2(),
          end = this.getEnd();
        return new CurveTo(this.getAbsolute(), cp1.x() + dx, cp1.y() + dy, cp2.x() + dx, cp2.y() + dy, end.x() + dx, end.y() + dy);
      }
    }]);
  }(Segment);
  var SmoothCurveTo = /*#__PURE__*/function (_Segment7) {
    function SmoothCurveTo(isAbsolute, x2, y2, x, y) {
      var _this7;
      _classCallCheck(this, SmoothCurveTo);
      _this7 = _callSuper(this, SmoothCurveTo, [isAbsolute]);
      try {
        _this7.$cp2 = new Point(x2, y2);
      } catch (err) {
        throw new Error("SmoothCurveTo Control Point: " + err.message);
      }
      try {
        _this7.$end = new Point(x, y);
      } catch (err) {
        throw new Error("SmoothCurveTo Point: " + err.message);
      }
      return _this7;
    }
    _inherits(SmoothCurveTo, _Segment7);
    return _createClass(SmoothCurveTo, [{
      key: "getCommand",
      value: function getCommand() {
        return this.getAbsolute() ? 'S' : 's';
      }
    }, {
      key: "getCp2",
      value: function getCp2() {
        return this.$cp2;
      }
    }, {
      key: "getEnd",
      value: function getEnd() {
        return this.$end;
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.$cp2.encodeToString() + ' ' + this.$end.encodeToString();
      }
    }, {
      key: "translate",
      value: function translate(dx, dy) {
        var cp2 = this.getCp2(),
          end = this.getEnd();
        return new SmoothCurveTo(this.getAbsolute(), cp2.x() + dx, cp2.y() + dy, end.x() + dx, end.y() + dy);
      }
    }]);
  }(Segment);
  var QuadTo = /*#__PURE__*/function (_Segment8) {
    function QuadTo(isAbsolute, x1, y1, x, y) {
      var _this8;
      _classCallCheck(this, QuadTo);
      _this8 = _callSuper(this, QuadTo, [isAbsolute]);
      try {
        _this8.$cp = new Point(x1, y1);
      } catch (err) {
        throw new Error("QuadTo Control Point: " + err.message);
      }
      try {
        _this8.$end = new Point(x, y);
      } catch (err) {
        throw new Error("QuadTo Point: " + err.message);
      }
      return _this8;
    }
    _inherits(QuadTo, _Segment8);
    return _createClass(QuadTo, [{
      key: "getCommand",
      value: function getCommand() {
        return this.getAbsolute() ? 'Q' : 'q';
      }
    }, {
      key: "getCp",
      value: function getCp() {
        return this.$cp;
      }
    }, {
      key: "getEnd",
      value: function getEnd() {
        return this.$end;
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.$cp.encodeToString() + ' ' + this.$end.encodeToString();
      }
    }, {
      key: "translate",
      value: function translate(dx, dy) {
        var cp = this.getCp(),
          end = this.getEnd();
        return new QuadTo(this.getAbsolute(), cp.x() + dx, cp.y() + dy, end.x() + dx, end.y() + dy);
      }
    }]);
  }(Segment);
  var SmoothQuadTo = /*#__PURE__*/function (_Segment9) {
    function SmoothQuadTo(isAbsolute, x, y) {
      var _this9;
      _classCallCheck(this, SmoothQuadTo);
      _this9 = _callSuper(this, SmoothQuadTo, [isAbsolute]);
      try {
        _this9.$end = new Point(x, y);
      } catch (err) {
        throw new Error("SmoothQuadTo Point: " + err.message);
      }
      return _this9;
    }
    _inherits(SmoothQuadTo, _Segment9);
    return _createClass(SmoothQuadTo, [{
      key: "getCommand",
      value: function getCommand() {
        return this.getAbsolute() ? 'T' : 't';
      }
    }, {
      key: "getEnd",
      value: function getEnd() {
        return this.$end;
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.$end.encodeToString();
      }
    }, {
      key: "translate",
      value: function translate(dx, dy) {
        var end = this.getEnd();
        return new SmoothQuadTo(this.getAbsolute(), end.x() + dx, end.y() + dy);
      }
    }]);
  }(Segment);
  var ArcTo = /*#__PURE__*/function (_Segment10) {
    function ArcTo(isAbsolute, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y) {
      var _this10;
      _classCallCheck(this, ArcTo);
      _this10 = _callSuper(this, ArcTo, [isAbsolute]);
      if (!isNumber(rx)) {
        throw new Error('ArcTo: radius x not a valid number.');
      }
      if (!isNumber(ry)) {
        throw new Error('ArcTo: radius y not a valid number.');
      }
      if (!isNumber(xAxisRotation)) {
        throw new Error('ArcTo: x axis rotaion not a valid number.');
      }
      try {
        _this10.$end = new Point(x, y);
      } catch (err) {
        throw new Error("ArcTo Point: " + err.message);
      }
      _this10.$largeArcFlag = Boolean.make(!!largeArcFlag);
      _this10.$sweepFlag = Boolean.make(!!sweepFlag);
      _this10.$rx = rx;
      _this10.$ry = ry;
      _this10.$xAxisRotation = xAxisRotation;
      return _this10;
    }
    _inherits(ArcTo, _Segment10);
    return _createClass(ArcTo, [{
      key: "getCommand",
      value: function getCommand() {
        return this.getAbsolute() ? 'A' : 'a';
      }
    }, {
      key: "getRadiusX",
      value: function getRadiusX() {
        return this.$rx;
      }
    }, {
      key: "getRadiusY",
      value: function getRadiusY() {
        return this.$ry;
      }
    }, {
      key: "getXAxisRotation",
      value: function getXAxisRotation() {
        return this.$xAxisRotation;
      }
    }, {
      key: "getLargeArcFlag",
      value: function getLargeArcFlag() {
        return this.$largeArcFlag;
      }
    }, {
      key: "getSweepFlag",
      value: function getSweepFlag() {
        return this.$sweepFlag;
      }
    }, {
      key: "getEnd",
      value: function getEnd() {
        return this.$end;
      }
    }, {
      key: "toString",
      value: function toString() {
        return this.$rx.encodeToString() + ',' + this.$ry.encodeToString() + ' ' + this.$xAxisRotation.encodeToString() + ' ' + this.$largeArcFlag.getOrdinal().encodeToString() + ',' + this.$sweepFlag.getOrdinal().encodeToString() + ' ' + this.$end.encodeToString();
      }
    }, {
      key: "translate",
      value: function translate(dx, dy) {
        var end = this.getEnd();
        return new ArcTo(this.getAbsolute(), this.getRadiusX() + dx, this.getRadiusY() + dy, this.getXAxisRotation(), this.getLargeArcFlag(), this.getSweepFlag(), end.x() + dx, end.y() + dy);
      }
    }]);
  }(Segment);
  var DEFAULT = new PathGeom();

  /**
   * Parse the path string and return a list of Segments
   * 
   * @param {String} pathString 
   * @return {module:nmodule/gx/rc/baja/PathGeom}
   */
  function parsePathAndMakePathGeom(pathString) {
    var cmdRegEx = /([MLHVCSQTAZ])([^MLHVCSQTAZ]*)/gi,
      commands = pathString.match(cmdRegEx);
    var pathGeom = new PathGeom();
    commands.map(function (c) {
      var cmdArg = c.substring(1).trim();
      switch (c[0].toUpperCase()) {
        case 'M':
          {
            var points = parsePoints(cmdArg);
            return points.forEach(function (p) {
              return pathGeom = pathGeom.moveTo(isAbsolute(c[0]), p.x, p.y);
            });
          }
        case 'L':
          {
            var _points = parsePoints(cmdArg);
            return _points.map(function (p) {
              return pathGeom = pathGeom.lineTo(isAbsolute(c[0]), p.x, p.y);
            });
          }
        case 'H':
          {
            var xs = parseArgs(cmdArg);
            if (!xs) {
              throw new Error('Invalid HLineTo segment.');
            }
            return xs.map(function (x) {
              return pathGeom = pathGeom.hLineTo(isAbsolute(c[0]), x);
            });
          }
        case 'V':
          {
            var ys = parseArgs(cmdArg);
            if (!ys) {
              throw new Error('Invalid VLineTo segment.');
            }
            return ys.map(function (y) {
              return pathGeom = pathGeom.vLineTo(isAbsolute(c[0]), y);
            });
          }
        case 'C':
          {
            var cGroup = getArgChunks(parsePoints(cmdArg), 3, []);
            return cGroup.map(function (points) {
              return pathGeom = pathGeom.curveTo(isAbsolute(c[0]), points[0].x, points[0].y, points[1].x, points[1].y, points[2].x, points[2].y);
            });
          }
        case 'S':
          {
            var _cGroup = getArgChunks(parsePoints(cmdArg), 2, []);
            return _cGroup.map(function (points) {
              return pathGeom = pathGeom.smoothCurveTo(isAbsolute(c[0]), points[0].x, points[0].y, points[1].x, points[1].y);
            });
          }
        case 'Q':
          {
            var _cGroup2 = getArgChunks(parsePoints(cmdArg), 2, []);
            return _cGroup2.map(function (points) {
              return pathGeom = pathGeom.quadTo(isAbsolute(c[0]), points[0].x, points[0].y, points[1].x, points[1].y);
            });
          }
        case 'T':
          {
            var _cGroup3 = getArgChunks(parsePoints(cmdArg), 1, []);
            return _cGroup3.map(function (points) {
              return pathGeom = pathGeom.smoothQuadTo(isAbsolute(c[0]), points[0].x, points[0].y);
            });
          }
        case 'A':
          {
            var args = parseArgs(cmdArg);
            if (!args) {
              throw new Error('Invalid ArcTo segment.');
            }
            var arcs = getArgChunks(args, 7, []);
            return arcs.map(function (arcArgs) {
              var _pathGeom;
              if (arcArgs.length !== 7) {
                throw new Error('Incorrect Arc syntax.');
              }
              return pathGeom = (_pathGeom = pathGeom).arcTo.apply(_pathGeom, [isAbsolute(c[0])].concat(_toConsumableArray(arcArgs)));
            });
          }
        case 'Z':
          {
            return pathGeom = pathGeom.close(false);
          }
        default:
          {
            throw new Error("Unknown Command");
          }
      }
    });
    return pathGeom;
  }

  /**
   * Parse each command arguments and return as list of points
   * 
   * @param {String} str 
   * @returns {Array<Object>} of the form {x:xVal, y:yVal}
   */
  function parsePoints(str) {
    var values = parseArgs(str);
    if (!values) {
      throw new Error('Invalid geom');
    }
    return values.reduce(function (points, val, i, vals) {
      if (i % 2 === 0) {
        points.push({
          x: parseFloat(val, 10),
          y: parseFloat(vals[i + 1], 10)
        });
      }
      return points;
    }, []);
  }

  /**
   * 
   * @param {String} str 
   * @returns {Array<Number>|null}
   */
  function parseArgs(str) {
    var valRegEx = /-?\d*\.?\d+/g;
    var argValues = str.match(valRegEx);
    return argValues && argValues.map(function (v) {
      return parseFloat(v, 10);
    });
  }
  function isAbsolute(_char) {
    return _char === _char.toUpperCase();
  }

  /**
   * Return groups of segment argument values sized by n
   * 
   * @param {Array<Object>} args 
   * @param {Number} n size of the group/chunk
   * @returns {Array<Array<Object>>} of size n chunks
   */
  function getArgChunks(args, n, g) {
    return args.length === 0 ? g : getArgChunks(args.slice(n), n, g.concat([args.slice(0, n)]));
  }
  function isNumber(number) {
    return typeof number === 'number';
  }
  PathGeom.MoveTo = MoveTo;
  PathGeom.LineTo = LineTo;
  PathGeom.HLineTo = HLineTo;
  PathGeom.VLineTo = VLineTo;
  PathGeom.CurveTo = CurveTo;
  PathGeom.SmoothCurveTo = SmoothCurveTo;
  PathGeom.QuadTo = QuadTo;
  PathGeom.SmoothQuadTo = SmoothQuadTo;
  PathGeom.ArcTo = ArcTo;
  PathGeom.ClosePath = ClosePath;
  return PathGeom;
});
