function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
* API Status: **Private**
* @module nmodule/gx/rc/baja/LineGeom
*/

define(['baja!', 'nmodule/gx/rc/baja/Point'], function (baja, Point) {
  'use strict';

  /**
  * BajaScript representation of a `gx:LineGeom`.
  *
  * @class
  * @alias module:nmodule/gx/rc/baja/LineGeom
  * @extends baja.Simple
  */
  var LineGeom = /*#__PURE__*/function (_baja$Simple) {
    function LineGeom(x1, y1, x2, y2) {
      var _this;
      _classCallCheck(this, LineGeom);
      _this = _callSuper(this, LineGeom);
      try {
        _this.$point1 = new Point(x1, y1);
      } catch (err) {
        throw new Error("Point1: " + err.message);
      }
      try {
        _this.$point2 = new Point(x2, y2);
      } catch (err) {
        throw new Error("Point2: " + err.message);
      }
      return _this;
    }

    /**
     * Gets the x coordinate of the first/start point
     * @returns {Number}
     */
    _inherits(LineGeom, _baja$Simple);
    return _createClass(LineGeom, [{
      key: "x1",
      value: function x1() {
        return this.$point1.x();
      }

      /**
       * Gets the y coordinate of the first/start point
       * @returns {Number}
       */
    }, {
      key: "y1",
      value: function y1() {
        return this.$point1.y();
      }

      /**
       * Gets the x coordinate of the second/end point
       * @returns {Number}
       */
    }, {
      key: "x2",
      value: function x2() {
        return this.$point2.x();
      }

      /**
       * Gets the y coordinate of the second/end point
       * @returns {Number}
       */
    }, {
      key: "y2",
      value: function y2() {
        return this.$point2.y();
      }

      /**
       * @param {number} dx
       * @param {number} dy
       * @param {number} [idx] index of the specific point to translate 
       * @returns {module:nmodule/gx/rc/baja/LineGeom} a clone of the geom, translated by the given
       * deltas
       * @since Niagara 4.15
       */
    }, {
      key: "translate",
      value: function translate(dx, dy, idx) {
        var points = this.getPoints();
        if (typeof idx === 'number') {
          var point = points[idx];
          if (!point) {
            return this;
          }
          points[idx] = new Point(point.x() + dx, point.y() + dy);
          return LineGeom.fromPoints.apply(LineGeom, _toConsumableArray(points));
        }
        return new LineGeom(this.x1() + dx, this.y1() + dy, this.x2() + dx, this.y2() + dy);
      }

      /**
       * Makes a LineGeom from a string input of the form 
       * "x1,y1 x2,y2"
       * 
       * @param {String} geomString 
       * @returns {module:nmodule/gx/rc/baja/LineGeom}
       */
    }, {
      key: "make",
      value: function make(geomString) {
        return LineGeom.make(geomString);
      }

      /**
       * Convenience to make a line from two gx:Point instances
       * 
       * @param {module:nmodule/gx/rc/baja/Point} start 
       * @param {module:nmodule/gx/rc/baja/Point} end 
       * @returns {module:nmodule/gx/rc/baja/LineGeom}
       */
    }, {
      key: "fromPoint",
      value: function fromPoint(start, end) {
        return LineGeom.fromPoints(start, end);
      }

      /**
       * Encoded as x1,y1 x2,y2
       * 
       * @returns {String}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        if (this.isNull()) {
          return 'null';
        }
        return [this.$point1, this.$point2].map(function (p) {
          return p.encodeToString();
        }).join(' ');
      }

      /**
       * 
       * @param {String} geomString 
       * @returns {module:nmodule/gx/rc/baja/LineGeom}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(geomString) {
        return LineGeom.make(geomString);
      }

      /**
       * @returns {boolean}
       */
    }, {
      key: "isNull",
      value: function isNull() {
        return this === LineGeom.NULL;
      }

      /**
       * @since Niagara 4.15
       * @returns {Array.<module:nmodule/gx/rc/baja/Point>}
       */
    }, {
      key: "getPoints",
      value: function getPoints() {
        return [this.$point1, this.$point2];
      }

      /**
       * @returns {module:nmodule/gx/rc/baja/LineGeom}
       */
    }], [{
      key: "make",
      value: function make(geomString) {
        if (geomString === "null") {
          return LineGeom.NULL;
        }
        var _geomString$split$map = geomString.split(' ').map(Point.DEFAULT.decodeFromString),
          _geomString$split$map2 = _slicedToArray(_geomString$split$map, 2),
          p1 = _geomString$split$map2[0],
          p2 = _geomString$split$map2[1];
        try {
          return new LineGeom(p1.x(), p1.y(), p2.x(), p2.y());
        } catch (error) {
          throw new Error("Incorrect format for LineGeom: ".concat(error.message));
        }
      }
    }, {
      key: "fromPoints",
      value: function fromPoints(start, end) {
        return new LineGeom(start.x(), start.y(), end.x(), end.y());
      }
    }, {
      key: "DEFAULT",
      get: function get() {
        return DEFAULT;
      }

      /**
       * @returns {module:nmodule/gx/rc/baja/LineGeom}
       */
    }, {
      key: "NULL",
      get: function get() {
        return NULL;
      }
    }]);
  }(baja.Simple);
  var DEFAULT = new LineGeom(0, 0, 0, 0);
  var NULL = new LineGeom(0, 0, 0, 0);
  return LineGeom;
});
