function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _construct(t, e, r) { if (_isNativeReflectConstruct()) return Reflect.construct.apply(null, arguments); var o = [null]; o.push.apply(o, e); var p = new (t.bind.apply(t, o))(); return r && _setPrototypeOf(p, r.prototype), p; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
* API Status: **Private**
* @module nmodule/gx/rc/baja/EllipseGeom
*/

define(['baja!', 'nmodule/gx/rc/baja/Point'], function (baja, Point) {
  'use strict';

  /**
  * BajaScript representation of a `gx:EllipseGeom`.
  *
  * @class
  * @alias module:nmodule/gx/rc/baja/EllipseGeom
  * @extends baja.Simple
  */
  var EllipseGeom = /*#__PURE__*/function (_baja$Simple) {
    function EllipseGeom(x, y, width, height) {
      var _this;
      _classCallCheck(this, EllipseGeom);
      _this = _callSuper(this, EllipseGeom);
      try {
        _this.$point = new Point(x, y);
      } catch (err) {
        throw new Error("Point: " + err.message);
      }
      if (!isNumber(width)) {
        throw new Error('Width must be a valid number.');
      }
      if (!isNumber(height)) {
        throw new Error('Height must be a valid number.');
      }
      _this.$width = width;
      _this.$height = height;
      return _this;
    }

    /**
     * Makes a EllipseGeom from a string input of the form 
     * "x,y,width,height"
     * 
     * @param {String} geomString 
     * @returns {module:nmodule/gx/rc/baja/EllipseGeom}
     */
    _inherits(EllipseGeom, _baja$Simple);
    return _createClass(EllipseGeom, [{
      key: "make",
      value:
      /**
       * @param {string} geomString
       * @returns {module:nmodule/gx/rc/baja/EllipseGeom}
       */
      function make(geomString) {
        return EllipseGeom.make(geomString);
      }

      /**
       * @returns {number}
       */
    }, {
      key: "x",
      value: function x() {
        return this.$point.x();
      }

      /**
       * @returns {number}
       */
    }, {
      key: "y",
      value: function y() {
        return this.$point.y();
      }

      /**
       * @returns {number}
       */
    }, {
      key: "width",
      value: function width() {
        return this.$width;
      }

      /**
       * @returns {number}
       */
    }, {
      key: "height",
      value: function height() {
        return this.$height;
      }

      /**
       * @param {number} dx
       * @param {number} dy
       * @returns {module:nmodule/gx/rc/baja/EllipseGeom} a clone of the geom, translated by the given
       * deltas
       * @since Niagara 4.15
       */
    }, {
      key: "translate",
      value: function translate(dx, dy) {
        return new EllipseGeom(this.x() + dx, this.y() + dy, this.width(), this.height());
      }

      /**
       * @returns {number}
       */
    }, {
      key: "cx",
      value: function cx() {
        return this.$point.x() + this.rx();
      }

      /**
       * @returns {number}
       */
    }, {
      key: "cy",
      value: function cy() {
        return this.$point.y() + this.ry();
      }

      /**
       * @returns {number}
       */
    }, {
      key: "rx",
      value: function rx() {
        return this.$width / 2;
      }

      /**
       * @returns {number}
       */
    }, {
      key: "ry",
      value: function ry() {
        return this.$height / 2;
      }

      /**
       * Encoded as x,y,width,height
       * 
       * @returns {String}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        if (this.isNull()) {
          return 'null';
        }
        var pVal = this.$point.encodeToString(),
          wVal = this.$width.encodeToString(),
          hVal = this.$height.encodeToString();
        return "".concat(pVal, ",").concat(wVal, ",").concat(hVal);
      }

      /**
       * 
       * @param {String} geomString 
       * @returns {module:nmodule/gx/rc/baja/EllipseGeom}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(geomString) {
        return EllipseGeom.make(geomString);
      }

      /**
       * @returns {boolean}
       */
    }, {
      key: "isNull",
      value: function isNull() {
        return this === EllipseGeom.NULL;
      }

      /**
       * @returns {module:nmodule/gx/rc/baja/EllipseGeom}
       */
    }], [{
      key: "make",
      value: function make(geomString) {
        if (geomString === 'null') {
          return EllipseGeom.NULL;
        }
        return _construct(EllipseGeom, _toConsumableArray(geomString.split(',').map(baja.Double.DEFAULT.decodeFromString)));
      }
    }, {
      key: "DEFAULT",
      get: function get() {
        return DEFAULT;
      }

      /**
       * @returns {module:nmodule/gx/rc/baja/EllipseGeom}
       */
    }, {
      key: "NULL",
      get: function get() {
        return NULL;
      }
    }]);
  }(baja.Simple);
  function isNumber(number) {
    return typeof number === 'number';
  }
  var DEFAULT = new EllipseGeom(0, 0, 0, 0);
  var NULL = new EllipseGeom(0, 0, 0, 0);
  return EllipseGeom;
});
