function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/lonworks/rc/wb/lonlink/UxLonLinkManager
 */

define(['baja!', 'baja!lonworks:LonLinkType,lonworks:SetServiceTypeParameter', 'dialogs', 'bajaux/spandrel', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'bajaux/commands/ToggleCommandGroup', 'bajaux/mixin/subscriberMixIn', 'bajaux/util/CommandButtonGroup', 'lex!lonworks,bajaux', 'Promise', 'nmodule/lonworks/rc/wb/lonlink/LinkTable', 'nmodule/lonworks/rc/wb/lonlink/TagLinkTable', 'nmodule/webEditors/rc/fe/baja/FrozenEnumEditor', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/job/JobBar', 'nmodule/webEditors/rc/wb/table/Table'], function (baja, types, dialogs, spandrel, Command, CommandGroup, ToggleCommandGroup, subscribable, CommandButtonGroup, lexs, Promise, LinkTable, TagLinkTable, FrozenEnumEditor, compUtils, DepthSubscriber, feDialogs, JobBar, Table) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 2),
    LON_LEX = _lexs[0],
    bajauxLex = _lexs[1];
  var ROW_SELECTION_CHANGED_EVENT = Table.ROW_SELECTION_CHANGED_EVENT;
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-UxLonLinkManager'
      }
    };
  };
  var isProxyEntry = function isProxyEntry(linkEntry) {
    return linkEntry.getHubDevice() === 'LocalDev' || linkEntry.getTargetDevice() === 'LocalDev';
  };
  var MAX_CRITICAL_TARGETS = 5;
  var MAX_CONNECTIONS = 12287;

  /**
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/lonworks/rc/wb/lonlink/UxLonLinkManager~RefreshCommand
   */
  var RefreshCommand = /*#__PURE__*/function (_Command) {
    function RefreshCommand(linkManager, tab) {
      _classCallCheck(this, RefreshCommand);
      return _callSuper(this, RefreshCommand, [{
        module: 'lonworks',
        lex: 'lonlink.refresh',
        func: function func() {
          return linkManager.$doRefresh();
        }
      }]);
    }
    _inherits(RefreshCommand, _Command);
    return _createClass(RefreshCommand);
  }(Command);
  /**
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/lonworks/rc/wb/lonlink/UxLonLinkManager~BindCommand
   */
  var BindCommand = /*#__PURE__*/function (_Command2) {
    function BindCommand(linkManager, tab) {
      _classCallCheck(this, BindCommand);
      return _callSuper(this, BindCommand, [{
        module: 'lonworks',
        lex: 'lonlink.bind',
        func: function func() {
          return linkManager.$doBind();
        }
      }]);
    }
    _inherits(BindCommand, _Command2);
    return _createClass(BindCommand);
  }(Command);
  /**
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/lonworks/rc/wb/lonlink/UxLonLinkManager~SelectiveBindCommand
   */
  var SelectiveBindCommand = /*#__PURE__*/function (_Command3) {
    function SelectiveBindCommand(linkManager, tab) {
      _classCallCheck(this, SelectiveBindCommand);
      return _callSuper(this, SelectiveBindCommand, [{
        module: 'lonworks',
        lex: 'lonlink.selectiveBind',
        enabled: false,
        func: function func() {
          return linkManager.$doSelectiveBind();
        }
      }]);
    }
    _inherits(SelectiveBindCommand, _Command3);
    return _createClass(SelectiveBindCommand);
  }(Command);
  /**
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/lonworks/rc/wb/lonlink/UxLonLinkManager~SetServiceTypeCommand
   */
  var SetServiceTypeCommand = /*#__PURE__*/function (_Command4) {
    function SetServiceTypeCommand(linkManager, tab) {
      _classCallCheck(this, SetServiceTypeCommand);
      return _callSuper(this, SetServiceTypeCommand, [{
        module: 'lonworks',
        lex: 'lonlink.setServiceType',
        enabled: false,
        func: function func() {
          return linkManager.$doSetServiceType();
        }
      }]);
    }
    _inherits(SetServiceTypeCommand, _Command4);
    return _createClass(SetServiceTypeCommand);
  }(Command);
  /**
   * @class
   * @inner
   * @alias module:nmodule/lonworks/rc/wb/lonlink/UxLonLinkManager~SelectServiceTypeEditor
   * @extends {module:bajaux/spandrel}
   */
  var SelectServiceTypeEditor = /*#__PURE__*/function (_spandrel) {
    function SelectServiceTypeEditor(params) {
      _classCallCheck(this, SelectServiceTypeEditor);
      return _callSuper(this, SelectServiceTypeEditor, [{
        params: params,
        defaults: {
          properties: {
            rootCssClass: "-t-SelectServiceTypeEditor"
          }
        }
      }]);
    }
    _inherits(SelectServiceTypeEditor, _spandrel);
    return _createClass(SelectServiceTypeEditor, [{
      key: "toState",
      value: function toState() {
        return {
          selected: baja.$('lonworks:LonLinkType').get('standard'),
          priority: false
        };
      }
    }, {
      key: "fromState",
      value: function fromState(_ref) {
        var selected = _ref.selected,
          priority = _ref.priority;
        return {
          selected: selected,
          priority: priority
        };
      }

      /**
       * @private
       * @returns {module:bajaux/Widget} 
       */
    }, {
      key: "$getSelectServiceTypeEd",
      value: function $getSelectServiceTypeEd() {
        return this.queryWidget('wrapper/serviceType/lonLinkType');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget} 
       */
    }, {
      key: "$getPriorityEd",
      value: function $getPriorityEd() {
        return this.queryWidget('wrapper/priority');
      }
    }]);
  }(spandrel(function (value, _ref2) {
    var self = _ref2.self,
      selected = _ref2.selected,
      priority = _ref2.priority;
    var priorityTxt = LON_LEX.get('lonlink.priority');
    return spandrel.jsx("div", {
      spandrelKey: "wrapper",
      className: "-t-SelectServiceTypeEditor-wrapper"
    }, spandrel.jsx("div", {
      spandrelKey: "serviceType",
      className: "-t-SelectServiceTypeEditor-selectServiceType"
    }, spandrel.jsx("label", null, LON_LEX.get('lonlink.serviceTypeText')), spandrel.jsx(FrozenEnumEditor, {
      spandrelKey: "lonLinkType",
      bindKey: "selected",
      value: selected,
      properties: {
        uxValidOptions: baja.EnumSet.make([1, 2, 3, 4, 5]).encodeToString()
      }
    })), spandrel.jsx("any", {
      spandrelKey: "priority",
      bind: true,
      value: priority,
      properties: {
        displayType: 'checkbox',
        trueText: priorityTxt,
        falseText: priorityTxt
      }
    }));
  }, {
    strategy: 'niagara'
  }));
  /**
   * @class
   * @extends module:bajaux/spandrel
   * @alias module:nmodule/lonworks/rc/wb/lonlink/UxLonLinkManager
   */
  return /*#__PURE__*/function (_spandrel2) {
    function UxLonLinkManager(params) {
      var _this;
      _classCallCheck(this, UxLonLinkManager);
      _this = _callSuper(this, UxLonLinkManager, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$lonLinkCommandGroup = new CommandGroup({
        commands: [new RefreshCommand(_this), new BindCommand(_this), new SelectiveBindCommand(_this), new SetServiceTypeCommand(_this)]
      });
      _this.$tabSwitchCommands = new ToggleCommandGroup({
        commands: [{
          displayName: LON_LEX.get("lonlink.tab.NetworkVariableLinks.name"),
          value: 'linkTable',
          selected: true
        }, {
          displayName: LON_LEX.get("lonlink.tab.MessageTagLinks.name"),
          value: 'tagLinkTable'
        }],
        onChange: function onChange(linkTable) {
          return _this.state({
            visibleLinkTable: linkTable
          }).then(function () {
            return _this.$updateCommandStatus();
          });
        }
      });

      // Only subscribe to what is needed
      _this.$subscriber = new DepthSubscriber({
        depth: 2,
        subscribeCallback: function subscribeCallback(_ref3) {
          var comp = _ref3.comp,
            sub = _ref3.sub;
          if (baja.hasType(comp, 'lonworks:LonNetmgmt')) {
            return sub.subscribe(comp);
          }
        }
      });
      subscribable(_this);
      _this.$subscriber.attach('topicFired', function (topic, entryTable) {
        if (topic.getName() === "linksUpdated") {
          var linkEntries = entryTable.getSlots().properties().is('lonworks:LinkEntry').toValueArray();
          var exceededMaximumConnections = entryTable.getExceededMaximumConnections();
          return _this.state({
            linkEntries: linkEntries
          }).then(function () {
            return _this.$updateLinks(exceededMaximumConnections);
          });
        }
        if (topic.getName() === "tagLinksUpdated") {
          return _this.$updateTagLinks(entryTable);
        }
      });
      return _this;
    }
    _inherits(UxLonLinkManager, _spandrel2);
    return _createClass(UxLonLinkManager, [{
      key: "toState",
      value: function toState() {
        return {
          visibleLinkTable: 'linkTable',
          hideProxyLinks: false,
          hideNetLinks: false,
          linkEntries: []
        };
      }

      /**
       * Returns the network that the manager is attached to
       * @returns {baja.Complex}
       */
    }, {
      key: "getNetwork",
      value: function getNetwork() {
        return compUtils.closest(this.value(), baja.lt('lonworks:LonNetwork'));
      }

      /**
       * Returns the lonworks:LonNetmgmt instance attached to this network
       * @returns {baja.Complex}
       */
    }, {
      key: "getLonNetmgmt",
      value: function getLonNetmgmt() {
        return this.getNetwork().getLonNetmgmt();
      }

      /**
       * @private
       * @returns {module:bajaux/commands/CommandGroup}
       */
    }, {
      key: "$getCommandGroup",
      value: function $getCommandGroup() {
        return this.$lonLinkCommandGroup;
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/job/JobBar}
       */
    }, {
      key: "$getJobBar",
      value: function $getJobBar() {
        return this.queryWidget('container/jobBar');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButtonGroup}
       */
    }, {
      key: "$getTabSwitcher",
      value: function $getTabSwitcher() {
        return this.queryWidget('container/tabSwitcher');
      }

      /**
       * @private
       * @returns {Array.<module:nmodule/lonworks/rc/wb/lonlink/LonLinkManagerTab>}
       */
    }, {
      key: "$getTabs",
      value: function $getTabs() {
        return this.queryWidgets('container/tabs/*');
      }

      /**
       * @private
       * @return {module:nmodule/webEditors/rc/wb/table/ExportOnlyTable}
       */
    }, {
      key: "$getLinkTable",
      value: function $getLinkTable() {
        return this.queryWidget('container/tabs/linkTable/*');
      }

      /**
       * @private
       * @return {module:nmodule/webEditors/rc/wb/table/ExportOnlyTable}
       */
    }, {
      key: "$getTagLinkTable",
      value: function $getTagLinkTable() {
        return this.queryWidget('container/tabs/tagLinkTable/*');
      }

      /**
       * @private
       * @returns {module:nmodule/lonworks/rc/wb/lonlink/UxLonLinkManager~RefreshCommand}
       */
    }, {
      key: "$getRefreshCommand",
      value: function $getRefreshCommand() {
        return this.$getCommandGroup().findCommand(RefreshCommand);
      }

      /**
       * @private
       * @returns {module:nmodule/lonworks/rc/wb/lonlink/UxLonLinkManager~BindCommand}
       */
    }, {
      key: "$getBindCommand",
      value: function $getBindCommand() {
        return this.$getCommandGroup().findCommand(BindCommand);
      }

      /**
       * @private
       * @returns {module:nmodule/lonworks/rc/wb/lonlink/UxLonLinkManager~SelectiveBindCommand}
       */
    }, {
      key: "$getSelectiveBindCommand",
      value: function $getSelectiveBindCommand() {
        return this.$getCommandGroup().findCommand(SelectiveBindCommand);
      }

      /**
       * @private
       * @returns {module:nmodule/lonworks/rc/wb/lonlink/UxLonLinkManager~SetServiceTypeCommand}
       */
    }, {
      key: "$getSetServiceTypeCommand",
      value: function $getSetServiceTypeCommand() {
        return this.$getCommandGroup().findCommand(SetServiceTypeCommand);
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getHideProxyLinksOptionEd",
      value: function $getHideProxyLinksOptionEd() {
        return this.queryWidget('container/footer/options/0');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getHideNetLinksOptionEd",
      value: function $getHideNetLinksOptionEd() {
        return this.queryWidget('container/footer/options/1');
      }

      /**
       * @private
       */
    }, {
      key: "$doRefresh",
      value: function $doRefresh() {
        return this.getLonNetmgmt().invoke({
          slot: 'refreshLinkTable'
        });
      }

      /**
       * @private
       * @param {String} [selectors=String.DEFAULT] 
       * @returns {Promise}
       */
    }, {
      key: "$doBind",
      value: function $doBind() {
        var _this2 = this;
        var selectors = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : String.DEFAULT;
        return this.getLonNetmgmt().invoke({
          slot: 'bindLinkEntry',
          value: selectors
        }).then(function (jobOrd) {
          return jobOrd.resolve({
            base: _this2.value()
          });
        }).then(function (jobTarget) {
          return _this2.$getJobBar().load(jobTarget.getComponent());
        });
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doSelectiveBind",
      value: function $doSelectiveBind() {
        var _this3 = this;
        var _this$state = this.state(),
          visibleLinkTable = _this$state.visibleLinkTable;
        if (visibleLinkTable === 'linkTable') {
          var selectors = this.$getSelectors();
          return this.$doBind(selectors);
        } else {
          var selectedRows = this.$getTagLinkTable().getSelectedRows();
          var sameOutput = function sameOutput(entry1, entry2) {
            return entry1.getOutputDevice() === entry2.getOutputDevice() && entry1.getOutputTag() === entry2.getOutputTag();
          };
          var lastEntry;
          return Promise.all(selectedRows.map(function (row) {
            var tagLinkEntry = row.getSubject();
            if (lastEntry && sameOutput(tagLinkEntry, lastEntry)) {
              return;
            }
            lastEntry = tagLinkEntry;
            return _this3.getLonNetmgmt().invoke({
              slot: 'bindTagLinkEntry',
              value: tagLinkEntry
            });
          })).then(function (jobs) {
            return jobs.length > 0 && _this3.$loadJob(jobs);
          });
        }
      }

      /**
       * @private
       * @returns {String}
       */
    }, {
      key: "$getSelectors",
      value: function $getSelectors() {
        var selectedRows = this.$getLinkTable().getSelectedRows();
        return selectedRows.map(function (row) {
          return row.getSubject().getSelector();
        }).join(',');
      }

      /**
       * @private
       * @param {baja.Ord|Array.<baja.Ord>} jobOrds
       * @returns {Promise}
       */
    }, {
      key: "$loadJob",
      value: function $loadJob(jobOrds) {
        var _this4 = this;
        var jobOrdToLoad;
        if (Array.isArray(jobOrds)) {
          // Just load the last job like what bajaui does.
          jobOrds = jobOrds.filter(function (jobOrd) {
            return jobOrd;
          });
          jobOrdToLoad = jobOrds[jobOrds.length - 1];
        } else {
          jobOrdToLoad = jobOrds;
        }
        return jobOrdToLoad.resolve({
          base: this.value()
        }).then(function (jobTarget) {
          return _this4.$getJobBar().load(jobTarget.getComponent());
        });
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doUpdateLinks",
      value: function $doUpdateLinks() {
        var _this5 = this;
        return Promise["try"](function () {
          var _this5$state = _this5.state(),
            linkEntries = _this5$state.linkEntries;
          if (linkEntries && linkEntries.length > 0) {
            return _this5.$updateLinks();
          }
        });
      }

      /**
       * @private
       * @return {undefined|Promise}
       */
    }, {
      key: "$updateLinks",
      value: function $updateLinks(exceededMaximumConnections) {
        var _this$state2 = this.state(),
          linkEntries = _this$state2.linkEntries;
        var linkTable = this.$getLinkTable(),
          model = linkTable && linkTable.value();
        if (model) {
          if (exceededMaximumConnections) {
            showFailureDialog(LON_LEX.get({
              key: 'lonlink.maxConnections.error',
              args: [MAX_CONNECTIONS]
            }));
          }
          return Promise.all([this.$getHideProxyLinksOptionEd().read(), this.$getHideNetLinksOptionEd().read()]).then(function (_ref4) {
            var _ref5 = _slicedToArray(_ref4, 2),
              hideProxyLinks = _ref5[0],
              hideNetLinks = _ref5[1];
            return model.clearRows().then(function () {
              return Promise.all(linkEntries.map(function (linkEntry) {
                var isProxy = isProxyEntry(linkEntry);
                if (!hideProxyLinks && isProxy || !hideNetLinks && !isProxy) {
                  return model.insertRows([linkEntry]);
                }
              }));
            });
          });
        }
      }

      /**
       * @private
       * @param {baja.Component} tagLinkEntryTable 
       * @returns {Promise}
       */
    }, {
      key: "$updateTagLinks",
      value: function $updateTagLinks(tagLinkEntryTable) {
        var tagLinkEntries = tagLinkEntryTable.getSlots().properties().is('lonworks:TagLinkEntry').toValueArray();
        var tagLinkTable = this.$getTagLinkTable(),
          model = tagLinkTable && tagLinkTable.value();
        if (model) {
          return model.clearRows().then(function () {
            return model.insertRows(tagLinkEntries);
          });
        }
        return Promise.resolve();
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButtonGroup} 
       */
    }, {
      key: "$setUpCommands",
      value: function $setUpCommands() {
        var netmgmt = this.getLonNetmgmt();
        var commandGroup = this.$lonLinkCommandGroup;
        var bindCmd = commandGroup.findCommand(BindCommand);
        bindCmd.setEnabled(netmgmt.getEnabled());
        return commandGroup;
      }

      /**
       * @private
       */
    }, {
      key: "$updateCommandStatus",
      value: function $updateCommandStatus() {
        var _this$state3 = this.state(),
          visibleLinkTable = _this$state3.visibleLinkTable;
        var tableInFocus;
        if (visibleLinkTable === 'linkTable') {
          tableInFocus = this.$getLinkTable();
        } else {
          tableInFocus = this.$getTagLinkTable();
        }
        var netEnabled = this.getLonNetmgmt().getEnabled();
        var selectedRows = tableInFocus.getSelectedRows();
        var bindCmd = this.$getBindCommand(),
          selectiveBindCmd = this.$getSelectiveBindCommand(),
          setServiceTypeCmd = this.$getSetServiceTypeCommand();
        bindCmd.setEnabled(!(selectedRows.length > 0) && netEnabled);
        selectiveBindCmd.setEnabled(selectedRows.length > 0 && netEnabled);
        if (visibleLinkTable === 'linkTable') {
          setServiceTypeCmd.setEnabled(selectedRows.length > 0 && netEnabled);
        } else {
          setServiceTypeCmd.setEnabled(false);
        }
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/table/Table} table
       */
    }, {
      key: "$linkTableEventHandler",
      value: function $linkTableEventHandler(table) {
        this.$updateCommandStatus();
        var selectedRows = table.getSelectedRows(),
          selection = table.$getSelection(),
          model = table.getModel();
        var emitChanged = false;
        selectedRows.forEach(function (selectedRow) {
          var selectedLinkEntry = selectedRow.getSubject();
          model.getRows().forEach(function (row, i) {
            if (selection.isSelected(i)) {
              return;
            }
            var linkEntry = row.getSubject();
            if (selectedLinkEntry.getSelector() === linkEntry.getSelector() || selectedLinkEntry.getHubDevice() === linkEntry.getHubDevice() && selectedLinkEntry.getHubNv() === linkEntry.getHubNv()) {
              selection.put(i, true);
              emitChanged = true;
            }
          });
        });
        if (emitChanged) {
          selection.emit('changed');
        }
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/table/Table} table
       * @return {Promise} 
       */
    }, {
      key: "$tagLinkTableEventHandler",
      value: function $tagLinkTableEventHandler(table) {
        this.$updateCommandStatus();
        var selectedRows = table.getSelectedRows(),
          selection = table.$getSelection(),
          model = table.getModel();
        var emitChanged = false;
        selectedRows.forEach(function (selectedRow) {
          var selectedLinkEntry = selectedRow.getSubject();
          model.getRows().forEach(function (row, i) {
            if (selection.isSelected(i)) {
              return;
            }
            var tagLinkEntry = row.getSubject();
            if (selectedLinkEntry.getOutputDevice() === tagLinkEntry.getOutputDevice() && selectedLinkEntry.getOutputTag() === tagLinkEntry.getOutputTag()) {
              selection.put(i, true);
              emitChanged = true;
            }
          });
        });
        if (emitChanged) {
          selection.emit('changed');
        }
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doSetServiceType",
      value: function $doSetServiceType() {
        var _this6 = this;
        return feDialogs.showFor({
          title: LON_LEX.get('lonlink.serviceTypeText'),
          type: SelectServiceTypeEditor,
          value: ""
        }).then(function (readVal) {
          if (readVal) {
            var selected = readVal.selected,
              priority = readVal.priority;
            var checkCritical = function checkCritical() {
              var selectedRows = _this6.$getLinkTable().getSelectedRows();
              var currSel = -1,
                selCount = 0;
              for (var i = 0; i < selectedRows.length; i++) {
                var linkEntry = selectedRows[i].getSubject();
                if (isProxyEntry(linkEntry)) {
                  continue;
                }
                var _selector = linkEntry.getSelector();
                if (_selector !== currSel) {
                  selCount = 0;
                  currSel = _selector;
                } else {
                  selCount++;
                  if (selCount > MAX_CRITICAL_TARGETS) {
                    return true;
                  }
                }
              }
              return false;
            };
            if (selected === baja.$('lonworks:LonLinkType').get('critical') && checkCritical()) {
              throw new Error(LON_LEX.get('lonlink.setServiceType.critical.error'));
            }
            var selector = _this6.$getSelectors();
            var param = baja.$('lonworks:SetServiceTypeParameter', {
              selector: selector,
              linkType: selected,
              priority: priority
            });
            return _this6.getLonNetmgmt().invoke({
              slot: 'setServiceType',
              value: param
            }).then(function (jobOrd) {
              return jobOrd.resolve({
                base: _this6.value()
              });
            }).then(function (jobTarget) {
              return _this6.$getJobBar().load(jobTarget.getComponent());
            });
          }
        });
      }
    }]);
  }(spandrel(function (lonNetwork, _ref6) {
    var self = _ref6.self,
      visibleLinkTable = _ref6.visibleLinkTable,
      hideProxyLinks = _ref6.hideProxyLinks,
      hideNetLinks = _ref6.hideNetLinks;
    function hideIfNot(linkTable) {
      return {
        display: linkTable !== visibleLinkTable && 'none'
      };
    }
    return spandrel.jsx("div", {
      spandrelKey: "container",
      className: "-t-UxLonLinkManager-Container"
    }, spandrel.jsx(JobBar, {
      spandrelKey: "jobBar"
    }), spandrel.jsx(CommandButtonGroup, {
      value: self.$tabSwitchCommands,
      spandrelKey: "tabSwitcher",
      className: "-t-UxLonLinkManager-tabSwitcher ux-toggle-btn-group"
    }), spandrel.jsx("div", {
      spandrelKey: "tabs",
      className: "-t-UxLonLinkManager-tabContainer ux-select-none"
    }, spandrel.jsx(LinkTable, {
      spandrelKey: "linkTable",
      style: hideIfNot("linkTable"),
      on: _defineProperty({}, ROW_SELECTION_CHANGED_EVENT, function (e, table) {
        self.$linkTableEventHandler(table);
      })
    }), spandrel.jsx(TagLinkTable, {
      spandrelKey: "tagLinkTable",
      style: hideIfNot("tagLinkTable"),
      on: _defineProperty({}, ROW_SELECTION_CHANGED_EVENT, function (e, table) {
        self.$tagLinkTableEventHandler(table);
      })
    })), spandrel.jsx("div", {
      spandrelKey: "footer",
      className: "-t-UxLonLinkManager-footer"
    }, spandrel.jsx("div", {
      spandrelKey: "options",
      style: hideIfNot("linkTable"),
      className: "-t-UxLonLinkManager-options"
    }, spandrel.jsx("any", {
      value: hideProxyLinks,
      bindKey: "hideProxyLinks",
      lax: true,
      properties: {
        displayType: 'checkbox',
        trueText: LON_LEX.get('lonlink.proxyLinkFilter.displayName'),
        falseText: LON_LEX.get('lonlink.proxyLinkFilter.displayName')
      },
      onUxModify: function onUxModify() {
        return self.$doUpdateLinks()["finally"](function () {
          return self.setModified(false);
        });
      }
    }), spandrel.jsx("any", {
      value: hideNetLinks,
      bindKey: "hideNetLinks",
      lax: true,
      properties: {
        displayType: 'checkbox',
        trueText: LON_LEX.get('lonlink.netLinkFilter.displayName'),
        falseText: LON_LEX.get('lonlink.netLinkFilter.displayName')
      },
      onUxModify: function onUxModify() {
        return self.$doUpdateLinks()["finally"](function () {
          return self.setModified(false);
        });
      }
    })), spandrel.jsx(CommandButtonGroup, {
      spandrelKey: "commands",
      value: self.$setUpCommands()
    })));
  }, {
    strategy: 'niagara'
  }));
  function showFailureDialog(cause) {
    dialogs.showOk({
      title: bajauxLex.get("errorDetails.title"),
      content: function content(dlg) {
        dlg.content().text(cause);
      }
    });
  }
});

/**
 * Each Lon Link Manager tab displays a table of Link Entries
 *
 * @interface module:nmodule/lonworks/rc/wb/lonlink/LonLinkManagerTab
 * @extends module:bajaux/Widget
 */
