function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/lonworks/rc/util/AppDownloadWidget
 */

define(['baja!', 'lex!lonworks', 'bajaux/spandrel', 'nmodule/webEditors/rc/fe/ValueWithPopoutWidget'], function (baja, lexs, spandrel, ValueWithPopoutWidget) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    LON_WORKS_LEX = _lexs[0];
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: "-t-AppDownloadWidget"
      }
    };
  };
  var APP_FILE_LABEL = LON_WORKS_LEX.get("appDownLoad.appFile");
  var XIF_FILE_LABEL = LON_WORKS_LEX.get("appDownLoad.xifFile");
  var LNML_FILE_LABEL = LON_WORKS_LEX.get("appDownLoad.lnmlFile");
  var USE_ZERO_BASE_LABEL = LON_WORKS_LEX.get("lonXmlCreate.zeroBased");
  var BIND_LINKS_LABEL = LON_WORKS_LEX.get("appDownLoad.bind");

  /**
   * Widget to gather the AppDownload parameters
   *
   * @class
   * @alias module:nmodule/lonworks/rc/util/AppDownloadWidget
   * @extends module:bajaux/Widget
   * @since Niagara 4.14
  */
  var AppDownloadWidget = /*#__PURE__*/function (_spandrel) {
    function AppDownloadWidget(params) {
      var _this;
      _classCallCheck(this, AppDownloadWidget);
      _this = _callSuper(this, AppDownloadWidget, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.validators().add(function () {
        var _this$state = _this.state(),
          appFileOrd = _this$state.appFileOrd;
        if (appFileOrd.isNull()) {
          throw new Error(LON_WORKS_LEX.get('appDownLoad.validationError'));
        }
      });
      return _this;
    }

    /**
     * build the editor
     * @private
     * @param {Object} state The current state of the editor
     * @returns {module:bajaux/spandrel~SpandrelData}
     */
    _inherits(AppDownloadWidget, _spandrel);
    return _createClass(AppDownloadWidget, [{
      key: "$buildEditor",
      value: function $buildEditor(state) {
        var _this2 = this;
        var bindLinks = state.bindLinks,
          appFileOrd = state.appFileOrd,
          lnmlFileOrd = state.lnmlFileOrd,
          useZero = state.useZero,
          xifFileOrd = state.xifFileOrd;
        return [spandrel.jsx("div", {
          spandrelKey: "appDownloadWidget"
        }, spandrel.jsx("table", null, spandrel.jsx("tr", null, spandrel.jsx("td", {
          className: "-t-app-file-label",
          spandrelKey: "appFileLabel"
        }, APP_FILE_LABEL), spandrel.jsx("td", null, spandrel.jsx(ValueWithPopoutWidget, {
          lax: true,
          value: appFileOrd,
          bindKey: "appFileOrd",
          formFactor: "mini",
          spandrelKey: "appFileOrd",
          properties: {
            displayFilter: function displayFilter(parent, child) {
              return _this2.$displayFilter("nxe", parent, child);
            },
            selectFilter: function selectFilter(selected) {
              return _this2.$selectFilter('nxe', selected);
            }
          }
        }))), spandrel.jsx("tr", null, spandrel.jsx("td", {
          className: "-t-xif-file-label",
          spandrelKey: "xifFileLabel"
        }, XIF_FILE_LABEL), spandrel.jsx("td", null, spandrel.jsx(ValueWithPopoutWidget, {
          lax: true,
          value: xifFileOrd,
          bindKey: "xifFileOrd",
          formFactor: "mini",
          spandrelKey: "xifFileOrd",
          enabled: lnmlFileOrd.isNull(),
          properties: {
            displayFilter: function displayFilter(parent, child) {
              return _this2.$displayFilter("xif", parent, child);
            },
            selectFilter: function selectFilter(selected) {
              return _this2.$selectFilter('xif', selected);
            }
          }
        }))), spandrel.jsx("tr", null, spandrel.jsx("td", {
          className: "-t-use-zero-label",
          spandrelKey: "useZeroLabel"
        }, USE_ZERO_BASE_LABEL), spandrel.jsx("td", null, spandrel.jsx("any", {
          value: useZero,
          bindKey: "useZero",
          spandrelKey: "useZero",
          enabled: !xifFileOrd.isNull(),
          properties: {
            displayType: "checkbox",
            trueText: "",
            falseText: ""
          }
        }))), spandrel.jsx("tr", null, spandrel.jsx("td", {
          className: "-t-lnml-file-label",
          spandrelKey: "lnmlFileLabel"
        }, LNML_FILE_LABEL), spandrel.jsx("td", null, spandrel.jsx(ValueWithPopoutWidget, {
          lax: true,
          value: lnmlFileOrd,
          bindKey: "lnmlFileOrd",
          formFactor: "mini",
          spandrelKey: "lnmlFileOrd",
          enabled: xifFileOrd.isNull(),
          properties: {
            displayFilter: function displayFilter(parent, child) {
              return _this2.$displayFilter("lnml", parent, child);
            },
            selectFilter: function selectFilter(selected) {
              return _this2.$selectFilter('lnml', selected);
            }
          }
        }))), spandrel.jsx("tr", null, spandrel.jsx("td", {
          className: "-t-bind-links-label",
          spandrelKey: "bindLinksLabel"
        }, BIND_LINKS_LABEL), spandrel.jsx("td", null, spandrel.jsx("any", {
          value: bindLinks,
          bindKey: "bindLinks",
          spandrelKey: "bindLinks",
          properties: {
            displayType: "checkbox",
            trueText: "",
            falseText: ""
          }
        })))))];
      }

      /**
       * converts the value to the state for the editor
       * @param {object} value the current value of object
       * @returns {object}
       */
    }, {
      key: "toState",
      value: function toState(value) {
        var appFileOrd = value.appFileOrd,
          bindLinks = value.bindLinks,
          lnmlFileOrd = value.lnmlFileOrd,
          useZero = value.useZero,
          xifFileOrd = value.xifFileOrd;
        return {
          appFileOrd: appFileOrd,
          xifFileOrd: xifFileOrd,
          lnmlFileOrd: lnmlFileOrd,
          useZero: useZero,
          bindLinks: bindLinks
        };
      }

      /**
       * converts the state of the editor to the return value
       * @param {object} state the current state of the object
       * @returns {object}
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        var appFileOrd = state.appFileOrd,
          bindLinks = state.bindLinks,
          lnmlFileOrd = state.lnmlFileOrd,
          useZero = state.useZero,
          xifFileOrd = state.xifFileOrd;
        return {
          appFileOrd: appFileOrd,
          bindLinks: bindLinks,
          lnmlFileOrd: lnmlFileOrd,
          useZero: useZero,
          xifFileOrd: xifFileOrd
        };
      }

      /**
       * Filters the entries to be displayed
       * @private
       * @param {String} extn the extension to be displayed
       * @param {module:nmodule/webEditors/rc/wb/tree/TreeNode} parent the parent tree node
       * @param {module:nmodule/webEditors/rc/wb/tree/TreeNode} child the child tree node
       * @returns {boolean}
       */
    }, {
      key: "$displayFilter",
      value: function $displayFilter(extn, parent, child) {
        var typeArray = ['baja:FileSystem', 'baja:Directory', 'baja:ModuleSpace', 'baja:ModuleNavNode'];
        var childValue = child.value();
        var regEx = new RegExp('\\.(' + extn + ')$', 'i');
        if (childValue) {
          var navTypeSpec = childValue.getNavTypeSpec();
          return !!(typeArray.includes(navTypeSpec) || child.value().getNavName().match(regEx));
        } else {
          return true;
        }
      }

      /**
       * Returns true if the selected item can be selected by the user
       * @private
       * @param {String} extn the extension to be selected
       * @param {baja.Ord} selected the ord of the selected item
       */
    }, {
      key: "$selectFilter",
      value: function $selectFilter(extn, selected) {
        var regEx = new RegExp('\\.(' + extn + ')$', 'i');
        if (!selected.toString().match(regEx)) {
          throw new Error(LON_WORKS_LEX.get('appDownLoad.selectionError', extn));
        }
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getAppFileLabel",
      value: function $getAppFileLabel() {
        return this.jq().find('.-t-app-file-label');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getAppFileOrd",
      value: function $getAppFileOrd() {
        return this.queryWidget('appDownloadWidget/**/appFileOrd');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getXifFileLabel",
      value: function $getXifFileLabel() {
        return this.jq().find('.-t-xif-file-label');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getXifFileOrd",
      value: function $getXifFileOrd() {
        return this.queryWidget('appDownloadWidget/**/xifFileOrd');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getUseZeroLabel",
      value: function $getUseZeroLabel() {
        return this.jq().find('.-t-use-zero-label');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getUseZero",
      value: function $getUseZero() {
        return this.queryWidget('appDownloadWidget/**/useZero');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getLnmlFileLabel",
      value: function $getLnmlFileLabel() {
        return this.jq().find('.-t-lnml-file-label');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getLnmlFileOrd",
      value: function $getLnmlFileOrd() {
        return this.queryWidget('appDownloadWidget/**/lnmlFileOrd');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getBindLinksLabel",
      value: function $getBindLinksLabel() {
        return this.jq().find('.-t-bind-links-label');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getBindLinks",
      value: function $getBindLinks() {
        return this.queryWidget('appDownloadWidget/**/bindLinks');
      }
    }]);
  }(spandrel(function (value, state) {
    var self = state.self;
    return self.$buildEditor(state);
  }, {
    strategy: 'niagara'
  }));
  return AppDownloadWidget;
});
