function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @since Niagara 4.14
 * @module nmodule/lonworks/rc/menu/lonDeviceComponentMenuAgent
 */
define(['baja!', 'baja!lonworks:ImportParameters,lonworks:LocalImportXmlParameter,lonworks:LocalExtractXifParameter', 'lex!lonworks', 'jquery', 'bajaux/commands/Command', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/servlets/userData', 'nmodule/webEditors/rc/util/fileUtils', 'nmodule/webEditors/rc/wb/menu/Separator', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/webEditors/rc/wb/menu/componentMenuAgent'], function (baja, types, lexs, $, Command, feDialogs, compUtils, userData, fileUtils, Separator, PropertySheet, componentMenuAgent) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    lonLex = _lexs[0];
  var _types = _slicedToArray(types, 3),
    DYNAMIC_IMPORT_PARAMETERS = _types[0],
    LOCAL_IMPORT_PARAMETERS = _types[1],
    EXTRACT_XIF_PARAMETERS = _types[2];

  /**
   * @param {baja.Struct} importParameters
   * @param {baja.Component} device
   * @returns {Promise}
   */
  var showImportXmlDialog = function showImportXmlDialog(importParameters, device) {
    return feDialogs.showFor({
      title: lonLex.get('dynamicDevice.importXml.title'),
      value: importParameters,
      properties: {
        ordBase: device,
        readBehavior: 'copy'
      },
      type: PropertySheet,
      dom: $('<div/>')
    });
  };

  /**
   * @since Niagara 4.14
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   */
  var ImportXmlCommand = /*#__PURE__*/function (_Command) {
    function ImportXmlCommand(device) {
      _classCallCheck(this, ImportXmlCommand);
      return _callSuper(this, ImportXmlCommand, [{
        module: 'lonworks',
        lex: 'dynamicDevice.importXml',
        func: function func() {
          var importParameters;
          var localDevice = baja.hasType(device, "lonworks:LocalLonDevice");
          if (localDevice) {
            importParameters = baja.$(LOCAL_IMPORT_PARAMETERS);
          } else {
            var xmlFile = device.getXmlFile();
            importParameters = baja.$(DYNAMIC_IMPORT_PARAMETERS, {
              xmlFile: xmlFile
            });
          }
          return showImportXmlDialog(importParameters, device).then(function (importParameters) {
            if (importParameters) {
              if (localDevice) {
                return device.importXml(importParameters);
              } else {
                return device.setXmlFile(importParameters.getXmlFile()).then(function () {
                  return device.importXml(importParameters);
                });
              }
            }
          });
        }
      }]);
    }
    _inherits(ImportXmlCommand, _Command);
    return _createClass(ImportXmlCommand);
  }(Command);
  /**
   * @param {baja.Struct} extractXifParameters
   * @param {baja.Component} device
   * @returns {Promise}
   */
  var showExtractXifDialog = function showExtractXifDialog(extractXifParameters, device) {
    return feDialogs.showFor({
      title: lonLex.get('localDevice.extractXif.title'),
      value: extractXifParameters,
      properties: {
        ordBase: device,
        readBehavior: 'copy'
      },
      type: PropertySheet,
      dom: $('<div/>')
    });
  };

  /**
   * @since Niagara 4.14
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   */
  var ExtractXifCommand = /*#__PURE__*/function (_Command2) {
    function ExtractXifCommand(device) {
      _classCallCheck(this, ExtractXifCommand);
      return _callSuper(this, ExtractXifCommand, [{
        module: 'lonworks',
        lex: 'localDevice.extractXif',
        func: function func() {
          return userData.get('lonworks.xifFileName').then(function (prevFileName) {
            var fileName = prevFileName || 'local.xif';
            var extractParameter = baja.$(EXTRACT_XIF_PARAMETERS, {
              fileName: fileName
            });
            return showExtractXifDialog(extractParameter, device);
          }).then(function (extractParameters) {
            if (extractParameters) {
              var fileName = extractParameters.getFileName();
              return device.extractXif(extractParameters).then(function (contents) {
                return fileUtils.download(contents, fileName, 'application/text');
              }).then(function () {
                userData.put('lonworks.xifFileName', fileName);
              });
            }
          });
        }
      }]);
    }
    _inherits(ExtractXifCommand, _Command2);
    return _createClass(ExtractXifCommand);
  }(Command);
  var addLocalLonCommands = function addLocalLonCommands(cmdGrp, device) {
    var kids = cmdGrp.getChildren();
    var newGroup = kids.findIndex(function (entry) {
      return entry.getDisplayNameFormat() === '%lexicon(webEditors:menu.new.label)%';
    });
    kids.splice(newGroup + 1, 0, new Separator(), new ImportXmlCommand(device), new ExtractXifCommand(device));
    cmdGrp.setChildren(kids);
    return cmdGrp;
  };
  return function (navTree, device) {
    return componentMenuAgent(navTree, device).then(function (cmdGrp) {
      if (baja.hasType(device, "lonworks:DynamicDevice")) {
        var importXmlCommand = new ImportXmlCommand(device);
        cmdGrp.add(importXmlCommand);
      }
      if (baja.hasType(device, "lonworks:LocalLonDevice")) {
        cmdGrp = addLocalLonCommands(cmdGrp, device);
      }
      return cmdGrp;
    });
  };
});
