function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/wb/cert/util/DN
 */
define([], function () {
  'use strict';

  var COMMA_PLACEHOLDER = 'ʕ •ᴥ•ʔ <(comma)';
  var EQUALS_PLACEHOLDER = '(equals)> ʕ •`ᴥ•´ʔ';
  var REQUIRES_ESCAPE = /[,\\#+<>;"=]/g; //https://ldapwiki.com/wiki/DN%20Escape%20Values

  /**
   * Class representing a Distinguished Name.
   *
   * @class
   * @alias module:nmodule/platCrypto/rc/wb/cert/util/DN
   */
  return /*#__PURE__*/function () {
    function DN(tuples) {
      _classCallCheck(this, DN);
      this.$tuples = tuples;
    }

    /**
     * @param {string} string the string encoding of a DN
     * @returns {module:nmodule/platCrypto/rc/wb/cert/util/DN}
     */
    return _createClass(DN, [{
      key: "toString",
      value:
      /**
       * @returns {string} the string encoding of the DN
       */
      function toString() {
        return this.$tuples.map(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            key = _ref2[0],
            value = _ref2[1];
          return "".concat(escape(key), "=").concat(escape(value));
        }).join(', ');
      }

      /**
       * @returns {Array.<Array.<string>>} the key/value tuples in this DN
       */
    }, {
      key: "getTuples",
      value: function getTuples() {
        return this.$tuples.slice();
      }

      /**
       * @param {string} type
       * @returns {Array.<string>} all values matching that type
       */
    }, {
      key: "getValues",
      value: function getValues(type) {
        return this.$tuples.filter(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 1),
            t = _ref4[0];
          return t === type;
        }).map(function (_ref5) {
          var _ref6 = _slicedToArray(_ref5, 2),
            value = _ref6[1];
          return value;
        });
      }
    }], [{
      key: "parse",
      value: function parse(string) {
        var tuples = split(string).map(function (rdn) {
          var _rdn$split$map = rdn.split('=').map(function (s) {
              return rdnUnsafe(s).trim();
            }),
            _rdn$split$map2 = _slicedToArray(_rdn$split$map, 2),
            key = _rdn$split$map2[0],
            value = _rdn$split$map2[1];
          return [unescape(key), unescape(value)];
        });
        return new DN(tuples);
      }
    }]);
  }();

  /**
   * @param {string} dn
   * @returns {Array.<string>} the tuples encoded in the DN, split out into individual strings but
   * not yet into key/value tuples
   */
  function split(dn) {
    var rdns = [];
    var key;
    var quoted;
    var chars = [];
    function finishRdn(value) {
      if (key) {
        rdns.push(rdnSafe(key) + '=' + rdnSafe(value));
      }
      key = '';
      chars = [];
      quoted = false;
    }
    function eat() {
      var str = chars.join('');
      chars = [];
      return str;
    }
    _toConsumableArray(dn).forEach(function (c, i) {
      var escaped = dn[i - 1] === '\\';
      if (escaped) {
        return chars.push(c);
      }
      if (c === '\\') {
        return;
      }
      if (c === '"') {
        if (!key) {
          throw new Error('cannot wrap key in quotes');
        }
        quoted = !quoted;
      } else if (c === '=' && !quoted) {
        key = eat();
        if (!key) {
          throw new Error('key required');
        }
      } else if (c === ',' && !quoted) {
        finishRdn(eat());
      } else {
        chars.push(c);
      }
    });
    finishRdn(eat());
    return rdns;
  }
  function escape(str) {
    return str.replaceAll(REQUIRES_ESCAPE, function (match) {
      return '\\' + match;
    });
  }
  function rdnSafe(str) {
    return str.replaceAll(/,/g, COMMA_PLACEHOLDER).replaceAll(/=/g, EQUALS_PLACEHOLDER);
  }
  function rdnUnsafe(str) {
    return str.replaceAll(COMMA_PLACEHOLDER, ',').replaceAll(EQUALS_PLACEHOLDER, '=');
  }
  function unescape(str) {
    return str.replaceAll(/\\(.)/g, function (match, ch) {
      return ch;
    });
  }
});
