function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/wb/cert/commands/CertExportWidget
 */
define(['baja!', 'baja!baja:PasswordStrength', 'Promise', 'lex!platCrypto', 'bajaux/spandrel', 'underscore', 'nmodule/platCrypto/rc/rpc/certManagement', 'nmodule/platCrypto/rc/wb/cert/CertDetailsTabs', 'nmodule/platCrypto/rc/wb/cert/CertHeader', 'nmodule/webEditors/rc/fe/baja/ConfirmPasswordEditor', 'nmodule/webEditors/rc/fe/baja/IconEditor', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/fe/baja/PasswordEditor', 'css!nmodule/platCrypto/rc/platCrypto'], function (baja, types, Promise, lexs, spandrel, _, certManagement, CertDetailsTabs, CertHeader, ConfirmPasswordEditor, IconEditor, OrderedMapEditor, PasswordEditor) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];
  var FORMAT_LABEL = platCryptoLex.get('cert.export.cert.certFormat');
  var EXPORT_PUBLIC_LABEL = platCryptoLex.get('cert.export.cert.exportcert');
  var EXPORT_PRIVATE_LABEL = platCryptoLex.get('cert.export.cert.exportprivatekey');
  var ENCRYPT_PRIVATE_LABEL = platCryptoLex.get('cert.export.encryptprivatekey');
  var FILENAME_LABEL = platCryptoLex.get('cert.export.cert.fileName');
  var DECRYPT_PASSWORD_LABEL = platCryptoLex.get('cert.export.cert.decryptPassword');
  var REUSE_PASSWORD_LABEL = platCryptoLex.get('cert.export.cert.reusePassword');
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-CertExportWidget'
      }
    };
  };
  var errorMsg = "";
  var once = _.once;
  var certFormats = [];
  var formatList = new baja.OrderedMap();
  var defaultFormat;
  var loadFormats = once(function () {
    return certManagement.getSupportedExportFormats().then(function (formats) {
      defaultFormat = formats.defaultExportFormat;
      formats.supportedExportFormats.forEach(function (entry) {
        var exportFormatName = entry.exportFormatName;
        certFormats[exportFormatName] = entry;
        formatList.put(exportFormatName, exportFormatName);
      });
    });
  });

  /**
   * The widget for the `CertExportCommand`.
   *
   * @class
   * @extends module:bajaux/Widget
   * @alias module:nmodule/platCrypto/rc/wb/cert/CertExportWidget
   */
  var CertExportWidget = /*#__PURE__*/function (_spandrel) {
    function CertExportWidget(params) {
      var _this;
      _classCallCheck(this, CertExportWidget);
      _this = _callSuper(this, CertExportWidget, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.validators().add(function () {
        var _this$state = _this.state(),
          exportPublic = _this$state.exportPublic,
          exportPrivate = _this$state.exportPrivate,
          encryptPrivate = _this$state.encryptPrivate,
          encryptPassword = _this$state.encryptPassword,
          reusePassword = _this$state.reusePassword;
        errorMsg = "";
        _this.$getPasswordErr().empty();
        if (!(exportPublic || exportPrivate)) {
          throw new Error();
        }
        if (exportPrivate && encryptPrivate && !reusePassword) {
          return _this.$getConfirmPassword().validate().then(function () {
            return _this.$validatePassword(encryptPassword.encodeToString());
          })["catch"](function (error) {
            errorMsg = error.message;
            errorMsg = _.escape(errorMsg);
            errorMsg = errorMsg.replace(/\n/g, '<br>');
            _this.$getPasswordErr().append(errorMsg);
            throw error;
          });
        }
      });
      return _this;
    }

    /**
     * @private
     * @param {String} password the password to be validated
     * @returns {Promise.<Boolean>} true if the password is valid, false if it is not.
     */
    _inherits(CertExportWidget, _spandrel);
    return _createClass(CertExportWidget, [{
      key: "$validatePassword",
      value: function $validatePassword(password) {
        return certManagement.passwordStrength().then(function (passwordStrength) {
          return passwordStrength.validatePassword(password);
        });
      }

      /**
       * @private
       * @param {string} format
       * @param {string} fileName
       * @returns {string}
       */
    }, {
      key: "$buildFileName",
      value: function $buildFileName(format, fileName) {
        var formatExt = certFormats[format].defaultFileExtension;
        if (!fileName) {
          var cert = this.state().cert;
          fileName = cert.alias;
        }
        var idx = fileName.lastIndexOf(".");
        idx = idx < 0 ? fileName.length : idx;
        fileName = fileName.substr(0, idx) + "." + formatExt;
        return fileName;
      }

      /**
       * @private
       * @param {string} format
       * @returns {Promise}
       */
    }, {
      key: "$applyFormat",
      value: function $applyFormat(format) {
        var fileName = this.state().fileName;
        fileName = this.$buildFileName(format, fileName);
        return this.state({
          fileName: fileName
        });
      }

      /**
       * @param {module:nmodule/platCrypto/rc/wb/cert/CertExportWidget~CertExportRequest} exportRequest the export request the user is editing
       * @returns {module:nmodule/platCrypto/rc/wb/cert/CertExportWidget~CertExportWidgetState} the widget state derived from this export request
       */
    }, {
      key: "toState",
      value: function toState(exportRequest) {
        var _this2 = this;
        return loadFormats().then(function () {
          var hidePassword = !!_this2.$shouldHidePassword();
          var cert = exportRequest.cert,
            exportPublic = exportRequest.exportPublic,
            exportPrivate = exportRequest.exportPrivate,
            encryptPrivate = exportRequest.encryptPrivate,
            encryptPassword = exportRequest.encryptPassword,
            decryptPassword = exportRequest.decryptPassword,
            decryptPasswordReqd = exportRequest.decryptPasswordReqd,
            reusePassword = exportRequest.reusePassword;
          var formatData = certFormats[defaultFormat];
          var formatExt = formatData.defaultFileExtension;
          var fileName = cert.alias + "." + formatExt;
          return {
            cert: cert,
            format: defaultFormat,
            exportPublic: exportPublic || hidePassword,
            exportPrivate: exportPrivate,
            encryptPrivate: encryptPrivate,
            encryptPassword: encryptPassword,
            decryptPassword: decryptPassword,
            decryptPasswordReqd: decryptPasswordReqd,
            fileName: fileName,
            reusePassword: reusePassword && decryptPasswordReqd
          };
        });
      }

      /**
       * @param {module:nmodule/platCrypto/rc/wb/cert/CertExportWidget~CertExportWidgetState} state
       * @returns {module:nmodule/platCrypto/rc/wb/cert/CertExportWidget~CertExportRequest}
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        var cert = state.cert,
          format = state.format,
          exportPublic = state.exportPublic,
          exportPrivate = state.exportPrivate,
          encryptPrivate = state.encryptPrivate,
          encryptPassword = state.encryptPassword,
          decryptPassword = state.decryptPassword,
          decryptPasswordReqd = state.decryptPasswordReqd,
          reusePassword = state.reusePassword;
        var fileName = state.fileName;
        if (!fileName) {
          fileName = this.$buildFileName(format, fileName);
        }
        var formatData = certFormats[format];
        var mimeType = formatData.mimeType;
        return {
          cert: cert,
          alias: cert.alias,
          exportFormat: format,
          exportCert: exportPublic,
          exportPrivateKey: exportPrivate,
          encryptPrivateKey: encryptPrivate && exportPrivate,
          encryptPassword: encryptPrivate ? encryptPassword : baja.$('baja:Password'),
          decryptPassword: decryptPassword,
          decryptPasswordReqd: decryptPasswordReqd,
          fileName: fileName,
          mimeType: mimeType,
          reusePassword: reusePassword && decryptPasswordReqd
        };
      }

      /**
       * @private
       * @param {module:nmodule/platCrypto/rc/wb/cert/CertExportWidget~CertExportWidgetState} state
       * @returns {Array}
       */
    }, {
      key: "$buildEditor",
      value: function $buildEditor(state) {
        var cert = state.cert,
          format = state.format,
          exportPublic = state.exportPublic,
          exportPrivate = state.exportPrivate,
          encryptPrivate = state.encryptPrivate,
          encryptPassword = state.encryptPassword,
          decryptPassword = state.decryptPassword,
          decryptPasswordReqd = state.decryptPasswordReqd,
          fileName = state.fileName,
          reusePassword = state.reusePassword,
          self = state.self;
        var subtitle = platCryptoLex.get('cert.export.cert.info', cert.issuedBy);
        var formatEntry = certFormats[format];
        var enablePassword = formatEntry.supportsPrivateKey;
        var hidePassword = !!this.$shouldHidePassword();
        var beforeMainProperties = [{
          value: cert['alias'],
          label: platCryptoLex.get('cert.field.alias')
        }];
        return [spandrel.jsx("div", {
          spandrelKey: "exportCertLayout"
        }, spandrel.jsx(CertHeader, {
          spandrelKey: "certHeader",
          value: cert,
          properties: {
            subtitle: subtitle
          }
        }), spandrel.jsx("div", {
          className: "-t-exportPublicSection",
          spandrelKey: "exportPublic"
        }, spandrel.jsx("table", {
          spandrelKey: "publicTable"
        }, spandrel.jsx("tr", {
          spandrelKey: "row1"
        }, spandrel.jsx("td", {
          spandrelKey: "formatLabel"
        }, FORMAT_LABEL), spandrel.jsx("td", {
          spandrelKey: "formatCell"
        }, spandrel.jsx(OrderedMapEditor, {
          className: "-t-certificateFormat",
          bindKey: "format",
          lax: "true",
          spandrelKey: "formatEditor",
          value: format,
          onUxModifiedValue: function onUxModifiedValue(format) {
            return self.$applyFormat(format);
          },
          properties: {
            map: formatList
          }
        }))), spandrel.jsx("tr", {
          spandrelKey: "row2"
        }, spandrel.jsx("td", {
          colSpan: "2",
          spandrelKey: "exportPublic"
        }, spandrel.jsx("any", {
          className: "-t-exportPublicCheckBox",
          bindKey: "exportPublic",
          lax: "true",
          spandrelKey: "exportPublic",
          value: exportPublic,
          enabled: hidePassword === false,
          properties: {
            displayType: "checkbox",
            trueText: EXPORT_PUBLIC_LABEL,
            falseText: EXPORT_PUBLIC_LABEL
          }
        }))), spandrel.jsx("tr", {
          spandrelKey: "row3"
        }, spandrel.jsx("td", {
          spandrelKey: "fileNameLabel"
        }, FILENAME_LABEL), spandrel.jsx("td", {
          spandrelKey: "fileNameCell"
        }, spandrel.jsx("any", {
          className: "-t-exportPublicFileName",
          bindKey: "fileName",
          lax: "true",
          spandrelKey: "fileNameEditor",
          value: fileName
        }))))), spandrel.jsx("hr", null), spandrel.jsx("div", {
          className: "-t-exportPrivate",
          spandrelKey: "exportPrivate",
          style: {
            display: hidePassword && 'none'
          }
        }, spandrel.jsx(PrivateKeyHeader, {
          spandrelKey: "privateHeader"
        }), spandrel.jsx("table", {
          spandrelKey: "privateTable"
        }, spandrel.jsx("tr", {
          spandrelKey: "row1"
        }, spandrel.jsx("td", {
          spandrelKey: "privateCell"
        }, spandrel.jsx("any", {
          className: "-t-exportPrivateCheckBox",
          bindKey: "exportPrivate",
          lax: "true",
          spandrelKey: "exportPrivate",
          value: exportPrivate,
          enabled: enablePassword,
          properties: {
            displayType: "checkbox",
            trueText: EXPORT_PRIVATE_LABEL,
            falseText: EXPORT_PRIVATE_LABEL
          },
          onUxModifiedValue: function onUxModifiedValue(exportPrivate) {
            return exportPrivate && self.state({
              encryptPrivate: true
            });
          }
        }))), spandrel.jsx("tr", {
          spandrelKey: "row2",
          className: "-t-decryptPasswordRow",
          style: {
            display: !decryptPasswordReqd && 'none'
          }
        }, spandrel.jsx("td", {
          spandrelKey: "decryptPassword"
        }, DECRYPT_PASSWORD_LABEL), spandrel.jsx("td", null, spandrel.jsx(PasswordEditor, {
          className: "-t-decryptPassword",
          bindKey: "decryptPassword",
          lax: "true",
          enabled: exportPrivate && enablePassword,
          spandrelKey: "decryptPasswordEditor",
          value: decryptPassword
        }))), spandrel.jsx("tr", {
          spandrelKey: "row3"
        }, spandrel.jsx("td", {
          spandrelKey: "encryptCell"
        }, spandrel.jsx("any", {
          className: "-t-encryptPrivateCheckBox",
          bindKey: "encryptPrivate",
          lax: "true",
          spandrelKey: "encryptPrivate",
          value: encryptPrivate && exportPrivate && enablePassword,
          enabled: exportPrivate && enablePassword,
          properties: {
            displayType: "checkbox",
            trueText: ENCRYPT_PRIVATE_LABEL,
            falseText: ENCRYPT_PRIVATE_LABEL
          }
        }))), spandrel.jsx("tr", {
          spandrelKey: "row4",
          className: "-t-reusePasswordRow",
          style: {
            display: !decryptPasswordReqd && 'none'
          }
        }, spandrel.jsx("td", {
          colSpan: "2"
        }, spandrel.jsx("any", {
          className: "-t-reusePassword",
          bindKey: "reusePassword",
          lax: "true",
          spandrelKey: "reusePasswordEditor",
          value: reusePassword,
          enabled: exportPrivate && enablePassword && encryptPrivate,
          properties: {
            displayType: "checkbox",
            trueText: REUSE_PASSWORD_LABEL,
            falseText: REUSE_PASSWORD_LABEL
          }
        })))), spandrel.jsx("div", {
          spandrelKey: "confirmPassword"
        }, spandrel.jsx(ConfirmPasswordEditor, {
          className: "-t-confirmPasswordEditor",
          bindKey: "encryptPassword",
          lax: "true",
          spandrelKey: "confirmPasswordEditor",
          enabled: encryptPrivate && exportPrivate && enablePassword && !reusePassword,
          value: encryptPassword
        })), spandrel.jsx("div", {
          className: "-t-CertExportWidget -t-passwordErr"
        }), spandrel.jsx("hr", null)), spandrel.jsx(CertDetailsTabs, {
          value: cert,
          spandrelKey: "detailTabs",
          properties: {
            beforeMainProperties: beforeMainProperties
          }
        }))];
      }

      /**
       * @private
       */
    }, {
      key: "$getCertHeader",
      value: function $getCertHeader() {
        return this.queryWidget('exportCertLayout/certHeader');
      }

      /**
       * @private
       */
    }, {
      key: "$getCertTabs",
      value: function $getCertTabs() {
        return this.queryWidget('exportCertLayout/detailTabs');
      }

      /**
       * @private
       */
    }, {
      key: "$getPrivateKeyHeader",
      value: function $getPrivateKeyHeader() {
        return this.queryWidget('exportCertLayout/exportPrivate/privateHeader');
      }

      /**
       * @private
       */
    }, {
      key: "$getFormatLabel",
      value: function $getFormatLabel() {
        return this.queryWidget('exportCertLayout/exportPublic/publicTable/row1/formatLabel');
      }

      /**
       * @private
       */
    }, {
      key: "$getFormat",
      value: function $getFormat() {
        return this.queryWidget('exportCertLayout/exportPublic/publicTable/row1/formatCell/formatEditor');
      }

      /**
       * @private
       */
    }, {
      key: "$getExportPublic",
      value: function $getExportPublic() {
        return this.queryWidget('exportCertLayout/exportPublic/publicTable/row2/exportPublic/exportPublic');
      }

      /**
       * @private
       */
    }, {
      key: "$getFileNameLabel",
      value: function $getFileNameLabel() {
        return this.queryWidget('exportCertLayout/exportPublic/publicTable/row3/fileNameLabel');
      }

      /**
       * @private
       */
    }, {
      key: "$getFileName",
      value: function $getFileName() {
        return this.queryWidget('exportCertLayout/exportPublic/publicTable/row3/fileNameCell/fileNameEditor');
      }

      /**
       * @private
       */
    }, {
      key: "$getExportKey",
      value: function $getExportKey() {
        return this.queryWidget('exportCertLayout/exportPrivate/privateTable/row1/privateCell/exportPrivate');
      }

      /**
       * @private
       */
    }, {
      key: "$getDecryptPasswordLabel",
      value: function $getDecryptPasswordLabel() {
        return this.queryWidget('exportCertLayout/exportPrivate/privateTable/row2/decryptPassword');
      }

      /**
       * @private
       */
    }, {
      key: "$getDecryptPassword",
      value: function $getDecryptPassword() {
        return this.queryWidget('exportCertLayout/exportPrivate/privateTable/row2/**/decryptPasswordEditor');
      }

      /**
       * @private
       */
    }, {
      key: "$getEncryptKey",
      value: function $getEncryptKey() {
        return this.queryWidget('exportCertLayout/exportPrivate/privateTable/row3/encryptCell/encryptPrivate');
      }

      /**
       * @private
       */
    }, {
      key: "$getReusePassword",
      value: function $getReusePassword() {
        return this.queryWidget('exportCertLayout/exportPrivate/privateTable/row4/**/reusePasswordEditor');
      }

      /**
       * @private
       */
    }, {
      key: "$getConfirmPassword",
      value: function $getConfirmPassword() {
        return this.queryWidget('exportCertLayout/exportPrivate/confirmPassword/confirmPasswordEditor');
      }

      /**
       * @private
       */
    }, {
      key: "$getPasswordErr",
      value: function $getPasswordErr() {
        return this.jq().find('.-t-passwordErr');
      }

      /**
       * @private
       */
    }, {
      key: "$shouldHidePassword",
      value: function $shouldHidePassword() {
        return this.properties().getValue('hidePassword');
      }
    }]);
  }(spandrel(function (value, state) {
    var self = state.self;
    var subtitle = function subtitle(cert) {
      return platCryptoLex.get('cert.export.dialog.info', cert.issuedBy);
    };
    return self.$buildEditor(state, subtitle);
  }, {
    strategy: 'niagara'
  }));
  var PrivateKeyHeader = /*#__PURE__*/function (_spandrel2) {
    function PrivateKeyHeader() {
      _classCallCheck(this, PrivateKeyHeader);
      return _callSuper(this, PrivateKeyHeader, arguments);
    }
    _inherits(PrivateKeyHeader, _spandrel2);
    return _createClass(PrivateKeyHeader);
  }(spandrel(function () {
    var headerIcon = baja.Icon.make(platCryptoLex.get("key.x32.icon", "module://icons/x32/keys.png"));
    var title = platCryptoLex.get("cert.export.dialog.privatekey", "PrivateKey");
    return [spandrel.jsx("div", {
      className: "-t-CertHeader -t-PrivateKey"
    }, spandrel.jsx("div", {
      spandrelKey: "header",
      className: "-t-header"
    }, spandrel.jsx(IconEditor, {
      value: headerIcon,
      spandrelKey: "icon",
      className: "-t-header-icon"
    }), spandrel.jsx("div", {
      className: "-t-header-text"
    }, spandrel.jsx("div", {
      className: "-t-title"
    }, title))))];
  }));
  return CertExportWidget;

  /**
   * An object defining a request to export a certificate from the server.
   *
   * @typedef module:nmodule/platCrypto/rc/wb/cert/CertExportWidget~CertExportRequest
   * @property {object} cert the actual cert data being exported
   * @property {string} alias the alias for the cert that is to be exported
   * @property {string} format what format the user wants to use to export the cert
   * @property {boolean} exportCert whether the user wants to export the public key
   * @property {boolean} exportPrivateKey whether the user wants to export the private key
   * @property {boolean} encryptPrivateKey whether the user wants to encrypt the private key
   * @property {baja.Simple} encryptPassword the password the user will use to encrypt the private key
   * @property {baja.Simple} decryptPassword the password to be used to decrypt the private key
   * @property {boolean} decryptPasswordReqd is a decryptPassword required
   * @property {string} filename the name of the file to be created
   * @property {string} mimeType the mimeType of the resulting file
   * @property {boolean} reusePassword should the decryptPassword be used to encrypt the private key
   */

  /**
   * An object defining what values the user has currently entered within the CertExportWidget.
   *
   * @typedef module:nmodule/platCrypto/rc/wb/cert/CertExportWidget~CertExportWidgetState
   * @property {string} cert the actual cert data being exported
   * @property {string} format the desired format the user has selected
   * @property {boolean} exportPublic whether the user has checked the "export public" checkbox
   * @property {boolean} exportPrivate whether the user has checked the "export private" checkbox
   * @property {boolean} encryptPrivate whether the user has checked the "encrypt private" checkbox
   * @property {baja.Simple} encryptPassword the password the user has typed in for encrypting the private key
   */
});
