function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Nick Dodd
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/fe/SingleExtensionEditor
 */
define(['lex!platCrypto', 'bajaux/spandrel', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'Promise', 'nmodule/platCrypto/rc/CertConstants', 'nmodule/platCrypto/rc/fe/certificateEditorUtils', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/wb/commands/HelpCommand', 'css!nmodule/platCrypto/rc/platCrypto'], function (lexs, spandrel, Command, CommandButton, Promise, CertConstants, certificateEditorUtils, feDialogs, OrderedMapEditor, HelpCommand) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];
  var extensionTypes = certificateEditorUtils.extensionTypes,
    getExtensionWidget = certificateEditorUtils.getExtensionWidget,
    getExtensionHelpKey = certificateEditorUtils.getExtensionHelpKey,
    getExtensionLabel = certificateEditorUtils.getExtensionLabel,
    getDefaultEkuPurpose = certificateEditorUtils.getDefaultEkuPurpose,
    getDefaultKeyUsageFlags = certificateEditorUtils.getDefaultKeyUsageFlags;
  var _CertConstants$EXTENS = CertConstants.EXTENSION_OID,
    SUBJECT_ALTERNATIVE_NAME_OID = _CertConstants$EXTENS.SUBJECT_ALTERNATIVE_NAME_OID,
    KEY_USAGE_OID = _CertConstants$EXTENS.KEY_USAGE_OID,
    EXTENDED_KEY_USAGE_OID = _CertConstants$EXTENS.EXTENDED_KEY_USAGE_OID;

  /**
   * Compact editor for editing a single certificate extension, selecting the type from a drop-down
   * and then editing that extensions specific fields in a popup editor.
   *
   * @class
   * @alias module:nmodule/platCrypto/rc/fe/SingleExtensionEditor
   * @extends module:bajaux/Widget
   */
  var SingleExtensionEditor = /*#__PURE__*/function (_spandrel) {
    function SingleExtensionEditor() {
      var _this;
      _classCallCheck(this, SingleExtensionEditor);
      _this = _callSuper(this, SingleExtensionEditor, arguments);
      _this.$editCmd = new Command({
        module: 'platCrypto',
        lex: 'NewCertForm.extension.commands.edit',
        func: function func() {
          return editExtension(_this);
        }
      });
      _this.$helpCmd = new Command({
        module: 'webEditors',
        lex: 'commands.help',
        func: function func() {
          var _this$state = _this.state(),
            oid = _this$state.oid;
          return new HelpCommand({
            module: 'platCrypto',
            lex: getExtensionHelpKey(oid),
            title: getExtensionLabel(oid)
          }).invoke();
        }
      });
      return _this;
    }

    /**
     * @param {string} extension the loaded extension json string value
     * @returns {object} a state object containing the oid / isCritical / value from the json.
     */
    _inherits(SingleExtensionEditor, _spandrel);
    return _createClass(SingleExtensionEditor, [{
      key: "toState",
      value: function toState(extension) {
        // extract key purpose if possible
        var parent = this.getComplex().getParent();
        return parent.lease().then(function () {
          var keyPurpose = "custom";
          if (parent && parent.getType().is("signingService:AbstractSigningProfile") && parent.getEnforceKeyPurpose()) {
            keyPurpose = parent.getKeyPurpose().getTag();
          }
          var loadedFromJson;
          if (extension !== "") {
            loadedFromJson = JSON.parse(extension);
          }
          var oid = loadedFromJson ? loadedFromJson.oid : SUBJECT_ALTERNATIVE_NAME_OID;
          var isCritical = loadedFromJson ? loadedFromJson.isCritical : false;
          var defaultValue;
          if (!loadedFromJson || !loadedFromJson.value) {
            defaultValue = getDefaultValue(oid, keyPurpose);
          }
          var value = defaultValue || loadedFromJson.value;
          return {
            oid: oid,
            isCritical: isCritical,
            value: value,
            oidThatCreatedValue: oid,
            keyPurpose: keyPurpose,
            defaultValue: defaultValue
          };
        });
      }

      /**
       * @param {object} state
       * @param {string} state.oid
       * @param {boolean} state.isCritical
       * @returns {string} a json string containing the oid / isCritical / value for the extension.
       */
    }, {
      key: "fromState",
      value: function fromState(_ref) {
        var oid = _ref.oid,
          isCritical = _ref.isCritical,
          value = _ref.value,
          defaultValue = _ref.defaultValue;
        oid = oid || SUBJECT_ALTERNATIVE_NAME_OID;
        isCritical = isCritical || false;
        if (defaultValue) {
          return JSON.stringify({
            oid: oid,
            isCritical: isCritical,
            value: null
          });
        }
        return JSON.stringify({
          oid: oid,
          isCritical: isCritical,
          value: value
        });
      }
    }]);
  }(spandrel(function (extension, _ref2) {
    var oid = _ref2.oid,
      isCritical = _ref2.isCritical,
      value = _ref2.value,
      keyPurpose = _ref2.keyPurpose,
      defaultValue = _ref2.defaultValue,
      self = _ref2.self;
    var ExtensionWidget = getExtensionWidget(oid);
    var widgetValue = defaultValue || value;
    var formFactor = 'mini';
    return [spandrel.jsx("tr", null, spandrel.jsx("td", null, spandrel.jsx("label", null, platCryptoLex.get('certificateExtensionParameter.type'))), spandrel.jsx("td", null, spandrel.jsx(OrderedMapEditor, {
      tagName: "span",
      bind: true,
      spandrelKey: "oid",
      value: oid,
      onUxModify: function onUxModify() {
        return updateDefaultValue(self);
      },
      properties: {
        map: getExtensionTypeList()
      }
    })), spandrel.jsx("td", null, spandrel.jsx(CommandButton, {
      className: "-t-HelpCommand",
      spandrelKey: "helpButton",
      tagName: "span",
      value: self.$helpCmd
    }))), spandrel.jsx("tr", null, spandrel.jsx("td", null, spandrel.jsx("label", null, platCryptoLex.get('certificateExtensionParameter.critical'))), spandrel.jsx("td", null, spandrel.jsx("any", {
      bind: true,
      spandrelKey: "isCritical",
      value: isCritical
    }))), spandrel.jsx("tr", null, spandrel.jsx("td", null, spandrel.jsx("label", null, platCryptoLex.get('certificateExtensionParameter.value'))), spandrel.jsx("td", null, spandrel.jsx(ExtensionWidget, {
      bind: true,
      spandrelKey: "value",
      formFactor: formFactor,
      value: widgetValue,
      properties: getIndividualEditProperties(keyPurpose)
    })), spandrel.jsx("td", null, spandrel.jsx(CommandButton, {
      tagName: "button",
      type: "button",
      className: "ux-btn-tb",
      spandrelKey: "editButton",
      value: self.$editCmd
    })))];
  }, {
    strategy: 'niagara'
  }));
  function getIndividualEditProperties(keyPurpose) {
    return {
      certUsage: keyPurpose
    };
  }
  function updateDefaultValue(editor) {
    var _editor$state = editor.state(),
      oidThatCreatedValue = _editor$state.oidThatCreatedValue,
      keyPurpose = _editor$state.keyPurpose;
    return editor.queryWidget("**/oid").read() // oid not yet updated in state when this is invoked
    .then(function (oid) {
      // default the ext widget value unless we are editing extension of same oid that created the existing value
      var useDefaultValue = oidThatCreatedValue && oidThatCreatedValue !== oid;
      var newDefaultValue = useDefaultValue ? getDefaultValue(oid, keyPurpose) : null;
      editor.state({
        defaultValue: newDefaultValue
      });
    });
  }
  function getDefaultValue(oid, keyPurpose) {
    var defaults = {};
    if (oid === KEY_USAGE_OID) {
      defaults.flags = getDefaultKeyUsageFlags(keyPurpose);
    } else if (oid === EXTENDED_KEY_USAGE_OID) {
      defaults.purposes = getDefaultEkuPurpose(keyPurpose);
    }
    return defaults;
  }

  /**
   * @inner
   * @returns {Promise}
   */
  function editExtension(editor) {
    var _editor$state2 = editor.state(),
      oid = _editor$state2.oid,
      value = _editor$state2.value,
      keyPurpose = _editor$state2.keyPurpose,
      defaultValue = _editor$state2.defaultValue;
    return feDialogs.showFor({
      type: getExtensionWidget(oid),
      value: defaultValue || value,
      formFactor: 'compact',
      title: getExtensionLabel(oid),
      properties: getIndividualEditProperties(keyPurpose)
    }).then(function (modified) {
      if (modified === null) {
        return; //user pressed cancel
      }
      // save the oid which was used to make the edit in the state
      editor.state({
        value: modified,
        oidThatCreatedValue: oid,
        defaultValue: null
      });
      editor.setModified(true);
    });
  }

  /**
   * @private
   * @returns {Object}
   */
  function getExtensionTypeList() {
    var map = {};
    var keys = Object.keys(extensionTypes);
    keys.forEach(function (key) {
      var desc = getExtensionLabel(key);
      map[desc] = key;
    });
    return map;
  }
  return SingleExtensionEditor;
});
