function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/platCrypto/rc/fe/DistinguishedNameEditor
 */
define(['baja!', 'lex!platCrypto', 'bajaux/spandrel', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'Promise', 'nmodule/platCrypto/rc/wb/cert/util/DN', 'nmodule/platCrypto/rc/wb/cert/util/certUtils', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/options/MruButton', 'nmodule/webEditors/rc/wb/options/MruOptions', 'css!nmodule/platCrypto/rc/platCrypto'], function (baja, lexs, spandrel, Command, CommandButton, Promise, DN, certUtils, feDialogs, MruButton, MruOptions) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];
  var getValidCountryCodes = certUtils.getValidCountryCodes;
  var COUNTRY_CODE = 'C';
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-DistinguishedNameEditor'
      }
    };
  };

  /**
   * Compact editor for editing the fields of a Distinguished Name.
   *
   * @class
   * @alias module:nmodule/platCrypto/rc/fe/DistinguishedNameEditor
   * @extends module:bajaux/Widget
   */
  var DistinguishedNameEditor = /*#__PURE__*/function (_spandrel) {
    function DistinguishedNameEditor(params) {
      var _this;
      _classCallCheck(this, DistinguishedNameEditor);
      _this = _callSuper(this, DistinguishedNameEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$addCmd = new Command({
        module: 'platCrypto',
        lex: 'NewCertForm.distinguishedName.commands.addRDN',
        func: function func() {
          return _this.$promptForNewRDN().then(function (newTuple) {
            return newTuple && _this.$addRDN(newTuple);
          });
        }
      });
      _this.$isOffline = baja.isOffline();
      _this.$editCmd = new Command({
        module: 'webEditors',
        lex: 'commands.popOut',
        func: function func() {
          return _this.$popOut().then(function (newDn) {
            return newDn !== null && _this.loadAndModify(newDn);
          });
        }
      });
      return _this;
    }

    /**
     * @private
     * @param {string} dnString the distinguished name as edited by the user in the popup
     * @returns {Promise} to be resolved when the MRU entry has been written to user data
     */
    _inherits(DistinguishedNameEditor, _spandrel);
    return _createClass(DistinguishedNameEditor, [{
      key: "$saveMru",
      value: function $saveMru(dnString) {
        var _this$state = this.state(),
          options = _this$state.options;
        options.add(dnString);
        return options.save();
      }

      /**
       * Only when in mini mode, retrieve MRU options to use for the inline MRU button.
       * @returns {Promise.<object>}
       */
    }, {
      key: "toState",
      value: function toState() {
        if (!this.$isOffline && this.getFormFactor() === 'mini') {
          return MruOptions.make('DistinguishedNameEditorMRU').then(function (options) {
            return {
              options: options
            };
          });
        }
      }

      /**
       * @private
       * @returns {Promise.<string>} the new DN after the user has edited it in detail in a popup
       */
    }, {
      key: "$popOut",
      value: function $popOut() {
        return this.read().then(function (dn) {
          return feDialogs.showFor({
            value: dn,
            type: DistinguishedNameEditor
          });
        });
      }

      /**
       * @private
       * @returns {Promise.<Array.<string>>} resolves to a new tuple
       */
    }, {
      key: "$promptForNewRDN",
      value: function $promptForNewRDN() {
        return feDialogs.showFor({
          value: ['', ''],
          type: AddRowPrompt
        });
      }

      /**
       * @private
       * @param {Array.<string>} newTuple new tuple to add
       * @returns {Promise}
       */
    }, {
      key: "$addRDN",
      value: function $addRDN(newTuple) {
        var _this2 = this;
        if (!newTuple.join('')) {
          return Promise.resolve();
        }
        return this.$getTuplesSection().read().then(function (tuples) {
          return _this2.render(new DN([].concat(_toConsumableArray(tuples), [newTuple])).toString());
        }).then(function () {
          return _this2.setModified(true);
        });
      }

      /**
       * @private
       * @returns {string}
       */
    }, {
      key: "doRead",
      value:
      /**
       * @returns {Promise.<string>}
       */
      function doRead() {
        if (this.getFormFactor() === 'mini') {
          return this.$getStringEditor().read();
        }
        return this.$getTuplesSection().read().then(function (tuples) {
          return new DN(tuples).toString();
        });
      }

      /**
       * When in mini mode, saves the newly entered DN into the MRU list for later use.
       * @param {string} newDn
       * @returns {Promise}
       */
    }, {
      key: "doSave",
      value: function doSave(newDn) {
        return !this.$isOffline && this.getFormFactor() === 'mini' && this.$saveMru(newDn);
      }

      /**
       * @private
       * @returns {string}
       */
    }, {
      key: "$getPreviewText",
      value: function $getPreviewText() {
        return this.queryWidget('**/preview').jq().text();
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getTuplesSection",
      value: function $getTuplesSection() {
        return this.queryWidget('tuples');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getAddButton",
      value: function $getAddButton() {
        return this.queryWidget('addButton');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getStringEditor",
      value: function $getStringEditor() {
        return this.queryWidget('string');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getEditButton",
      value: function $getEditButton() {
        return this.queryWidget('edit');
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/options/MruButton}
       */
    }, {
      key: "$getMruButton",
      value: function $getMruButton() {
        return this.queryWidget('mru');
      }
    }], [{
      key: "$getCountryCodeDatalist",
      value: function $getCountryCodeDatalist() {
        return getValidCountryCodes().join(';');
      }
    }]);
  }(spandrel(function (dnString, _ref) {
    var formFactor = _ref.formFactor,
      options = _ref.options,
      self = _ref.self;
    if (formFactor === 'mini') {
      var widgetArray = [spandrel.jsx("any", {
        spandrelKey: "string",
        value: dnString
      }), spandrel.jsx(CommandButton, {
        spandrelKey: "edit",
        "class": "ux-btn-tb",
        tagName: "button",
        type: "button",
        value: self.$editCmd
      })];
      //add mru button only in online mode
      if (!self.$isOffline) {
        widgetArray.push(spandrel.jsx(MruButton, {
          spandrelKey: "mru",
          value: {
            options: options,
            select: function select(v) {
              return self.loadAndModify(v);
            }
          }
        }));
      }
      return widgetArray;
    }
    var dn = DN.parse(dnString);
    return [spandrel.jsx("div", null, spandrel.jsx("label", null, platCryptoLex.get('NewCertForm.distinguishedName.dnPreview')), spandrel.jsx("div", {
      className: "-t-DistinguishedNameEditor-preview ".concat(dnString && 'ux-border', " ")
    }, spandrel.jsx("code", {
      spandrelKey: "preview"
    }, dnString))), spandrel.jsx(Tuples, {
      tagName: "table",
      className: "-t-DistinguishedNameEditor-Tuples",
      value: dn.getTuples(),
      lax: true,
      spandrelKey: "tuples",
      onUxModify: function onUxModify() {
        return self.rerender();
      }
    }), spandrel.jsx(CommandButton, {
      tagName: "button",
      type: "button",
      className: "ux-btn",
      value: self.$addCmd,
      spandrelKey: "addButton"
    })];
  }, {
    strategy: 'niagara'
  }));
  /**
   * Widget that holds the rows for the individual fields of the DN.
   * @class
   * @extends module:bajaux/Widget
   */
  var Tuples = /*#__PURE__*/function (_spandrel2) {
    function Tuples() {
      _classCallCheck(this, Tuples);
      return _callSuper(this, Tuples, arguments);
    }
    _inherits(Tuples, _spandrel2);
    return _createClass(Tuples, [{
      key: "doRead",
      value:
      /**
       * @returns {Promise.<Array.<string>>} the current tuples in the DN
       */
      function doRead() {
        return Promise.all(this.$getTupleRows().map(function (row) {
          return row.read();
        }));
      }

      /**
       * @private
       * @param {number} i the index to delete
       * @returns {Promise}
       */
    }, {
      key: "$deleteRow",
      value: function $deleteRow(i) {
        var _this3 = this;
        return this.read().then(function (tuples) {
          tuples.splice(i, 1);
          return _this3.load(tuples);
        }).then(function () {
          return _this3.setModified(true);
        });
      }

      /**
       * @private
       * @returns {Array.<TupleRow>}
       */
    }, {
      key: "$getTupleRows",
      value: function $getTupleRows() {
        return this.queryWidgets('*');
      }
    }]);
  }(spandrel(function (tuples, _ref2) {
    var self = _ref2.self;
    return tuples.map(function (tuple, i) {
      return spandrel.jsx(TupleRow, {
        tagName: "tr",
        value: tuple,
        properties: {
          deleteMe: function deleteMe() {
            return self.$deleteRow(i);
          }
        }
      });
    });
  }));
  /**
   * Widget for editing one RDN tuple in the DN.
   * @class
   * @extends module:bajaux/Widget
   */
  var TupleRow = /*#__PURE__*/function (_spandrel3) {
    function TupleRow() {
      var _this4;
      _classCallCheck(this, TupleRow);
      _this4 = _callSuper(this, TupleRow, arguments);
      _this4.$deleteCmd = new Command({
        module: 'platCrypto',
        lex: 'NewCertForm.distinguishedName.commands.removeRDN',
        func: function func() {
          var deleteMe = _this4.properties().getValue('deleteMe');
          return deleteMe();
        }
      });
      return _this4;
    }

    /**
     * @returns {Promise.<Array.<string>>} the tuple entered in this row
     */
    _inherits(TupleRow, _spandrel3);
    return _createClass(TupleRow, [{
      key: "doRead",
      value: function doRead() {
        var _this$value = this.value(),
          _this$value2 = _slicedToArray(_this$value, 1),
          key = _this$value2[0];
        return this.$getValueEditor().read().then(function (value) {
          return [key, value];
        });
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getLabel",
      value: function $getLabel() {
        return this.queryWidget('**/label').jq();
      }

      /**
       * @private
       * @returns {module:bajaux/Widget} the string editor for the tuple value
       */
    }, {
      key: "$getValueEditor",
      value: function $getValueEditor() {
        return this.queryWidget('**/input');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */
    }, {
      key: "$getDeleteButton",
      value: function $getDeleteButton() {
        return this.queryWidget('**/deleteButton');
      }
    }]);
  }(spandrel(function (tuple, _ref3) {
    var self = _ref3.self;
    var _tuple = _slicedToArray(tuple, 2),
      key = _tuple[0],
      value = _tuple[1];
    return [spandrel.jsx("td", null, spandrel.jsx("label", {
      spandrelKey: "label"
    }, attrDisplay(key))), spandrel.jsx("td", null, spandrel.jsx("any", {
      spandrelKey: "input",
      value: value,
      properties: {
        datalist: key === COUNTRY_CODE ? DistinguishedNameEditor.$getCountryCodeDatalist() : ''
      }
    })), spandrel.jsx("td", null, spandrel.jsx(CommandButton, {
      tagName: "button",
      type: "button",
      className: "ux-btn-tb",
      spandrelKey: "deleteButton",
      value: self.$deleteCmd
    }))];
  }, {
    strategy: 'niagara'
  }));
  /**
   * The widget that is shown in a dialog to prompt the user for a new tuple when the Add button is clicked.
   * @class
   * @extends module:bajaux/Widget
   */
  var AddRowPrompt = /*#__PURE__*/function (_spandrel4) {
    function AddRowPrompt(params) {
      _classCallCheck(this, AddRowPrompt);
      return _callSuper(this, AddRowPrompt, [{
        params: params,
        defaults: {
          properties: {
            rootCssClass: '-t-DistinguishedNameEditor-AddPrompt'
          }
        }
      }]);
    }
    /**
     * @private
     * @returns {module:bajaux/Widget}
     */
    _inherits(AddRowPrompt, _spandrel4);
    return _createClass(AddRowPrompt, [{
      key: "$getKeyEditor",
      value: function $getKeyEditor() {
        return this.queryWidget('key');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getValueEditor",
      value: function $getValueEditor() {
        return this.queryWidget('value');
      }

      /**
       * @returns {Promise.<Array.<string>>} the new tuple to add
       */
    }, {
      key: "doRead",
      value: function doRead() {
        return Promise.all([this.$getKeyEditor().read(), this.$getValueEditor().read()]);
      }
    }]);
  }(spandrel(function (tuple, _ref4) {
    var self = _ref4.self;
    var _tuple2 = _slicedToArray(tuple, 2),
      key = _tuple2[0],
      value = _tuple2[1];
    return [spandrel.jsx("label", null, platCryptoLex.get('NewCertForm.distinguishedName.commands.addRDN.type')), spandrel.jsx("any", {
      spandrelKey: "key",
      value: key,
      properties: {
        datalist: {
          'CN': attrDisplay('CN'),
          'OU': attrDisplay('OU'),
          'O': attrDisplay('O'),
          'L': attrDisplay('L'),
          'ST': attrDisplay('ST'),
          'C': attrDisplay('C')
        },
        filterWhileTyping: false
      },
      onUxModify: function onUxModify() {
        return self.rerender();
      }
    }), spandrel.jsx("label", null, platCryptoLex.get('NewCertForm.distinguishedName.commands.addRDN.value')), spandrel.jsx("any", {
      spandrelKey: "value",
      value: value,
      properties: {
        datalist: key === COUNTRY_CODE ? DistinguishedNameEditor.$getCountryCodeDatalist() : ''
      }
    })];
  }, {
    strategy: 'niagara'
  }));
  /**
   * @param {string} attr
   * @returns {string} a friendly display for this attribute name
   */
  function attrDisplay(attr) {
    switch (attr) {
      case 'CN':
        return platCryptoLex.get('cert.field.commonName');
      case 'OU':
        return platCryptoLex.get('cert.field.organizationalUnit');
      case 'O':
        return platCryptoLex.get('cert.field.organization');
      case 'L':
        return platCryptoLex.get('cert.field.locality');
      case 'ST':
        return platCryptoLex.get('cert.field.stateProvince');
      case 'C':
        return platCryptoLex.get('cert.field.countryCode');
      default:
        return attr;
    }
  }
  return DistinguishedNameEditor;
});
