function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

define(['baja!', 'lex!platCrypto'], function (baja, lexs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    platCryptoLex = _lexs[0];

  /**
   * API Status: **Private**
   * @exports nmodule/platCrypto/rc/CertConstants
   */
  var exports = {};

  /**
   * Common Key Purpose Ids for setting up Extended Key Usage options
   * @see org.bouncycastle.asn1.x509.KeyPurposeId
   * @see nre:OidMap
   * @type {Array}
   */
  exports.EXTENDED_KEY_USAGE_COMMON_IDS = ['1.3.6.1.5.5.7.3.1', '1.3.6.1.5.5.7.3.2', '1.3.6.1.5.5.7.3.3', '1.3.6.1.5.5.7.3.4', '1.3.6.1.5.5.7.3.8', '1.3.6.1.5.5.7.3.9', '1.3.6.1.4.1.311.20.2.2'];

  /**
   * List of OIDs of the supported extension types
   * @see org.bouncycastle.asni.x509.Extensions
   * @see nre:OidMap for a list of common OIDs
   * @type (Object)
   */
  exports.EXTENSION_OID = {
    SUBJECT_ALTERNATIVE_NAME_OID: '2.5.29.17',
    KEY_USAGE_OID: '2.5.29.15',
    EXTENDED_KEY_USAGE_OID: '2.5.29.37',
    BASIC_CONSTRAINT_OID: '2.5.29.19',
    CRL_DISTRIBUTION_POINTS_OID: '2.5.29.31'
  };

  /**
   * @type {baja.Icon}
   */
  exports.ICON_SECURITY_LOW = baja.Icon.make(platCryptoLex.get('security.low.x16.icon'));

  /**
   * @type {baja.Icon}
   */
  exports.ICON_SECURITY_MEDIUM = baja.Icon.make(platCryptoLex.get('security.medium.x16.icon'));

  /**
   * @type {baja.Icon}
   */
  exports.ICON_SECURITY_HIGH = baja.Icon.make(platCryptoLex.get('security.high.x16.icon'));

  /**
   * @type {baja.Icon}
   */
  exports.ICON_SECURITY_HIGH_PARTIAL_CHAIN = baja.Icon.make([platCryptoLex.get('security.high.x16.icon'), platCryptoLex.get('security.high.partialBadge.x16.icon')]);

  /**
   * @type {baja.Icon}
   */
  exports.ICON_DEFAULT_CERT = baja.Icon.make([platCryptoLex.get('security.medium.x16.icon'), platCryptoLex.get('security.default.badge.x16.icon')]);

  /**
   * @type {Array}
   */
  exports.PROPERTY_FIELDS = ['version', 'serialNumber', 'issuedBy', 'issuerDN', 'subject', 'subjectDN', 'notBefore', 'notAfter', 'keyAlgorithm', 'keySize', 'spec', 'signatureAlgorithm', 'signatureSize', 'basicConstraints', 'keyUsage', 'extendedKeyUsage', 'md5Fingerprint', 'sha1Fingerprint', 'valid'];

  /**
   * Mapping to fix JSON attributes that
   * does not match the lex suffix   
   * @type {object}
   */
  exports.CERT_FIELD_LEX_MAPPING = {
    serialNumber: 'serialNum',
    issuerDN: 'issuerDn',
    subjectDN: 'subjectDn'
  };

  /**
   * @type {String}
   */
  exports.DEFAULT_ALIAS = 'default';

  /**
   * Subject Alternative Name Tag mappings
   * @type {object}
   */
  exports.SAN_EXT_TAGS = {
    TAG_NO_DNS_NAME: 2,
    TAG_NO_IP_ADDRESS: 7
  };
  return exports;
});
