function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @since Niagara 4.14
 * @module nmodule/rdb/rc/model/RdbDeviceUxManagerModel
 */

define(['baja!', 'baja!rdb:Rdbms,rdbSqlServer:SqlServerDatabase,rdbMySQL:MySQLConnectionPoolWithCredentials,rdbSqlServer:SqlServerConnectionPoolWithCredentials', 'lex!rdb', 'Promise', 'nmodule/driver/rc/wb/mgr/DeviceMgrModel', 'nmodule/driver/rc/wb/mgr/columns/DeviceExtsMgrColumn', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/facetsUtils', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/TypeMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/MgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column'], function (baja, types, lexs, Promise, DeviceMgrModel, DeviceExtsMgrColumn, compUtils, facetsUtils, MgrTypeInfo, mgrUtils, NameMgrColumn, PropertyMgrColumn, PropertyPathMgrColumn, IconMgrColumn, TypeMgrColumn, MgrColumn, Column) {
  'use strict';

  var _Column$flags = Column.flags,
    EDITABLE = _Column$flags.EDITABLE,
    UNSEEN = _Column$flags.UNSEEN,
    READONLY = _Column$flags.READONLY;
  var RDB_TYPE = baja.lt('rdb:Rdbms');
  var HIDDEN = baja.Flags.HIDDEN;
  var _lexs = _slicedToArray(lexs, 1),
    rdbLex = _lexs[0];
  var PORT_LABEL = rdbLex.get('RdbDeviceUxManagerModel.portColumn.name');
  var DATABASE_NAME_LABEL = rdbLex.get('RdbDeviceUxManagerModel.databaseNameColumn.name');
  var toProperties = facetsUtils.toProperties;
  var RDB_MYSQL_CONNECTION_TYPE = baja.lt('rdbMySQL:MySQLConnectionPoolWithCredentials');
  var RDB_SQLSERVER_CONNECTION_TYPE = baja.lt('rdbSqlServer:SqlServerConnectionPoolWithCredentials');
  var RDBMS_CONNECTION_TYPES = [RDB_SQLSERVER_CONNECTION_TYPE, RDB_MYSQL_CONNECTION_TYPE];
  function makeColumns() {
    return [new IconMgrColumn(), new NameMgrColumn({
      flags: EDITABLE
    }), new TypeMgrColumn({
      flags: READONLY
    }), new DeviceExtsMgrColumn('deviceExts', {
      dynamic: true
    }), new PropertyMgrColumn('enabled', {
      flags: EDITABLE,
      type: RDB_TYPE
    }), new PropertyMgrColumn('status', {
      flags: READONLY,
      type: RDB_TYPE
    }), new PropertyMgrColumn('health', {
      flags: READONLY,
      type: RDB_TYPE
    }), new DatabaseNameColumn('databaseName', {
      flags: EDITABLE,
      type: RDB_TYPE
    }), new NetAddressColumn('hostAddress', {
      flags: EDITABLE,
      type: RDB_TYPE
    }), new NetAddressColumn('port', {
      flags: EDITABLE,
      displayName: PORT_LABEL,
      getDefaultValue: function getDefaultValue() {
        return null;
      }
    }), new PropertyMgrColumn('userName', {
      flags: EDITABLE,
      type: RDB_TYPE,
      displayName: rdbLex.get('rdbms.privileged.username')
    }), new PropertyMgrColumn('password', {
      flags: UNSEEN | EDITABLE,
      type: RDB_TYPE,
      displayName: rdbLex.get('rdbms.privileged.password')
    }), new PropertyMgrColumn('useEncryptedConnection', {
      flags: EDITABLE,
      type: RDB_TYPE
    }), new PropertyMgrColumn('exportMode', {
      flags: EDITABLE,
      type: RDB_TYPE
    }), new PropertyMgrColumn('faultCause', {
      flags: UNSEEN | READONLY,
      type: RDB_TYPE
    }), new PropertyPathMgrColumn('nonPrivilegedConnectionPoolEnabled', 'nonPrivilegedConnectionPool/enabled', {
      flags: EDITABLE,
      type: RDBMS_CONNECTION_TYPES,
      displayName: rdbLex.get('rdbms.nonprivileged.connections.enabled')
    }), new PropertyPathMgrColumn('nonPrivilegedConnectionPoolUserName', 'nonPrivilegedConnectionPool/username', {
      flags: EDITABLE,
      type: RDBMS_CONNECTION_TYPES,
      displayName: rdbLex.get('rdbms.nonprivileged.username')
    }), new PropertyPathMgrColumn('nonPrivilegedConnectionPoolPassword', 'nonPrivilegedConnectionPool/password', {
      flags: UNSEEN | EDITABLE,
      type: RDBMS_CONNECTION_TYPES,
      displayName: rdbLex.get('rdbms.nonprivileged.password')
    })];
  }

  /**
   * A column editor that handles the two special columns in the Rdbms dealing with network
   *  connections
   */
  var NetAddressColumn = /*#__PURE__*/function (_PropertyMgrColumn) {
    function NetAddressColumn() {
      _classCallCheck(this, NetAddressColumn);
      return _callSuper(this, NetAddressColumn, arguments);
    }
    _inherits(NetAddressColumn, _PropertyMgrColumn);
    return _createClass(NetAddressColumn, [{
      key: "coalesceRows",
      value:
      /**
       * Checks to see if the columns in the rows can be edited, and if not throws and error
       * @param rows
       * @returns {*}
       */
      function coalesceRows(rows) {
        var _this = this;
        var name = this.getName();
        var hidden = false;
        rows.forEach(function (row) {
          hidden = hidden || !!(_this.$getComplex(row).getFlags(name) & HIDDEN);
        });
        if (hidden) {
          throw new Error('cannot edit hidden slot: ' + name);
        }
        return _superPropGet(NetAddressColumn, "coalesceRows", this, 3)([rows]);
      }
    }, {
      key: "buildCell",
      value: function buildCell(row, dom) {
        var hiddenOrNull = true;
        var value = this.getProposedValueFor(row);
        if (value !== null) {
          hiddenOrNull = !!(this.$getComplex(row).getFlags(this.getName()) & HIDDEN);
        }
        if (hiddenOrNull) {
          return Promise.resolve().then(function () {
            dom.text('');
          });
        }
        return _superPropGet(NetAddressColumn, "buildCell", this, 3)(arguments);
      }
    }]);
  }(PropertyMgrColumn);
  /**
   * A column editor that handles the database name column.  The value for this column can come
   * from 3 different slots depending on which one exist.  The name of these three slots can be
   * `databaseName`, `serviceName` or `instanceName`.  If none of these slots exist then
   * `databaseName` will be used.
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn
   */
  var DatabaseNameColumn = /*#__PURE__*/function (_MgrColumn) {
    function DatabaseNameColumn(prop, params) {
      _classCallCheck(this, DatabaseNameColumn);
      params.displayName = DATABASE_NAME_LABEL;
      return _callSuper(this, DatabaseNameColumn, ['databaseName', params]);
    }

    /**
     * Returns the slot name for the database name value based on the subject of the row
     * @private
     * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row the current row
     * @returns {String}
     */
    _inherits(DatabaseNameColumn, _MgrColumn);
    return _createClass(DatabaseNameColumn, [{
      key: "$getDatabaseNameProperty",
      value: function $getDatabaseNameProperty(row) {
        var slotNames = ["serviceName", "instanceName"];
        var comp = row.getSubject();
        // set to the default property name of 'databaseName'
        var prop = "databaseName";
        slotNames.forEach(function (slotName) {
          var slot = comp.getSlot(slotName);

          // if we find a slot with one of the other two name set to that name
          if (slot) {
            prop = slotName;
          }
        });
        return prop;
      }

      /**
       * Determines the property in the subject that holds the database name value and returns that
       * value for the property.  Returns null if there is no database name property.
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @returns {*}
       */
    }, {
      key: "getValueFor",
      value: function getValueFor(row) {
        var prop = this.$getDatabaseNameProperty(row);
        var comp = row.getSubject();
        if (comp.has(prop)) {
          return comp.get(prop);
        }

        // returns null if no database name property
        return null;
      }

      /**
       * Determines the property in the subject that holds the database name value and updates the
       * value of that property with the proposed database name value.
       * @param {baja.Value} value
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @param {Object} [params]
       * @param {baja.comm.Batch} [params.batch]
       * @returns {Promise} promise to be resolved when the value has
       * been set on the backing `Component`
       */
    }, {
      key: "commit",
      value: function commit(value, row, params) {
        var prop = this.$getDatabaseNameProperty(row);
        var comp = row.getSubject();
        var progressCallback = params && params.progressCallback;
        var prom = comp.has(prop) ? compUtils.writeSlot(comp, prop, value, params) : Promise.resolve();
        if (progressCallback) {
          progressCallback(MgrColumn.COMMIT_READY);
        }
        return prom;
      }

      /**
       * If editing only one row, then the facets used to configure the field
       * editor will be taken from the component instance in that one row.
       *
       * If editing multiple rows, then the facets will be taken from the
       * appropriate frozen slot on the column's configured Type, if present.
       *
       * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} rows
       * @returns {Object} config object for `fe.makeFor`, possibly including
       * properties derived from slot facets
       */
    }, {
      key: "getConfigFor",
      value: function getConfigFor(rows) {
        var value = this.coalesceRows(rows);
        var facets = baja.Facets.DEFAULT;
        if (rows.length > 0) {
          var row = rows[0];
          var prop = this.$getDatabaseNameProperty(row);
          facets = row.getSubject().getFacets(prop);
        }
        return {
          value: value,
          properties: toProperties(facets)
        };
      }
    }]);
  }(MgrColumn);
  /**
   * The model that defines the entries for the RdbDeviceUxManager
   * @class
   * @alias module:nmodule/rdb/rc/model/RdbDeviceUxManagerModel
   * @extends module:nmodule/driver/rc/wb/mgr/DeviceMgrModel
   */
  var RdbDeviceUxManagerModel = /*#__PURE__*/function (_DeviceMgrModel) {
    function RdbDeviceUxManagerModel() {
      _classCallCheck(this, RdbDeviceUxManagerModel);
      return _callSuper(this, RdbDeviceUxManagerModel, arguments);
    }
    _inherits(RdbDeviceUxManagerModel, _DeviceMgrModel);
    return _createClass(RdbDeviceUxManagerModel, null, [{
      key: "make",
      value: function make(component) {
        return Promise.all([makeColumns(), resolveNewTypes()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            columns = _ref2[0],
            newTypes = _ref2[1];
          return new RdbDeviceUxManagerModel({
            component: component,
            columns: columns,
            newTypes: newTypes,
            folderType: 'rdb:RdbmsFolder'
          });
        });
      }
    }]);
  }(DeviceMgrModel);
  /**
   * Resolves the types that this manager can add
   * @returns {Promise<MgrTypeInfo>}
   */
  function resolveNewTypes() {
    return MgrTypeInfo.make({
      from: 'rdb:Rdbms',
      concreteTypes: true
    }).then(function (newTypes) {
      return newTypes.sort();
    });
  }
  return RdbDeviceUxManagerModel;
});
