function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

define(['baja!', 'Promise'], function (baja, Promise) {
  'use strict';

  /**
   * API Status: **Private**
   * @exports nmodule/history/rc/servlet/historyRpc
   */
  var exports = {};

  /**
   * @param {baja.NavNode} history a `history:IHistory` nav node
   * @returns {Promise.<string>} the history's current display name in BFormat format
   */
  exports.getHistoryDisplayNameFormat = function (history) {
    return verifyIsHistory(history).then(function () {
      return callHistoryRpc('getHistoryDisplayNameFormat', [String(history.getNavOrd())]);
    });
  };

  /**
   * @param {baja.NavNode} history a `history:IHistory` nav node
   * @param {string} displayNameFormat the new display name to set, in BFormat format
   * @returns {Promise}
   */
  exports.setHistoryDisplayNameFormat = function (history, displayNameFormat) {
    if (typeof displayNameFormat !== 'string') {
      return Promise.reject(new Error('name required'));
    }
    return verifyIsHistory(history).then(function (type) {
      var ordString = String(history.getNavOrd());
      return callHistoryRpc('setHistoryDisplayNameFormat', [ordString, displayNameFormat]).then(function (displayName) {
        // HistoryMirrors prepend the device name to their display name.
        if (type.is('history:HistoryMirror')) {
          var deviceName = getDeviceName(history);
          if (deviceName) {
            displayName = deviceName + '/' + displayName;
          }
        }

        // noinspection JSAccessibilityCheck
        history.$syntheticSetDisplayName(displayName);
      });
    });
  };
  function getDeviceName(historyMirror) {
    var match = historyMirror.getNavDisplayName().match(/^([^/]*)\//);
    if (match) {
      var _match = _slicedToArray(match, 2),
        deviceName = _match[1];
      return deviceName;
    }
  }
  function verifyIsHistory(history) {
    return baja.importTypes([history.getNavTypeSpec()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
        type = _ref2[0];
      if (!type.is('history:IHistory')) {
        throw new Error('history:IHistory required');
      }
      return type;
    });
  }
  function callHistoryRpc(method, args) {
    return baja.rpc({
      typeSpec: 'history:HistoryRpc',
      method: method,
      args: args
    });
  }
  return exports;
});
