function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/history/rc/baja/CollectionInterval
 */
define(['baja!', 'lex!history'], function (baja, lexs) {
  'use strict';

  var objUtil = require('bajaScript/baja/obj/objUtil');
  var _lexs = _slicedToArray(lexs, 1),
    HISTORY_LEX = _lexs[0];
  function relTime(millis) {
    return baja.RelTime.make(millis);
  }
  var Simple = baja.Simple,
    cacheDecode = objUtil.cacheDecode,
    cacheEncode = objUtil.cacheEncode,
    STR_REGEX = /([^:]+):([+-]?\d+)/,
    MILLIS_IN_MINUTE = baja.RelTime.MILLIS_IN_MINUTE,
    MINUTE = relTime(MILLIS_IN_MINUTE);

  /**
   * BajaScript representation of a `history:CollectionInterval`.
   *
   * @class
   * @extends baja.Simple
   * @alias module:nmodule/history/rc/baja/CollectionInterval
   */
  var CollectionInterval = function CollectionInterval() {
    Simple.apply(this, arguments);
  };
  CollectionInterval.prototype = Object.create(Simple.prototype);
  CollectionInterval.prototype.constructor = CollectionInterval;

  /**
   * Make a new regular `CollectionInterval` instance.
   *
   * @param {baja.RelTime} interval
   * @returns {module:nmodule/history/rc/baja/CollectionInterval}
   */
  CollectionInterval.make = function (interval) {
    if (!baja.hasType(interval, 'baja:RelTime')) {
      throw new Error('baja:RelTime required');
    }
    var ci = new CollectionInterval();
    ci.$irregular = false;
    ci.$interval = interval;
    return ci;
  };

  /**
   * Make a new regular `CollectionInterval` instance.
   * @see module:nmodule/history/rc/baja/CollectionInterval.make
   */
  CollectionInterval.prototype.make = function () {
    return CollectionInterval.make.apply(CollectionInterval, arguments);
  };
  CollectionInterval.prototype.decodeFromString = cacheDecode(function (str) {
    var result = STR_REGEX.exec(str);
    if (!result) {
      throw new Error('invalid history:CollectionInterval encoding: ' + str);
    }
    var interval = baja.RelTime.make(parseInt(result[2], 10)),
      ci = CollectionInterval.make(interval);
    if (result[1] === 'true') {
      ci.$irregular = true;
    }
    return ci;
  });
  CollectionInterval.prototype.encodeToString = cacheEncode(function () {
    return this.isIrregular() + ':' + this.getInterval().encodeToString();
  });

  /**
   * Return the `String` representation of the `CollectionInterval` (itself).
   * @since Niagara 4.14
   * @returns {String}
   */
  CollectionInterval.prototype.toString = function () {
    return this.isIrregular() ? HISTORY_LEX.get('irregular') : this.getInterval().toString();
  };
  /**
   * Get the collection interval.
   *
   * @returns {baja.RelTime}
   */
  CollectionInterval.prototype.getInterval = function () {
    return this.$interval;
  };

  /**
   * Return true if this interval is irregular.
   *
   * @returns {boolean}
   */
  CollectionInterval.prototype.isIrregular = function () {
    return this.$irregular;
  };
  CollectionInterval.DEFAULT = CollectionInterval.make(MINUTE);
  CollectionInterval.IRREGULAR = CollectionInterval.make(MINUTE);
  CollectionInterval.IRREGULAR.$irregular = true;
  CollectionInterval.REGULAR_1_MIN = CollectionInterval.DEFAULT;
  CollectionInterval.REGULAR_5_MIN = CollectionInterval.make(relTime(MILLIS_IN_MINUTE * 5));
  CollectionInterval.REGULAR_15_MIN = CollectionInterval.make(relTime(MILLIS_IN_MINUTE * 15));
  CollectionInterval.REGULAR_30_MIN = CollectionInterval.make(relTime(MILLIS_IN_MINUTE * 30));
  CollectionInterval.REGULAR_1_HOUR = CollectionInterval.make(relTime(MILLIS_IN_MINUTE * 60));
  baja.registerType('history:CollectionInterval', function () {
    return CollectionInterval;
  });
  return CollectionInterval;
});
