function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 * @author Nutan Naik
 */

/**
 * API Status: **Private**
 * @module nmodule/driver/rc/wb/mgr/network/DriverUxManagerModel
 */
define(['baja!', 'baja!driver:DeviceNetwork', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/model/MgrModel', 'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/TypeMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/source/ContainerComponentSource'], function (baja, types, MgrTypeInfo, MgrModel, IconMgrColumn, NameMgrColumn, PropertyMgrColumn, TypeMgrColumn, Column, ContainerComponentSource) {
  'use strict';

  /**
   * Device Network Manager Model Implementation
   *
   * @since Niagara 4.14
   */
  var DEVICE_TYPE = baja.lt('driver:DeviceNetwork'),
    EDITABLE = Column.flags.EDITABLE,
    NETWORK_ICON = baja.Icon.make('module://icons/x16/deviceNetwork.png');
  function toColumn(slot, params) {
    params = params || {};
    var Ctor = params.ctor || PropertyMgrColumn,
      flags = params.flags || EDITABLE;
    return new Ctor(slot, {
      type: DEVICE_TYPE,
      flags: flags
    });
  }
  var icon = new IconMgrColumn();
  icon.getValueFor = function (row) {
    return row.getSubject().getIcon() || NETWORK_ICON;
  };
  var COLUMNS = [icon, new NameMgrColumn({
    flags: EDITABLE
  }), new TypeMgrColumn({
    flags: EDITABLE
  }), toColumn('status', {
    flags: Column.flags.READONLY
  }), toColumn('enabled'), toColumn('faultCause', {
    flags: Column.flags.READONLY
  })];

  /**
   * @class
   * @alias module:nmodule/driver/rc/wb/mgr/network/DriverUxManagerModel
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrModel
   */
  return /*#__PURE__*/function (_MgrModel) {
    function DriverUxManagerModel() {
      _classCallCheck(this, DriverUxManagerModel);
      return _callSuper(this, DriverUxManagerModel, arguments);
    }
    _inherits(DriverUxManagerModel, _MgrModel);
    return _createClass(DriverUxManagerModel, null, [{
      key: "make",
      value:
      /**
       * Creates and resolves DriverUxManagerModel
       * @param {baja.Component} driverNetwork
       * @returns {Promise.<module:nmodule/driver/rc/wb/mgr/network/DriverUxManagerModel>}
       */
      function make(driverNetwork) {
        return MgrTypeInfo.make({
          from: DEVICE_TYPE,
          concreteTypes: true
        }).then(function (newTypes) {
          var includeTypes = ['driver:DeviceNetwork'];
          return new DriverUxManagerModel({
            componentSource: new ContainerComponentSource({
              container: driverNetwork,
              filter: includeTypes
            }),
            newTypes: newTypes.sort(function (type1, type2) {
              return type1.getDisplayName().toLowerCase().localeCompare(type2.getDisplayName().toLowerCase());
            }),
            columns: COLUMNS,
            filter: includeTypes
          });
        });
      }
    }]);
  }(MgrModel);
});
//# sourceMappingURL=DriverUxManagerModel.js.map
