function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

define(['baja!', 'underscore', 'baja!driver:ArchiveDescriptor,control:TimeTrigger,history:Capacity,history:FullPolicy', 'lex!history', 'nmodule/history/rc/baja/Capacity', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyPathMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/TypeMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column'], function (baja, _, types, lexs, Capacity, typeUtils, NameMgrColumn, PropertyMgrColumn, PropertyPathMgrColumn, IconMgrColumn, TypeMgrColumn, Column) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    historyLex = _lexs[0];
  var _Column$flags = Column.flags,
    EDITABLE = _Column$flags.EDITABLE,
    UNSEEN = _Column$flags.UNSEEN;
  var getSlotDisplayName = typeUtils.getSlotDisplayName;
  var _types = _slicedToArray(types, 2),
    ARCHIVE_DESCRIPTOR_TYPE = _types[0],
    TIME_TRIGGER = _types[1];
  var HISTORY_ICON = baja.Icon.make('module://icons/x16/history.png');
  var fromArchiveDescriptor = function fromArchiveDescriptor(flags) {
    return {
      flags: flags,
      type: ARCHIVE_DESCRIPTOR_TYPE
    };
  };
  var archivePropCol = function archivePropCol(slot, flags) {
    return new PropertyMgrColumn(slot, fromArchiveDescriptor(flags));
  };

  /**
   * API Status: **Private**
   * @exports nmodule/driver/rc/wb/mgr/history/historyMgrUtils
   */
  var exports = {};
  var icon = new IconMgrColumn();
  icon.getValueFor = function (row) {
    return row.getSubject().getIcon() || HISTORY_ICON;
  };

  /**
   * Columns that are appropriate for all archive descriptor managers. See ArchiveModel.java.
   * @param {object} [params]
   * @param {boolean} [params.includesType]
   * @returns {Array.<module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn>}
   */
  exports.getArchiveMgrColumns = function () {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      includesType = _ref.includesType;
    var archiveMgrCols = [icon, new NameMgrColumn({
      flags: EDITABLE
    }), archivePropCol('historyId', EDITABLE), new PropertyPathMgrColumn('executionTime/triggerMode', {
      displayName: getSlotDisplayName(ARCHIVE_DESCRIPTOR_TYPE, 'executionTime'),
      type: TIME_TRIGGER,
      flags: EDITABLE | UNSEEN
    }), archivePropCol('enabled', EDITABLE | UNSEEN), archivePropCol('status'), archivePropCol('state'), archivePropCol('lastAttempt', UNSEEN), archivePropCol('lastSuccess'), archivePropCol('lastFailure', UNSEEN), archivePropCol('faultCause', UNSEEN)];
    if (includesType) {
      archiveMgrCols.splice(2, 0, new TypeMgrColumn({
        flags: EDITABLE
      }));
    }
    return archiveMgrCols;
  };

  /**
   * Columns that are appropriate for all history import managers. See ImportModel.java.
   * @returns {Array.<module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn>}
   */
  exports.getImportMgrColumns = function () {
    return [new PropertyPathMgrColumn('configOverrides/capacity', {
      displayName: historyLex.get('HistoryConfig.capacity'),
      flags: EDITABLE | UNSEEN,
      getDefaultValue: function getDefaultValue() {
        return Capacity.UNLIMITED;
      }
    }), new PropertyPathMgrColumn('configOverrides/fullPolicy', {
      displayName: historyLex.get('HistoryConfig.fullPolicy'),
      flags: EDITABLE | UNSEEN,
      getDefaultValue: function getDefaultValue() {
        return baja.$('history:FullPolicy', 'roll');
      }
    })];
  };
  return exports;
});
//# sourceMappingURL=historyMgrUtils.js.map
