function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/driver/rc/fe/XYPointEditor
 */
define(['nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'jquery', 'Promise', 'nmodule/driver/rc/baja/XYPoint'], function (BaseWidget, fe, $, Promise, XYPoint) {
  'use strict';

  /**
   * A basic editor for a point with X and Y double values
   * @class
   * @alias module:nmodule/driver/rc/fe/XYPointEditor
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   */
  var XYPointEditor = function XYPointEditor() {
    BaseWidget.apply(this, arguments);
  };
  XYPointEditor.prototype = Object.create(BaseWidget.prototype);
  XYPointEditor.prototype.constructor = XYPointEditor;
  XYPointEditor.prototype.doInitialize = function (dom) {
    return Promise.all([fe.buildFor({
      value: 0.0,
      dom: $("<div class='js-x'/>").appendTo(dom),
      formFactor: 'mini'
    }), fe.buildFor({
      value: 0.0,
      dom: $("<div class='js-y'/>").appendTo(dom),
      formFactor: 'mini'
    })]);
  };
  XYPointEditor.prototype.$getXEditor = function () {
    return this.jq().children(".js-x").data("widget");
  };
  XYPointEditor.prototype.$getYEditor = function () {
    return this.jq().children(".js-y").data("widget");
  };
  XYPointEditor.prototype.doLoad = function (value) {
    return Promise.all([this.$getXEditor().load(value.xValue()), this.$getYEditor().load(value.yValue())]);
  };
  XYPointEditor.prototype.doRead = function () {
    return Promise.all([this.$getXEditor().read(), this.$getYEditor().read()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        xVal = _ref2[0],
        yVal = _ref2[1];
      return new XYPoint({
        x: xVal,
        y: yVal
      });
    });
  };

  /**
   * Destroy all the child editors
   * @returns {*}
   */
  XYPointEditor.prototype.doDestroy = function () {
    return this.getChildWidgets().destroyAll();
  };
  return XYPointEditor;
});
//# sourceMappingURL=XYPointEditor.js.map
