function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Robert Staley
 */

/**
 * API Status: **Private**
 * @module nmodule/driver/rc/fe/LinearWithUnitConversionEditor
 */
define(['nmodule/webEditors/rc/fe/baja/BaseEditor', 'jquery', 'Promise', 'baja!', 'baja!driver:LinearWithUnitConversion', 'nmodule/webEditors/rc/fe/fe', 'lex!driver', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'hbs!nmodule/driver/rc/fe/templates/LinearWithUnitConversionEditor', 'css!nmodule/driver/rc/driver'], function (BaseEditor, $, Promise, baja, types, fe, lexs, events, OrderedMapEditor, templateEditor) {
  'use strict';

  var driverLex = lexs[0];
  var DESTROY_EVENT = events.DESTROY_EVENT,
    INITIALIZE_EVENT = events.INITIALIZE_EVENT,
    LOAD_EVENT = events.LOAD_EVENT,
    ENABLE_EVENT = events.ENABLE_EVENT,
    DISABLE_EVENT = events.DISABLE_EVENT,
    MODIFY_EVENT = events.MODIFY_EVENT,
    READONLY_EVENT = events.READONLY_EVENT,
    WRITABLE_EVENT = events.WRITABLE_EVENT;
  var APPLY_UNITS = function () {
    var map = new baja.OrderedMap();
    map.put(driverLex.get("LinearWithUnitConversion.unit.conversion.device"), true);
    map.put(driverLex.get("LinearWithUnitConversion.unit.conversion.proxy"), false);
    return map;
  }();

  /**
   * LinearWithUnitConversionEditor is a bajaux field editor a BProxyConversion property. This property is
   * property. This property is a proxy conversion type that
   * additionally takes scale and offset parameters. It is
   * part of a composite Proxy Extension component of any protocol point.
   *
   * @private
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/driver/rc/fe/LinearWithUnitConversionEditor
   */
  var LinearWithUnitConversionEditor = function LinearWithUnitConversionEditor() {
    BaseEditor.apply(this, arguments);
  };

  //extend and set up prototype chain
  LinearWithUnitConversionEditor.prototype = Object.create(BaseEditor.prototype);
  LinearWithUnitConversionEditor.prototype.constructor = LinearWithUnitConversionEditor;

  /**
   * Initial is a one-time setup activity. The select html control is
   * initialized with all possible proxy extension types available to be set.
   *
   * @param {jQuery} dom the DOM element into which to load this widget
   * @return {Promise}
   */
  LinearWithUnitConversionEditor.prototype.doInitialize = function (dom) {
    var _this = this;
    //Disable events from bubbling up
    dom.on([DESTROY_EVENT, INITIALIZE_EVENT, LOAD_EVENT, ENABLE_EVENT, DISABLE_EVENT, READONLY_EVENT, WRITABLE_EVENT].join(' '), '.editor', false);
    dom.on(MODIFY_EVENT, '.editor', function () {
      _this.setModified(true);
      return false;
    });
    dom.html(templateEditor({
      labels: {
        scale: driverLex.get("LinearConversion.scale"),
        offset: driverLex.get("LinearConversion.offset"),
        applyUnitsTo: driverLex.get("LinearWithUnitConversion.unit.conversion")
      }
    }));
    return Promise.all([fe.buildFor({
      value: 0.0,
      dom: $(".js-scale", dom.children(".js-scaleEditor")),
      properties: {
        prelabel: driverLex.get("LinearConversion.scale"),
        uxFieldEditor: "webEditors:StringEditor"
      }
    }), fe.buildFor({
      value: 0.0,
      dom: $(".js-offset", dom.children(".js-offsetEditor")),
      properties: {
        prelabel: driverLex.get("LinearConversion.offset"),
        uxFieldEditor: "webEditors:StringEditor"
      }
    }), fe.buildFor({
      value: APPLY_UNITS,
      dom: $(".js-applyUnitsTo", dom.children(".js-applyUnitsToEditor")),
      type: OrderedMapEditor
    })]);
  };

  /**
   * Get the scale editor widget
   * @returns {module:nmodule/webEditors/rc/fe/baja/BaseEditor} the scale editor
   */
  LinearWithUnitConversionEditor.prototype.$getScaleEditor = function () {
    return this.jq().find(".js-scale").data("widget");
  };

  /**
   * Get the offset editor widget
   * @returns {module:nmodule/webEditors/rc/fe/baja/BaseEditor} the offset editor
   */
  LinearWithUnitConversionEditor.prototype.$getOffsetEditor = function () {
    return this.jq().find(".js-offset").data("widget");
  };

  /**
   * Get the applyUnitsTo editor widget
   * @returns {module:nmodule/webEditors/rc/fe/baja/OrderedMapEditor}
   */
  LinearWithUnitConversionEditor.prototype.$getApplyUnitsToEditor = function () {
    return this.jq().find(".js-applyUnitsTo").data("widget");
  };

  /**
   * The field editor is of type driver:LinearWithUnitConversion and loaded into
   * by any confirming types. The loaded in value is then set as default
   * values of the scale and offset widgets.
   *
   * @param {baja.Simple} value `driver:LinearWithUnitConversion` instance to load
   * @return {Promise}
   */
  LinearWithUnitConversionEditor.prototype.doLoad = function (value) {
    var vals = value.encodeToString() === "" ? [1, 0, 'false'] : value.encodeToString().split(";");
    return Promise.all([this.$getScaleEditor().load(parseFloat(vals[0])), this.$getOffsetEditor().load(parseFloat(vals[1])), this.$getApplyUnitsToEditor().setSelectedValue(vals[2] === 'true', true)]);
  };

  /**
   * driver:LinearWithUnitConversion is the type that is set so it matches
   * the loaded in value type.
   *
   * @returns {Promise} promise to be resolved with the current value
   */
  LinearWithUnitConversionEditor.prototype.doRead = function () {
    return Promise.all([this.$getScaleEditor().read(), this.$getOffsetEditor().read(), this.$getApplyUnitsToEditor().read()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 3),
        scale = _ref2[0],
        offset = _ref2[1],
        applyUnitsTo = _ref2[2];
      return baja.$("driver:LinearWithUnitConversion", scale, offset, applyUnitsTo);
    });
  };

  /**
   * Enables or disables the scale and offset text boxes.
   *
   * @param {Boolean} enabled
   */
  LinearWithUnitConversionEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };

  /**
   * Disables or enables the scale and offset text boxes.
   *
   * @param {Boolean} readonly
   */
  LinearWithUnitConversionEditor.prototype.doReadonly = function (readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };

  /**
   * Destroy all the child editors
   * @returns {*}
   */
  LinearWithUnitConversionEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };
  return LinearWithUnitConversionEditor;
});
//# sourceMappingURL=LinearWithUnitConversionEditor.js.map
