function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

define(['baja!', 'baja!control:TimeTrigger,driver:AbstractDescriptor,nss:SecurityDashboardDeviceExt', 'lex!nss', 'nmodule/webEditors/rc/wb/mgr/model/columns/MixinPropMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column'], function (baja, types, lexs, MixinPropMgrColumn, Column) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    nssLex = _lexs[0],
    _Column$flags = Column.flags,
    EDITABLE = _Column$flags.EDITABLE,
    UNSEEN = _Column$flags.UNSEEN,
    ABSTRACT_DESCRIPTOR = baja.lt('driver:AbstractDescriptor'),
    SECURITY_DASHBOARD_DEVICE_EXT = baja.lt('nss:SecurityDashboardDeviceExt'),
    TIME_TRIGGER_TYPE = baja.lt('control:TimeTrigger');

  /**
   * API Status: **Private**
   * @exports nmodule/nss/rc/fe/securityDashboardMgrAgent
   */
  var exports = {};
  exports.getColumns = function () {
    return [new MixinPropMgrColumn('secDashImportStatus', SECURITY_DASHBOARD_DEVICE_EXT, 'dataImporter/status', {
      type: ABSTRACT_DESCRIPTOR,
      displayName: nssLex.get('securityDashboardMgrCol.status'),
      flags: UNSEEN
    }), new MixinPropMgrColumn('secDashImportState', SECURITY_DASHBOARD_DEVICE_EXT, 'dataImporter/state', {
      type: ABSTRACT_DESCRIPTOR,
      displayName: nssLex.get('securityDashboardMgrCol.state'),
      flags: UNSEEN
    }), new MixinPropMgrColumn('secDashImportEnabled', SECURITY_DASHBOARD_DEVICE_EXT, 'dataImporter/enabled', {
      type: ABSTRACT_DESCRIPTOR,
      displayName: nssLex.get('securityDashboardMgrCol.enabled'),
      flags: EDITABLE | UNSEEN
    }), new MixinPropMgrColumn('secDashImportTime', SECURITY_DASHBOARD_DEVICE_EXT, 'dataImporter/executionTime/triggerMode', {
      type: TIME_TRIGGER_TYPE,
      displayName: nssLex.get('securityDashboardMgrCol.executionTime'),
      flags: EDITABLE | UNSEEN
    }), new MixinPropMgrColumn('secDashImportLastAttempt', SECURITY_DASHBOARD_DEVICE_EXT, 'dataImporter/lastAttempt', {
      type: ABSTRACT_DESCRIPTOR,
      displayName: nssLex.get('securityDashboardMgrCol.lastAttempt'),
      flags: UNSEEN
    }), new MixinPropMgrColumn('secDashImportLastSuccess', SECURITY_DASHBOARD_DEVICE_EXT, 'dataImporter/lastSuccess', {
      type: ABSTRACT_DESCRIPTOR,
      displayName: nssLex.get('securityDashboardMgrCol.lastSuccess'),
      flags: UNSEEN
    }), new MixinPropMgrColumn('secDashImportLastFailure', SECURITY_DASHBOARD_DEVICE_EXT, 'dataImporter/lastFailure', {
      type: ABSTRACT_DESCRIPTOR,
      displayName: nssLex.get('securityDashboardMgrCol.lastFailure'),
      flags: UNSEEN
    }), new MixinPropMgrColumn('secDashImportFaultCause', SECURITY_DASHBOARD_DEVICE_EXT, 'dataImporter/faultCause', {
      type: ABSTRACT_DESCRIPTOR,
      displayName: nssLex.get('securityDashboardMgrCol.faultCause'),
      flags: UNSEEN
    })];
  };

  /**
   * @param {baja.Component} component
   * @returns {Promise.<Array.<baja.Component>>}
   * @since Niagara 4.13
   */
  exports.getSubscriptionComponents = function (component) {
    var dataImporter, executionTime;
    return component.loadSlots().then(function () {
      dataImporter = component.getDataImporter();
      return dataImporter.loadSlots();
    }).then(function () {
      executionTime = dataImporter.getExecutionTime();
      return [dataImporter, executionTime];
    });
  };
  return exports;
});
