function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */
/**
 * API Status: **Private**
 * @module nmodule/nss/rc/fe/SecurityDashboard
 */
define(['baja!', 'baja!nss:SecurityDashboardViewMode', 'lex!nss', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/commands/ToggleCommandGroup', 'bajaux/util/CommandButtonGroup', 'dialogs', 'Promise', 'underscore', 'nmodule/nss/rc/fe/SourceCollectionWidget', 'nmodule/nss/rc/rpc/rpc', 'nmodule/nss/rc/rpc/StationDashboardService', 'nmodule/nss/rc/rpc/SystemDashboardService', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/util/htmlUtils'], function (baja, types, lexs, Widget, Command, ToggleCommandGroup, CommandButtonGroup, dialogs, Promise, _, SourceCollectionWidget, rpc, StationDashboardService, SystemDashboardService, BaseWidget, fe, htmlUtils) {
  'use strict';

  var DELAY = 200;
  var _lexs = _slicedToArray(lexs, 1),
    nssLex = _lexs[0];
  var escapeHtml = htmlUtils.escapeHtml;
  var UNSPECIFIED_VIEW = 'unspecifiedView';
  var STATION_VIEW = 'stationView';
  var SYSTEM_VIEW = 'systemView';
  var tpl = function tpl() {
    return "\n    <div class=\"CommandButtonGroup\"></div>\n    <div class=\"SourceCollectionWidget\"></div>\n  ";
  };

  /**
   * @class
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   * @alias module:nmodule/nss/rc/fe/SecurityDashboard
   */
  return /*#__PURE__*/function (_BaseWidget) {
    function SecurityDashboard(params) {
      var _this;
      _classCallCheck(this, SecurityDashboard);
      _this = _callSuper(this, SecurityDashboard, [_.extend({
        moduleName: 'nss',
        keyName: 'SecurityDashboardView'
      }, params)]);
      _this.properties().addAll({
        name: 'mode',
        typeSpec: 'nss:SecurityDashboardViewMode',
        value: UNSPECIFIED_VIEW
      }, {
        name: 'selectedMode',
        typeSpec: 'nss:SecurityDashboardViewMode',
        value: UNSPECIFIED_VIEW,
        parameter: true,
        // makes configurable as part of a view query
        hidden: true,
        "transient": true
      });
      _this.$viewSelectorGroup = null;
      _this.$dashboardService = null;
      return _this;
    }

    /**
     * @param {JQuery} dom
     */
    _inherits(SecurityDashboard, _BaseWidget);
    return _createClass(SecurityDashboard, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        dom.html(tpl()).addClass('SecurityDashboard');
        this.getCommandGroup().add(new Command({
          module: 'nss',
          lex: 'SecurityDashboardView.refreshCommand',
          func: function func() {
            return _this2.load(_this2.value());
          }
        }));
        return new CommandButtonGroup({
          properties: {
            toolbar: true
          }
        }).initialize(dom.children('.CommandButtonGroup'));
      }

      /**
       * @param {baja.Component} component
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(component) {
        var _this3 = this;
        var ord = component.getNavOrd();
        return showLoadingWhile(rpc.getDashboardStatus(ord).then(function (dashboardStatus) {
          return _this3.$applyDashboardStatus(dashboardStatus);
        })["catch"](function (err) {
          _this3.jq().html("<h1>".concat(escapeHtml(err.message), "</h1>"));
        }).then(function (initialView) {
          return initialView && _this3.$initializeView(initialView);
        }));
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('SecurityDashboard');
        return this.getChildWidgets().destroyAll();
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        return this.getChildWidgets().layoutAll();
      }

      /**
       * @private
       * @param {object} params the result of a call to `getDashboardStatus`
       * @returns {Promise.<string>} the view type that should be initially shown
       */
    }, {
      key: "$applyDashboardStatus",
      value: function $applyDashboardStatus(_ref) {
        var _this4 = this;
        var stationDashboardStatus = _ref.stationDashboardStatus,
          systemDashboardStatus = _ref.systemDashboardStatus;
        var stationEnabled = stationDashboardStatus === 'enabled';
        var systemEnabled = systemDashboardStatus === 'enabled';
        if (!stationEnabled && !systemEnabled) {
          throw new Error(nssLex.get('SecurityDashboardView.noViewsAvailable'));
        }
        var configuredMode = this.$getConfiguredMode();
        var selectedMode = this.$getSelectedMode() || configuredMode || systemEnabled && SYSTEM_VIEW || stationEnabled && STATION_VIEW;
        if (selectedMode === SYSTEM_VIEW && !systemEnabled) {
          selectedMode = STATION_VIEW;
        }
        if (selectedMode === STATION_VIEW && !stationEnabled) {
          selectedMode = SYSTEM_VIEW;
        }
        var isStationView = selectedMode === STATION_VIEW;
        var commands;
        if (stationEnabled && systemEnabled && !configuredMode) {
          commands = [{
            module: 'nss',
            lex: "SecurityDashboardView.commands.systemView",
            value: SYSTEM_VIEW,
            selected: !isStationView
          }, {
            module: 'nss',
            lex: "SecurityDashboardView.commands.stationView",
            value: STATION_VIEW,
            selected: isStationView
          }];
        } else {
          commands = [];
        }
        var viewSelectorGroup = this.$viewSelectorGroup = new ToggleCommandGroup({
          onChange: function onChange(mode) {
            if (mode !== _this4.$getSelectedMode()) {
              return _this4.$switchView(mode);
            }
          },
          commands: commands
        });
        return this.$getViewSelectorButtonGroup().load(viewSelectorGroup).then(function () {
          return selectedMode;
        });
      }

      /**
       * Set up the dashboard service and load the appropriate data for system or
       * station view.
       * @param {string} mode
       * @returns {Promise}
       */
    }, {
      key: "$initializeView",
      value: function $initializeView(mode) {
        var ord = this.value().getNavOrd().relativizeToSession();
        var dashboardService = this.$dashboardService = makeDashboardService(mode);
        var existing = this.$getSourceCollectionWidget();
        var sourceCollectionElement = this.$getSourceCollectionElement();
        this.jq().toggleClass('system-view', mode === SYSTEM_VIEW);
        this.$setSelectedMode(mode);
        return Promise.resolve(existing && existing.destroy()).then(function () {
          return dashboardService.getSourceCollection(ord);
        }).then(function (sourceCollection) {
          return fe.buildFor({
            type: SourceCollectionWidget,
            dom: sourceCollectionElement,
            value: sourceCollection,
            properties: {
              dashboardService: dashboardService
            }
          });
        });
      }

      /**
       * Switch to Station or System view. Should only be called if already
       * initialized with a particular view type.
       * @param {string} mode
       * @returns {Promise}
       */
    }, {
      key: "$switchView",
      value: function $switchView(mode) {
        return showLoadingWhile(this.$initializeView(mode));
      }

      /**
       * @private
       * @returns {module:nmodule/nss/rc/rpc/rpc.IDashboardService}
       */
    }, {
      key: "$getDashboardService",
      value: function $getDashboardService() {
        return this.$dashboardService;
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getRefreshCommand",
      value: function $getRefreshCommand() {
        return this.getCommandGroup().get(0);
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getSourceCollectionElement",
      value: function $getSourceCollectionElement() {
        return this.jq().children('.SourceCollectionWidget');
      }

      /**
       * @private
       * @returns {module:nmodule/nss/rc/fe/SourceCollectionWidget}
       */
    }, {
      key: "$getSourceCollectionWidget",
      value: function $getSourceCollectionWidget() {
        return Widget["in"](this.$getSourceCollectionElement());
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command|null} command to switch to
       * Station View, or null if Station View is disabled
       */
    }, {
      key: "$getStationViewCommand",
      value: function $getStationViewCommand() {
        return this.$viewSelectorGroup.get(1);
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command|null} command to switch to
       * System View, or null if System View is disabled
       */
    }, {
      key: "$getSystemViewCommand",
      value: function $getSystemViewCommand() {
        return this.$viewSelectorGroup.get(0);
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButtonGroup}
       */
    }, {
      key: "$getViewSelectorButtonGroup",
      value: function $getViewSelectorButtonGroup() {
        return Widget["in"](this.jq().children('.CommandButtonGroup'));
      }

      /**
       * @private
       * @returns {string|null} a `nss:SecurityDashboardViewMode` tag indicating
       * the currently selected mode (selectable by the user)
       */
    }, {
      key: "$getSelectedMode",
      value: function $getSelectedMode() {
        var mode = this.properties().getValue('selectedMode');
        return mode !== UNSPECIFIED_VIEW && mode;
      }

      /**
       * @private
       * @param {string} mode
       */
    }, {
      key: "$setSelectedMode",
      value: function $setSelectedMode(mode) {
        this.properties().setValue('selectedMode', mode);
      }

      /**
       * @private
       * @returns {string|null} a `nss:SecurityDashboardViewMode` tag indicating
       * the configured mode (not selectable by the user; if present will force
       * the dashboard into that mode)
       */
    }, {
      key: "$getConfiguredMode",
      value: function $getConfiguredMode() {
        var mode = this.properties().getValue('mode');
        return mode !== UNSPECIFIED_VIEW && mode;
      }

      /**
       * @private
       * @param {string} mode
       */
    }, {
      key: "$setConfiguredMode",
      value: function $setConfiguredMode(mode) {
        this.properties().setValue('mode', mode);
      }
    }]);
  }(BaseWidget);
  function showLoadingWhile(prom) {
    dialogs.showLoading(DELAY, prom);
    return prom;
  }

  /**
   * @param {string} viewType
   * @returns {module:nmodule/nss/rc/rpc/rpc.IDashboardService}
   */
  function makeDashboardService(viewType) {
    switch (viewType) {
      case STATION_VIEW:
        return new StationDashboardService();
      case SYSTEM_VIEW:
        return new SystemDashboardService();
      default:
        throw new Error('unknown view type ' + viewType);
    }
  }
});
