/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/hierarchy/rc/bs/RoleHierarchies
 */
define(['baja!', 'baja!baja:AdminRole', 'lex!hierarchy'], function (baja, types, lexs) {
  'use strict';

  var Component = baja.Component,
    hLex = lexs[0],
    ADMIN_HIERARCHIES = hLex.get('roleHierarchiesFE.allHierarchies'),
    DELIMITER_REGEX = /,/g,
    NAMES_DELIMITER_DISPLAY = ', ';

  /**
   * BajaScript representation of a `hierarchies:RoleHierarchies` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/hierarchy/rc/bs/RoleHierarchies}
   */
  var RoleHierarchies = function RoleHierarchies() {
    Component.apply(this, arguments);
  };
  RoleHierarchies.prototype = Object.create(Component.prototype);
  RoleHierarchies.prototype.constructor = RoleHierarchies;
  RoleHierarchies.prototype.toString = function () {
    return this.getHierarchyNamesDisplay();
  };
  RoleHierarchies.prototype.$isOnAdminRole = function () {
    return baja.hasType(this.getParent(), 'baja:AdminRole');
  };
  RoleHierarchies.prototype.getDisplay = function (slot) {
    if (String(slot) === 'hierarchyNames') {
      return this.$isOnAdminRole() ? ADMIN_HIERARCHIES : baja.SlotPath.unescape(this.get('hierarchyNames')).replace(DELIMITER_REGEX, NAMES_DELIMITER_DISPLAY);
    }
    return Component.prototype.getDisplay.apply(this, arguments);
  };
  return RoleHierarchies;
});
