/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/ace/rc/aceComponentMenuAgent
 */
define(['nmodule/webEditors/rc/wb/menu/componentMenuAgent'], function (componentMenuAgent) {
  'use strict';

  var IS_COMPOSITE_COMMAND = componentMenuAgent.IS_COMPOSITE_COMMAND,
    IS_EDIT_TAGS_COMMAND = componentMenuAgent.IS_EDIT_TAGS_COMMAND,
    IS_NEW_COMMAND = componentMenuAgent.IS_NEW_COMMAND,
    IS_WIRESHEET_VIEW_COMMAND = componentMenuAgent.IS_WIRESHEET_VIEW_COMMAND;
  return function acePointManagerMenuAgent(widget, navNode) {
    // use componentMenuAgent to generate the standard context menu items
    return componentMenuAgent(widget, navNode).then(function (cmdGroup) {
      var newCmd = cmdGroup.findCommand(IS_NEW_COMMAND),
        editTagsCmd = cmdGroup.findCommand(IS_EDIT_TAGS_COMMAND),
        compositeCmd = cmdGroup.findCommand(IS_COMPOSITE_COMMAND),
        wiresheetViewCmd = cmdGroup.findCommand(IS_WIRESHEET_VIEW_COMMAND);
      return cmdGroup.remove(wiresheetViewCmd, newCmd, editTagsCmd, compositeCmd);
    });
  };
});
