/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */

/* jshint maxerr:1000 */


/**
 * JavaScript support for BHxSmartTableView.
 */

/**
 * Convenience for <code>document.getElementById(id) or document.getElementsByName(id)[0]</code>.
 * <p>
 * This method is deprecated. It's recommended to use the scoped smartTable.$$ method instead.
 *
 * @see smartTable#$$
 *
 * @deprecated
 */
function $$(id) {  //jshint ignore:line
  "use strict";
  var elem = document.getElementById(id);
  if (elem === null) {
    elem = document.getElementsByName(id)[0];
  }
  return elem;
}

var smartTable = new SmartTable();
function SmartTable() {
  this.loadingId = 0;
  this.forceRightClick = false;
  this.rightClickRow = null;
  this.selectAnchor = null;

  /**
   * Convenience for <code>document.getElementById(id) or document.getElementsByName(id)[0]</code>.
   */
  this.$$ = function(id) {
    var elem = document.getElementById(id);
    if (elem === null) {
      elem = document.getElementsByName(id)[0];
    }
    return elem;
  };

  this.addClick = function(table) {
    if (hx.ie){
      document.attachEvent("onmousedown", this.unselect);
      table.attachEvent("onmousedown", this.select);
      table.attachEvent("onselectstart", this.disableSelection);
      table.attachEvent("oncontextmenu", this.contextMenu);
      table.attachEvent("ondblclick", this.doubleClick);
    }
    else{
      document.addEventListener("mousedown", this.unselect, false);
      table.addEventListener("mousedown", this.select, false);
      table.addEventListener("contextmenu", this.contextMenu, false);
      table.addEventListener("dblclick", this.doubleClick, false);
    }
  };

  this.contextMenu = function(e) {
    smartTable.forceRightClick = true;
    smartTable.select(e);
    smartTable.forceRightClick = false;

    if (!hx.ie) {
      e.preventDefault();
    }
    return false;
  };

  //go to the parent until you find the scope
  this.elemFromEvent = function(event) {
    if (hx.ie) {
      return event.srcElement;
    } else {
      return event.target;
    }
  };

  this.scopeEvent = function(event) {
    return smartTable.scope(smartTable.elemFromEvent(event));
  };


  /**
   * Go to the parent until you find the scope
   * @param {Object} elem
   * @returns {String}
   */
  this.scope = function(elem) {
    if (elem === null) {
      return null;
    }
    while(elem.id.indexOf("commands") === -1 && elem.id.indexOf("records") === -1){
      elem = elem.parentNode;
      if (elem == null) {
        return null;
      }
    }

    var i = elem.id.indexOf("commands");
    if (i !== -1) {
      return elem.id.substring(0, i);
    }

    i = elem.id.indexOf("records");
    if (i !== -1) {
      return elem.id.substring(0, i);
    }
  };

  //get the parent table
  this.getTableElem = function(elem) {
    while(elem.id.indexOf("records") === -1){
      elem = elem.parentNode;
      if (elem === null) {
        return null;
      }
    }
    return elem;
  };

  //save the double click command
  this.doubleClick = function(e) {
    var scope = smartTable.scopeEvent(e);
    var selectionCountElem = smartTable.$$(scope + "selectionCount");
    var selectionCount = parseInt(selectionCountElem.value);
    if (selectionCount !== 1) {
      return;
    }
    var td = smartTable.elemFromEvent(e),
      tr = td.parentNode;
    if (tr.className.indexOf("row") === -1) {
      return;
    }

    var event = smartTable.$$(smartTable.scopeEvent(e) + "doubleClick");
    if (event && event.value.length > 0){
      var split = event.value.split("|");
      if (split[0].length > 0) {
        hx.fireEvent(split[0], split[1]);
      } else {
        hx.fireEvent("*", split[1]);
      }
    }
  };

  this.add = function(elem) {
    while(elem.id === "")
      elem = elem.parentNode;

    var scope = smartTable.scope(elem);
    var selectionList = smartTable.$$(scope + "working");
    var selectionCountElem = smartTable.$$(scope + "selectionCount");
    var selectionCount = parseInt(selectionCountElem.value);
    if (selectionCount === 0)
      selectionList.value += "|";
    selectionList.value += elem.id;
    selectionList.value += "|";
    selectionCount++;
    selectionCountElem.value = "" + selectionCount;
  };

  this.remove = function(elem) {

    var scope = smartTable.scope(elem);
    while(elem.id === "")
      elem = elem.parentNode;


    var selectionListElem = smartTable.$$(scope + "working");
    var selectionList = selectionListElem.value;
    var id = "|" + elem.id + "|";
    var index = selectionList.indexOf(id);
    var length = id.length;
    var offset = 1;
    selectionList = selectionList.substring(0, index + offset) + selectionList.substring(index + length);
    selectionListElem.value = selectionList;

    var selectionCountElem = smartTable.$$(scope + "selectionCount");
    var selectionCount = parseInt(selectionCountElem.value);
    selectionCount--;
    if (selectionCount === 0)
      selectionListElem.value = "";

    selectionCountElem.value = "" + selectionCount;
    if (elem === smartTable.selectAnchor)
      smartTable.selectAnchor = null;
  };

  this.select = function(e) {
    var $ = jQuery;
    if (e.button === 2 && !smartTable.forceRightClick)
      return false;
    var td = smartTable.elemFromEvent(e);

    //start ie fix - IE insists on hilighting things even with user-select: none
    td.onselectstart = function () { return false; };
    window.setTimeout(function () { td.onselectstart = null; }, 0);
    //end ie fix

    //ie image hack
    if (td.tagName === "SPAN" && td.style.filter.length > 0){
      td = td.parentNode;
    }
    else if (td.tagName === "IMG"){
      td = td.parentNode;
      if (td.tagName === "SPAN" && td.style.filter.length > 0)
        td = td.parentNode;
    }
    var scope = smartTable.scope(td),
        tr    = td.parentNode;

    if (tr.className.indexOf("row") === -1)
      return;

    var selected  = false,
        jq        = $(tr),
        className = "";

    var hasSelectedClass = jq.hasClass("selected");
    //->selected
    if (!hasSelectedClass){

      selected = true;
      smartTable.add(td);
      jq.addClass("selected");
    }
    //->stay selected, possibly unselect others
    else if (!e.ctrlKey && smartTable.getTableElem(td).className.indexOf("check") === -1 || smartTable.forceRightClick){
      className = tr.className;
    }
    //->unselect self,
    else{
      jq.removeClass("selected");
      smartTable.remove(td);
    }


    if (e.ctrlKey || selected || (smartTable.getTableElem(td).className.indexOf("check") > -1 && !smartTable.forceRightClick)){

      if (selected){
        jq.addClass("selected");
      }
      else{
        jq.removeClass("selected");
      }
    }

    if (smartTable.selectAnchor && smartTable.scope(smartTable.selectAnchor) !== scope)
      smartTable.selectAnchor = null;

    if (!e.shiftKey || smartTable.selectAnchor === null)
      smartTable.selectAnchor = tr;

    if (e.shiftKey && smartTable.selectAnchor)
      smartTable.shift(tr);

    if (!e.ctrlKey && !e.shiftKey && !smartTable.forceRightClick && (e.button !== 2 || selected) &&
      smartTable.getTableElem(td).className.indexOf("check") === -1){
      //remove
      smartTable.rightClickRow = tr;
      var anchorTr = tr;
      while(tr.previousSibling){
        tr = tr.previousSibling;
        //skip headers
        if (tr.className.indexOf("row") !== -1)
          smartTable.fixRows(tr);
      }

      tr = anchorTr;
      while(tr.nextSibling){
        tr = tr.nextSibling;
        smartTable.fixRows(tr);
      }
    }

    smartTable.setForm(scope);

   scope = smartTable.scope(smartTable.elemFromEvent(e));
    var commands = smartTable.fixCommands(scope);
    //right click
    if (e.button === 2 || smartTable.forceRightClick){
      smartTable.showRightClickMenu(e, commands);

      if (!hx.ie)
        e.preventDefault();
      return false;
    }
  };

  this.setForm = function(scope) {
    if (parseInt(smartTable.$$(scope + "selectionCount").value) > 0){
      var value = smartTable.$$(scope + "working").value;
      if (value.length > 1)
        smartTable.$$(scope + "selectionList").value = value.substring(1, value.length - 1);
      else
        smartTable.$$(scope + "selectionList").value = "";
    }
    else
      smartTable.$$(scope + "selectionList").value = "";
  };

  this.shift = function(tr) {
    var start = smartTable.selectAnchor.rowIndex;
    var end = tr.rowIndex;
    if (start > end){
      var temp = end;
      end = start;
      start = temp;
    }

    var anchorTr = tr;
    while(tr.previousSibling){
      tr = tr.previousSibling;
      //skip headers
      if (tr.className.indexOf("row") !== -1)
        smartTable.fixShiftRows(tr, start, end);
    }

    tr = anchorTr;
    while(tr.nextSibling){
      tr = tr.nextSibling;
      smartTable.fixShiftRows(tr, start, end);
    }

  };


  this.fixShiftRows = function (tr, start, end) {
    var select = false,
      $ = jQuery;
    if (tr.rowIndex >= start && tr.rowIndex <= end) {
      select = true;
    }
    var jq = $(tr);

    var hasSelectedClass = jq.hasClass("selected");
    if (!hasSelectedClass && select) {
      smartTable.add(tr);
      jq.addClass("selected");
    } else if (hasSelectedClass && !select) {
      jq.removeClass("selected");
      smartTable.remove(tr);
    } else {
      return;
    }
  };

  this.fixRows = function(tr) {
    var $         = jQuery,
        jq        = $(tr);

    var hasSelectedClass = jq.hasClass("selected");
    if (!hasSelectedClass)
      return;
    else{
      smartTable.remove(tr);
      jq.removeClass("selected");
    }
  };

  this.unselect = function(event) {

    try{
      var elem = smartTable.elemFromEvent(event);
      //a table unselects itself if the user user clicks in
      //an element designated by the "unselect" css className
      if (elem.className === "unselect"){
        smartTable.unselectFromElem(elem);
      }
    }
    catch(err){
    }
  };

  this.unselectFromElem = function(elem) {
    var $              = jQuery,
        selectionLists = smartTable.findInputWithName("selectionList");
    var i;
    for(i = 0; i < selectionLists.length; i++)
      selectionLists[i].value = "";

    var selectionCounts = smartTable.findInputWithName("selectionCount");
    for(i = 0; i < selectionCounts.length; i++)
      selectionCounts[i].value = "0";

    var workings = smartTable.findInputWithName("working");
    for(i = 0; i < workings.length; i++){
      workings[i].value = "";
    }

    smartTable.closeMenu();

    var trs = elem.getElementsByTagName("tr");
    for(i = 0; i < trs.length; i++){
      var tr = trs[i],
          jq = $(tr);
      var hasSelectedClass = jq.hasClass("selected");
      if (hasSelectedClass){
        jq.removeClass("selected");
        smartTable.fixCommands(this.scope(tr));
      }
    }
  };

  /**
   * Will add or remove 'selected' className to tr and can add a specified className to all tds.
   * @param {HTMLElement} elem
   * @param {String} [additionalClassName] adds a className to all tds, when empty will remove all existing classNames on tds
   * @param {boolean} selected
   */
  this.styleRow = function (elem, additionalClassName, selected) {
    var $ = jQuery,
      tr = $(elem),
      tds = tr.find('td');


    if (additionalClassName) {
      tds.addClass(additionalClassName);
    } else {
      tds.removeClass();
    }


    if (selected) {
      tr.addClass("selected");
    } else {
      tr.removeClass("selected");
    }
  };

  /**
   * Will remove all classNames from tds and will toggle tr 'selected' class.
   * @param {HTMLElement} elem
   * @param {boolean} selected
   */
  this.unstyleRow = function (elem, selected) {
    this.styleRow(elem, "", selected);
  };

  /**
   *  Unselects the records in the table with the given scope.
   * @param {String} scope
   */
  this.unselectScope = function(scope) {

    if (scope && !scope.match(/\.$/) ) {
      scope += ".";
    }
    //a table unselects itself if the user user clicks in the outer portions of the html,
    //or in an element designated by the "unselect" css className
    smartTable.$$(scope + "selectionList").value = "";
    smartTable.$$(scope + "selectionCount").value = "0";
    smartTable.$$(scope + "working").value = "";
    smartTable.selectAnchor = null;
    smartTable.rightClickRow = null;
    smartTable.fixCommands(scope);
  };


  this.disableSelection = function(e) {

    if (!hx.ie && e)
      e.preventDefault();
    return smartTable.endEvent(e);
  };

  this.endEvent = function(event) {
    if (event == null)
      return false;
    if (event.stopPropagation)
      event.stopPropagation();
    else
      event.cancelBubble = true;

    event.returnValue = false;
    return false;
  };


  this.showRightClickMenu = function(event, commands) {
    var $ = jQuery;
    smartTable.closeMenu();

    //way to check if commands is empty (dont show dialog)
    if (commands.length === 0 || (commands.length == 1 && commands[0] == "0"))
      return false;

    var mx;
    var my;
    if (!event.target){
      mx = event.clientX + document.body.scrollLeft;
      my = event.clientY + document.body.scrollTop;
    }
    else{
      mx = event.pageX - 5;
      my = event.pageY - 5;
    }

    var menu = document.createElement("ul");
    menu.className = "context-menu-list context-menu-root";
    menu.id = hx.menuId;
    menu.style.position = "absolute";
    menu.style.left = mx + "px";
    menu.style.top = my + "px";
    menu.style.zIndex = 99;
    document.body.appendChild(menu);

    for(var i = 0; i < commands.length; i++){
      var menuItem = document.createElement("li");
      menuItem.className = "context-menu-item";
      menuItem.innerHTML = $(commands[i]).clone().html();
      if (menuItem.firstChild.nextSibling == null){
        var text = document.createElement("span");
        text.textContent = " " + commands[i].title;
        menuItem.appendChild(text);
      }

      var imgs = menuItem.getElementsByTagName('img');
      if (imgs.length === 1)
        imgs[0].title = "";

      menu.appendChild(menuItem);

      if (hx.ie){
        menuItem.attachEvent("onmouseover", smartTable.menuOver);
        menuItem.attachEvent("onmouseout", smartTable.menuOut);
        menuItem.attachEvent("onclick", commands[i].onclick);
      }
      else{
        menuItem.addEventListener("mouseover", smartTable.menuOver, false);
        menuItem.addEventListener("mouseout", smartTable.menuOut, false);
        menuItem.addEventListener("click", commands[i].onclick, false);
      }
    }

    if (hx.ie)
      menu.attachEvent("oncontextmenu", smartTable.disableSelection);
    else
      menu.addEventListener("contextmenu", smartTable.disableSelection, false);
  };

  this.menuOver = function(e) {
    var elem,
        $ = jQuery;
    if (hx.ie) elem = e.srcElement;else elem = e.target;

    $(elem).closest('li').addClass("hover");
  };

  this.menuOut = function(e) {
    var elem,
        $ = jQuery;
    if (hx.ie) {
      elem = e.srcElement;
    } else {
      elem = e.target;
    }

    $(elem).closest('li').removeClass("hover");
  };


  this.closeMenu = function() {
    var menu = smartTable.$$(hx.menuId);
    if (menu != null) {
      menu.parentNode.removeChild(menu);
    }
  };

  this.changeLabel = function(elemName, oldDisplay, newDisplay) {
    var commands = document.getElementsByName(elemName);
    for(var i = 0; i < commands.length; i++){
      var index = commands[i].textContent.indexOf(oldDisplay);
      if (index !== -1){
        commands[i].textContent = commands[i].textContent.replace(oldDisplay, newDisplay);
        return;
      }
    }
  };

  this.syntheticMouseDown = function(elem) {
    var e;
    if (hx.ie){
      e = document.createEventObject();
      elem.fireEvent('onmousedown', e);
    }
    else {
      e = document.createEvent("MouseEvents");
      e.initEvent('mousedown', true, true);
      elem.dispatchEvent(e);
    }
  };

/* Is this used anywhere? Can't find any references in either Java or JS */
  this.showContextMenu = function(scope, event, overrideSelectCount) {
    var commands = smartTable.fixCommands(scope, overrideSelectCount);
    smartTable.showRightClickMenu(event, commands);
    return smartTable.endEvent(event);
  };


  this.fixCommands = function(scope, overrideCount) {
    if (scope && !scope.match(/\.$/) ) {
        scope += ".";
    }
    var commands      = [],
        classScope    = scope.split('.').join('-');


    var count;
    if (overrideCount != null) {
      count = overrideCount;
    } else {
      count = parseInt(smartTable.$$(scope + "selectionCount").value);
    }

    classScope = hx.escapeSelector(classScope);

    Array.prototype.push.apply(commands, this.getCommands("." + classScope + 'singleSelection', count===1));
    Array.prototype.push.apply(commands, this.getCommands("." + classScope + 'anySelection', count>0));
    Array.prototype.push.apply(commands, this.getCommands("." + classScope + 'doubleSelection', count===2));
    Array.prototype.push.apply(commands, this.getCommands("." + classScope + 'multiSelection', count>1));
    Array.prototype.push.apply(commands, this.getCommands("." + classScope + 'alwaysOrAnySelection', true));

    smartTable.fixCommandEvent(scope);

    return commands;
  };


  /**
   * Get the Commands given the properly escaped selector and set enabled
   * based on the eanbledPolicy attribute and parameter
   * @param {String} selector
   * @param {boolean} enabled
   * @returns {Array}
   */
  this.getCommands = function(selector, enabled) {
    var $ = jQuery;
    var commands = [];
    var collection = $(selector);
    collection.each(function(i, val) {
      var policy = val.getAttribute('enablePolicy'),
          eachEnabled = enabled;
      if (policy) {
        eachEnabled = eval(policy);
      }

      smartTable.toggleEnable(collection[i], eachEnabled);

      if (eachEnabled){
        commands.push(collection[i]);
      }
    });
    return commands;
  };


  this.toggleEnable = function(elem, enabled) {
    var $  = jQuery,
        jq = $(elem);
    var hasDisabledClass = jq.hasClass("ux-disabled");
    if (enabled && hasDisabledClass){
      jq.removeClass("ux-disabled");
      jq.prop('disabled', false);
    }
    else if (!hasDisabledClass && !enabled){
      jq.addClass("ux-disabled");
      jq.prop('disabled', true);
    }
  };


  this.fixCommandEvent = function(scope) {
    var event = smartTable.$$(scope + "fixCommandEvent");
    if (event != null)
      eval(event.value);
  };

  this.findInputByName = function(key) {
    var inputs = document.body.getElementsByTagName("input");

    for(var i = 0; i < inputs.length; i++){
      if (inputs[i].name == key){
        return inputs[i];
      }
    }
    return null;
  };


  this.findInputWithName = function(key) {
    var matched = [0];
    var matchedAmount = 0;
    var inputs = document.body.getElementsByTagName("input");

    for(var i = 0; i < inputs.length; i++){
      if (inputs[i].name.indexOf(key) > -1){
        matched[matchedAmount] = inputs[i];
        matchedAmount++;
      }
    }

    inputs = document.body.getElementsByTagName("select");

    for(var i = 0; i < inputs.length; i++){
      if (inputs[i].name.indexOf(key) > -1){
        matched[matchedAmount] = inputs[i];
        matchedAmount++;
      }
    }
    return matched;
  };

  this.disable = function(scope, checked) {
    var inputs = smartTable.findInputWithName(scope);
    for(var i = 0; i < inputs.length; i++){

      try{
        if (inputs[i].getAttribute("locked") != null)
          continue;
      }
      catch(err){
      }

      smartTable.disableInput(inputs[i], checked);
    }
  };

  this.disableInput = function(input, checked) {
    if (input.type == "text"){
      if (checked)
        input.readOnly = "";
      else
        input.readOnly = "readOnly";
    }
    else if (input.type != "hidden"){
      if (checked)
        input.disabled = "";
      else
        input.disabled = "disabled";
    }
  };

  this.resetTable = function(scope) {
    var table = smartTable.$$(scope + ".records");
    var tableLength = table.rows.length;
    for(var i = 1; i < tableLength; i++)
      table.deleteRow(-1);
  };

  this.setTitle = function(title, scope) {
    var elem = smartTable.$$(scope + ".title");
    elem.innerHTML = title;
  };
////////////////////////////////////////////////////////////////
// loading resources
////////////////////////////////////////////////////////////////
  this.addJavaScript = function(resourceString) {
    var resource = document.createElement("script");
    resource.type = "text/javascript";
    resource.src = "/ord?" + resourceString;
    var head = document.getElementsByTagName("head")[0];
    head.appendChild(resource);
  };

  this.addStyleSheet = function(resourceString) {
    var resource = document.createElement("link");
    resource.rel = "stylesheet";
    resource.type = "text/css";
    resource.href = "/ord?" + resourceString;
    var head = document.getElementsByTagName("head")[0];
    head.appendChild(resource);
  };

////////////////////////////////////////////////////////////////
// loading progress bar
////////////////////////////////////////////////////////////////
  this.checkLoading = function(loading, records) {
    if (loading == null)
      return false;
    if (records.className.indexOf("loaded") == -1){
      loading.innerHTML = "Loading.";
      return true;
    }
    return false;
  };

  this.startLoading = function(span) {
    if (span == null)
      return;
    var text = span.innerHTML;
    this.loadingId++;
    var id = this.loadingId;
    span.loadingId = id;

    var speed = 100;

    if (text.indexOf('.') == -1 || text.indexOf("Error") > -1 || text.indexOf("Paused") > -1 || text.indexOf("Warning") > -1){
      span.style.color = "black";
      span.parentNode.style.width = "222px";
      text = "Loading.";
    }
    else if (text == "&nbsp;")
      text = "Loading.";

    span.className = 'smartTable-loading';


    if (text.length < 15){
      text += ".";
      span.innerHTML = text;
    }

    setTimeout("smartTable.loading(smartTable.$$('" + span.id + "')," + speed + "," + id + ");", speed);
  };

  this.loading = function(span, speed, id) {
    if (span == null)
      return;

    if (span.loadingId != id)
      return;

    var text = "";
    text = span.innerHTML;

    if (text.indexOf('.') == -1 || text.indexOf("Error") > -1 || text.indexOf("Paused") > -1 || text.indexOf("Warning") > -1){
      return;
    }

    if (text.length < 25){
      text += ".";
      span.innerHTML = text;
    }
    else
      span.innerHTML = "Loading.";

    setTimeout("smartTable.loading(smartTable.$$('" + span.id + "'), " + speed + "," + id + ");", speed);
  };

  this.loadingException = function(span, message) {
    span.innerHTML = "Error: " + message;
    span.style.color = "red";
    span.parentNode.style.width = "";
  };

  this.pause = function(span) {
    span.innerHTML = "Paused";
    span.style.color = "red";
    span.parentNode.style.width = "";
  };

  this.warning = function(span, message) {
    span.innerHTML = "Warning: " + message;
    span.style.color = "red";
    span.parentNode.style.width = "";
  };


////////////////////////////////////////////////////////////////
// Sort
////////////////////////////////////////////////////////////////
  this.sort = function(columnIndex, scope, up) {
    var newSortColumn = smartTable.$$(scope + columnIndex);
    var upArrow = smartTable.$$(scope + "upArrow");
    var downArrow = smartTable.$$(scope + "downArrow");
    if (up){
      upArrow.style.display = "";
      downArrow.style.display = "none";
      newSortColumn.appendChild(upArrow);
    }
    else{
      upArrow.style.display = "none";
      downArrow.style.display = "";
      newSortColumn.appendChild(downArrow);
    }
  };

////////////////////////////////////////////////////////////////
// Eventing
////////////////////////////////////////////////////////////////
  this.fireEvent = function(e, sourceId, path, eventId) {
    hx.fireEvent(path, eventId);
  };

  this.fireRowEvent = function(e, sourceId, path, eventId) {
    var td = smartTable.elemFromEvent(e),
        tr;
    if (td != null){
      tr = td.parentNode;
      if (tr.className.indexOf("row") > -1){
        hx.fireEvent(path, eventId);
      }
    }
  };

  this.addEvent = function(eventName, changeFunction, callNow, sourceId, param1, param2, param3) {
    var inputs = [];
    var names = document.getElementsByName(sourceId);
    if (names.length == 0) {
      inputs[0] = smartTable.$$(sourceId);
    } else {
      inputs = names;
    }
    for(var i = 0; i < inputs.length; i++){
      if (inputs[i]) {
        smartTable.addEventForElem(inputs[i], eventName, changeFunction, callNow && i == 0, sourceId, param1, param2, param3);
      }
    }
  };

  this.addEventForElem = function(elem, eventName, changeFunction, callNow, sourceId, param1, param2, param3) {
    var input = elem;
    //if(input == null)
    //  alert('Elem not found:' + sourceId);
    var storeName = "e" + eventName;
    while(input[storeName] != null)
      storeName = "e" + storeName

    if (hx.ie){
      input[storeName] = function() {
        eval('changeFunction(window.event, sourceId, param1, param2, param3);');
      };
      input.attachEvent('on' + eventName, input[storeName]);
      if (callNow)
        input[storeName].call(this, "", sourceId, param1, param2, param3);
    }
    else {
      input[storeName] = changeFunction;
      eval('input.addEventListener( eventName, function(event){input[storeName](event, sourceId, param1, param2, param3)}, false );');
      if (callNow)
        input[storeName].call(this, "", sourceId, param1, param2, param3);
    }
  };

  this.hideElem = function(e, sourceId, targetId, index) {
    var elem = smartTable.$$(targetId);
    var e = smartTable.$$(sourceId);
    if(elem && e) {
    if (e.value != index)
      elem.style.display = "none";
    else
      elem.style.display = "";
    }
  };

  this.matchValue = function(e, sourceId, targetId, index) {
    var elem = smartTable.$$(targetId);
    var elem2 = smartTable.$$(sourceId);
    elem.value = elem2.value;
  };

  this.matchChecked = function(e, sourceId, targetId, index) {
    var elem = smartTable.$$(targetId);
    var e = smartTable.$$(sourceId);
    elem.checked = e.checked;
  };

  this.hideChecked = function(e, sourceId, targetId, checked) {
    var elem = smartTable.$$(targetId);
    var e = smartTable.$$(sourceId);
    if ((e.checked && checked == "true") || (!e.checked && checked == "false"))
      elem.style.display = "none";
    else
      elem.style.display = "";
  };

  this.disableChecked = function(e, sourceId, targetId, checked) {

    var elem = smartTable.$$(targetId);
    var e = smartTable.$$(sourceId);

    if ((e.checked && checked == "true") || (!e.checked && checked == "false"))
      smartTable.disableInput(elem, true);
    else
      smartTable.disableInput(elem, false);
  };

  this.hideLessThanElem = function(e, sourceId, targetId, index) {
    var elem = smartTable.$$(targetId);
    var e = smartTable.$$(sourceId);
    if (parseInt(e.value) < parseInt(index))
      elem.style.display = "none";
    else
      elem.style.display = "";
  };

  this.showElem = function(e, sourceId, targetId, index) {
    var elem = smartTable.$$(targetId);
    var e = smartTable.$$(sourceId);
    if (e.value != index)
      elem.style.display = "";
    else
      elem.style.display = "none";
  };

  this.checkInput = function(inputId) {
    var input = document.getElementById(inputId);
    input.checked = "true";
  };


  this.exception = function(sourceId, error) {
    var elem = smartTable.$$(sourceId);
    if (elem == null)
      return;
    elem.firstChild.style.color = 'red';
    var td = elem.firstChild.nextSibling;
    td.style.color = 'red';
    if (elem.firstChild.nextSibling.nextSibling == null){
      var newTd = document.createElement('td');
      newTd.style.color = 'red';
      newTd.innerHTML = error;
      elem.appendChild(newTd);
    }
    else
      elem.firstChild.nextSibling.nextSibling.innerHTML = error;
  };

  this.clearException = function(sourceId) {
    var elem = smartTable.$$(sourceId);
    if (elem == null)
      return;
    elem.firstChild.style.color = "";
    var td = elem.firstChild.nextSibling;
    td.style.color = "";
    if (elem.firstChild.nextSibling.nextSibling != null)
      elem.removeChild(elem.firstChild.nextSibling.nextSibling);
  };

  this.onEnter = function(e) {
    var keycode;
    if (window.event)
      keycode = window.event.keyCode;
    else if (e)
      keycode = e.which;
    else
      return true;

    if (keycode == 13){
      smartTable.disableSelection(e)
      smartTable.endEvent(e);
      return true;
    }
    else
      return false;
  };

  this.fireOnChange = function(elem) {

    if (hx.ie){
      elem.fireEvent("onchange");
    }
    else{
      var changeEvent = document.createEvent("HTMLEvents");
      changeEvent.initEvent("change", true, true);
      elem.dispatchEvent(changeEvent);
    }
  };

  this.setFormValue = function(key, value) {
    var newLineMatch = "\\n";
    var newLine = "\n";
    value = value.replace(/\\n/g, newLine);
    hx.setFormValue(key, value);
  };

  this.registerMouseWheel = function(elem, path) {
    if (elem.registerMouseWheel != null)
      return;

    elem.registerMouseWheel = path;
    var mousewheelevt = (/Firefox/i.test(navigator.userAgent)) ? "DOMMouseScroll" : "mousewheel";
    if (elem.attachEvent)
      elem.attachEvent("on" + mousewheelevt, smartTable.mouseWheel)
    else if (elem.addEventListener)
      elem.addEventListener(mousewheelevt, smartTable.mouseWheel, false)
  };

  this.mouseWheel = function(e) {
    var event = window.event || e;
    var elem = smartTable.elemFromEvent(e);
    var path = elem.registerMouseWheel;
    if (path.length > 0)
      path += ".";
    var valueElem = smartTable.$$(path + "smartTablePage");
    var count = parseInt(smartTable.$$(path + "smartTablePageCount").value);
    var currentPage = parseInt(valueElem.value);

    var delta = event.detail ? event.detail * (-120) : event.wheelDelta;
    if (delta <= -20){
      if (currentPage >= count){
        if (event.preventDefault)
          event.preventDefault();
        return smartTable.endEvent(e);
      }
      valueElem.value = currentPage + 1;
    }
    else{
      if (currentPage <= 1){
        if (event.preventDefault)
          event.preventDefault();
        return smartTable.endEvent(e);
      }
      valueElem.value = currentPage - 1;
    }


    smartTable.fireOnChange(valueElem);
    if (event.preventDefault)
      event.preventDefault();
    return smartTable.endEvent(event);
  };

  this.showDialog = function(body, title, doneText) {
    hx.showDialog(smartTable.dialogChrome(body, title, doneText));
  };

  this.dialogChrome = function(body, title, doneText) {
    var c = "";

    c += "<table border='0' align='center' height='100%'";
    c += ">";
    c += "<tr><td valign='middle'>";
    c += "<div class='control-bg dialog-outerBorder'>";
    c += "<div class='dialog-innerBorder'>";
    c += "<div class='dialog-header'>";
    c += title;
    c += "</div>";
    c += "<div class='dialog-content'>";
    c += "<div id='dialog-maxHeight'>";
    c += body;
    c += "</div>";
    c += "</div>";
    c += "<div class='dialog-button-content-hx'>";
    c += "<input type='submit' class='button' value='" + doneText + "' onclick='hx.closeDialog(null,null,null);'/>";
    c += "</div>";
    c += "</div>";
    c += "</td></tr>";
    c += "</table>";


    return c;
  };

}
