function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/file/rc/menu/fileMenuAgent
 */
define(['baja!', 'lex!file', 'bajaux/commands/CommandGroup', 'underscore', 'nmodule/webEditors/rc/transform/ExportCommand', 'nmodule/webEditors/rc/wb/menu/menuUtils', 'nmodule/webEditors/rc/wb/menu/NewViewCommand', 'nmodule/webEditors/rc/wb/menu/Separator', 'nmodule/file/rc/commands/CreateFileCommand', 'nmodule/file/rc/commands/DeleteFileCommand', 'nmodule/file/rc/commands/MakeDirCommand', 'nmodule/file/rc/commands/RenameFileCommand', 'nmodule/file/rc/commands/UploadFileCommand'], function (baja, lexs, CommandGroup, _, ExportCommand, menuUtils, NewViewCommand, Separator, CreateFileCommand, DeleteFileCommand, MakeDirCommand, RenameFileCommand, UploadFileCommand) {
  'use strict';

  var makeViewsGroup = menuUtils.makeViewsGroup;
  var _lexs = _slicedToArray(lexs, 1),
    fileLex = _lexs[0];
  function getCommandGroup(fileNode, isReadonly) {
    return menuUtils.ifAllowedByProfile('viewSelection', function () {
      return makeViewsGroup(fileNode.getNavOrd());
    }).then(function (viewsGroup) {
      var commands = [];
      var navTypeSpec = fileNode.getNavTypeSpec();
      if (viewsGroup) {
        commands.push(viewsGroup, new Separator());
      }
      if ((navTypeSpec === 'baja:Directory' || navTypeSpec === 'baja:FileSystem') && !isReadonly) {
        var newCommandGroup = new CommandGroup({
          displayName: fileLex.get('commands.newCommandGroup.displayName'),
          commands: [new MakeDirCommand(fileNode), new Separator(), new CreateFileCommand(fileNode), new CreateFileCommand(fileNode, {
            module: "file",
            lex: "commands.createPxFile",
            suggestedName: "PxFile.px",
            contents: NewViewCommand.getDefaultPxFileContents()
          })],
          enabled: true
        });
        commands.push(newCommandGroup, new Separator(), new UploadFileCommand(fileNode));
      }
      return baja.importTypes([fileNode.getNavTypeSpec()]).then(function (types) {
        if (navTypeSpec === 'baja:Directory' || types[0].is('baja:IFile')) {
          var renameFileCmd = new RenameFileCommand(fileNode),
            deleteFileCmd = new DeleteFileCommand([fileNode]);
          renameFileCmd.setEnabled(!isReadonly);
          deleteFileCmd.setEnabled(!isReadonly);
          commands.push(renameFileCmd, deleteFileCmd);
        }
        commands.push(new Separator(), new ExportCommand(fileNode));
        return new CommandGroup({
          commands: commands
        });
      });
    });
  }

  /**
   * Menu agent for handling right-click context menus on File nodes.
   *
   * @alias module:nmodule/file/rc/menu/fileMenuAgent
   * @param {module:bajaux/Widget} widget
   * @param {baja.NavNode} fileNode
   * @returns {Promise.<module:bajaux/commands/CommandGroup>}
   * @since Niagara 4.14
   */
  return function fileMenuAgent(widget, fileNode) {
    try {
      var permissions = fileNode.getPermissions();
      return getCommandGroup(fileNode, !permissions.hasOperatorWrite());
    } catch (err) {
      return fileNode.getNavOrd().resolve().then(function (target) {
        return getCommandGroup(fileNode, !target.canWrite());
      });
    }
  };
});
