function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */
/**
 * API Status: **Private**
 * @since Niagara 4.14
 * @module nmodule/nrio/rc/wb/mgr/NrioPointUxManager
 */

define(['baja!', 'baja!driver:DefaultProxyConversion,nrio:NrioIoTypeEnum,nrio:Nrio16ModulePoints,nrio:Nrio34ModulePoints,' + 'nrio:UIPointEntry,nrio:NrioRelayOutputProxyExt,control:BooleanWritable,nrio:NrioResistiveInputProxyExt,' + 'nrio:NrioVoltageOutputProxyExt,control:NumericWritable,control:BooleanPoint,nrio:NrioVoltageInputProxyExt,' + 'control:NumericPoint,nrio:LinearCalibrationExt,nrio:NrioCounterInputProxyExt,nrio:NrioBooleanInputProxyExt', 'Promise', 'underscore', 'nmodule/driver/rc/wb/mgr/PointMgr', 'nmodule/nrio/rc/wb/mgr/NrioMgrTypeImpl', 'nmodule/nrio/rc/wb/mgr/model/NrioPointLearnModel', 'nmodule/nrio/rc/wb/mgr/model/NrioPointManagerModel', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/mgr/MgrLearn', 'nmodule/webEditors/rc/wb/mgr/commands/AllDescendantsCommand', 'nmodule/webEditors/rc/wb/mgr/commands/CancelDiscoverCommand', 'nmodule/webEditors/rc/wb/mgr/commands/NewCommand', 'nmodule/webEditors/rc/wb/mgr/commands/MatchCommand', 'nmodule/webEditors/rc/wb/tree/TreeNode', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/mgrUtils'], function (baja, types, Promise, _, PointMgr, NrioMgrTypeImpl, NrioPointLearnModel, NrioPointManagerModel, compUtils, MgrLearn, AllDescendantsCommand, CancelDiscoverCommand, NewCommand, MatchCommand, TreeNode, MgrTypeInfo, mgrUtils) {
  'use strict';

  var filter = _.filter;
  var findCommand = mgrUtils.findCommand;
  var NRIO_IO_ENUM = baja.lt('nrio:NrioIoTypeEnum');
  var NRIO_UNIVERSAL_ENUM = baja.lt('nrio:UniversalInputTypeEnum');
  var UNIVERSAL_INPUT = NRIO_IO_ENUM.tagToOrdinal('universalInput');
  var ANALOG_OUTPUT = NRIO_IO_ENUM.tagToOrdinal('analogOutput');
  var RELAY_OUTPUT = NRIO_IO_ENUM.tagToOrdinal('relayOutput');
  var DI_NORMAL = NRIO_UNIVERSAL_ENUM.tagToOrdinal('di_Normal');
  var DI_HIGH_SPEED = NRIO_UNIVERSAL_ENUM.tagToOrdinal('di_HighSpeed');
  var AI_RESISTIVE = NRIO_UNIVERSAL_ENUM.tagToOrdinal('ai_Resistive');
  var AI_0TO_10_VDC = NRIO_UNIVERSAL_ENUM.tagToOrdinal('ai_0to10_vdc');

  /**
   * Point Manager for Nrio Points
   * @class
   * @alias module:nmodule/nrio/rc/wb/mgr/NrioPointUxManager
   * @extends module:nmodule/driver/rc/wb/mgr/PointMgr
   */
  return /*#__PURE__*/function (_PointMgr) {
    function NrioPointUxManager() {
      var _this;
      _classCallCheck(this, NrioPointUxManager);
      _this = _callSuper(this, NrioPointUxManager, [{
        moduleName: 'nrio',
        keyName: 'NrioPointUxManager',
        folderType: 'nrio:Nrio16PointFolder'
      }]);
      _this.$createMgrTypeInfo();
      _this.$sub = new baja.Subscriber();
      MgrLearn(_this);
      return _this;
    }

    /**
     * Create NrioMgrTypeImpl instances.
     * @private
     */
    _inherits(NrioPointUxManager, _PointMgr);
    return _createClass(NrioPointUxManager, [{
      key: "$createMgrTypeInfo",
      value: function $createMgrTypeInfo() {
        var uiDiType = new NrioMgrTypeImpl(baja.lt("control:BooleanPoint"), baja.lt("nrio:NrioBooleanInputProxyExt"), DI_NORMAL, null, "type.UiBooleanInput");
        var uiViType = new NrioMgrTypeImpl(baja.lt("control:NumericPoint"), baja.lt("nrio:NrioVoltageInputProxyExt"), AI_0TO_10_VDC, null, "type.UiVoltageInput");
        var uiRiType = new NrioMgrTypeImpl(baja.lt("control:NumericPoint"), baja.lt("nrio:NrioResistiveInputProxyExt"), AI_RESISTIVE, null, "type.UiResistiveInput");
        var uiTiType = new NrioMgrTypeImpl(baja.lt("control:NumericPoint"), baja.lt("nrio:NrioResistiveInputProxyExt"), AI_RESISTIVE, baja.$('nrio:NrioThermistorType3Conversion'), "type.UiThermistorInput");
        var uiCiType = new NrioMgrTypeImpl(baja.lt("control:NumericPoint"), baja.lt("nrio:NrioCounterInputProxyExt"), DI_HIGH_SPEED, null, "type.UiCounterInput");
        this.$uiTypes = [uiDiType, uiViType, uiRiType, uiTiType, uiCiType];
        this.$roTypes = [new NrioMgrTypeImpl(baja.lt("control:BooleanWritable"), baja.lt("nrio:NrioRelayOutputProxyExt"), null, null, "type.BooleanOutput")];
        this.$aoTypes = [new NrioMgrTypeImpl(baja.lt("control:NumericWritable"), baja.lt("nrio:NrioVoltageOutputProxyExt"), null, null, "type.VoltageOutput")];
      }

      /**
       * Remove the NewCommand
       * @returns {Array.<module:bajaux/commands/Command>}
       */
    }, {
      key: "makeCommands",
      value: function makeCommands() {
        return _superPropGet(NrioPointUxManager, "makeCommands", this, 3)([]).then(function (cmds) {
          return filter(cmds, function (cmd) {
            return !(cmd instanceof NewCommand) && !(cmd instanceof MatchCommand) && !(cmd instanceof CancelDiscoverCommand);
          });
        });
      }

      /**
       * Makes the main model
       * @param {baja.Component} component
       * @returns {Promise<module:nmodule/nrio/rc/wb/mgr/model/NrioPointManagerModel>}
       */
    }, {
      key: "makeModel",
      value: function makeModel(component) {
        return NrioPointManagerModel.make(component);
      }

      /**
       * Makes the learn model
       * @returns {Promise<module:nmodule/nrio/rc/wb/mgr/model/NrioPointLearnModel>}
       */
    }, {
      key: "makeLearnModel",
      value: function makeLearnModel() {
        return NrioPointLearnModel.make();
      }

      /**
       * Updates the learn table.
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$updateLearnTableModel",
      value: function $updateLearnTableModel() {
        var _this2 = this;
        var learnModel = this.getLearnModel();
        return Promise.all(this.$nrioEntries.map(function (entry) {
          return _this2.getExisting(entry).then(function (existing) {
            if (existing) {
              entry.setUsedByPoint(existing.getParent().getDisplayName() + "." + existing.getDisplayName());
            } else {
              entry.setUsedByPoint("");
            }
          });
        })).then(function () {
          var nodes = _this2.$nrioEntries.map(makeDiscoveryTableNode);
          return learnModel.clearRows().then(function () {
            return learnModel.insertRows(nodes, 0);
          });
        });
      }

      /**
       * Calls super.doLoad to initialize and load the main table with the `MgrModel`, then
       * discovers the points.
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad() {
        var _this3 = this;
        return _superPropGet(NrioPointUxManager, "doLoad", this, 3)(arguments).then(function () {
          _this3.getModel().on('rowsAdded', function (e) {
            return _this3.$handleRowsUpdated();
          });
          _this3.getModel().on('rowsRemoved', function (e) {
            return _this3.$handleRowsUpdated();
          });
          if (_this3.value().getType().is('nrio:NrioPointDeviceExt')) {
            return _this3.discover();
          } else {
            return _this3.$resolveDeep(_this3.getDeviceExt(), _this3.getModel().getProxyExtType()).then(function (existingPoints) {
              _this3.$existingPointExts = existingPoints;
              return _this3.discover();
            });
          }
        });
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$handleRowsUpdated",
      value: function $handleRowsUpdated() {
        var _this4 = this;
        if (this.value().getType().is('nrio:NrioPointDeviceExt')) {
          return this.$updateLearnTableModel();
        } else {
          return this.$resolveDeep(this.getDeviceExt(), this.getModel().getProxyExtType()).then(function (existingPoints) {
            _this4.$existingPointExts = existingPoints;
            return _this4.$updateLearnTableModel();
          });
        }
      }
      /**
       * Starts the discovery job
       * @returns {Promise}
       */
    }, {
      key: "doDiscover",
      value: function doDiscover() {
        var allDescendants = findCommand(this, AllDescendantsCommand);
        allDescendants.setSelected(true);
        allDescendants.setEnabled(false);
        var deviceExt = this.getDeviceExt();
        var comp;
        if (deviceExt.getType().is('nrio:Nrio34PriSecPoints')) {
          comp = baja.$('nrio:Nrio34ModulePoints');
        } else {
          comp = baja.$('nrio:Nrio16ModulePoints');
        }
        this.$nrioEntries = comp.getSlots().is('nrio:UIPointEntry').toValueArray();
        return this.$updateLearnTableModel();
      }

      /**
       * Returns the point ext for the current loaded component. As we may have a folder
       * loaded, this may be several levels up in the component tree.
       *
       * @returns {baja.Component}
       */
    }, {
      key: "getDeviceExt",
      value: function getDeviceExt() {
        return compUtils.closest(this.value(), baja.lt('nrio:NrioPointDeviceExt'));
      }

      /**
       * Returns the proposed values based on the learnDevice and dbDevice
       * @param {baja.Component} discovery nrio learn point
       * @param {baja.Component} database the database point
       * @returns {Object}
       */
    }, {
      key: "getProposedValuesFromDiscovery",
      value: function getProposedValuesFromDiscovery(discovery, database) {
        return {
          name: discovery.getName(),
          values: {
            instance: baja.Integer.make(discovery.getInstance())
          }
        };
      }

      /**
       * Returns the types that can be selected based on the discovery subject
       * @param {baja.Component} discovery nrio learn point
       * @returns {Promise<Array<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>>}
       */
    }, {
      key: "getTypesForDiscoverySubject",
      value: function getTypesForDiscoverySubject(discovery) {
        var nrioPointTypes = [];
        if (discovery.getIoType().getOrdinal() === UNIVERSAL_INPUT) {
          nrioPointTypes = this.$uiTypes;
        } else if (discovery.getIoType().getOrdinal() === ANALOG_OUTPUT) {
          nrioPointTypes = this.$aoTypes;
        } else {
          nrioPointTypes = this.$roTypes;
        }
        return Promise.all(nrioPointTypes.map(function (type) {
          return new MgrTypeInfo(type);
        }));
      }

      /**
       * Invokes add command if the selected subject is not existing in the database.
       * @override
       * @param {JQuery.Event} event the double click event
       * @param {Array.<*>} subjects the selected subject of the table being clicked
       * @returns {Promise|*}
       */
    }, {
      key: "onLearnTableDblClicked",
      value: function onLearnTableDblClicked(event, subjects) {
        var _this5 = this;
        return this.getExisting(subjects[0]).then(function (existing) {
          if (!existing) {
            var addCommand = _this5.$getAddCommand();
            if (addCommand) {
              return addCommand.invoke();
            }
          }
        });
      }

      /**
       * Will perform extra checks to set the enabling of the add command
       * @inheritDoc
       */
    }, {
      key: "onTableSelectionChanged",
      value: function onTableSelectionChanged(selectedSubjects) {
        var _this6 = this;
        return _superPropGet(NrioPointUxManager, "onTableSelectionChanged", this, 3)(arguments).then(function () {
          var learnTableSelection = selectedSubjects.learnTableSelection;
          var addCommand = _this6.$getAddCommand();
          var learnSel;
          if (learnTableSelection.length === 1) {
            learnSel = learnTableSelection[0];
            return _this6.getExisting(learnSel).then(function (existing) {
              if (existing) {
                addCommand.setEnabled(false);
              }
            });
          }
        });
      }

      /**
       * @param {baja.Component} discovery
       * @param {baja.Component} component
       * @returns {boolean}
       */
    }, {
      key: "isExisting",
      value: function isExisting(discovery, component) {
        return isMatchable(discovery, component);
      }

      /**
       * @private
       * @param {baja.Component} target the device ext for the nrio point
       * @param {baja.Component} include proxy ext for nrio point
       * @returns {Promise.<Array.<baja.Component>>}
       */
    }, {
      key: "$resolveDeep",
      value: function $resolveDeep(target, include) {
        var _this7 = this;
        var bql = "bql:select slotPath from " + include;
        var ords = [];
        return baja.Ord.make(bql).get({
          base: target,
          cursor: {
            each: function each() {
              ords.push(this.get('slotPath').toString());
            },
            limit: -1
          }
        }).then(function (result) {
          return baja.BatchResolve.resolve({
            ords: ords,
            base: target,
            subscriber: _this7.$sub
          }).then(function (br) {
            return br.getTargets().map(function (target) {
              return target.getComponent();
            });
          });
        });
      }

      /**
       * @private
       * @param {baja.Component} discovery a discovered object
       * @returns {Promise.<baja.Component|undefined>}
       */
    }, {
      key: "$findExistingPoint",
      value: function $findExistingPoint(discovery) {
        var _this8 = this;
        var point = _.find(this.$existingPointExts, function (c) {
          return !!_this8.isExisting(discovery, c.getParent());
        });
        return point ? Promise.resolve(point.getParent()) : Promise.resolve(undefined);
      }

      /**
       * Destroy the main view table / unsubscribe
       * @returns {Promise}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        return Promise.all([this.$sub.unsubscribeAll(), _superPropGet(NrioPointUxManager, "doDestroy", this, 3)([])]);
      }

      /**
       * Override the getExisting function to search for given discovery element
       * that matches the parent point device extension points.
       *
       * @param {baja.Component} discovery a discovered object
       *
       * @returns {Promise.<baja.Component|undefined>} the existing parent component that was found to match
       * the given discovery node, or undefined if no such match was found.
       */
    }, {
      key: "getExisting",
      value: function getExisting(discovery) {
        if (this.value().getType().is('nrio:NrioPointDeviceExt')) {
          if (this.getModel().getRows().length === 0) {
            discovery.setUsedByPoint("");
          }
          return MgrLearn.prototype.getExisting.call(this, discovery);
        }
        if (this.$existingPointExts == null || this.$existingPointExts.length === 0) {
          discovery.setUsedByPoint("");
        }
        return this.$findExistingPoint(discovery);
      }

      /**
       *
       * @returns {object}
       */
    }, {
      key: "saveStateForOrd",
      value: function saveStateForOrd() {
        var obj = {};
        if (this.$nrioEntries) {
          this.$nrioEntries.forEach(function (entry) {
            var entryName = entry.getName();
            var comp = baja.$('baja:Component', _defineProperty({}, entryName, entry.newCopy()));
            obj[entryName] = baja.bson.encodeValue(comp);
          });
        }
        return obj;
      }

      /**
       * @param {Object} obj - an object with data retrieved from the browser
       * storage.
       * @returns {Promise}
       */
    }, {
      key: "restoreStateForOrd",
      value: function restoreStateForOrd(obj) {
        var _this9 = this;
        if (obj) {
          return Promise.all(Object.entries(obj).map(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
              key = _ref2[0],
              comp = _ref2[1];
            return baja.bson.decodeAsync(comp).then(function (c) {
              return c.get(key);
            });
          })).then(function (decodedNrioEntries) {
            _this9.$nrioEntries = decodedNrioEntries;
            return _this9.$updateLearnTableModel();
          });
        }
        return Promise.resolve();
      }
    }]);
  }(PointMgr);

  /**
   * Tests if the learn and main subjects match.
   *
   * @param {baja.Component} learnSubject the subject selected in the learn table
   * @param {baja.Component} mainSubject the subject from the mainSelection that the
   * learnSelection subject is being matched to
   * @returns {boolean}
   */
  function isMatchable(learnSubject, mainSubject) {
    var pointType = mainSubject.getType();
    if (pointType.is('control:ControlPoint')) {
      var proxy = mainSubject.getProxyExt();
      var ioType = learnSubject.getIoType();
      if (proxy.getType().is('nrio:Nrio16ProxyExt') && proxy.getEnabled()) {
        var proxyInstance = proxy.getInstance();
        if (learnSubject.getInstance() !== proxyInstance) {
          return false;
        }
        if (pointType.is('control:BooleanWritable')) {
          return ioType.getOrdinal() === RELAY_OUTPUT;
        } else if (pointType.is('control:BooleanPoint')) {
          return ioType.getOrdinal() === UNIVERSAL_INPUT;
        } else if (pointType.is('control:NumericWritable')) {
          return ioType.getOrdinal() === ANALOG_OUTPUT;
        } else if (pointType.is('control:NumericPoint')) {
          return ioType.getOrdinal() === UNIVERSAL_INPUT;
        }
      }
    }
    return false;
  }

  /**
   * Make a tree node for an item in the discovery table.
   *
   * @param  {Object} discovery - a discovered object.
   * @returns {module:nmodule/webEditors/rc/wb/tree/TreeNode}
   */
  function makeDiscoveryTableNode(discovery) {
    var name = discovery.getName(),
      node = new TreeNode(name, name);
    node.getIcon = _.constant(discovery.getIcon());
    node.mayHaveKids = _.constant(false);
    node.value = _.constant(discovery);
    return node;
  }
});
