/*jshint browser: true */

/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 * @author Matthew Balch
 */
// Create window.location for non-browser contexts
// eslint doesn't like this workaround

/* eslint-disable */
if (typeof window === 'undefined') {
  /* eslint-enable */
  var window = {};
}

if (!("location" in window)) {
  window.location = {
    href: "not-browser"
  };
}
/**
 * @private
 * @module nmodule/cloudLink/rc/util/PassphraseDialogTemplate.hbs
 */


define(['dialogs', 'lex!cloudLink', 'jquery', 'Promise', 'hbs!nmodule/cloudLink/rc/util/PassphraseDialogTemplate'], function (dialogs, lexicons, $, Promise, template) {
  "use strict";

  var lex = lexicons[0];
  return {
    /**
     * Return true if the browser using https.
     *
     * @private
     *
     * @returns {Boolean} Returns true if https is being used.
     */
    isSecure: function isSecure() {
      return /^https:/i.test(window.location.href);
    },

    /**
     * Show a passphrase dialog, extract the passphrase value and show it to the user.
     *
     * @private
     *
     * @returns The dialog instance.
     */
    showPassphraseDialog: function showPassphraseDialog(params) {
      params = params || {};
      params.title = lex.get("enterPassphrase.title");
      params.content = template({
        message: lex.get("enterPassphrase.description")
      });
      var dlg = dialogs.showOkCancel(params);
      var passphraseInput = dlg.content().find("input");
      passphraseInput.focus(); // tack on completing the dialog equivalent to clicking "ok" when hitting enter

      passphraseInput.keyup(function (e) {
        if (e.key === "Enter") {
          dlg.close("ok", false);
        }
      }); // tack on passphrase retrieval property

      Object.defineProperty(dlg, "passphrase", {
        get: function get() {
          return passphraseInput.val();
        }
      });
      return dlg;
    }
  };
});
