function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/*jshint browser: true */

/* global window */

/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 * @author Matthew Balch
 */
define(['baja!', 'jquery', 'Promise', 'bajaux/Widget', 'dialogs', 'nmodule/cloudLink/rc/util/PassphraseDialog', 'lex!cloudLink', 'hbs!nmodule/cloudLink/rc/file/view/EncryptedDistributionViewTemplate', 'css!nmodule/cloudLink/rc/file/view/EncryptedDistributionViewStyle'], function (baja, $, Promise, Widget, dialogs, PassphraseDialog, lexicons, template) {
  'use strict';

  var lex = lexicons[0];
  var isSecure = PassphraseDialog.isSecure,
      showPassphraseDialog = PassphraseDialog.showPassphraseDialog;
  var rpc = baja.rpc,
      isOffline = baja.isOffline;
  var hyperlink = null;

  if (window && window.niagara && window.niagara.env) {
    hyperlink = function hyperlink(distOrd) {
      return window.niagara.env.hyperlink(distOrd);
    };
  }
  /**
  * @class
  * @alias module:nmodule/cloudLink/rc/file/view/EncryptedDistributionView
  * @desc Manages Niagara Back ups.
  */


  var EncryptedDistributionView = /*#__PURE__*/function (_Widget) {
    _inherits(EncryptedDistributionView, _Widget);

    var _super = _createSuper(EncryptedDistributionView);

    function EncryptedDistributionView() {
      _classCallCheck(this, EncryptedDistributionView);

      return _super.call(this, arguments);
    }
    /**
     * Decrypt a edist file to a dist file.
     *
     * @param  {jQuery}  jq The jQuery wrapper for the widget.
     * @param  {string}  eDistFile The encrypted distribution file.
     * @return {Promise}
     */


    _createClass(EncryptedDistributionView, [{
      key: "decrypt",
      value: function decrypt(jq, eDistFile) {
        return rpc(eDistFile.getNavOrd(), 'isDistFileAvailable').then(function (distFileAvailable) {
          return distFileAvailable ? dialogs.showYesNo({
            parent: jq,
            content: lex.get('unencryptedFileFound')
          }).promise() : [null, 'yes'];
        }).then(function (response) {
          return response[1] === 'no' ? Promise.reject(new Error('')) : null;
        }).then(function () {
          return showPassphraseDialog({
            parent: jq
          }).promise();
        }).then(function (result) {
          if (result[1] === 'cancel') {
            throw new Error('');
          }

          var dlg = result[0];
          var callPromise = rpc(eDistFile.getNavOrd(), 'decryptToDist', dlg.passphrase);
          dialogs.showLoading(0, callPromise, jq);
          return callPromise;
        }).then(function (distOrd) {
          if (distOrd) {
            return dialogs.showYesNo({
              parent: jq,
              content: lex.get('decryptSuccess')
            }).yes(function () {
              return hyperlink(distOrd);
            });
          } else {
            throw new Error(lex.get('decryptFail'));
          }
        })["catch"](function (error) {
          return error.message ? dialogs.showOk({
            parent: jq,
            content: error.message
          }) : null;
        });
      }
      /**
       * Load the encrypted distribution view.
       *
       * @param eDistFile The encrypted distribution file.
       * @returns {Promise}
       */

    }, {
      key: "doLoad",
      value: function doLoad(eDistFile) {
        var _this = this;

        var enabled = this.$canDecrypt();
        this.jq().html(template({
          ord: String(eDistFile.getNavOrd()),
          message: enabled ? lex.get("decryptDistFile") : lex.get("decryptWithHttps"),
          canDecrypt: enabled
        }));

        if (enabled) {
          this.jq().on("click", ".encrypted-dist-view-decrypt-button", function () {
            _this.decrypt(_this.jq(), eDistFile);

            return false;
          });
        }
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        var parent = this.jq().parent();
        this.jq().children(".encrypted-dist-view-outer").css({
          width: parent.width(),
          height: parent.height()
        });
      }
    }, {
      key: "$canDecrypt",
      value: function $canDecrypt() {
        return isOffline() || isSecure();
      } // Allows mocking out for test purposes

    }, {
      key: "$overrideIsOffline",
      value: function $overrideIsOffline(value) {
        isOffline = function isOffline() {
          return value;
        };
      }
    }, {
      key: "$overrideIsSecure",
      value: function $overrideIsSecure(value) {
        isSecure = function isSecure() {
          return value;
        };
      }
    }, {
      key: "$overrideRpc",
      value: function $overrideRpc(func) {
        rpc = func;
      }
    }, {
      key: "$overrideHyperlink",
      value: function $overrideHyperlink(func) {
        hyperlink = func;
      }
    }]);

    return EncryptedDistributionView;
  }(Widget);

  return EncryptedDistributionView;
});
