function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 *
 * @module nmodule/webEditors/rc/wb/util/category/ShowConfiguredCommand
 */

define(['baja!', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/fe/baja/util/subscriberUtils', 'bajaux/commands/Command'], function (baja, $, Promise, _, feDialogs, compUtils, spaceUtils, subscriberUtils, Command) {
  'use strict';

  var partial = _.partial;
  var resolveService = spaceUtils.resolveService;
  var leaseWhenNeeded = subscriberUtils.leaseWhenNeeded;
  var getCategoryService = leaseWhenNeeded(partial(resolveService, 'baja:CategoryService'));
  var getStationName = compUtils.getStationName;

  /**
   * This command show all the configured navNodes of the categoryBrowser.
   * @class
   * @extends module:bajaux/commands/Command
   * @since Niagara 4.14
   * @alias module:nmodule/webEditors/rc/wb/util/category/ShowConfiguredCommand
   * @param {Object} [params] the Object Literal for the constructor's arguments.
   * @param {String} [params.module='wbutil'] the module to look up the command's lexicon entry.
   * @param {String} [params.lex='category.showConfigured'] the lexicon value.
   * @param {module:nmodule/webEditors/rc/wb/util/category/CategoryBrowser} [params.categoryBrowser] categoryBrowser widget.
   */
  var ShowConfiguredCommand = /*#__PURE__*/function (_Command) {
    function ShowConfiguredCommand() {
      var _this;
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        _ref$module = _ref.module,
        module = _ref$module === void 0 ? 'wbutil' : _ref$module,
        _ref$lex = _ref.lex,
        lex = _ref$lex === void 0 ? 'category.showConfigured' : _ref$lex,
        _ref$categoryBrowser = _ref.categoryBrowser,
        categoryBrowser = _ref$categoryBrowser === void 0 ? null : _ref$categoryBrowser;
      _classCallCheck(this, ShowConfiguredCommand);
      return _this = _callSuper(this, ShowConfiguredCommand, [{
        module: module,
        lex: lex,
        enabled: true,
        func: function func() {
          return _this.$showConfiguredRows(categoryBrowser);
        }
      }]);
    }

    /**
     * @private
     * @param {module:nmodule/webEditors/rc/wb/util/category/CategoryBrowser} categoryBrowser
     * @returns {Promise}
     */
    _inherits(ShowConfiguredCommand, _Command);
    return _createClass(ShowConfiguredCommand, [{
      key: "$showConfiguredRows",
      value: function $showConfiguredRows(categoryBrowser) {
        var table = categoryBrowser.$getTable();
        var promises = [];
        var rootNodeType = categoryBrowser.value().getType();
        if (rootNodeType.is('baja:CategoryService')) {
          promises.push(this.$expandComponentNodes(table, categoryBrowser));
          promises.push(this.$expandNonComponentNodes(table));
        } else if (rootNodeType.is('baja:Component')) {
          promises.push(this.$expandComponentNodes(table, categoryBrowser));
        } else {
          promises.push(this.$expandNonComponentNodes(table));
        }
        return Promise.all(promises);
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/table/Table} table
       * @returns {Promise}
       */
    }, {
      key: "$expandNonComponentNodes",
      value: function $expandNonComponentNodes(table) {
        var _this2 = this;
        //get all the entries from categoryService ordMap which stores the non-component
        // and virtual component nodes whose category mask is set
        return getCategoryService().then(function (service) {
          var ordMap = service.getOrdMap();
          var pairs = ordMap.pairs();
          return Promise.all(pairs.map(function (pair) {
            return _this2.$convertOrdToPath(pair.ord).then(function (paths) {
              if (paths[0] === 'history:') {
                // as root history ord is of format history:/stationName, hence isRoot is set to false.
                return _this2.$expandNodes("", paths, table, false);
              }
              return _this2.$expandNodes("", paths, table, true);
            });
          }));
        });
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/table/Table} table
       * @param {module:nmodule/webEditors/rc/wb/util/category/CategoryBrowser} categoryBrowser
       * @returns {Promise}
       */
    }, {
      key: "$expandComponentNodes",
      value: function $expandComponentNodes(table, categoryBrowser) {
        var _this3 = this;
        var configuredComponentOrds = [];
        var rootNodeType = categoryBrowser.value().getType();
        //get all the component nodes whose category mask is set
        return baja.Ord.make({
          base: rootNodeType.is('baja:CategoryService') ? 'station:|slot:/' : categoryBrowser.value().getNavOrd(),
          child: "bql:select navOrd from baja:Component where not categoryMask.isNull"
        }).get({
          cursor: {
            each: function each(comp) {
              configuredComponentOrds.push(comp.get('navOrd').relativizeToSession().toString());
            },
            limit: -1
          }
        }).then(function () {
          return Promise.all(configuredComponentOrds.map(function (ord) {
            var paths = ord.split("/");
            paths[0] = paths[0] + "/"; //root ord
            return _this3.$expandNodes("", paths, table, true);
          }));
        });
      }

      /**
       * @private
       * @param {baja.Ord} ord
       * @returns {Promise}
       */
    }, {
      key: "$convertOrdToPath",
      value: function $convertOrdToPath(ord) {
        var query = ord.parse(),
          file = query.get('file'),
          history = query.get('history'),
          virtual = query.get('virtual');
        var pathOrd = "";
        return getStationName().then(function (stationName) {
          if (file) {
            //convert the file ord to path format
            pathOrd = 'file:' + file.getBody().replace(/^\^/, '^/');
          } else if (history) {
            // a local history ord is stored in history^: format, but to expand the node,
            // the ord should be in path format which is history:/stationName/historyOrd
            // in case of bajaui, this conversion is done as part of HistoryCategoryUtil.convertToShorthand
            if (history.getBody().startsWith('^')) {
              pathOrd = 'history:/' + stationName + history.getBody().replace(/^\^/, '/');
            } else {
              // If the history came from a different station, it won't have the shorthand notation
              pathOrd = history.toString();
            }
          } else if (virtual) {
            pathOrd = ord.toString();
            var paths = pathOrd.split("/");
            // Need to add a '/' to the end of the first path for a virtual ORD ("station:|slot:" -> "station:|slot:/")
            paths[0] = paths[0] + "/";
            return paths;
          }
          return pathOrd.split("/");
        });
      }

      /**
       * @private
       * @param {String} subOrds iterative value of the ord
       * @param {Array.<String>} paths array of child paths of the ord.
       * @param {module:nmodule/webEditors/rc/wb/table/Table} table
       * @param {Boolean} isRoot true paths contains rootOrd
       * @returns {Promise}
       */
    }, {
      key: "$expandNodes",
      value: function $expandNodes(subOrds, paths, table) {
        var _this4 = this;
        var isRoot = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
        var model = table.getModel();
        var rows = model.getRows();
        //expand till last but one node.
        if (paths.length === 1) {
          return Promise.resolve();
        }
        var subOrd = paths[0];
        if (subOrd.endsWith("|virtual:")) {
          // Special handling when arrive at a virtual gateway in the slot path of a virtual (must
          // add a slash to resolve to the root component of the virtual space)
          subOrd += '/';
          isRoot = true;
        }
        subOrds += subOrd;
        var lowerCaseSubOrds = subOrds.toLowerCase();
        var caseSensitiveMatch = subOrds !== lowerCaseSubOrds;
        //get the ord from the paths array
        //find the row, if the row is not expanded, expand the row.
        //recursively loop through all the child ords and expand each child node row.
        // some ORDs saved to the CategoryService's ordMap (like history ORDs and file ORDs) are
        // in lowercase form
        var row = _.find(rows, function (row) {
          return caseSensitiveMatch ? baja.Ord.make(row.getTreeNode().$ord).relativizeToSession().toString() === subOrds : baja.Ord.make(row.getTreeNode().$ord).relativizeToSession().toString().toLowerCase() === lowerCaseSubOrds;
        });
        paths.shift();
        if (!isRoot) {
          subOrds += "/";
        }
        if (row && !model.isExpanded(row)) {
          return model.expand(row).then(function () {
            return _this4.$expandNodes(subOrds, paths, table);
          });
        } else {
          return this.$expandNodes(subOrds, paths, table);
        }
      }
    }]);
  }(Command);
  return ShowConfiguredCommand;
});
