function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Nutan Naik
 */

/** @jsx spandrel.jsx */
/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/category/CategoryBrowser
 * @since Niagara 4.14
 */
define(['baja!', 'lex!wbutil,webEditors', 'bajaux/spandrel', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'bajaux/mixin/subscriberMixIn', 'bajaux/util/SaveCommand', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/IconEditor', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/fe/baja/util/subscriberUtils', 'nmodule/webEditors/rc/fe/baja/util/userUtils', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/servlets/category', 'nmodule/webEditors/rc/transform/ExportCommand', 'nmodule/webEditors/rc/wb/mixin/ContextMenuSupport', 'nmodule/webEditors/rc/wb/menu/Separator', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/wb/mgr/commands/HyperlinkCommand', 'nmodule/webEditors/rc/wb/table/menu/DefaultTableContextMenu', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/tree/TreeNode', 'nmodule/webEditors/rc/wb/table/tree/TreeTable', 'nmodule/webEditors/rc/wb/table/tree/TreeTableModel', 'nmodule/webEditors/rc/wb/util/category/ClearConfiguredCommand', 'nmodule/webEditors/rc/wb/profile/profileUtils', 'nmodule/webEditors/rc/wb/util/category/ShowCategoriesCommand', 'nmodule/webEditors/rc/wb/util/category/ShowConfiguredCommand', 'nmodule/webEditors/rc/wb/util/category/ShowOrHideAllCategoriesCommand'], function (baja, lexs, spandrel, Widget, Command, CommandGroup, subscriberMixIn, SaveCommand, $, Promise, _, IconEditor, compUtils, spaceUtils, subscriberUtils, userUtils, fe, category, ExportCommand, ContextMenuSupport, Separator, mgrUtils, HyperlinkCommand, DefaultTableContextMenu, Table, Column, TreeNode, TreeTable, TreeTableModel, ClearConfiguredCommand, profileUtils, ShowCategoriesCommand, ShowConfiguredCommand, ShowOrHideAllCategoriesCommand) {
  'use strict';

  var OrdToCategoryMap = require('bajaScript/baja/obj/OrdToCategoryMap');
  var CategoryMask = require('bajaScript/baja/obj/CategoryMask');
  var _lexs = _slicedToArray(lexs, 2),
    wbUtilLex = _lexs[0],
    webEditorsLex = _lexs[1];
  var notApplicableTxt = wbUtilLex.get('category.notApplicable');
  var markerTxt = wbUtilLex.get('category.marker');
  var partial = _.partial,
    sortBy = _.sortBy,
    compact = _.compact;
  var resolveService = spaceUtils.resolveService;
  var leaseWhenNeeded = subscriberUtils.leaseWhenNeeded;
  var getCategoryService = leaseWhenNeeded(partial(resolveService, 'baja:CategoryService'));
  var getNavNodeInfo = category.getNavNodeInfo,
    getNavChildren = category.getNavChildren,
    toCategorizableOrd = category.toCategorizableOrd,
    getCategoryMask = category.getCategoryMask,
    getAppliedCategoryMask = category.getAppliedCategoryMask,
    setCategoryMask = category.setCategoryMask;
  var getDisplayName = compUtils.getDisplayName,
    getStationName = compUtils.getStationName;
  var findCommand = mgrUtils.findCommand;
  var getViewQuery = profileUtils.getViewQuery;
  var ORD_CATEGORY_BROWSER_UXVIEW = 'station:|service:baja:CategoryService|view:webEditors:UxCategoryBrowser';

  /**
   * A specialized DefaultTableContextMenu that only adds the Export Command
   * @inner
   * @class
   * @extends module:nmodule/webEditors/rc/wb/table/menu/DefaultTableContextMenu
   */
  var CategoryTableContextMenu = /*#__PURE__*/function (_DefaultTableContextM) {
    function CategoryTableContextMenu() {
      _classCallCheck(this, CategoryTableContextMenu);
      return _callSuper(this, CategoryTableContextMenu, arguments);
    }
    _inherits(CategoryTableContextMenu, _DefaultTableContextM);
    return _createClass(CategoryTableContextMenu, [{
      key: "toContextMenu",
      value: function toContextMenu() {
        return new CommandGroup({
          commands: [new ExportCommand(this.$table), new Separator(), new ShowOrHideAllCategoriesCommand(this.$table, {
            lex: 'category.showAll',
            show: true
          }), new ShowOrHideAllCategoriesCommand(this.$table, {
            lex: 'category.hideAll',
            show: false
          }), new ShowCategoriesCommand(this.$table)]
        });
      }
    }]);
  }(DefaultTableContextMenu);
  /**
   *
   * @inner
   * @class
   * @extends module:nmodule/webEditors/rc/wb/table/Table
   */
  var CategoryTable = /*#__PURE__*/function (_TreeTable) {
    function CategoryTable() {
      var _this;
      _classCallCheck(this, CategoryTable);
      _this = _callSuper(this, CategoryTable, arguments);
      DefaultTableContextMenu.mixin(_this, {
        ctor: CategoryTableContextMenu
      });
      return _this;
    }
    _inherits(CategoryTable, _TreeTable);
    return _createClass(CategoryTable, [{
      key: "finishBuildingRow",
      value: function finishBuildingRow(row, dom) {
        return updateRowClass(row, dom);
      }
    }]);
  }(TreeTable);
  function updateRowClass(row, dom) {
    var node = row.getTreeNode();
    //change background color for not-inherited rows
    dom.toggleClass('-t-CategoryBrowser-inherited', node.$isInherited);
    dom.toggleClass('-t-CategoryBrowser-not-inherited', !node.$isInherited);
    return Promise.resolve(dom);
  }
  function convertNodeToObj(node) {
    var obj = {};
    obj.navName = node.getNavName();
    obj.displayName = node.getNavDisplayName();
    if (node.getNavDisplayName() === null || node.getNavDisplayName() === "") {
      obj.displayName = getDisplayName(node);
    }
    obj.icon = node.getNavIcon().encodeToString();
    obj.ord = node.getNavOrd().toString();
    obj.categorizableOrd = toCategorizableOrd(obj.ord);
    obj.typeSpec = node.getType().toString();
    var isVirtual = node.getType().is('baja:VirtualComponent');
    if (!node.getType().is('baja:Component') || isVirtual) {
      obj.categorizableOrd = isVirtual ? node.getNavOrd().relativizeToSession().toString() : obj.ord;
    }
    return obj;
  }
  function getLocalHistoryOrd(ord) {
    return getStationName().then(function (stationName) {
      // CategoryService OrdMap stores the history ord for current station in history:^ format
      return ord.replace("history:/" + stationName + "/", "history:^");
    });
  }

  /**
   *
   * @inner
   * @class
   * @extends {module:nmodule/webEditors/rc/wb/table/model/Column}
   */
  var DisplayNameWithIconColumn = /*#__PURE__*/function (_Column) {
    function DisplayNameWithIconColumn() {
      var _this2;
      _classCallCheck(this, DisplayNameWithIconColumn);
      _this2 = _callSuper(this, DisplayNameWithIconColumn, arguments);
      _this2.setHidable(false);
      return _this2;
    }
    _inherits(DisplayNameWithIconColumn, _Column);
    return _createClass(DisplayNameWithIconColumn, [{
      key: "buildCell",
      value: function buildCell(row, dom) {
        var _this3 = this;
        dom.toggleClass('-t-CategoryBrowser-disabled-cell', row.getTreeNode().$isInherited);
        return fe.buildFor({
          value: row.getIcon(),
          type: IconEditor,
          dom: $('<span/>').appendTo(dom)
        }).then(function () {
          return dom.append($("<span>".concat(_.escape(_this3.getValueFor(row)), "</span>")).addClass('-t-CategoryBrowser-displayName'));
        });
      }
    }, {
      key: "getValueFor",
      value: function getValueFor(row) {
        return row.getTreeNode().$displayName;
      }
    }]);
  }(Column);
  /**
   *
   * @inner
   * @class
   * @extends {module:nmodule/webEditors/rc/wb/table/model/Column}
   */
  var CategoryColumn = /*#__PURE__*/function (_Column2) {
    function CategoryColumn(name, params) {
      var _this4;
      _classCallCheck(this, CategoryColumn);
      _this4 = _callSuper(this, CategoryColumn, [name, params]);
      params = params || {};
      _this4.$index = params.index;
      _this4.$hasAdminWrite = params.hasAdminWrite;
      _this4.setSortable(false);
      return _this4;
    }
    _inherits(CategoryColumn, _Column2);
    return _createClass(CategoryColumn, [{
      key: "buildCell",
      value: function buildCell(row, dom) {
        dom.toggleClass('-t-CategoryBrowser-disabled-cell', row.getTreeNode().$isInherited);
        dom.toggleClass('-t-CategoryBrowser-readonly-cell', !this.$hasAdminWrite);
        dom.addClass('-t-CategoryBrowser-cell');
        var iconStr = this.getValueFor(row);
        if (iconStr) {
          return fe.buildFor({
            value: baja.Icon.make('module://icons/x16/bullet.png'),
            type: IconEditor,
            dom: $('<span/>').appendTo(dom)
          });
        } else {
          return Promise.resolve(dom.text(iconStr));
        }
      }
    }, {
      key: "getValueFor",
      value: function getValueFor(row) {
        var node = row.getTreeNode();
        var categoryMask = node.$isInherited ? node.$parentMask : node.$compMask;
        return categoryMask.get(this.$index) ? markerTxt : "";
      }
    }]);
  }(Column);
  /**
   *
   * @inner
   * @class
   * @extends {module:nmodule/webEditors/rc/wb/table/model/Column}
   */
  var InheritedColumn = /*#__PURE__*/function (_Column3) {
    function InheritedColumn() {
      var _this5;
      _classCallCheck(this, InheritedColumn);
      _this5 = _callSuper(this, InheritedColumn, arguments);
      _this5.setHidable(false);
      _this5.setSortable(false);
      return _this5;
    }
    _inherits(InheritedColumn, _Column3);
    return _createClass(InheritedColumn, [{
      key: "buildCell",
      value: function buildCell(row, dom) {
        dom.addClass('-t-CategoryBrowser-cell');
        var iconStr = this.getValueFor(row);
        if (iconStr === markerTxt) {
          return fe.buildFor({
            value: baja.Icon.make('module://icons/x16/check.png'),
            type: IconEditor,
            dom: $('<span/>').appendTo(dom)
          });
        } else {
          return Promise.resolve(dom.text(iconStr));
        }
      }
    }, {
      key: "getValueFor",
      value: function getValueFor(row) {
        var node = row.getTreeNode();
        return node.$isRoot ? notApplicableTxt : node.$isInherited ? markerTxt : "";
      }
    }]);
  }(Column);
  /**
   *
   * @inner
   * @class
   * @extends {module:nmodule/webEditors/rc/wb/tree/TreeNode}
   */
  var CategoryTreeNode = /*#__PURE__*/function (_TreeNode) {
    function CategoryTreeNode(obj) {
      var _this6;
      _classCallCheck(this, CategoryTreeNode);
      var navName = obj.navName,
        displayName = obj.displayName,
        isRoot = obj.isRoot,
        ord = obj.ord,
        compMask = obj.compMask,
        parentMask = obj.parentMask,
        icon = obj.icon;
      _this6 = _callSuper(this, CategoryTreeNode, [navName, displayName]);
      _this6.$ord = ord;
      _this6.$displayName = displayName;
      _this6.$isRoot = isRoot || false;
      //if component mask is undefined or empty then the node is inherited
      _this6.$isInherited = compMask === undefined || compMask.isNull();
      //for inherited columns the parent mask is component mask
      _this6.$compMask = _this6.$isInherited ? parentMask : compMask;
      _this6.$parentMask = parentMask;
      _this6.$icon = icon;
      _this6.$clearConfigured = obj.clearConfigured;
      _this6.$type = obj.type;

      //when we obtain the NavNode for the Files when it's the only root, we end up with a NavNode which is the file "Station Database"
      // which is not what we want to display here.
      if (ord === "local:|file:^") {
        _this6.$displayName = webEditorsLex.get('stationTree.files.displayName');
        _this6.$icon = webEditorsLex.get('nav.files.icon');
      }
      return _this6;
    }
    _inherits(CategoryTreeNode, _TreeNode);
    return _createClass(CategoryTreeNode, [{
      key: "getIcon",
      value: function getIcon() {
        return baja.Icon.make(this.$icon);
      }
    }, {
      key: "$loadKids",
      value: function $loadKids() {
        var _this7 = this;
        return getNavChildren(this.$ord).then(function (objs) {
          objs = JSON.parse(objs);
          var that = _this7;
          return getCategoryService().then(function (service) {
            return Promise.all(objs.map(function (obj) {
              return createTreeNode(obj, that, service);
            })).then(function (nodes) {
              return compact(nodes);
            });
          });
        });
      }
    }]);
  }(TreeNode);
  function createTreeNode(obj, parentNode, service) {
    return baja.importTypes([obj.typeSpec]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
        type = _ref2[0];
      obj.type = type;
      if (type.is('baja:ICategorizable')) {
        obj.isRoot = false;
        obj.parentMask = parentNode && parentNode.$compMask;
        var isVirtual = type.is('baja:VirtualComponent');
        obj.categorizableOrd = toCategorizableOrd(obj.ord);
        if (parentNode && parentNode.$clearConfigured) {
          obj.compMask = undefined;
          obj.clearConfigured = true;
          return new CategoryTreeNode(obj);
        } else {
          if (type.is('baja:Component') && !isVirtual) {
            return getCategoryMask(obj.categorizableOrd).then(function (mask) {
              obj.compMask = CategoryMask.make(mask);
              return new CategoryTreeNode(obj);
            });
          } else {
            obj.ord = obj.categorizableOrd;
            obj.compMask = service.getOrdMap().getCategoryMask(baja.Ord.make(obj.categorizableOrd));
            if (obj.compMask === undefined) {
              var ord = baja.Ord.make(obj.categorizableOrd).relativizeToSession().toString();
              if (ord.startsWith('history:')) {
                return getStationName().then(function (stationName) {
                  // CategoryService OrdMap stores the history ord for current station in history:^ format
                  ord = ord.replace("history:/" + stationName + "/", "history:^");
                  obj.compMask = service.getOrdMap().getCategoryMask(baja.Ord.make(ord));
                  return new CategoryTreeNode(obj);
                });
              }
            }
            return new CategoryTreeNode(obj);
          }
        }
      }
    });
  }
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: "webEditors",
      keyName: "UxCategoryBrowser",
      properties: {
        rootCssClass: '-t-CategoryBrowser'
      }
    };
  };

  /**
   * Category browser implementation.
   * @class
   * @extends module:bajaux/spandrel/SpandrelWidget
   * @alias nmodule/webEditors/rc/wb/util/category/CategoryBrowser
   */
  var CategoryBrowser = /*#__PURE__*/function (_spandrel) {
    function CategoryBrowser(params) {
      var _this8;
      _classCallCheck(this, CategoryBrowser);
      _this8 = _callSuper(this, CategoryBrowser, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      subscriberMixIn(_this8);
      ContextMenuSupport(_this8);
      _this8.getCommandGroup().add(new ShowConfiguredCommand({
        categoryBrowser: _this8
      }));
      _this8.getCommandGroup().add(new SaveCommand());
      _this8.$clearConfiguredOrds = [];
      _this8.$editedNodes = [];
      return _this8;
    }
    _inherits(CategoryBrowser, _spandrel);
    return _createClass(CategoryBrowser, [{
      key: "doSave",
      value: function doSave() {
        var _this9 = this;
        return Promise.resolve(this.$clearConfiguredOrds.length && ClearConfiguredCommand.clearAll(this)).then(function (clearObj) {
          return _this9.$saveNodes(clearObj);
        }).then(function () {
          _this9.$clearConfiguredOrds = [];
          _this9.$editedNodes = [];
        });
      }
    }, {
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this10 = this,
          _arguments = arguments;
        var ord = baja.Ord.make(ORD_CATEGORY_BROWSER_UXVIEW);
        dom.on('click', '.-t-CategoryBrowser-cell', function (e) {
          return _this10.$handleClick(e);
        });
        return HyperlinkCommand.make(ord, {
          displayNameFormat: webEditorsLex.get('CategoryBrowser.GoToTopCommand.displayName'),
          icon: webEditorsLex.get('CategoryBrowser.GoToTopCommand.icon')
        }).then(function (cmd) {
          return ord.resolve().then(function (target) {
            if (!target.getPermissionsOnTarget().hasAdminRead()) {
              cmd.setEnabled(false);
            }
            _this10.getCommandGroup().add(cmd);
            return _superPropGet(CategoryBrowser, "doInitialize", _this10, 3)(_arguments);
          });
        });
      }

      /**
       * @private
       * @param {Object} clearObj
       * @returns {Promise}
       */
    }, {
      key: "$saveNodes",
      value: function $saveNodes(clearObj) {
        var _this11 = this;
        var compNodes = clearObj.compNodes,
          nonCompNodes = clearObj.nonCompNodes;
        return Promise.all([getCategoryService(), getStationName()]).then(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2),
            service = _ref4[0],
            stationName = _ref4[1];
          var ords = [],
            masks = [];
          if (nonCompNodes) {
            ords = nonCompNodes.ords;
            masks = nonCompNodes.masks;
          } else {
            var map = service.getOrdMap();
            // as OrdToCategoryMap is a Simple and immutable, hence get the ords and masks
            // and modify the ords and masks as per the selected nodes.
            for (var i = 0, len = map.size(); i < len; ++i) {
              ords.push(map.getOrd(i));
              masks.push(map.getCategoryMask(i));
            }
          }
          return Promise.all(_this11.$editedNodes.map(function (node) {
            var isVirtual = node.$type.is('baja:VirtualComponent');
            var ord = baja.Ord.make(toCategorizableOrd(node.$ord)).relativizeToSession().toString();
            if ((node.$type.is('baja:Component') || node.$type.is('baja:ComponentSpace')) && !isVirtual) {
              if (compNodes) {
                var index = _.findIndex(compNodes.ords, function (cOrd) {
                  return cOrd === ord;
                });
                if (index >= 0) {
                  compNodes.ords.splice(index, 1);
                }
              }
              return setCategoryMask(ord, node.$compMask.encodeToString());
            } else {
              if (ord.startsWith('history:')) {
                // CategoryService OrdMap stores the history ord for current station in history:^ format
                ord = ord.replace("history:/" + stationName + "/", "history:^");
              }
              // check the ords array
              // if ords array contains the node.$ord then modify the categoryMask else add to the ords array
              var _index = _.findIndex(ords, function (o) {
                return o.toString() === ord;
              });
              if (_index < 0) {
                // In NCCB-63126, we are now using the case-sensitive form of the updated ORD when
                // sent in the new map from client to server (station), and the station side will
                // eventually convert the ORD to lowercase form for some entries in the map after
                // server-side validation. The following code is therefore needed to replace the
                // existing lowercase entry with the new case-sensitive entry since we are about
                // to save a new map from client to server.
                var lowerCaseOrd = ord.toLowerCase();
                _index = _.findIndex(ords, function (o) {
                  return o.toString() === lowerCaseOrd;
                });
              }
              var isInherited = node.$compMask.isNull();
              if (isInherited) {
                if (_index > -1) {
                  ords.splice(_index, 1);
                  masks.splice(_index, 1);
                }
              } else {
                if (_index >= 0) {
                  // Per NCCB-63126 (see note above), we may be replacing an existing lowercase
                  // ORD with a case-sensitive one, so make sure to replace the ORD at the matching
                  // index in the array since it could be different by case.
                  ords[_index] = ord;
                  masks[_index] = node.$compMask;
                } else {
                  ords.push(ord);
                  masks.push(node.$compMask);
                }
              }
            }
          })).then(function () {
            return service.set({
              slot: "ordMap",
              value: OrdToCategoryMap.DEFAULT.make({
                ords: ords,
                masks: masks
              })
            });
          }).then(function () {
            return compNodes && compNodes.ords.length && Promise.all(compNodes.ords.map(function (ord) {
              return setCategoryMask(ord, "");
            }));
          });
        });
      }

      /**
       * @private
       * @param {jQuery.Event} e
       */
    }, {
      key: "$handleClick",
      value: function $handleClick(e) {
        return this.$updateNodes($(e.target));
      }

      /**
       * Update the table with selected categoryMask.
       * @private
       * @param {HTMLElement} elem
       * @returns {Promise}
       */
    }, {
      key: "$updateNodes",
      value: function $updateNodes(elem) {
        var colIndex = elem.closest('td').index(),
          rowIndex = elem.closest('tr').index(),
          tableModel = this.$getTable().getModel(),
          row = tableModel.getRows()[rowIndex],
          col = tableModel.getColumns()[colIndex];
        var node = row.getTreeNode();
        if (col instanceof CategoryColumn && col.$hasAdminWrite) {
          // get the category mask and convert it into an array
          // update the category array based on the selected category
          // update the current node categoryMask and all the kids and grandKids categoryMask.
          var categoryMask = node.$isInherited ? CategoryMask.make("") : node.$compMask;
          var bytes = Number(parseInt(categoryMask.encodeToString(), 16)).toString(2).split('').reverse();
          bytes = bytes.slice(0, this.$categories.length);
          var catArray = [];
          for (var i = 0, len = bytes.length; i < len; ++i) {
            if (parseInt(bytes[i])) {
              catArray.push(i + 1);
            }
          }
          var selectedCategoryIndex = col.$index;
          //to toggle the category mask
          if (!catArray.includes(selectedCategoryIndex)) {
            catArray.push(selectedCategoryIndex);
          } else if (catArray.length > 1) {
            // component should be assigned to at least 1 category
            catArray.splice(catArray.indexOf(selectedCategoryIndex), 1); //deleting
          }
          node.$compMask = CategoryMask.DEFAULT.make(catArray);
          node.$isInherited = false;
          return this.$updateRows(node, row);
        } else if (col instanceof InheritedColumn && !node.$isRoot) {
          // toggle the isInherited flag.
          node.$isInherited = !node.$isInherited;
          if (node.$isInherited) {
            node.$compMask = CategoryMask.make("");
          } else {
            node.$compMask = node.$parentMask;
          }
          return this.$updateRows(node, row);
        }
      }

      /**
       * Updates the $clearConfiguredOrds and $editedNodes based on the selected node ord.
       * @param {String} selectedOrd
       */
    }, {
      key: "updateConfiguredOrds",
      value: function updateConfiguredOrds(selectedOrd) {
        this.$clearConfiguredOrds.push(baja.Ord.make(selectedOrd).relativizeToSession().toString());
        // remove entries from editedNodes when clearConfigured is clicked on the parentNode
        this.$editedNodes = this.$editedNodes.filter(function (node) {
          return !node.$ord.startsWith(selectedOrd);
        });
      }

      /**
       * Updates the $clearConfiguredOrds and $editedNodes based on the selected node ord.
       * @returns {Array<String>} selectedOrd
       */
    }, {
      key: "getClearConfiguredOrds",
      value: function getClearConfiguredOrds() {
        return this.$clearConfiguredOrds;
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/tree/TreeNode} node
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @returns {Promise}
       */
    }, {
      key: "$updateRows",
      value: function $updateRows(node, row) {
        var _this12 = this;
        this.$modifiedRows = [row];
        if (!this.$editedNodes.some(function (eNode) {
          return eNode.$ord.toString() === node.$ord.toString();
        })) {
          this.$editedNodes.push(node);
        }

        // recursively change the kids and grandKids categoryMask
        return this.$resetKids(node).then(function () {
          _this12.$getTable().getModel().emit('rowsChanged', _this12.$modifiedRows);
          _this12.setModified(true);
        });
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/tree/TreeNode} node
       */
    }, {
      key: "$resetRow",
      value: function $resetRow(node) {
        var rows = this.$getTable().getModel().getRows();
        if (node.$compMask !== null || node.$compMask !== undefined) {
          //get the row
          var row = _.find(rows, function (row) {
            return row.getTreeNode().$ord === node.$ord;
          });
          if (row && node.$isInherited) {
            var treeNode = row.getTreeNode();
            treeNode.$parentMask = node.getParent().$isRoot ? node.getParent().$compMask : node.getParent().$parentMask;
            this.$modifiedRows.push(row);
          }
        }
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/tree/TreeNode} node
       * @returns {Promise}
       */
    }, {
      key: "$resetKids",
      value: function $resetKids(node) {
        var _this13 = this;
        if (node.$kidsLoaded) {
          return node.getKids().then(function (kids) {
            return Promise.all(kids.map(function (kid) {
              if (kid.$compMask !== null) {
                _this13.$resetRow(kid);
                // recursively traverse the tree
                return _this13.$resetKids(kid);
              }
            }));
          });
        } else {
          return Promise.resolve([]);
        }
      }

      /**
       * @override
       * @returns {string}
       */
    }, {
      key: "getContextMenuSelector",
      value: function getContextMenuSelector() {
        return 'tr';
      }

      /**
       * @private
       * @param {Event} e
       * @returns {Promise.<module:bajaux/util/CommandButtonGroup>}
       */
    }, {
      key: "$toContextMenu",
      value: function $toContextMenu(e) {
        var table = this.$getTable();
        var index = $(e.target).closest('tr').index();
        var selection = table.$getSelection();
        var rows = table.getModel().getRows();
        var node;
        if (selection.isSelected(index)) {
          node = selection.getSelectedElements(rows)[0].getTreeNode();
        }
        var clearConfiguredCmd = new ClearConfiguredCommand({
          selectedNode: node,
          categoryBrowser: this
        });
        var commandGroup = new CommandGroup({
          commands: [clearConfiguredCmd]
        });
        var ordString;
        ordString = baja.Ord.make(node.$ord).relativizeToSession().toString();
        var isComponent = ordString.startsWith("station:|slot:/");
        var isOrion = this.$isOrionOrd(ordString);
        if (isComponent) {
          ordString = ordString + "|view:webEditors:UxCategoryBrowser";
        } else {
          ordString = ORD_CATEGORY_BROWSER_UXVIEW + "?root=" + baja.SlotPath.escape(ordString);
        }
        return HyperlinkCommand.make(baja.Ord.make(ordString), {
          checkPermissions: true,
          displayNameFormat: webEditorsLex.get('CategoryBrowser.GoIntoCommand.displayName'),
          icon: webEditorsLex.get('CategoryBrowser.GoIntoCommand.icon')
        }).then(function (hyperlinkCmd) {
          return baja.Ord.make(ordString).resolve().then(function (target) {
            commandGroup.add(hyperlinkCmd);
            if (!target.getPermissionsOnTarget().hasAdminRead()) {
              hyperlinkCmd.setEnabled(false);
            }
            if (!target.getPermissionsOnTarget().hasAdminWrite() || isOrion) {
              clearConfiguredCmd.setEnabled(false);
            }
            return commandGroup;
          });
        });
      }

      /**
       * @private
       * @param {String} ordString
       * @returns {boolean}
       */
    }, {
      key: "$isOrionOrd",
      value: function $isOrionOrd(ordString) {
        return ordString.startsWith("orion:");
      }

      /**
       * @private
       * @returns {Promise.<module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel>}
       */
    }, {
      key: "$buildModel",
      value: function $buildModel() {
        var _this14 = this;
        return getCategoryService().then(function (service) {
          return Promise.all([_this14.$getCategoryColumns(), _this14.$getRootNodes(service)]).then(function (_ref5) {
            var _ref6 = _slicedToArray(_ref5, 2),
              columns = _ref6[0],
              nodes = _ref6[1];
            return new TreeTableModel({
              rows: nodes,
              columns: columns
            });
          });
        });
      }

      /**
       * @private
       * @returns {Promise.<String>}
       */
    }, {
      key: "$getCategories",
      value: function $getCategories() {
        return this.$getNamedCategories().then(function (namedCategories) {
          // Category browser always contains at least 8 category columns
          // if it's not named categories, then default name will Category + index will be shown
          var maxCategories = 8;
          var categories = [];
          var maxIndex = Math.max.apply(Math, namedCategories.map(function (o) {
            return o.index;
          }));
          if (maxIndex > maxCategories) {
            maxCategories = maxIndex;
          }
          while (maxCategories) {
            categories.push("");
            maxCategories--;
          }
          namedCategories.forEach(function (nameCategory) {
            categories[nameCategory.index - 1] = nameCategory.displayName;
          });
          return categories.map(function (category, index) {
            return category === "" ? wbUtilLex.get('category.generic', [index + 1]) : category;
          });
        });
      }

      /**
       * @private
       * @returns {Promise.<Array.<Object>>}
       */
    }, {
      key: "$getNamedCategories",
      value: function $getNamedCategories() {
        return getCategoryService().then(function (service) {
          var categories = service.getSlots().properties().is("baja:Category").toValueArray();
          return Promise.all(categories.map(function (cat) {
            return cat.lease().then(function () {
              return {
                displayName: cat.getDisplayName(),
                index: cat.getIndex()
              };
            });
          }));
        });
      }

      /**
       * @private
       * @returns {Promise.<Array.<module:nmodule/webEditors/rc/wb/table/model/Column>>}
       */
    }, {
      key: "$getCategoryColumns",
      value: function $getCategoryColumns() {
        var _this15 = this;
        return this.$getCategories().then(function (categories) {
          _this15.$categories = categories;
          return userUtils.resolveCurrentUser().then(function (user) {
            // get current user permission and check for adminWrite access.
            var permissionMap = user.get("permissions");
            var columns = [];
            columns.push(new DisplayNameWithIconColumn('categoryName', {
              displayName: ""
            }));
            columns.push(new InheritedColumn('inherit', {
              displayName: wbUtilLex.get('category.inherit.label')
            }));
            categories.forEach(function (category, index) {
              columns.push(new CategoryColumn(category, {
                displayName: category,
                index: index + 1,
                hasAdminWrite: permissionMap.getPermissions(index + 1).hasAdminWrite()
              }));
            });
            return columns;
          });
        });
      }
    }, {
      key: "resolve",
      value: function resolve(ord) {
        this.$ord = ord;
        return _superPropGet(CategoryBrowser, "resolve", this, 3)(arguments);
      }

      /**
       * Returns categorizable root nodes
       * @private
       * @param {baja.Component} service
       * @returns {Promise.<Array.<CategoryTreeNode>>}
       */
    }, {
      key: "$getRootNodes",
      value: function $getRootNodes(service) {
        var _this16 = this;
        var value = this.value();
        var query = getViewQuery(this.$ord);
        var root = query && query.getParameters().root && baja.SlotPath.unescape(query.getParameters().root);
        if (!value.getType().is('baja:CategoryService')) {
          // Category browser is launched from component
          return this.$getComponentTreeNode(value, service).then(function (node) {
            return [node];
          });
        } else {
          if (root) {
            // Category browser is launched from non component nodes
            return getNavNodeInfo(root).then(function (obj) {
              return baja.importTypes([obj.typeSpec]).then(function (_ref7) {
                var _ref8 = _slicedToArray(_ref7, 1),
                  type = _ref8[0];
                obj.type = type;
                if (root.startsWith('history:')) {
                  return getLocalHistoryOrd(root).then(function (historyOrd) {
                    obj.ord = historyOrd;
                    return _this16.$getNonComponentTreeNode(obj, service);
                  });
                } else {
                  return _this16.$getNonComponentTreeNode(obj, service);
                }
              });
            });
          } else {
            return getNavChildren("local:").then(function (objs) {
              objs = JSON.parse(objs);
              return Promise.all(objs.map(function (obj) {
                return baja.importTypes([obj.typeSpec]).then(function (_ref9) {
                  var _ref10 = _slicedToArray(_ref9, 1),
                    type = _ref10[0];
                  obj.type = type;
                  if (type.is('baja:Space') && type.is('baja:ICategorizable')) {
                    obj.isRoot = true;
                    if (type.is('baja:ComponentSpace')) {
                      return getCategoryMask(obj.ord).then(function (mask) {
                        // rootNode's component mask cannot be empty
                        obj.compMask = mask === "" ? CategoryMask.make("1") : CategoryMask.make(mask);
                        return obj;
                      });
                    } else {
                      //SpySpace is a special case where its own ORD points to something else and resolves to a Spy
                      //which is not a NavNode, as spySpace is the only case which has this special behaviour
                      //adding the check to filter it out of NavNodes.
                      if (!type.is('baja:SpySpace')) {
                        //Fox File system adds this extra caret for NavNodes and hence handling it in client side to add the same
                        if (type.is('baja:FileSystem')) {
                          obj.ord = obj.ord + "^";
                          obj.displayName = webEditorsLex.get('stationTree.files.displayName');
                        }
                        // rootNode's component mask cannot be empty
                        obj.compMask = service.getOrdMap().getCategoryMask(baja.Ord.make(obj.ord)) || CategoryMask.make("1");
                        return obj;
                      }
                    }
                  }
                });
              })).then(function (nodeObjs) {
                nodeObjs = sortBy(compact(nodeObjs), 'displayName');
                return nodeObjs.map(function (obj) {
                  return new CategoryTreeNode(obj);
                });
              });
            });
          }
        }
      }

      /**
       * Converts and returns treeNode for given component.
       * @private
       * @param {Object} obj
       * @param {baja.Component} service
       * @returns {CategoryTreeNode[]}
       */
    }, {
      key: "$getNonComponentTreeNode",
      value: function $getNonComponentTreeNode(obj, service) {
        obj.compMask = service.getOrdMap().getCategoryMask(baja.Ord.make(obj.ord));
        if (obj.compMask === null || obj.compMask === undefined) {
          // if category mask of current node is null, recursively find the categoryMask of the parent.
          obj.parentMask = this.$getNonComponentAppliedMask(baja.Ord.make(obj.ord).relativizeToSession().toString().split("/"), service) || CategoryMask.make("1");
          return [new CategoryTreeNode(obj)];
        }
        return [new CategoryTreeNode(obj)];
      }

      /**
       * Converts and returns treeNode for given component.
       * @private
       * @param {Array.<String>} paths
       * @param {baja.Component} service
       * @returns {CategoryMask|null}
       */
    }, {
      key: "$getNonComponentAppliedMask",
      value: function $getNonComponentAppliedMask(paths, service) {
        if (paths.length === 0) {
          return null;
        }
        var ord = paths.join("/");
        var mask = service.getOrdMap().getCategoryMask(baja.Ord.make(ord));
        paths.pop();
        return mask || this.$getNonComponentAppliedMask(paths, service);
      }

      /**
       * Converts and returns treeNode for given component.
       * @private
       * @param {baja.Component} compNode
       * @param {baja.Component} service
       * @returns {Promise.<CategoryTreeNode>}
       */
    }, {
      key: "$getComponentTreeNode",
      value: function $getComponentTreeNode(compNode, service) {
        return createTreeNode(convertNodeToObj(compNode), null, service).then(function (node) {
          if (node.$compMask === undefined || node.$compMask === null || node.$parentMask === null || node.$parentMask === undefined) {
            var ord = toCategorizableOrd(compNode.getNavOrd());
            var parent = compNode.getParent();
            var parentOrd;
            if (parent && parent.getType().is('baja:ICategorizable')) {
              parentOrd = toCategorizableOrd(parent.getNavOrd());
            } else {
              parentOrd = toCategorizableOrd(ord);
            }
            return Promise.all([getCategoryMask(ord), Promise.resolve(parentOrd && getAppliedCategoryMask(parentOrd) || "")]).then(function (_ref11) {
              var _ref12 = _slicedToArray(_ref11, 2),
                maskEncoding = _ref12[0],
                parentMaskEncoding = _ref12[1];
              var compMask = CategoryMask.make(maskEncoding);
              var parentMask = CategoryMask.make(parentMaskEncoding);
              node.$isInherited = compMask.isNull();
              //for inherited columns the parent mask is component mask
              node.$compMask = node.$isInherited ? parentMask : compMask;
              node.$parentMask = parentMask;
              return node;
            });
          }
          return node;
        });
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/Table}
       */
    }, {
      key: "$getTable",
      value: function $getTable() {
        return this.queryWidget('table');
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getGoToTopCommand",
      value: function $getGoToTopCommand() {
        return findCommand(this, HyperlinkCommand);
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getSaveCommand",
      value: function $getSaveCommand() {
        return findCommand(this, SaveCommand);
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getShowConfiguredCommand",
      value: function $getShowConfiguredCommand() {
        return findCommand(this, ShowConfiguredCommand);
      }
    }]);
  }(spandrel(function (value, _ref13) {
    var self = _ref13.self;
    return self.$buildModel().then(function (model) {
      return [spandrel.jsx(CategoryTable, {
        spandrelKey: "table",
        value: model,
        className: "-t-CategoryBrowser-table",
        properties: {
          fixedHeaders: true,
          enableStriping: false
        }
      })];
    });
  }));
  return CategoryBrowser;
});
