function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/TransferWidget
 */
define([], function () {
  'use strict';

  /**
   * An interface that can be placed on widgets which support the transfer framework.
   *
   * @interface
   * @alias module:nmodule/webEditors/rc/wb/util/TransferWidget
   * @since Niagara 4.15
   */
  var TransferWidget = /*#__PURE__*/function () {
    function TransferWidget() {
      _classCallCheck(this, TransferWidget);
    }
    return _createClass(TransferWidget, [{
      key: "insertTransferData",
      value:
      /**
       * If implemented and the TransferWidget is provided as an argument to a PasteCommand, this method will be invoked to
       * let the widget handle its own paste operation.
       * @abstract
       * @param {Array} subject
       * @param {Object} transferParams
       * @returns {Promise}
       */
      function insertTransferData(subject, transferParams) {
        throw new Error('not implemented');
      }

      /**
       * If implemented and the TransferWidget provided as an argument to a CutCommand, this method will be invoked to
       * let the widget handle its own cut operation.
       * @abstract
       * @param {Array} subject
       * @returns {Promise}
       */
    }, {
      key: "removeTransferData",
      value: function removeTransferData(subject) {
        throw new Error('not implemented');
      }

      /**
       * This will be called on a copy or cut operation. Allows the widget to implement its own logic for taking the values being copied,
       * and converting them into an Envelope that will be placed onto the clipboard. If not implemented, default "copy" logic will be used.
       * @abstract
       * @param {Array} subject the things we're copying
       * @returns {Promise.<module:bajaux/dragdrop/Envelope>}
       */
    }, {
      key: "getTransferData",
      value: function getTransferData(subject) {
        throw new Error('not implemented');
      }
    }]);
  }();
  return TransferWidget;
});
