function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Patrick Sager
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/AutoLogoffSettingsEditor
 */
define(['baja!', 'baja!baja:AutoLogoffSettings', 'lex!webEditors', 'underscore', 'Promise', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/fe/baja/util/subscriberUtils', 'hbs!nmodule/webEditors/rc/wb/util/template/AutoLogoffSettingsEditor'], function (baja, types, lexs, _, Promise, events, ComplexCompositeEditor, spaceUtils, subscriberUtils, template) {
  'use strict';

  var resolveService = spaceUtils.resolveService;
  var leaseWhenNeeded = subscriberUtils.leaseWhenNeeded;
  var KEY_AUTO_LOGOFF_ENABLED = 'autoLogoffEnabled';
  var KEY_USE_DEFAULT_AUTO_LOGOFF_PERIOD = 'useDefaultAutoLogoffPeriod';
  var KEY_AUTO_LOGOFF_PERIOD = 'autoLogoffPeriod';
  var KEY_ABSOLUTE_LOGOFF_ENABLED = 'absoluteLogoffEnabled';
  var keys = [KEY_AUTO_LOGOFF_ENABLED, KEY_USE_DEFAULT_AUTO_LOGOFF_PERIOD, KEY_AUTO_LOGOFF_PERIOD, KEY_ABSOLUTE_LOGOFF_ENABLED];
  var lex = lexs[0];
  var getUserService = leaseWhenNeeded(_.partial(resolveService, 'baja:UserService'));

  /**
   * Editor for setting the auto logoff settings on a user.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/util/AutoLogoffSettingsEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
   */
  var AutoLogoffSettingsEditor = function AutoLogoffSettingsEditor() {
    ComplexCompositeEditor.apply(this, arguments);
  };
  AutoLogoffSettingsEditor.prototype = Object.create(ComplexCompositeEditor.prototype);
  AutoLogoffSettingsEditor.prototype.constructor = AutoLogoffSettingsEditor;

  /**
   * Return the AutoLogoffSettings properties.
   *
   * @returns {string[]}
   */
  AutoLogoffSettingsEditor.prototype.getSlotFilter = function () {
    return keys;
  };

  /**
   * Set up the dom and event handler
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */
  AutoLogoffSettingsEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.on(events.MODIFY_EVENT, function () {
      that.doReadonly(that.isReadonly())["catch"](function () {
        //if we can't set the editors readonly, just leave them as they are.
      });
      return true;
    });
    var rows = keys.map(function (key) {
      return {
        key: key,
        name: lex.get('AutoLogoffSettingsEditor.' + key)
      };
    });
    that.jq().html(template({
      rows: rows
    }));
    return ComplexCompositeEditor.prototype.doInitialize.apply(this, arguments);
  };

  /**
   * Make the ComplexCompositeBuilder.
   *
   * @returns {module:nmodule/webEditors/rc/fe/config/ComplexCompositeBuilder}
   */
  AutoLogoffSettingsEditor.prototype.makeBuilder = function () {
    var builder = ComplexCompositeEditor.prototype.makeBuilder.apply(this, arguments),
      that = this;
    builder.getDomFor = function (key) {
      return that.jq().find('.key-' + key);
    };
    return builder;
  };

  /**
   * Load the AutoLogoffSettings into the editor and load the child editors.
   *
   * @param {baja.Complex} value a `baja:AutoLogoffSettings` instance
   * @returns {Promise}
   */
  AutoLogoffSettingsEditor.prototype.doLoad = function (value) {
    var _arguments = arguments,
      _this = this;
    var that = this;
    return this.getOrdBase().then(function (base) {
      return that.$getUserService(base);
    }).then(function (userService) {
      var serviceAbsoluteLogoffEnabled = userService ? userService.getAbsoluteLogoffEnabled() : true;
      var autoLogoffEnabledRow = _this.jq().find('tr')[3];
      if (autoLogoffEnabledRow) {
        _this.jq().find('tr')[3].style.visibility = serviceAbsoluteLogoffEnabled ? 'visible' : 'collapse';
      }
      if (!baja.hasType(value, 'baja:AutoLogoffSettings')) {
        throw new Error('baja:AutoLogoffSettings required');
      }
      return ComplexCompositeEditor.prototype.doLoad.apply(_this, _arguments).then(function () {
        var builder = that.getBuilder();
        if (!value.get(KEY_AUTO_LOGOFF_ENABLED)) {
          return Promise.all([builder.getEditorFor(KEY_USE_DEFAULT_AUTO_LOGOFF_PERIOD).setReadonly(true), builder.getEditorFor(KEY_AUTO_LOGOFF_PERIOD).setReadonly(true)]);
        } else if (value.get(KEY_USE_DEFAULT_AUTO_LOGOFF_PERIOD)) {
          return builder.getEditorFor(KEY_AUTO_LOGOFF_PERIOD).setReadonly(true);
        }
      });
    });
  };

  /**
   * Set child editors readonly/writable based on the readonly param and
   * the values of the AutoLogoffEnabled and UseDefaultAutoLogoffPeriod editors
   *
   * @param {boolean} readonly
   * @returns {Promise}
   */
  AutoLogoffSettingsEditor.prototype.doReadonly = function (readonly) {
    var builder = this.getBuilder();
    var enabledEditor = builder.getEditorFor(KEY_AUTO_LOGOFF_ENABLED);
    var useDefaultEditor = builder.getEditorFor(KEY_USE_DEFAULT_AUTO_LOGOFF_PERIOD);
    var autoLogoffPeriodEditor = builder.getEditorFor(KEY_AUTO_LOGOFF_PERIOD);
    var absoluteLogoffEnabled = builder.getEditorFor(KEY_ABSOLUTE_LOGOFF_ENABLED);
    if (!enabledEditor || !useDefaultEditor || !autoLogoffPeriodEditor) {
      return Promise.resolve();
    }
    return Promise.all([enabledEditor.read(), useDefaultEditor.read()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        enabledValue = _ref2[0],
        useDefaultValue = _ref2[1];
      return Promise.all([enabledEditor.setReadonly(readonly), useDefaultEditor.setReadonly(readonly || !enabledValue), autoLogoffPeriodEditor.setReadonly(readonly || !enabledValue || useDefaultValue), absoluteLogoffEnabled.setReadonly(readonly)]);
    });
  };

  /**
   * Returns the UserService of the station
   * @private
   * @since Niagara 4.15
   * @param {baja.Component} [base]
   * @returns {Promise.<baja.Component|undefined>}
   */
  AutoLogoffSettingsEditor.prototype.$getUserService = function (base) {
    return getUserService(base)["catch"](function () {
      return undefined;
    });
  };
  return AutoLogoffSettingsEditor;
});
