function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/tree/PaletteNavTree
 */
define(['baja!', 'log!nmodule.webEditors.rc.wb.tree.PaletteNavTree', 'lex!webEditors', 'jquery', 'Promise', 'underscore', 'bajaux/commands/Command', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/servlets/palette', 'nmodule/webEditors/rc/wb/tree/NavTree', 'nmodule/webEditors/rc/wb/tree/TreeNode', 'nmodule/webEditors/rc/util/storageUtil'], function (baja, log, lexs, $, Promise, _, Command, asyncUtils, feDialogs, palette, NavTree, TreeNode, storageUtil) {
  'use strict';

  var webEditorsLex = lexs[0];
  var getLocalStorage = storageUtil.getLocalStorage;
  var DEFAULT_PALETTES = ['alarm', 'baja', 'control', 'history', 'kitControl', 'schedule'];
  var logFine = log.fine.bind(log);
  var once = _.once;
  var doRequire = asyncUtils.doRequire;
  var requireUxBuilder = once(function () {
    return baja.importTypes(['uxBuilder:UxBuilder']).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
        type = _ref2[0];
      return type && doRequire('nmodule'.toLowerCase() + '/uxBuilder/rc/ux/make/MwPalettePreview', type.getJsDependencies());
    });
  });

  ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  function getModuleName(obj) {
    return obj.n;
  }

  /**
   * Return true if this node represents a palette (an actual palette like baja
   * or workbench; not an item inside a palette).
   *
   * @inner
   * @param {module:nmodule/webEditors/rc/wb/tree/TreeNode} node
   * @returns {Boolean} true if node represents a palette root node
   */
  function isPaletteNode(node) {
    return node.getFullPath().length === 2;
  }

  /**
   * Gets the value for the `datalist` facet on the dialog string editor.
   *
   * @inner
   * @returns {Promise} promise to be resolved with a string to be
   * stuck in the StringEditor's `datalist` facet
   */
  function getDatalist() {
    return palette.list().then(function (paletteObjs) {
      return _.map(paletteObjs, getModuleName).join(';');
    });
  }

  /**
   * Resolve a single `TreeNode` that can be added to the Palette nav tree.
   * It's assumed it does not already exist.
   *
   * @inner
   * @param {String} paletteToAdd module name for the palette to add
   * @returns {Promise} promise to be resolved with a new `TreeNode`
   * to add to the palette
   */
  function retrievePaletteNode(paletteToAdd) {
    return palette.getPalettes([paletteToAdd]).then(function (node) {
      return node.getKid(paletteToAdd);
    }).then(function (kid) {
      delete kid.$parent; //TODO: come up with reasonable way of transplanting tree nodes
      return kid;
    });
  }

  /**
   * Shows a string editor dialog prompting the user for a palette name to open.
   *
   * @inner
   * @returns {Promise} promise to be resolved with a String containing
   * a module name
   */
  function getPaletteToAdd() {
    return getDatalist().then(function (datalist) {
      return feDialogs.showFor({
        title: webEditorsLex.get('commands.addPalette.title'),
        properties: {
          datalist: datalist
        },
        value: '',
        formFactor: 'mini'
      });
    });
  }

  /**
   * Prompts the user for a palette to add, retrieves the data from the station,
   * and adds it to the palette node.
   *
   * @inner
   * @param {module:nmodule/webEditors/rc/wb/tree/TreeNode} treeNode the tree
   * node containing all palette data (one child node per open palette)
   * @returns {Promise} promise to be resolved when the new palette
   * is added (or operation is canceled by user)
   * @throws {Error} if no TreeNode given
   */
  function doAddPalette(treeNode) {
    if (!(treeNode instanceof TreeNode)) {
      throw new Error('TreeNode required');
    }
    var paletteToAdd;
    return getPaletteToAdd().then(function (p) {
      if (!p) {
        return;
      }
      paletteToAdd = p;
      return treeNode.getKid(paletteToAdd);
    }).then(function (existingKid) {
      if (!paletteToAdd || existingKid) {
        return;
      }
      return retrievePaletteNode(paletteToAdd).then(function (node) {
        return treeNode.add(node);
      }).then(function () {
        return treeNode.reorder(TreeNode.BY_NODE_NAME);
      });
    });
  }

  ////////////////////////////////////////////////////////////////
  // Commands
  ////////////////////////////////////////////////////////////////

  /**
   * A command for opening a new palette in the palette tree. Will show a
   * user prompt for the palette name and then add to the tree.
   *
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   * @param {module:nmodule/webEditors/rc/wb/tree/NavTree} ed the `NavTree` to
   * bind this `Command` to
   */
  var AddPaletteCommand = function AddPaletteCommand(ed) {
    Command.call(this, {
      module: 'webEditors',
      lex: 'commands.addPalette',
      /**
       * Shows dialog for a palette name and adds the palette.
       */
      func: function func() {
        return doAddPalette(ed.value());
      }
    });
  };
  AddPaletteCommand.prototype = Object.create(Command.prototype);
  AddPaletteCommand.prototype.constructor = AddPaletteCommand;

  /**
   * A command for closing the selected palettes.
   *
   * @inner
   * @class
   * @extends module:bajaux/commands/Command
   * @param {module:nmodule/webEditors/rc/wb/tree/NavTree} ed the
   * `NavTree` to bind this `Command` to
   */
  var ClosePaletteCommand = function ClosePaletteCommand(ed) {
    Command.call(this, {
      module: 'webEditors',
      lex: 'commands.closePalette',
      enabled: false,
      /**
       * Closes the selected palettes.
       */
      func: function func() {
        var that = this,
          rootNode = ed.value();
        function removeIfPaletteNode(node) {
          if (isPaletteNode(node)) {
            return rootNode.remove(node);
          }
        }
        return Promise.all(ed.getSelectedNodes().map(removeIfPaletteNode)).then(function () {
          return that.setEnabled(false);
        });
      }
    });
  };
  ClosePaletteCommand.prototype = Object.create(Command.prototype);
  ClosePaletteCommand.prototype.constructor = ClosePaletteCommand;

  ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////

  /**
   * NavTree for working with Palettes.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/tree/PaletteNavTree
   * @extends module:nmodule/webEditors/rc/wb/tree/NavTree
   */
  var PaletteNavTree = function PaletteNavTree(params) {
    NavTree.call(this, $.extend(true, {}, params || {}, {
      moduleName: 'webEditors',
      keyName: 'palette',
      properties: {
        hideRoot: true
      }
    }));
    this.getCommandGroup().add(new AddPaletteCommand(this));
    this.getCommandGroup().add(new ClosePaletteCommand(this));
  };
  PaletteNavTree.prototype = Object.create(NavTree.prototype);
  //TODO: NavTree currently makes kids using this.constructor. revisit when smarter
  PaletteNavTree.prototype.constructor = NavTree;
  PaletteNavTree.prototype.$getAddPaletteCommand = function () {
    return this.getCommandGroup().get(0);
  };
  PaletteNavTree.prototype.$getClosePaletteCommand = function () {
    return this.getCommandGroup().get(1);
  };

  /**
   * Registers event handler that will enable/disable the Close Palette
   * command as appropriate when different palette nodes are selected.
   *
   * @param {JQuery} dom
   * @returns {Promise} promise to be resolved after the NavTree
   * superclass initialization is complete and the node selection event
   * handlers are registered
   */
  PaletteNavTree.prototype.doInitialize = function (dom) {
    var that = this;
    return Promise.resolve(NavTree.prototype.doInitialize.apply(that, arguments)).then(function () {
      dom.on(NavTree.SELECTED_EVENT + ' ' + NavTree.DESELECTED_EVENT, function () {
        var nodes = that.getSelectedNodes(),
          cmd = that.$getClosePaletteCommand(),
          enabled = true;
        if (!nodes.length) {
          enabled = false;
        } else {
          for (var i = 0; i < nodes.length; i++) {
            if (!isPaletteNode(nodes[i])) {
              enabled = false;
              break;
            }
          }
        }
        return cmd.setEnabled(enabled);
      });
    });
  };

  /**
   * @returns {string}
   */
  function paletteStorageKey() {
    return baja.getUserName() + '.profile.openPalettes';
  }

  /**
   * @returns {Array.<String>}
   * @since Niagara 4.15
   */
  PaletteNavTree.getOpenPalettes = function () {
    try {
      var openPalettes = getLocalStorage().getItem(paletteStorageKey());
      if (openPalettes) {
        return JSON.parse(openPalettes);
      }
    } catch (e) {}
    return [].concat(DEFAULT_PALETTES);
  };

  /**
   * @param {Array.<String>} paletteNames
   * @since Niagara 4.15
   */
  PaletteNavTree.savePalettes = function (paletteNames) {
    try {
      getLocalStorage().setItem(paletteStorageKey(), JSON.stringify(paletteNames));
    } catch (e) {}
  };

  /**
   * @private
   * @since Niagara 4.15
   * @returns {Promise}
   */
  PaletteNavTree.$getMwPalettePreview = function () {
    return requireUxBuilder();
  };

  /**
   * @since Niagara 4.15
   * @returns {Promise}
   */
  PaletteNavTree.getPaletteNavTree = function () {
    return PaletteNavTree.$getMwPalettePreview().then(function (MwPalettePreview) {
      return new MwPalettePreview({
        properties: {
          storageKey: 'profile.openPalettes'
        }
      });
    })["catch"](function (err) {
      logFine(err);
      return new PaletteNavTree();
    });
  };
  return PaletteNavTree;
});
