/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @module nmodule/webEditors/rc/wb/table/tree/TreeNodeRow
 */
define(['nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/wb/tree/TreeNode'], function (Row, TreeNode) {
  'use strict';

  /**
   * API Status: **Development**
   *
   * Row backed by a TreeNode. The value and icon of the TreeNode will be used
   * as the subject and icon of the row itself.
   *
   * This type of row will be used in a `TreeTableModel`. This allows the use of
   * regular Column types in the model (using the actual value of the node as
   * the row's subject) while still being able to use the expand/collapse
   * functionality of a tree (by accessing `#getTreeNode()`).
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/table/tree/TreeNodeRow
   * @extends module:nmodule/webEditors/rc/wb/table/model/Row
   * @param {module:nmodule/webEditors/rc/wb/tree/TreeNode} node
   * @see module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel
   * @since Niagara 4.6
   */
  var TreeNodeRow = function TreeNodeRow(node) {
    if (!(node instanceof TreeNode)) {
      throw new Error('TreeNode required');
    }
    Row.call(this, node.value(), node.getIcon());
    this.$node = node;
  };
  TreeNodeRow.prototype = Object.create(Row.prototype);
  TreeNodeRow.prototype.constructor = TreeNodeRow;

  /**
   * @returns {module:nmodule/webEditors/rc/wb/tree/TreeNode} the node backing
   * this row
   */
  TreeNodeRow.prototype.getTreeNode = function () {
    return this.$node;
  };

  /**
   * @returns {Array.<String>} the icon of the backing TreeNode
   */
  TreeNodeRow.prototype.getIcon = function () {
    return this.$node.getIcon();
  };
  return TreeNodeRow;
});
