/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Aaron Laniewicz
 */

/**
 * @module nmodule/webEditors/rc/wb/table/model/columns/ToStringColumn
 */
define(['nmodule/webEditors/rc/wb/table/model/Column'], function (Column) {
  'use strict';

  /**
   * API Status: **Development**
   *
   * Column for showing a row's subject string representation.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/table/model/columns/ToStringColumn
   * @extends module:nmodule/webEditors/rc/wb/table/model/Column
   */
  var ToStringColumn = function ToStringColumn(name, params) {
    params = params || {};
    params.flags = Column.flags.READONLY;
    Column.call(this, name, params);
  };
  ToStringColumn.prototype = Object.create(Column.prototype);
  ToStringColumn.prototype.constructor = ToStringColumn;

  /**
   * Return the row's subject string representation.
   *
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @returns {String}
   */
  ToStringColumn.prototype.getValueFor = function (row) {
    return String(row.getSubject());
  };
  return ToStringColumn;
});
