function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Development**
 *
 * @module nmodule/webEditors/rc/wb/table/commands/RenameCommand
 * @since Niagara 4.12
 */

/**
 * Determines if a name is unique.
 *
 * @callback module:nmodule/webEditors/rc/wb/table/commands/RenameCommand~validateUniqueName
 * @param {String} name
 * @returns {Boolean} true if unique, false otherwise
 */

define(['baja!', 'jquery', 'lex!workbench', 'Promise', 'dialogs', 'nmodule/webEditors/rc/fe/feDialogs', 'bajaux/commands/Command'], function (baja, $, lexs, Promise, dialogs, feDialogs, Command) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    workbenchLex = _lexs[0];
  var dialogTitle = workbenchLex.get("compositeEditor.rename.label");
  var errorMsg = workbenchLex.get("compositeEditor.rename.exists");
  function showError(err) {
    dialogs.showOk({
      title: dialogTitle,
      text: err.message
    });
  }
  function handleRename(getTable, validateUniqueName) {
    var table = getTable();
    var selection = table.$getSelection();
    var model = table.value();
    var rows = model.getRows();
    var selectedRows = selection.getSelectedElements(model.getRows());
    var rowsChanged = [];
    var oldNames = [];
    function renameRows() {
      if (selectedRows.length > 0) {
        var row = selectedRows.shift(),
          subject = row.getSubject();
        return feDialogs.showFor({
          title: dialogTitle,
          value: subject.name,
          formFactor: 'mini'
        }).then(function (name) {
          if (name && name !== subject.name) {
            if (rows.filter(function (row) {
              return row.getSubject().name === name;
            }).length > 0 || !validateUniqueName(name)) {
              throw new Error(errorMsg);
            } else {
              oldNames.push(subject.name);
              subject.name = name;
              rowsChanged.push(row);
            }
          }
        }).then(renameRows);
      }
      return Promise.resolve();
    }
    return renameRows().then(function () {
      model.emit('rowsChanged', rowsChanged);
      table.trigger('rowsRenamed', rowsChanged, oldNames);
    })["catch"](showError);
  }

  /**
   * This command will modify the `name` property of a rows subject directly based upon the user's
   * input for the new name. This command will not allow the user to enter a duplicate name. The
   * command will directly validate name uniqueness against names already in the table.
   * An additional `validateUniqueName` callback can be passed to allow for custom unique validation
   * for names that are not in the table.
   *
   * This command will be initially disabled, and it is the responsibility of the code where it is
   * used to manage the command's enabled / disabled state.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/table/commands/RenameCommand
   * @see module:nmodule/webEditors/rc/wb/table/Table
   * @param {Function} getTable a function that returns the target table of this command.
   * @param {Object} [params]
   * @param {module:nmodule/webEditors/rc/wb/table/commands/RenameCommand~validateUniqueName} [params.validateUniqueName]
   * if not specified, the name will only be checked against existing entries in the table.
   * @param {String} [params.module='webEditors'] the module to look up the commands lexicon entry
   * @param {String} [params.lex='commands.rename'] the lexicon key to look up the command with
   */
  var RenameCommand = /*#__PURE__*/function (_Command) {
    function RenameCommand(getTable) {
      var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        _ref$validateUniqueNa = _ref.validateUniqueName,
        validateUniqueName = _ref$validateUniqueNa === void 0 ? function () {
          return true;
        } : _ref$validateUniqueNa,
        _ref$module = _ref.module,
        module = _ref$module === void 0 ? 'webEditors' : _ref$module,
        _ref$lex = _ref.lex,
        lex = _ref$lex === void 0 ? 'commands.rename' : _ref$lex;
      _classCallCheck(this, RenameCommand);
      return _callSuper(this, RenameCommand, [{
        module: module,
        lex: lex,
        enabled: false,
        func: function func() {
          return handleRename(getTable, validateUniqueName);
        }
      }]);
    }
    _inherits(RenameCommand, _Command);
    return _createClass(RenameCommand);
  }(Command);
  return RenameCommand;
});
