function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Development**
 *
 * @module nmodule/webEditors/rc/wb/table/commands/RemoveCommand
 * @since Niagara 4.12
 */
define(['bajaux/commands/Command', 'lex!webEditors', 'Promise'], function (Command, lexs, Promise) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];

  /**
   * Remove rows from the table and apply changes to the selected row.
   * @param {Function} getTable a function that returns the target table for this command
   * @returns {Promise}
   */
  function handleRemove(getTable) {
    var table = getTable();
    var selection = table.$getSelection();
    var model = table.getModel();
    var rows = selection.getSelectedElements(model.getRows());
    if (!rows.length) {
      return Promise.resolve();
    }
    return model.removeRows(rows).then(function () {
      table.setModified(true);
      table.trigger('rowsRemoved', rows);
    });
  }

  /**
   * This command will remove the selected rows of the given table from the backing TableModel. The
   * table model will also emit a rowsRemoved event when this happens.
   *
   * As for the undoable, it is keep as optional, it can be enabled by `undoable: true`. Here On
   * the first redo() call, it stores all rows before removing the row, and then it removes the row.
   * When undo() is called, it clears all the rows and inserts all the rows that were stored before
   * the removal. If redo() is called again, the rows after the removal are also stored separately,
   * so that it can clear all the rows and re-insert all the rows that were stored after the removal.
   *
   * This command will be initially disabled, and it is the responsibility of the code where it is
   * used to manage the command's enabled / disabled state.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/table/commands/RemoveCommand
   * @see module:nmodule/webEditors/rc/wb/table/Table
   * @param {Function} getTable a function that returns the target table of this command.
   * @param {String} [params.module='webEditors'] the module to look up the commands lexicon entry
   * @param {String} [params.lex='commands.removeItem'] the lexicon key to look up the command with
   * @param {Boolean} [params.undoable] true if the command should be undoable
   * @param {String} [params.redoText] Text describing what the command will do
   * @param {String} [params.undoText] Text describing what undoing the command will do
   */
  var RemoveCommand = /*#__PURE__*/function (_Command) {
    function RemoveCommand(getTable) {
      var _this;
      var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        _ref$module = _ref.module,
        module = _ref$module === void 0 ? 'webEditors' : _ref$module,
        _ref$lex = _ref.lex,
        lex = _ref$lex === void 0 ? 'commands.removeItem' : _ref$lex,
        undoable = _ref.undoable,
        _ref$redoText = _ref.redoText,
        _redoText = _ref$redoText === void 0 ? webEditorsLex.get('RemoveCommand.commands.remove.redoText') : _ref$redoText,
        _ref$undoText = _ref.undoText,
        _undoText = _ref$undoText === void 0 ? webEditorsLex.get('RemoveCommand.commands.remove.undoText') : _ref$undoText;
      _classCallCheck(this, RemoveCommand);
      _this = _callSuper(this, RemoveCommand, [{
        module: module,
        lex: lex,
        enabled: false,
        func: function func() {
          return handleRemove(getTable);
        },
        undoable: undoable && function () {
          var allRowsBeforeWeRemovedAny = getTable().getModel().getRows(),
            rowsAfterWeRemovedSome,
            call = 0;
          return {
            undo: function undo() {
              var model = getTable().getModel();
              return model.clearRows().then(function () {
                return model.insertRows(allRowsBeforeWeRemovedAny).then(function () {
                  return getTable().setModified(true);
                });
              });
            },
            redo: function redo() {
              var model = getTable().getModel();
              if (call === 0) {
                call++;
                return handleRemove(getTable).then(function () {
                  rowsAfterWeRemovedSome = model.getRows();
                });
              }
              return model.clearRows().then(function () {
                model.insertRows(rowsAfterWeRemovedSome);
                getTable().setModified(true);
              });
            },
            redoText: function redoText() {
              return _redoText;
            },
            undoText: function undoText() {
              return _undoText;
            }
          };
        }
      }]);

      /**
       * When called determines if the command should be enabled or not.
       * @private
       */
      _this.$updateEnabled = function () {
        var selectedRows = getTable().getSelectedRows();
        _this.setEnabled(!!selectedRows.length);
      };
      return _this;
    }
    _inherits(RemoveCommand, _Command);
    return _createClass(RemoveCommand);
  }(Command);
  return RemoveCommand;
});
