function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/table/EditTable
 */
define(['baja!', 'log!nmodule.webEditors.rc.wb.table.EditTable', 'bajaux/events', 'bajaux/Properties', 'bajaux/spandrel', 'bajaux/Widget', 'bajaux/commands/CommandGroup', 'bajaux/util/CommandButtonGroup', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/ValueWithPopoutWidget', 'nmodule/webEditors/rc/wb/table/commands/AddRowCommand', 'nmodule/webEditors/rc/wb/table/commands/MoveDownCommand', 'nmodule/webEditors/rc/wb/table/commands/MoveUpCommand', 'nmodule/webEditors/rc/wb/table/commands/RemoveCommand', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/webEditors/rc/wb/table/model/columns/JsonObjectPropertyColumn', 'nmodule/webEditors/rc/wb/table/Table'], function (baja, log, events, Properties, spandrel, Widget, CommandGroup, CommandButtonGroup, Promise, _, fe, ValueWithPopoutWidget, AddRowCommand, MoveDownCommand, MoveUpCommand, RemoveCommand, Column, TableModel, JsonObjectPropertyColumn, Table) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var findIndex = _.findIndex,
    last = _.last;
  var MODIFY_EVENT = events.MODIFY_EVENT;
  var ROW_SELECTION_CHANGED_EVENT = Table.ROW_SELECTION_CHANGED_EVENT;
  var CELL_MODIFIED_EVENT = 'EditTable:cellModified';
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-EditTable',
        showControls: false
      }
    };
  };

  /**
   * A table whose purpose is to display the values in an array of plain JSON objects, allow the
   * user to edit them (adding, removing, and reordering as needed), and read the new values
   * back out.
   *
   * The objects in each row should be JSON objects, keyed on column name, where each value is also
   * an object. Each must have a `value` property, and may optionally include a `properties` object
   * that will be applied when toStringing the value for a display column, or applied to the field
   * editor for an edit column.
   *
   * The value read out will be an array of rows in the same format as loaded in, with the newest
   * values as entered by the user.
   *
   * It supports the following properties:
   *
   * - `columns` (required): specify what columns are shown.
   * - `getNew`: a function to resolve a new row to insert, typically by prompting the user in a
   *   dialog. If present, an Add command will be included in the controls.
   * - `showControls`: if true, Move Up / Move Down / Remove / Add command buttons will be shown.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/table/EditTable
   * @extends module:bajaux/spandrel/SpandrelWidget
   * @example
   * <caption>Display user names, and allow the user to edit their email addresses.</caption>
   *
   * const { display, edit } = EditTable.columns;
   * const max = 50; // max email length
   *
   * const rows = [
   *   { name: { value: 'Moe Howard' }, email: { value: 'mhoward@stooges.com', properties: { max } } },
   *   { name: { value: 'Larry Fine' }, email: { value: 'lfine@stooges.com', properties: { max } } },
   *   { name: { value: 'Curly Howard' }, email: { value: 'choward@stooges.com', properties: { max } } }
   * ]
   *
   * const columns = [ display('name'), edit('email') ];
   *
   * const getNew = () => feDialogs.props({ name: '', email: '' })
   *   .then(({ name, email }) => ({ name: { value: name }, email: { value: email, properties: { max } } });
   *
   * return <EditTable value={rows} properties={{ columns, showControls: true, getNew }}>;
   */
  var EditTable = /*#__PURE__*/function (_spandrel) {
    function EditTable(params) {
      var _this;
      _classCallCheck(this, EditTable);
      _this = _callSuper(this, EditTable, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      var getTable = function getTable() {
        return _this.$getTable();
      };
      var getEditTable = function getEditTable() {
        return _this;
      };
      var cmdGroup = _this.$tableCmds = new CommandGroup();
      var getNew = _this.properties().getValue('getNew');
      if (typeof getNew === 'function') {
        cmdGroup.add(new AddRowCommand(getEditTable));
      }
      cmdGroup.add(new RemoveCommand(getTable), new MoveUpCommand(getTable), new MoveDownCommand(getTable));
      return _this;
    }

    /**
     * Fires whenever the user modifies a cell. The argument will be `{ column, row, index }` where `column`
     * is the name of the modified column, `row` is the newly updated row, and `index` is the row
     * index.
     * @returns {string}
     */
    _inherits(EditTable, _spandrel);
    return _createClass(EditTable, [{
      key: "findCellValues",
      value:
      /**
       * Find all cell values in the specified column that match the given row filter. Note that
       * row values will be *up to date* when filtering, so if you are filtering against an editable
       * column the values may change as the user types.
       *
       * @param {string} columnName
       * @param {function(object, number): *} [matchRow] return truthy to include the row
       * @returns {Array.<*>}
       */
      function findCellValues(columnName) {
        var matchRow = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : function () {
          return true;
        };
        var rows = this.$getTable().getModel().getRows().map(function (r) {
          return r.getSubject();
        }).filter(matchRow);
        var cellValues = [];
        rows.forEach(function (row) {
          var obj = row[columnName];
          return obj && cellValues.push(obj.value);
        });
        return cellValues;
      }

      /**
       * Find all editors in the specified column that match the given row filter. Note that
       * row values will be *up to date* when filtering, so if you are filtering against an editable
       * column the values may change as the user types.
       *
       * @param {string} columnName
       * @param {function(object, number): *} [matchRow] return truthy to include the row
       * @returns {Array.<module:bajaux/Widget>}
       */
    }, {
      key: "findEditors",
      value: function findEditors(columnName) {
        var matchRow = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : function () {
          return true;
        };
        var table = this.$getTable();
        var model = table.getModel();
        var rows = model.getRows();
        var x = findIndex(model.getColumns(), function (c) {
          return c.getName() === columnName;
        });
        var matchingTrs = [];
        table.$getTbody().children().each(function (i, tr) {
          matchRow(rows[i].getSubject(), i) && matchingTrs.push(tr);
        });
        return matchingTrs.map(function (tr) {
          return Widget["in"](tr.children[x]);
        }).filter(function (w) {
          return w;
        });
      }

      /**
       * Find the first editor in the specified column that matches the given row filter. Note that
       * row values will be *up to date* when filtering, so if you are filtering against an editable
       * column the values may change as the user types.
       *
       * @param {string} columnName
       * @param {function(object, number): *} [matchRow] return truthy to include the row
       * @returns {module:bajaux/Widget}
       * @example
       * const editorForBobsEmail = editTable.findEditor('email', where('name', 'Bob'));
       * return editorForBobsEmail.loadAndModify('bob@bob.com');
       */
    }, {
      key: "findEditor",
      value: function findEditor(columnName, matchRow) {
        return this.findEditors(columnName, matchRow)[0];
      }

      /**
       * Functions to create columns for use in the `EditTable`.
       * @returns {{edit: (function(string, object): EditColumn), display: (function(string, object): DisplayColumn)}}
       */
    }, {
      key: "doReadonly",
      value: function doReadonly(readonly) {
        this.$updateCommands();
        return _superPropGet(EditTable, "doReadonly", this, 3)(arguments);
      }
    }, {
      key: "doRead",
      value: function doRead() {
        return this.$getTable().getModel().getRows().map(function (r) {
          return cloneRow(r.getSubject());
        });
      }

      /**
       * In case there is a cell editor which require a save like a MruButton, make sure
       * to save any cell editors that are modified.
       * @returns {Promise}
       */
    }, {
      key: "doSave",
      value: function doSave() {
        var _arguments = arguments,
          _this2 = this;
        var cellEditorElements = _toConsumableArray(this.$getTable().jq().find("tbody").first().children(".ux-table-row").children('td'));
        return Promise.all(cellEditorElements.map(function (cell) {
          var widget = Widget["in"](cell);
          if (widget && widget.isModified()) {
            return widget.save();
          }
        })).then(function () {
          return _superPropGet(EditTable, "doSave", _this2, 3)(_arguments);
        });
      }

      /**
       * @private
       */
    }, {
      key: "$updateCommands",
      value: function $updateCommands() {
        var _this3 = this;
        this.$getTableCommandGroup().getChildren().forEach(function (cmd) {
          return _this3.isReadonly() ? cmd.setEnabled(false) : cmd.$updateEnabled && cmd.$updateEnabled();
        });
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/Table}
       */
    }, {
      key: "$getTable",
      value: function $getTable() {
        return this.queryWidget('table');
      }

      /**
       * @private
       * @returns {module:bajaux/commands/CommandGroup}
       */
    }, {
      key: "$getTableCommandGroup",
      value: function $getTableCommandGroup() {
        return this.$tableCmds;
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButtonGroup|undefined}
       */
    }, {
      key: "$getCommandButtonGroup",
      value: function $getCommandButtonGroup() {
        return this.queryWidget('commands');
      }

      /**
       * Adds new row value to the table and returns the last row
       * @private
       * @param {Object} newValue value to be added to the table
       * @returns {Promise<Array.<module:nmodule/webEditors/rc/wb/table/model/Row>|null>}
       */
    }, {
      key: "$addNewRowValue",
      value: function $addNewRowValue(newValue) {
        var _this4 = this;
        if (!newValue) {
          return Promise.reject(new Error('Cannot add null value to the EditTable'));
        }
        return this.read().then(function (values) {
          return _this4.$setNewRowValues([].concat(_toConsumableArray(values), [newValue]));
        }).then(function () {
          var table = _this4.$getTable();
          table.setModified(true);
          var model = table.getModel();
          table.$selection.select(model.getRowCount() - 1);
          return [last(model.getRows())];
        });
      }

      /**
       * @private
       * @param {Array<Object>} newValues
       */
    }, {
      key: "$setNewRowValues",
      value: function $setNewRowValues(newValues) {
        return this.render(newValues);
      }

      /**
       * Prompts for new row value resolves a whole row configuration
       * @private
       * returns {Promise<Object|null>}
       */
    }, {
      key: "$promptForNewRow",
      value: function $promptForNewRow() {
        var getNew = this.properties().getValue('getNew');
        if (typeof getNew !== 'function') {
          throw new Error('getNew function required');
        }
        var model = this.$getTable().getModel();
        return Promise.resolve(getNew(model)).then(function (newValue) {
          if (newValue === null || newValue === undefined) {
            return null;
          }
          return newValue;
        });
      }
    }], [{
      key: "CELL_MODIFIED_EVENT",
      get: function get() {
        return CELL_MODIFIED_EVENT;
      }

      /**
       * @param {string} columnName
       * @param {baja.Value} columnValue
       * @returns {function(object): boolean} a filter for use with `findEditors` to get the row(s) where
       * the specified column has the specified value
       */
    }, {
      key: "where",
      value: function where(columnName, columnValue) {
        return function (row) {
          var obj = row[columnName];
          return !!(obj && obj.value.equivalent(columnValue));
        };
      }
    }, {
      key: "columns",
      get: function get() {
        return {
          display: function display(name) {
            var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
            var displayColumn = new DisplayColumn(name, params);
            displayColumn.setSortable(false);
            /**
             * Clones the display column
             * @returns {DisplayColumn}
             */
            displayColumn.clone = function () {
              var clone = new DisplayColumn(name, params);
              clone.setSortable(false);
              return clone;
            };
            return displayColumn;
          },
          edit: function edit(name) {
            var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
            var editColumn = new EditColumn(name, params);
            editColumn.setSortable(false);
            /**
             * Clones the edit column
             * @returns {EditColumn}
             */
            editColumn.clone = function () {
              var clone = new EditColumn(name, params);
              clone.setSortable(false);
              return clone;
            };
            return editColumn;
          }
        };
      }
    }]);
  }(spandrel(function () {
    var rows = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    var _ref = arguments.length > 1 ? arguments[1] : undefined,
      properties = _ref.properties,
      self = _ref.self;
    var columns = properties.columns,
      showControls = properties.showControls;
    var columnClones;

    // attaching the properties of the EditTable to columns, and adding the readonly and enabled values.
    // This allows the `buildCell` functions of the column to access the properties of the EditTable
    if (columns) {
      columnClones = columns.map(tryToCloneColumn);
      columnClones.forEach(function (col) {
        col.$tableProps = self.properties().clone();
        col.$tableProps.add('readonly', self.isReadonly());
        col.$tableProps.add('enabled', self.isEnabled());
      });
    }

    // since we'll be socking away changes at all times as the user edits, the actual table gets
    // clones of the rows to avoid mutating the real input rows.
    // on every user change, we'll write the new value direct to these clones, and resolve them
    // direct from read().
    var model = new TableModel({
      columns: columnClones,
      rows: rows.map(cloneRow)
    });
    return [spandrel.jsx(Table, {
      spandrelKey: "table",
      lax: true,
      value: model,
      properties: "inherit",
      on: _defineProperty({}, ROW_SELECTION_CHANGED_EVENT, function () {
        return self.$updateCommands();
      })
    }), showControls && spandrel.jsx(CommandButtonGroup, {
      spandrelKey: "commands",
      value: self.$getTableCommandGroup()
    })];
  }));
  var DisplayColumn = /*#__PURE__*/function (_Column) {
    function DisplayColumn(props) {
      var _this5;
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      _classCallCheck(this, DisplayColumn);
      _this5 = _callSuper(this, DisplayColumn, arguments);
      _this5.$properties = params.properties || {};
      return _this5;
    }
    _inherits(DisplayColumn, _Column);
    return _createClass(DisplayColumn, [{
      key: "getValueFor",
      value: function getValueFor(row) {
        return row.getSubject()[this.getName()];
      }

      /**
       * Returns the current properties for the column
       * @returns {Object}
       */
    }, {
      key: "getProperties",
      value: function getProperties() {
        return this.$properties;
      }
    }, {
      key: "buildCell",
      value: function buildCell(row, dom) {
        var obj = this.getValueFor(row);
        var value = obj.value;
        var properties = Object.assign(this.getProperties(), obj.properties || {});
        var str = value === null || value === undefined ? String(value) : value.toString(properties);
        return Promise.resolve(str).then(function (text) {
          return dom.text(text);
        });
      }
    }]);
  }(Column);
  var EditColumn = /*#__PURE__*/function (_Column2) {
    function EditColumn(props) {
      var _this6;
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      _classCallCheck(this, EditColumn);
      _this6 = _callSuper(this, EditColumn, arguments);
      _this6.$properties = params.properties || {};
      return _this6;
    }
    _inherits(EditColumn, _Column2);
    return _createClass(EditColumn, [{
      key: "getValueFor",
      value: function getValueFor(row) {
        return row.getSubject()[this.getName()];
      }

      /**
       * Returns the current Properties for the column
       * @returns {Object}
       */
    }, {
      key: "getProperties",
      value: function getProperties() {
        return this.$properties;
      }
    }, {
      key: "buildCell",
      value: function buildCell(row, dom) {
        var _this7 = this;
        var obj = this.getValueFor(row);
        var tableProps = this.$tableProps || new Properties();
        var readonly = !!obj.readonly || !!tableProps.getValue('readonly') || !!(this.getFlags() & Column.flags.READONLY);
        var enabled = readonly ? false : tableProps.getValue('enabled') !== false;
        var properties = Object.assign(this.getProperties(), obj.properties || {});
        if (!baja.hasType(obj.value)) {
          return Promise.resolve();
        }

        // every time the user edits, write that to the underlying (cloned) rows. this is required
        // because the TableModel must have up-to-date values if the user reorders rows. it doesn't
        // just move <tr>s around in the DOM - it destroys the old rows and builds new ones with the
        // current values in the model.
        dom.on(MODIFY_EVENT, function (e, ed) {
          ed.read().then(function (value) {
            _this7.getValueFor(row).value = value;
          }).then(function () {
            var editTable = Widget["in"](ed.jq().closest(".-t-EditTable"));
            var table = editTable.$getTable();
            table.setModified(true);
            editTable.trigger(CELL_MODIFIED_EVENT, {
              column: _this7.getName(),
              row: row.getSubject(),
              index: table.getModel().getRowIndex(row)
            });
          })["catch"](logSevere);
        });
        return fe.buildFor(Object.assign({
          type: ValueWithPopoutWidget,
          dom: dom,
          formFactor: 'mini'
        }, obj, {
          readonly: readonly,
          enabled: enabled,
          properties: properties
        }));
      }
    }, {
      key: "destroyCell",
      value: function destroyCell(row, dom) {
        var widgetInDom = Widget["in"](dom);
        return widgetInDom && widgetInDom.destroy();
      }
    }]);
  }(Column);
  function tryToCloneColumn(col) {
    return _.result(col, 'clone') || col;
  }
  function cloneRow(jsonRow) {
    var clone = {};
    Object.keys(jsonRow).forEach(function (key) {
      clone[key] = Object.assign({}, jsonRow[key]);
    });
    return clone;
  }
  return EditTable;
});
