function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/shell/TitlePane
 */
define(['Promise', 'bajaux/Widget', 'bajaux/commands/CommandGroup', 'bajaux/util/CommandButtonGroup', 'nmodule/webEditors/rc/fe/fe', 'hbs!nmodule/webEditors/rc/wb/shell/template/TitlePane'], function (Promise, Widget, CommandGroup, CommandButtonGroup, fe, tplTitlePane) {
  'use strict';

  /**
   * @class
   * @alias module:nmodule/webEditors/rc/wb/shell/TitlePane
   * @extends module:bajaux/Widget
   */
  var TitlePane = function TitlePane() {
    Widget.apply(this, arguments);
  };
  TitlePane.prototype = Object.create(Widget.prototype);
  TitlePane.prototype.constructor = TitlePane;

  /**
   * @private
   * @returns {JQuery}
   */
  TitlePane.prototype.$getDisplayNameElement = function () {
    return this.jq().children('.header').find('.tab');
  };

  /**
   * @private
   * @returns {JQuery}
   */
  TitlePane.prototype.$getCommandsElement = function () {
    return this.jq().children('.header').find('.commands');
  };

  /**
   * @private
   * @returns {JQuery}
   */
  TitlePane.prototype.$getControlsElement = function () {
    return this.jq().children('.header').find('.controls');
  };

  /**
   * @private
   * @returns {module:bajaux/util/CommandButtonGroup}
   */
  TitlePane.prototype.$getCommandButtonGroup = function () {
    return Widget["in"](this.$getCommandsElement());
  };

  /**
   * @private
   * @returns {JQuery}
   */
  TitlePane.prototype.$getContentElement = function () {
    return this.jq().children('.content');
  };

  /**
   * @param {JQuery} dom
   */
  TitlePane.prototype.doInitialize = function (dom) {
    if (!dom.hasClass('TitlePane')) {
      dom.html(tplTitlePane({}));
      dom.addClass('TitlePane');
    }
  };

  /**
   * @param {*} value
   * @returns {Promise}
   */
  TitlePane.prototype.doLoad = function (value) {
    var widget = this.getContentWidget();
    if (!widget) {
      return Promise.reject(new Error('no content widget set'));
    }
    return widget.load(value);
  };

  /**
   * @returns {module:bajaux/Widget}
   */
  TitlePane.prototype.getContentWidget = function () {
    var contentElement = this.$getContentElement();

    //TODO: because the shell profile loads an entire hx view into the content element, the actual widget gets instantiated a couple levels down.
    return Widget["in"](contentElement) || Widget["in"](contentElement.children('.bajaux-container').children('.bajaux-widget-container').children('.bajaux-widget'));
  };

  /**
   * @returns {Promise|undefined}
   */
  TitlePane.prototype.doLayout = function () {
    var contentWidget = this.getContentWidget();
    return contentWidget && contentWidget.layout();
  };

  /**
   * @param {module:bajaux/Widget} widget
   * @returns {Promise}
   */
  TitlePane.prototype.setContentWidget = function (widget) {
    var that = this,
      oldWidget;
    if (!widget) {
      return Promise.reject(new Error('widget required'));
    }
    oldWidget = that.getContentWidget();
    return Promise.all([oldWidget && oldWidget !== widget && oldWidget.destroy(), that.$destroyCommandButtons()]).then(function () {
      return that.buildCommandGroup(widget);
    }).then(function (commandGroup) {
      return Promise.all([widget.toDisplayName(), !widget.jq() && widget.initialize(that.$getContentElement()), fe.buildFor({
        value: commandGroup,
        dom: that.$getCommandsElement(),
        type: CommandButtonGroup,
        properties: {
          toolbar: true
        }
      })]);
    }).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
        displayName = _ref2[0];
      that.$getDisplayNameElement().text(displayName);
    });
  };

  /**
   * Override point to allow a TitlePane to configure exactly which commands are
   * shown in its header for a particular widget. The default behavior is just
   * show all the widget's commands.
   *
   * @param {module:bajaux/Widget} widget
   * @returns {Promise.<module:bajaux/commands/CommandGroup>}
   */
  TitlePane.prototype.buildCommandGroup = function (widget) {
    return Promise.resolve(new CommandGroup({
      commands: widget.getCommandGroup().getChildren()
    }));
  };

  /**
   * @returns {Promise}
   */
  TitlePane.prototype.doDestroy = function () {
    var that = this,
      content = that.getContentWidget();
    that.jq().removeClass('TitlePane');
    return Promise.resolve(content && content.destroy());
  };

  /**
   * @private
   * @returns {Promise}
   */
  TitlePane.prototype.$destroyCommandButtons = function () {
    var buttons = this.$getCommandButtonGroup();
    return Promise.resolve(buttons && buttons.destroy());
  };
  return TitlePane;
});
